/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import java.util.List;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.spatial.dialect.oracle.OracleSpatialFunction;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;

public class SDORelateFunction
extends OracleSpatialFunction {
    private final List<String> masks;

    public SDORelateFunction(List<String> masks, BasicTypeRegistry typeRegistry) {
        super("SDO_GEOM.RELATE", false, StandardArgumentsValidators.exactly((int)2), StandardFunctionReturnTypeResolvers.invariant((BasicType)typeRegistry.resolve(StandardBasicTypes.BOOLEAN)));
        this.masks = masks;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        Expression geom1 = (Expression)sqlAstArguments.get(0);
        Expression geom2 = (Expression)sqlAstArguments.get(1);
        String maskExpression = String.join((CharSequence)"+", this.masks);
        sqlAppender.appendSql("CASE ");
        sqlAppender.appendSql(this.getName());
        sqlAppender.appendSql("(");
        walker.render((SqlAstNode)geom1, SqlAstNodeRenderingMode.DEFAULT);
        sqlAppender.appendSql(", '");
        sqlAppender.appendSql(maskExpression);
        sqlAppender.appendSql("', ");
        walker.render((SqlAstNode)geom2, SqlAstNodeRenderingMode.DEFAULT);
        sqlAppender.appendSql(")");
        sqlAppender.appendSql(" WHEN 'FALSE' THEN 0 ");
        sqlAppender.appendSql(" ELSE 1 ");
        sqlAppender.appendSql(" END");
    }
}

