/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.db.oracle.Encoders;
import org.geolatte.geom.codec.db.oracle.OracleJDBCTypeFactory;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.hibernate.HibernateException;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

class SDOGeometryValueBinder<J>
implements ValueBinder<J> {
    private static final String SQL_TYPE_NAME = "MDSYS.SDO_GEOMETRY";
    private final OracleJDBCTypeFactory typeFactory;
    private final JavaType<J> javaType;

    public SDOGeometryValueBinder(JavaType<J> javaType, JdbcType jdbcType, OracleJDBCTypeFactory typeFactory) {
        this.javaType = javaType;
        this.typeFactory = typeFactory;
    }

    public void bind(PreparedStatement st, J value, int index, WrapperOptions options) throws SQLException {
        if (value == null) {
            st.setNull(index, 2002, SQL_TYPE_NAME);
        } else {
            Geometry geometry = (Geometry)this.javaType.unwrap(value, Geometry.class, options);
            Object dbGeom = this.toNative(geometry, st.getConnection());
            st.setObject(index, dbGeom);
        }
    }

    public void bind(CallableStatement st, J value, String name, WrapperOptions options) throws SQLException {
        if (value == null) {
            st.setNull(name, 2002, SQL_TYPE_NAME);
        } else {
            Geometry geometry = (Geometry)this.javaType.unwrap(value, Geometry.class, options);
            Object dbGeom = this.toNative(geometry, st.getConnection());
            st.setObject(name, dbGeom);
        }
    }

    public Object store(SDOGeometry geom, Connection conn) throws SQLException {
        return this.typeFactory.createStruct(geom, conn);
    }

    private Object toNative(Geometry geom, Connection connection) {
        try {
            SDOGeometry sdoGeom = Encoders.encode((Geometry)geom);
            return this.store(sdoGeom, connection);
        }
        catch (SQLException e) {
            throw new HibernateException("Problem during conversion from JTS to SDOGeometry", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new HibernateException(e.getMessage());
        }
        catch (Exception e) {
            throw new HibernateException((Throwable)e);
        }
    }
}

