/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver;

import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.spatial.BaseSqmFunctionDescriptors;
import org.hibernate.spatial.CommonSpatialFunction;
import org.hibernate.spatial.dialect.sqlserver.Method;
import org.hibernate.spatial.dialect.sqlserver.Property;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeReference;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;

public class SqlServerSqmFunctionDescriptors
extends BaseSqmFunctionDescriptors {
    private final BasicTypeRegistry typeRegistry;

    public SqlServerSqmFunctionDescriptors(FunctionContributions functionContributions) {
        super(functionContributions);
        this.typeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        this.map.clear();
        this.map.put(CommonSpatialFunction.ST_ASTEXT.getKey(), new Method("STAsText", this.exactly(1), this.invariant(StandardBasicTypes.STRING)));
        this.map.put(CommonSpatialFunction.ST_GEOMETRYTYPE.getKey(), new Method("STGeometryType", this.exactly(1), this.invariant(StandardBasicTypes.STRING)));
        this.map.put(CommonSpatialFunction.ST_DIMENSION.getKey(), new Method("STDimension", this.exactly(1), this.invariant(StandardBasicTypes.INTEGER)));
        this.map.put(CommonSpatialFunction.ST_ENVELOPE.getKey(), new Method("STEnvelope", this.exactly(1), StandardFunctionReturnTypeResolvers.useFirstNonNull()));
        this.map.put(CommonSpatialFunction.ST_SRID.getKey(), new Property("STSrid", this.exactly(1), this.invariant(StandardBasicTypes.INTEGER)));
        this.map.put(CommonSpatialFunction.ST_ASBINARY.getKey(), new Method("STAsBinary", this.exactly(1), this.invariant(StandardBasicTypes.BINARY)));
        this.map.put(CommonSpatialFunction.ST_ISEMPTY.getKey(), new Method("STIsEmpty", this.exactly(1), this.invariant(StandardBasicTypes.BOOLEAN)));
        this.map.put(CommonSpatialFunction.ST_ISSIMPLE.getKey(), new Method("STIsSimple", this.exactly(1), this.invariant(StandardBasicTypes.BOOLEAN)));
        this.map.put(CommonSpatialFunction.ST_BOUNDARY.getKey(), new Method("STBoundary", this.exactly(1), StandardFunctionReturnTypeResolvers.useFirstNonNull()));
        this.map.put(CommonSpatialFunction.ST_OVERLAPS.getKey(), new Method("STOverlaps", this.exactly(2), this.invariant(StandardBasicTypes.BOOLEAN)));
        this.map.put(CommonSpatialFunction.ST_INTERSECTS.getKey(), new Method("STIntersects", this.exactly(2), this.invariant(StandardBasicTypes.BOOLEAN)));
        this.map.put(CommonSpatialFunction.ST_CROSSES.getKey(), new Method("STCrosses", this.exactly(2), this.invariant(StandardBasicTypes.BOOLEAN)));
        this.map.put(CommonSpatialFunction.ST_CONTAINS.getKey(), new Method("STContains", this.exactly(2), this.invariant(StandardBasicTypes.BOOLEAN)));
        this.map.put(CommonSpatialFunction.ST_DISJOINT.getKey(), new Method("STDisjoint", this.exactly(2), this.invariant(StandardBasicTypes.BOOLEAN)));
        this.map.put(CommonSpatialFunction.ST_EQUALS.getKey(), new Method("STEquals", this.exactly(2), this.invariant(StandardBasicTypes.BOOLEAN)));
        this.map.put(CommonSpatialFunction.ST_TOUCHES.getKey(), new Method("STTouches", this.exactly(2), this.invariant(StandardBasicTypes.BOOLEAN)));
        this.map.put(CommonSpatialFunction.ST_WITHIN.getKey(), new Method("STWithin", this.exactly(2), this.invariant(StandardBasicTypes.BOOLEAN)));
        this.map.put(CommonSpatialFunction.ST_DISTANCE.getKey(), new Method("STDistance", this.exactly(2), this.invariant(StandardBasicTypes.DOUBLE)));
        this.map.put(CommonSpatialFunction.ST_BUFFER.getKey(), new Method("STBuffer", this.exactly(2), StandardFunctionReturnTypeResolvers.useFirstNonNull()));
        this.map.put(CommonSpatialFunction.ST_CONVEXHULL.getKey(), new Method("STConvexHull", this.exactly(1), StandardFunctionReturnTypeResolvers.useFirstNonNull()));
        this.map.put(CommonSpatialFunction.ST_DIFFERENCE.getKey(), new Method("STDifference", this.exactly(2), StandardFunctionReturnTypeResolvers.useFirstNonNull()));
        this.map.put(CommonSpatialFunction.ST_INTERSECTION.getKey(), new Method("STIntersection", this.exactly(2), StandardFunctionReturnTypeResolvers.useFirstNonNull()));
        this.map.put(CommonSpatialFunction.ST_SYMDIFFERENCE.getKey(), new Method("STSymDifference", this.exactly(2), StandardFunctionReturnTypeResolvers.useFirstNonNull()));
        this.map.put(CommonSpatialFunction.ST_UNION.getKey(), new Method("STUnion", this.exactly(2), StandardFunctionReturnTypeResolvers.useFirstNonNull()));
        this.map.put(CommonSpatialFunction.ST_RELATE.getKey(), new Method("STRelate", this.exactly(3), this.invariant(StandardBasicTypes.BOOLEAN)));
    }

    ArgumentsValidator exactly(int i) {
        return StandardArgumentsValidators.exactly((int)i);
    }

    FunctionReturnTypeResolver invariant(BasicTypeReference<?> tpe) {
        return StandardFunctionReturnTypeResolvers.invariant((BasicType)this.typeRegistry.resolve(tpe));
    }
}

