/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.predicate;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import org.geolatte.geom.Envelope;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

@Deprecated(since="6.2")
public class GeolatteFilterPredicate {
    private final Expression<? extends Geometry> geometry;
    private final Expression<? extends Geometry> filter;

    public GeolatteFilterPredicate(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry, Expression<? extends Geometry> filter) {
        this.geometry = geometry;
        this.filter = filter;
    }

    public GeolatteFilterPredicate(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry, Geometry filter) {
        this(criteriaBuilder, geometry, (Expression<? extends Geometry>)criteriaBuilder.literal((Object)filter));
    }

    public GeolatteFilterPredicate(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry, Envelope envelope) {
        this(criteriaBuilder, geometry, (Geometry)GeolatteFilterPredicate.fromEnvelope(envelope));
    }

    private static <P extends Position> Polygon<P> fromEnvelope(Envelope<P> envelope) {
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        Position lowerLeft = envelope.lowerLeft();
        Position upperLeft = envelope.upperLeft();
        Position upperRight = envelope.upperRight();
        Position lowerRight = envelope.lowerRight();
        PositionSequence positionSequence = PositionSequenceBuilders.fixedSized((int)5, (Class)crs.getPositionClass()).add(lowerLeft).add(upperLeft).add(upperRight).add(lowerRight).add(lowerLeft).toPositionSequence();
        return new Polygon(positionSequence, crs);
    }
}

