/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.postgis;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkb;
import org.geolatte.geom.codec.WkbDecoder;
import org.geolatte.geom.codec.Wkt;
import org.geolatte.geom.codec.WktDecoder;
import org.geolatte.geom.codec.WktEncoder;
import org.hibernate.dialect.Dialect;
import org.hibernate.spatial.GeometryLiteralFormatter;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public abstract class AbstractCastingPostGISJdbcType
implements JdbcType {
    private final Wkb.Dialect wkbDialect;

    AbstractCastingPostGISJdbcType(Wkb.Dialect dialect) {
        this.wkbDialect = dialect;
    }

    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return new PGGeometryLiteralFormatter<T>(this.getConstructorFunction(), javaType);
    }

    public abstract int getDefaultSqlTypeCode();

    protected abstract String getConstructorFunction();

    public void appendWriteExpression(String writeExpression, SqlAppender appender, Dialect dialect) {
        appender.append((CharSequence)this.getConstructorFunction());
        appender.append('(');
        appender.append((CharSequence)writeExpression);
        appender.append(')');
    }

    public Geometry<?> toGeometry(String wkt) {
        if (wkt == null) {
            return null;
        }
        if (wkt.startsWith("00") || wkt.startsWith("01")) {
            ByteBuffer buffer = ByteBuffer.from((String)wkt);
            WkbDecoder decoder = Wkb.newDecoder((Wkb.Dialect)this.wkbDialect);
            return decoder.decode(buffer);
        }
        return AbstractCastingPostGISJdbcType.parseWkt(wkt);
    }

    private static Geometry<?> parseWkt(String pgValue) {
        WktDecoder decoder = Wkt.newDecoder((Wkt.Dialect)Wkt.Dialect.POSTGIS_EWKT_1);
        return decoder.decode(pgValue);
    }

    public int getJdbcTypeCode() {
        return 12;
    }

    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setString(index, this.toWkt(value, options));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setString(name, this.toWkt(value, options));
            }

            private String toWkt(X value, WrapperOptions options) throws SQLException {
                WktEncoder encoder = Wkt.newEncoder((Wkt.Dialect)Wkt.Dialect.POSTGIS_EWKT_1);
                Geometry geometry = (Geometry)this.getJavaType().unwrap(value, Geometry.class, options);
                return encoder.encode(geometry);
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(AbstractCastingPostGISJdbcType.this.toGeometry(rs.getString(paramIndex)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(AbstractCastingPostGISJdbcType.this.toGeometry(statement.getString(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(AbstractCastingPostGISJdbcType.this.toGeometry(statement.getString(name)), options);
            }
        };
    }

    static class PGGeometryLiteralFormatter<T>
    extends GeometryLiteralFormatter<T> {
        private final String constructorFunction;

        public PGGeometryLiteralFormatter(String constructorFunction, JavaType<T> javaType) {
            super(javaType, Wkt.Dialect.POSTGIS_EWKT_1, "");
            this.constructorFunction = constructorFunction;
        }

        @Override
        public void appendJdbcLiteral(SqlAppender appender, T value, Dialect dialect, WrapperOptions wrapperOptions) {
            Geometry geom = (Geometry)this.javaType.unwrap(value, Geometry.class, wrapperOptions);
            appender.append((CharSequence)this.constructorFunction);
            appender.appendSql("('");
            appender.appendSql(Wkt.toWkt((Geometry)geom, (Wkt.Dialect)this.wktDialect));
            appender.appendSql("')");
        }
    }
}

