/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.mysql;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkb;
import org.geolatte.geom.codec.WkbDecoder;
import org.geolatte.geom.codec.WkbEncoder;
import org.geolatte.geom.codec.Wkt;
import org.hibernate.spatial.GeometryLiteralFormatter;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class MySQLGeometryJdbcType
implements JdbcType {
    public static final MySQLGeometryJdbcType INSTANCE = new MySQLGeometryJdbcType();

    public int getJdbcTypeCode() {
        return 2003;
    }

    public int getDefaultSqlTypeCode() {
        return 3200;
    }

    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return new GeometryLiteralFormatter<T>(javaType, Wkt.Dialect.SFA_1_1_0, "ST_GeomFromText");
    }

    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                Geometry geometry;
                WkbEncoder encoder = Wkb.newEncoder((Wkb.Dialect)Wkb.Dialect.MYSQL_WKB);
                ByteBuffer buffer = encoder.encode(geometry = (Geometry)this.getJavaType().unwrap(value, Geometry.class, options), ByteOrder.NDR);
                byte[] bytes = buffer == null ? null : buffer.toByteArray();
                st.setBytes(index, bytes);
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                Geometry geometry;
                WkbEncoder encoder = Wkb.newEncoder((Wkb.Dialect)Wkb.Dialect.MYSQL_WKB);
                ByteBuffer buffer = encoder.encode(geometry = (Geometry)this.getJavaType().unwrap(value, Geometry.class, options), ByteOrder.NDR);
                byte[] bytes = buffer == null ? null : buffer.toByteArray();
                st.setBytes(name, bytes);
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap((Object)MySQLGeometryJdbcType.this.toGeometry(rs.getBytes(paramIndex)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap((Object)MySQLGeometryJdbcType.this.toGeometry(statement.getBytes(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap((Object)MySQLGeometryJdbcType.this.toGeometry(statement.getBytes(name)), options);
            }
        };
    }

    public Geometry toGeometry(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.from((byte[])bytes);
        WkbDecoder decoder = Wkb.newDecoder((Wkb.Dialect)Wkb.Dialect.MYSQL_WKB);
        return decoder.decode(buffer);
    }
}

