/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.postgis;

import java.util.List;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.query.sqm.function.NamedSqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.spatial.BaseSqmFunctionDescriptors;
import org.hibernate.spatial.FunctionKey;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;

public class PostgisSqmFunctionDescriptors
extends BaseSqmFunctionDescriptors {
    private final BasicTypeRegistry typeRegistry;

    public PostgisSqmFunctionDescriptors(FunctionContributions functionContributions) {
        super(functionContributions);
        this.typeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        this.addOperator("distance_2d", "<->");
        this.addOperator("distance_2d_bbox", "<#>");
        this.addOperator("distance_cpa", "|=|");
        this.addOperator("distance_centroid_nd", "<<->>");
    }

    protected void addOperator(String name, String operator) {
        this.map.put(FunctionKey.apply(name), new PostgisOperator(name, operator, (ArgumentsValidator)new ArgumentTypesValidator(StandardArgumentsValidators.exactly((int)2), new FunctionParameterType[]{FunctionParameterType.SPATIAL}), StandardFunctionReturnTypeResolvers.invariant((BasicType)this.typeRegistry.resolve(StandardBasicTypes.DOUBLE))));
    }

    static class PostgisOperator
    extends NamedSqmFunctionDescriptor {
        private final String operator;

        public PostgisOperator(String name, String op, ArgumentsValidator validator, FunctionReturnTypeResolver returnTypeResolver) {
            super(name, false, validator, returnTypeResolver);
            this.operator = op;
        }

        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, SqlAstTranslator<?> walker) {
            sqlAppender.appendSql('(');
            Expression arg1 = (Expression)sqlAstArguments.get(0);
            walker.render((SqlAstNode)arg1, SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.appendSql(this.operator);
            Expression arg2 = (Expression)sqlAstArguments.get(1);
            walker.render((SqlAstNode)arg2, SqlAstNodeRenderingMode.DEFAULT);
            sqlAppender.appendSql(')');
        }
    }
}

