/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.hana;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geolatte.geom.Geometry;
import org.hibernate.spatial.dialect.hana.HANASpatialUtils;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class HANAGeometryType
implements JdbcType {
    public static final HANAGeometryType CRS_LOADING_INSTANCE = new HANAGeometryType(true);
    public static final HANAGeometryType INSTANCE = new HANAGeometryType(false);
    private static final long serialVersionUID = -6978798264716544804L;
    final boolean determineCrsIdFromDatabase;

    public HANAGeometryType(boolean determineCrsIdFromDatabase) {
        this.determineCrsIdFromDatabase = determineCrsIdFromDatabase;
    }

    public int getJdbcTypeCode() {
        return 1111;
    }

    public int getDefaultSqlTypeCode() {
        return 3200;
    }

    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                Geometry geometry = (Geometry)this.getJavaType().unwrap(value, Geometry.class, options);
                st.setObject(index, HANASpatialUtils.toEWKB(geometry));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                Geometry geometry = (Geometry)this.getJavaType().unwrap(value, Geometry.class, options);
                st.setObject(name, (Object)HANASpatialUtils.toEWKB(geometry));
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                if (HANAGeometryType.this.determineCrsIdFromDatabase) {
                    throw new UnsupportedOperationException("First need to refactor HANASpatialUtils");
                }
                return this.getJavaType().wrap(HANASpatialUtils.toGeometry(rs.getObject(paramIndex)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(HANASpatialUtils.toGeometry(statement.getObject(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(HANASpatialUtils.toGeometry(statement.getObject(name)), options);
            }
        };
    }
}

