/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import java.util.List;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.spatial.dialect.oracle.OracleSpatialFunction;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;

public class OracleSpatialSQLMMFunction
extends OracleSpatialFunction {
    private final String stMethod;
    private final boolean addGeomAccessor;

    public OracleSpatialSQLMMFunction(String name, String stMethod, int numArgs, FunctionReturnTypeResolver returnTypeResolver, boolean addGeomAccessor) {
        super(name, true, StandardArgumentsValidators.exactly((int)numArgs), returnTypeResolver);
        this.stMethod = stMethod;
        this.addGeomAccessor = addGeomAccessor;
    }

    public OracleSpatialSQLMMFunction(String name, String stMethod, int numArgs, FunctionReturnTypeResolver returnTypeResolver) {
        this(name, stMethod, numArgs, returnTypeResolver, false);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, SqlAstTranslator<?> walker) {
        Expression geometry = (Expression)arguments.get(0);
        sqlAppender.appendSql("ST_GEOMETRY(");
        walker.render((SqlAstNode)geometry, SqlAstNodeRenderingMode.DEFAULT);
        sqlAppender.appendSql(").");
        sqlAppender.appendSql(this.stMethod);
        sqlAppender.appendSql("(");
        for (int i = 1; i < arguments.size(); ++i) {
            Expression param = (Expression)arguments.get(i);
            if (param.getExpressionType().getSingleJdbcMapping().getJdbcType().getDefaultSqlTypeCode() == 3200) {
                sqlAppender.appendSql("ST_GEOMETRY(");
                walker.render((SqlAstNode)param, SqlAstNodeRenderingMode.DEFAULT);
                sqlAppender.appendSql(")");
                continue;
            }
            walker.render((SqlAstNode)param, SqlAstNodeRenderingMode.DEFAULT);
        }
        sqlAppender.appendSql(")");
        if (this.addGeomAccessor) {
            sqlAppender.appendSql(".geom ");
        }
    }
}

