/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.util;

import java.util.Locale;

public final class StringUtil {
    private static final String GET = "get";
    private static final String IS = "is";
    private static final String HAS = "has";

    private StringUtil() {
    }

    public static String determineFullyQualifiedClassName(String defaultPackage, String name) {
        return StringUtil.isFullyQualified(name) ? name : defaultPackage + "." + name;
    }

    public static boolean isFullyQualified(String name) {
        return name.contains(".");
    }

    public static String packageNameFromFullyQualifiedName(String fullyQualifiedName) {
        return fullyQualifiedName.substring(0, fullyQualifiedName.lastIndexOf("."));
    }

    public static String classNameFromFullyQualifiedName(String fullyQualifiedName) {
        return fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(".") + 1);
    }

    public static boolean isProperty(String methodName, String returnType) {
        if (methodName == null) {
            return false;
        }
        return !StringUtil.isVoid(returnType) && StringUtil.isValidPropertyName(methodName, GET) || StringUtil.isBoolean(returnType) && (StringUtil.isValidPropertyName(methodName, IS) || StringUtil.isValidPropertyName(methodName, HAS));
    }

    private static boolean isVoid(String returnType) {
        return "void".equals(returnType);
    }

    private static boolean isBoolean(String type) {
        return "Boolean".equals(type) || "java.lang.Boolean".equals(type) || "boolean".equals(type);
    }

    private static boolean isValidPropertyName(String name, String prefix) {
        return name.startsWith(prefix) && name.length() > prefix.length();
    }

    public static String getPropertyName(String name) {
        return StringUtil.decapitalize(StringUtil.trimPropertyPrefix(name));
    }

    private static String trimPropertyPrefix(String name) {
        if (name.startsWith(GET)) {
            return name.replaceFirst(GET, "");
        }
        if (name.startsWith(IS)) {
            return name.replaceFirst(IS, "");
        }
        if (name.startsWith(HAS)) {
            return name.replaceFirst(HAS, "");
        }
        return name;
    }

    public static String decapitalize(String string) {
        return string == null || string.isEmpty() || StringUtil.startsWithSeveralUpperCaseLetters(string) ? string : string.substring(0, 1).toLowerCase(Locale.ROOT) + string.substring(1);
    }

    public static String nameToFieldName(String name) {
        return StringUtil.getUpperUnderscoreCaseFromLowerCamelCase(StringUtil.nameToMethodName(name));
    }

    public static String nameToMethodName(String name) {
        return name.replaceAll("[\\s.\\-!@#%=+/*^&|(){}\\[\\],]", "_");
    }

    public static String getUpperUnderscoreCaseFromLowerCamelCase(String lowerCamelCaseString) {
        int codePoint;
        StringBuilder result = new StringBuilder();
        boolean wasLowerCase = false;
        for (int position = 0; position < lowerCamelCaseString.length(); position += Character.charCount(codePoint)) {
            codePoint = lowerCamelCaseString.codePointAt(position);
            boolean isUpperCase = Character.isUpperCase(codePoint);
            if (wasLowerCase && isUpperCase) {
                result.append('_');
            }
            result.appendCodePoint(Character.toUpperCase(codePoint));
            wasLowerCase = !isUpperCase;
        }
        if (result.toString().equals(lowerCamelCaseString)) {
            result.insert(0, '_');
        }
        return result.toString();
    }

    private static boolean startsWithSeveralUpperCaseLetters(String string) {
        return string.length() > 1 && Character.isUpperCase(string.charAt(0)) && Character.isUpperCase(string.charAt(1));
    }

    public static String removeDollar(String simpleName) {
        return simpleName.endsWith("$") ? simpleName.substring(0, simpleName.length() - 1) : simpleName;
    }
}

