/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;

public class RepositoryConstructor
implements MetaAttribute {
    private final AnnotationMetaEntity annotationMetaEntity;
    private final String constructorName;
    private final String methodName;
    private final String sessionTypeName;
    private final String sessionVariableName;
    private final @Nullable String dataStore;
    private final boolean addInjectAnnotation;
    private final boolean addNonnullAnnotation;
    private final boolean addOverrideAnnotation;
    private final boolean dataRepository;
    private final boolean quarkusInjection;

    public RepositoryConstructor(AnnotationMetaEntity annotationMetaEntity, String constructorName, String methodName, String sessionTypeName, String sessionVariableName, @Nullable String dataStore, boolean addInjectAnnotation, boolean addNonnullAnnotation, boolean addOverrideAnnotation, boolean dataRepository, boolean quarkusInjection) {
        this.annotationMetaEntity = annotationMetaEntity;
        this.constructorName = constructorName;
        this.methodName = methodName;
        this.sessionTypeName = sessionTypeName;
        this.sessionVariableName = sessionVariableName;
        this.dataStore = dataStore;
        this.addInjectAnnotation = addInjectAnnotation;
        this.addNonnullAnnotation = addNonnullAnnotation;
        this.addOverrideAnnotation = addOverrideAnnotation;
        this.dataRepository = dataRepository;
        this.quarkusInjection = quarkusInjection;
    }

    @Override
    public boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public boolean hasStringAttribute() {
        return false;
    }

    @Override
    public String getAttributeDeclarationString() {
        StringBuilder declaration = new StringBuilder();
        declaration.append('\n');
        if (this.annotationMetaEntity.getSuperTypeElement() == null) {
            declaration.append("protected ");
            if (!this.dataRepository) {
                declaration.append("final ");
            }
            this.notNull(declaration);
            declaration.append(this.annotationMetaEntity.importType(this.sessionTypeName)).append(" ").append(this.sessionVariableName).append(";\n\n");
        }
        this.inject(declaration);
        declaration.append("public ").append(this.constructorName).append("(");
        this.notNull(declaration);
        this.qualifier(declaration);
        declaration.append(this.annotationMetaEntity.importType(this.sessionTypeName)).append(" ").append(this.sessionVariableName).append(") {\n");
        if (this.annotationMetaEntity.getSuperTypeElement() != null) {
            declaration.append("\tsuper(").append(this.sessionVariableName).append(");\n");
        } else {
            declaration.append("\tthis.").append(this.sessionVariableName).append(" = ").append(this.sessionVariableName).append(";\n");
        }
        declaration.append("}");
        if (this.annotationMetaEntity.getSuperTypeElement() == null) {
            declaration.append("\n\n");
            if (this.addOverrideAnnotation) {
                declaration.append("@Override\n");
            }
            declaration.append("public ");
            this.notNull(declaration);
            declaration.append(this.annotationMetaEntity.importType(this.providedSessionType())).append(" ").append(this.methodName).append("() {").append("\n\treturn ").append(this.sessionVariableName);
            if (this.annotationMetaEntity.isProvidedSessionAccess()) {
                declaration.append(".getObject()");
            }
            declaration.append(";\n}");
        }
        return declaration.toString();
    }

    private String providedSessionType() {
        return this.annotationMetaEntity.isProvidedSessionAccess() ? "org.hibernate.StatelessSession" : this.sessionTypeName;
    }

    private void qualifier(StringBuilder declaration) {
        if (this.addInjectAnnotation && this.quarkusInjection && this.dataStore != null) {
            declaration.append('@').append(this.annotationMetaEntity.importType("io.quarkus.hibernate.orm.PersistenceUnit")).append("(\"").append(this.dataStore).append("\") ");
        }
    }

    private void inject(StringBuilder declaration) {
        if (this.addInjectAnnotation && !this.annotationMetaEntity.needsDefaultConstructor()) {
            declaration.append('@').append(this.annotationMetaEntity.importType("jakarta.inject.Inject")).append('\n');
        }
    }

    private void notNull(StringBuilder declaration) {
        if (this.addNonnullAnnotation) {
            declaration.append('@').append(this.annotationMetaEntity.importType("jakarta.annotation.Nonnull")).append(' ');
        }
    }

    @Override
    public String getAttributeNameDeclarationString() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public String getMetaType() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public String getPropertyName() {
        return this.methodName;
    }

    @Override
    public String getTypeDeclaration() {
        return "jakarta.persistence.EntityManager";
    }

    @Override
    public Metamodel getHostingEntity() {
        return this.annotationMetaEntity;
    }
}

