/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.processor.annotation.AbstractQueryMethod;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.annotation.OrderBy;
import org.hibernate.processor.util.StringUtil;

public class QueryMethod
extends AbstractQueryMethod {
    private final String queryString;
    private final @Nullable String returnTypeClass;
    private final @Nullable String containerType;
    private final boolean isUpdate;
    private final boolean isNative;

    QueryMethod(AnnotationMetaEntity annotationMetaEntity, ExecutableElement method, String methodName, String queryString, @Nullable String returnTypeName, @Nullable String returnTypeClass, @Nullable String containerType, List<String> paramNames, List<String> paramTypes, boolean isUpdate, boolean isNative, boolean belongsToDao, String sessionType, String sessionName, List<OrderBy> orderBys, boolean addNonnullAnnotation, boolean dataRepository, String fullReturnType, boolean nullable) {
        super(annotationMetaEntity, method, methodName, paramNames, paramTypes, returnTypeName, sessionType, sessionName, belongsToDao, orderBys, addNonnullAnnotation, dataRepository, fullReturnType, nullable);
        this.queryString = queryString;
        this.returnTypeClass = returnTypeClass;
        this.containerType = containerType;
        this.isUpdate = isUpdate;
        this.isNative = isNative;
    }

    @Override
    public boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public boolean hasStringAttribute() {
        return true;
    }

    @Override
    boolean isNullable(int index) {
        return true;
    }

    @Override
    boolean singleResult() {
        return this.containerType == null && !this.isUpdate;
    }

    @Override
    public String getAttributeDeclarationString() {
        List<String> paramTypes = this.parameterTypes();
        StringBuilder declaration = new StringBuilder();
        this.comment(declaration);
        this.modifiers(declaration, paramTypes);
        this.preamble(declaration, paramTypes);
        this.nullChecks(declaration, paramTypes);
        this.createSpecification(declaration);
        this.handleRestrictionParameters(declaration, paramTypes);
        this.collectOrdering(declaration, paramTypes, this.containerType);
        this.chainSession(declaration);
        this.inTry(declaration);
        this.createQuery(declaration, true);
        this.setParameters(declaration, paramTypes);
        declaration.append(";\n");
        this.results(declaration, paramTypes, this.containerType);
        this.castResult(declaration);
        this.select(declaration);
        this.handlePageParameters(declaration, paramTypes, this.containerType);
        this.execute(declaration, this.initiallyUnwrapped());
        this.convertExceptions(declaration);
        this.chainSessionEnd(this.isUpdate, declaration);
        QueryMethod.closingBrace(declaration);
        return declaration.toString();
    }

    String specificationType() {
        return this.isUpdate ? "org.hibernate.query.specification.MutationSpecification" : "org.hibernate.query.specification.SelectionSpecification";
    }

    @Override
    void createQuery(StringBuilder declaration, boolean declareVariable) {
        if (declareVariable) {
            if (this.dataRepository && !this.isReactive()) {
                declaration.append('\t');
            }
            declaration.append('\t');
            declaration.append("var _select = ");
        }
        if (this.isUsingSpecification()) {
            if (this.isReactive()) {
                declaration.append(this.localSessionName()).append(".createQuery(_spec.buildCriteria(").append(this.localSessionName()).append(".getFactory().getCriteriaBuilder()))\n");
            } else {
                declaration.append("_spec.createQuery(").append(this.localSessionName()).append(this.getObjectCall()).append(")");
            }
        } else {
            declaration.append(this.localSessionName()).append(this.getObjectCall()).append('.').append(this.createQueryMethod()).append("(").append(this.getConstantName());
            if (this.returnTypeClass != null && !this.isUpdate) {
                declaration.append(", ").append(this.annotationMetaEntity.importType(this.returnTypeClass)).append(".class");
            }
            declaration.append(")");
        }
    }

    @Override
    void createSpecification(StringBuilder declaration) {
        if (this.returnTypeClass != null && this.isUsingSpecification()) {
            declaration.append("\tvar _spec = ").append(this.annotationMetaEntity.importType(this.specificationType())).append(".create(").append(this.annotationMetaEntity.importType(this.returnTypeClass)).append(".class, ").append(this.getConstantName()).append(");\n");
        }
    }

    @Override
    boolean isUsingSpecification() {
        return this.returnTypeClass != null && (this.hasRestriction() || this.hasOrder() && !QueryMethod.isJakartaCursoredPage(this.containerType));
    }

    private String createQueryMethod() {
        if (this.isNative) {
            return "createNativeQuery";
        }
        if (this.isUsingEntityManager() || this.isReactive() || QueryMethod.isUnspecializedQueryType(this.containerType)) {
            return "createQuery";
        }
        return this.isUpdate ? "createMutationQuery" : "createSelectionQuery";
    }

    private void castResult(StringBuilder declaration) {
        if (this.isNative && this.returnTypeName != null && this.containerType == null && this.isUsingEntityManager()) {
            declaration.append("(").append(this.fullReturnType).append(") ");
        }
    }

    private void execute(StringBuilder declaration, boolean unwrapped) {
        if (this.isUpdate) {
            declaration.append("\t\t\t.executeUpdate()");
            if (this.isReactive()) {
                if ("java.lang.Void".equals(this.returnTypeName)) {
                    declaration.append("\n\t\t\t.replaceWithVoid()");
                } else if ("java.lang.Boolean".equals(this.returnTypeName)) {
                    declaration.append("\n\t\t\t.map(rows -> rows>0)");
                }
            } else if ("boolean".equals(this.returnTypeName)) {
                declaration.append(" > 0");
            }
        } else {
            boolean mustUnwrap = QueryMethod.isHibernateQueryType(this.containerType) || this.isNative && this.returnTypeName != null;
            this.executeSelect(declaration, this.paramTypes, this.containerType, unwrapped, mustUnwrap);
        }
    }

    @Override
    void setParameters(StringBuilder declaration, List<String> paramTypes) {
        for (int i = 0; i < this.paramNames.size(); ++i) {
            if (QueryMethod.isSpecialParam(paramTypes.get(i))) continue;
            String paramName = (String)this.paramNames.get(i);
            int ordinal = i + 1;
            if (this.queryString.contains(":" + paramName)) {
                QueryMethod.setNamedParameter(declaration, paramName);
                continue;
            }
            if (!this.queryString.contains("?" + ordinal)) continue;
            QueryMethod.setOrdinalParameter(declaration, ordinal, paramName);
        }
    }

    private static void setOrdinalParameter(StringBuilder declaration, int i, String paramName) {
        declaration.append("\n\t\t\t.setParameter(").append(i).append(", ").append(paramName).append(")");
    }

    private static void setNamedParameter(StringBuilder declaration, String paramName) {
        declaration.append("\n\t\t\t.setParameter(\"").append(paramName).append("\", ").append(paramName).append(")");
    }

    private void comment(StringBuilder declaration) {
        declaration.append("\n/**").append("\n * Execute the query {@value #").append(this.getConstantName()).append("}.").append("\n *");
        this.see(declaration);
        declaration.append("\n **/\n");
    }

    private void modifiers(StringBuilder declaration, List<String> paramTypes) {
        boolean hasVarargs = paramTypes.stream().anyMatch(ptype -> ptype.endsWith("..."));
        if (hasVarargs) {
            declaration.append("@SafeVarargs\n");
        }
        if (this.belongsToDao) {
            declaration.append("@Override\npublic ");
            if (hasVarargs) {
                declaration.append("final ");
            }
        } else {
            declaration.append("public static ");
        }
    }

    void nullChecks(StringBuilder declaration, List<String> paramTypes) {
        for (int i = 0; i < this.paramNames.size(); ++i) {
            String paramType = paramTypes.get(i);
            if (!QueryMethod.isSpecialParam(paramType)) continue;
            this.nullCheck(declaration, (String)this.paramNames.get(i));
        }
    }

    @Override
    public String getAttributeNameDeclarationString() {
        StringBuilder declaration = new StringBuilder(this.queryString.length() + 200);
        declaration.append("\n/**\n * @see ").append("#");
        this.signature(declaration);
        declaration.append("\n **/\n").append("static final String ").append(this.getConstantName()).append(" = \"");
        for (int i = 0; i < this.queryString.length(); ++i) {
            char c = this.queryString.charAt(i);
            declaration.append(switch (c) {
                case '\r' -> "\\r";
                case '\n' -> "\\n";
                case '\\' -> "\\\\";
                case '\"' -> "\\\"";
                default -> Character.valueOf(c);
            });
        }
        return declaration.append("\";").toString();
    }

    private String getConstantName() {
        String stem = StringUtil.getUpperUnderscoreCaseFromLowerCamelCase(this.methodName);
        return this.paramTypes.isEmpty() || this.paramTypes.stream().allMatch(AbstractQueryMethod::isSpecialParam) ? stem : stem + "_" + this.paramTypes.stream().filter(type -> !QueryMethod.isSpecialParam(type)).map(type -> type.indexOf(60) > 0 ? type.substring(0, type.indexOf(60)) : type).map(StringHelper::unqualify).map(type -> type.replace("[]", "Array")).reduce((x, y) -> x + "_" + y).orElseThrow();
    }

    @Override
    public String getTypeDeclaration() {
        return "jakarta.persistence.Query";
    }
}

