/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.TreeSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.processor.annotation.AnnotationMeta;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.StringUtil;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;

class NamedQueryMethod
implements MetaAttribute {
    private final AnnotationMeta annotationMeta;
    private final SqmSelectStatement<?> select;
    private final String name;
    private final boolean belongsToRepository;
    private final boolean reactive;
    private final String sessionVariableName;
    private final boolean addNonnullAnnotation;
    private final String resultClass;

    public NamedQueryMethod(AnnotationMeta annotationMeta, SqmSelectStatement<?> select, String name, boolean belongsToRepository, @Nullable String sessionType, String sessionVariableName, boolean addNonnullAnnotation, String resultClass) {
        this.annotationMeta = annotationMeta;
        this.select = select;
        this.name = name;
        this.belongsToRepository = belongsToRepository;
        this.reactive = "org.hibernate.reactive.mutiny.Mutiny.Session".equals(sessionType);
        this.sessionVariableName = sessionVariableName;
        this.addNonnullAnnotation = addNonnullAnnotation;
        this.resultClass = resultClass;
    }

    @Override
    public boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public boolean hasStringAttribute() {
        return false;
    }

    @Override
    public String getAttributeDeclarationString() {
        TreeSet sortedParameters = new TreeSet(SqmParameter.COMPARATOR);
        sortedParameters.addAll(this.select.getSqmParameters());
        StringBuilder declaration = new StringBuilder();
        this.comment(declaration);
        this.modifiers(declaration);
        this.returnType(declaration);
        this.parameters(sortedParameters, declaration);
        declaration.append(" {").append("\n\treturn ").append(this.sessionVariableName).append(".createNamedQuery(").append(this.fieldName()).append(", ").append(this.annotationMeta.importType(this.resultClass)).append(".class)");
        for (SqmParameter<?> param : sortedParameters) {
            declaration.append("\n\t\t\t.setParameter(").append(param.getName() == null ? param.getPosition() : "\"" + param.getName() + "\"").append(", ").append((String)(param.getName() == null ? "parameter" + param.getPosition() : param.getName())).append(')');
        }
        declaration.append("\n\t\t\t.getResultList();\n}");
        return declaration.toString();
    }

    private String fieldName() {
        return "QUERY_" + StringUtil.nameToFieldName(this.name);
    }

    void notNull(StringBuilder declaration) {
        if (this.addNonnullAnnotation) {
            declaration.append('@').append(this.annotationMeta.importType("jakarta.annotation.Nonnull")).append(' ');
        }
    }

    private void comment(StringBuilder declaration) {
        declaration.append("\n/**\n * Execute named query {@value #").append(this.fieldName()).append("} defined by annotation of {@link ").append(this.annotationMeta.getSimpleName()).append("}.\n **/\n");
    }

    private void modifiers(StringBuilder declaration) {
        declaration.append(this.belongsToRepository ? "public " : "public static ");
    }

    private void returnType(StringBuilder declaration) {
        if (this.reactive) {
            declaration.append(this.annotationMeta.importType("io.smallrye.mutiny.Uni")).append('<');
        }
        declaration.append(this.annotationMeta.importType("java.util.List")).append('<').append(this.annotationMeta.importType(this.resultClass)).append("> ").append(this.name);
        if (this.reactive) {
            declaration.append('>');
        }
    }

    private void parameters(TreeSet<SqmParameter<?>> sortedParameters, StringBuilder declaration) {
        declaration.append('(');
        if (!this.belongsToRepository) {
            this.notNull(declaration);
            declaration.append(this.annotationMeta.importType("jakarta.persistence.EntityManager")).append(" ").append(this.sessionVariableName);
        }
        int i = 0;
        for (SqmParameter<?> param : sortedParameters) {
            if (0 < i++ || !this.belongsToRepository) {
                declaration.append(", ");
            }
            if (param.allowMultiValuedBinding()) {
                declaration.append(this.annotationMeta.importType("java.util.List")).append('<').append(this.parameterType(param)).append("> ").append(NamedQueryMethod.parameterName(param));
                continue;
            }
            declaration.append(this.parameterType(param)).append(" ").append(NamedQueryMethod.parameterName(param));
        }
        declaration.append(')');
    }

    private static String parameterName(SqmParameter<?> param) {
        String name = param.getName();
        return name == null ? "parameter" + param.getPosition() : name;
    }

    private String parameterType(SqmParameter<?> param) {
        SqmBindableType expressible = param.getExpressible();
        String paramType = expressible == null ? "unknown" : expressible.getTypeName();
        return "unknown".equals(paramType) ? "Object" : this.annotationMeta.importType(paramType);
    }

    @Override
    public String getAttributeNameDeclarationString() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public String getMetaType() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public String getPropertyName() {
        return this.name;
    }

    @Override
    public String getTypeDeclaration() {
        return "java.util.List";
    }

    @Override
    public Metamodel getHostingEntity() {
        return this.annotationMeta;
    }
}

