/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.StringUtil;

class NameMetaAttribute
implements MetaAttribute {
    private final Metamodel annotationMetaEntity;
    private final String name;
    private final String prefix;

    public NameMetaAttribute(Metamodel annotationMetaEntity, String name, String prefix) {
        this.annotationMetaEntity = annotationMetaEntity;
        this.name = name;
        this.prefix = prefix;
    }

    @Override
    public boolean hasTypedAttribute() {
        return false;
    }

    @Override
    public boolean hasStringAttribute() {
        return true;
    }

    @Override
    public String getAttributeDeclarationString() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public String getAttributeNameDeclarationString() {
        StringBuilder declaration = new StringBuilder();
        if (!this.annotationMetaEntity.isJakartaDataStyle()) {
            declaration.append("public static final ");
        }
        return declaration.append(this.annotationMetaEntity.importType("java.lang.String")).append(' ').append(this.prefix).append(this.fieldName()).append(" = ").append('\"').append(this.name).append('\"').append(';').toString();
    }

    String fieldName() {
        return StringUtil.nameToFieldName(this.name.charAt(0) == '#' ? this.name.substring(1) : this.name);
    }

    @Override
    public String getMetaType() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public String getPropertyName() {
        return this.name;
    }

    @Override
    public String getTypeDeclaration() {
        return "java.lang.String";
    }

    @Override
    public Metamodel getHostingEntity() {
        return this.annotationMetaEntity;
    }
}

