/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import jakarta.persistence.AccessType;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.processor.Context;
import org.hibernate.processor.annotation.AnnotationMetaAttribute;
import org.hibernate.processor.annotation.AnnotationMetaCollection;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.annotation.AnnotationMetaMap;
import org.hibernate.processor.annotation.AnnotationMetaSingleAttribute;
import org.hibernate.processor.util.AccessTypeInformation;
import org.hibernate.processor.util.Constants;
import org.hibernate.processor.util.NullnessUtil;
import org.hibernate.processor.util.TypeUtils;

public class MetaAttributeGenerationVisitor
extends SimpleTypeVisitor8<AnnotationMetaAttribute, Element> {
    private final AnnotationMetaEntity entity;
    private final Context context;

    MetaAttributeGenerationVisitor(AnnotationMetaEntity entity, Context context) {
        this.entity = entity;
        this.context = context;
    }

    private Types typeUtils() {
        return this.context.getTypeUtils();
    }

    @Override
    public @Nullable AnnotationMetaAttribute visitPrimitive(PrimitiveType primitiveType, Element element) {
        return new AnnotationMetaSingleAttribute(this.entity, element, TypeUtils.toTypeString(primitiveType));
    }

    @Override
    public @Nullable AnnotationMetaAttribute visitArray(ArrayType arrayType, Element element) {
        if (TypeUtils.isPluralAttribute(element)) {
            return new AnnotationMetaCollection(this.entity, element, "jakarta.persistence.metamodel.ListAttribute", TypeUtils.toTypeString(arrayType.getComponentType()));
        }
        return new AnnotationMetaSingleAttribute(this.entity, element, TypeUtils.toArrayTypeString(arrayType, this.context));
    }

    @Override
    public @Nullable AnnotationMetaAttribute visitTypeVariable(TypeVariable typeVariable, Element element) {
        return new AnnotationMetaSingleAttribute(this.entity, element, this.typeUtils().erasure(typeVariable.getUpperBound()).toString());
    }

    @Override
    public @Nullable AnnotationMetaAttribute visitDeclared(DeclaredType declaredType, Element element) {
        TypeElement returnedElement = (TypeElement)this.typeUtils().asElement(declaredType);
        if (returnedElement == null) {
            return null;
        }
        String targetEntity = TypeUtils.getTargetEntity(element.getAnnotationMirrors());
        if (TypeUtils.isPluralAttribute(element)) {
            String returnTypeName = returnedElement.getQualifiedName().toString();
            String collection = Constants.COLLECTIONS.get(returnTypeName);
            if (collection != null) {
                return this.createMetaCollectionAttribute(declaredType, element, returnTypeName, collection, targetEntity);
            }
            return null;
        }
        String type = targetEntity != null ? targetEntity : returnedElement.getQualifiedName().toString();
        return new AnnotationMetaSingleAttribute(this.entity, element, type);
    }

    private AnnotationMetaAttribute createMetaCollectionAttribute(DeclaredType declaredType, Element element, String returnTypeName, String collection, @Nullable String targetEntity) {
        String explicitTargetEntity;
        TypeMirror collectionElementType;
        if (TypeUtils.hasAnnotation(element, "jakarta.persistence.ElementCollection") && (collectionElementType = TypeUtils.getCollectionElementType(declaredType, returnTypeName, explicitTargetEntity = TypeUtils.getTargetEntity(element.getAnnotationMirrors()), this.context)).getKind() == TypeKind.DECLARED) {
            TypeElement collectionElement = (TypeElement)this.typeUtils().asElement(collectionElementType);
            this.setAccessType(collectionElementType, NullnessUtil.castNonNull(collectionElement));
        }
        return this.createMetaAttribute(declaredType, element, collection, targetEntity);
    }

    private AnnotationMetaAttribute createMetaAttribute(DeclaredType declaredType, Element element, String collection, @Nullable String targetEntity) {
        if (TypeUtils.hasAnnotation(element, "jakarta.persistence.OneToMany", "jakarta.persistence.ManyToMany", "org.hibernate.annotations.ManyToAny", "jakarta.persistence.ElementCollection")) {
            String elementType = this.getElementType(declaredType, targetEntity);
            if (collection.equals("jakarta.persistence.metamodel.MapAttribute")) {
                String keyType = this.getMapKeyType(declaredType, element);
                return new AnnotationMetaMap(this.entity, element, collection, keyType, elementType);
            }
            return new AnnotationMetaCollection(this.entity, element, collection, elementType);
        }
        return new AnnotationMetaSingleAttribute(this.entity, element, TypeUtils.extractClosestRealTypeAsString(declaredType, this.context));
    }

    private void setAccessType(TypeMirror collectionElementType, TypeElement collectionElement) {
        String elementTypeName = collectionElementType.toString();
        AccessTypeInformation accessTypeInfo = this.context.getAccessTypeInfo(elementTypeName);
        AccessType entityAccessType = this.entity.getEntityAccessTypeInfo().getAccessType();
        if (accessTypeInfo == null) {
            this.context.addAccessTypeInformation(elementTypeName, new AccessTypeInformation(elementTypeName, collectionElement == null ? null : TypeUtils.determineAnnotationSpecifiedAccessType(collectionElement), entityAccessType));
        } else {
            accessTypeInfo.setDefaultAccessType(entityAccessType);
        }
    }

    @Override
    public @Nullable AnnotationMetaAttribute visitExecutable(ExecutableType executable, Element element) {
        return TypeUtils.isPropertyGetter(executable, element) ? executable.getReturnType().accept(this, element) : null;
    }

    private String getMapKeyType(DeclaredType declaredType, Element element) {
        AnnotationMirror annotationMirror = TypeUtils.getAnnotationMirror(element, "jakarta.persistence.MapKeyClass");
        return annotationMirror == null ? TypeUtils.getKeyType(declaredType, this.context) : NullnessUtil.castNonNull(TypeUtils.getAnnotationValue(annotationMirror, "value")).getValue().toString();
    }

    private String getElementType(DeclaredType declaredType, @Nullable String targetEntity) {
        if (targetEntity != null) {
            return targetEntity;
        }
        List<? extends TypeMirror> mirrors = declaredType.getTypeArguments();
        switch (mirrors.size()) {
            case 0: {
                return "?";
            }
            case 1: {
                return TypeUtils.extractClosestRealTypeAsString(mirrors.get(0), this.context);
            }
            case 2: {
                return TypeUtils.extractClosestRealTypeAsString(mirrors.get(1), this.context);
            }
        }
        this.context.logMessage(Diagnostic.Kind.WARNING, "Unable to find the closest solid type" + String.valueOf(declaredType));
        return "?";
    }
}

