/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.processor.Context;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.annotation.DataAnnotationMetaAttribute;
import org.hibernate.processor.util.TypeUtils;

public class DataMetaAttributeGenerationVisitor
extends SimpleTypeVisitor8<DataAnnotationMetaAttribute, Element> {
    private final AnnotationMetaEntity entity;
    private final Context context;
    private final @Nullable String path;

    DataMetaAttributeGenerationVisitor(AnnotationMetaEntity entity, Context context) {
        this.entity = entity;
        this.context = context;
        this.path = null;
    }

    DataMetaAttributeGenerationVisitor(AnnotationMetaEntity entity, String path, Context context) {
        this.entity = entity;
        this.context = context;
        this.path = path;
    }

    private Types typeUtils() {
        return this.context.getTypeUtils();
    }

    @Override
    public @Nullable DataAnnotationMetaAttribute visitPrimitive(PrimitiveType primitiveType, Element element) {
        return new DataAnnotationMetaAttribute(this.entity, element, TypeUtils.toTypeString(primitiveType), this.path);
    }

    @Override
    public @Nullable DataAnnotationMetaAttribute visitArray(ArrayType arrayType, Element element) {
        return new DataAnnotationMetaAttribute(this.entity, element, TypeUtils.toArrayTypeString(arrayType, this.context), this.path);
    }

    @Override
    public @Nullable DataAnnotationMetaAttribute visitTypeVariable(TypeVariable typeVariable, Element element) {
        return new DataAnnotationMetaAttribute(this.entity, element, this.typeUtils().erasure(typeVariable.getUpperBound()).toString(), this.path);
    }

    @Override
    public @Nullable DataAnnotationMetaAttribute visitDeclared(DeclaredType declaredType, Element element) {
        TypeElement returnedElement = (TypeElement)this.typeUtils().asElement(declaredType);
        if (returnedElement == null) {
            return null;
        }
        String targetEntity = TypeUtils.getTargetEntity(element.getAnnotationMirrors());
        if (TypeUtils.isPluralAttribute(element)) {
            return null;
        }
        String type = targetEntity != null ? targetEntity : returnedElement.getQualifiedName().toString();
        return new DataAnnotationMetaAttribute(this.entity, element, type, this.path);
    }

    @Override
    public @Nullable DataAnnotationMetaAttribute visitExecutable(ExecutableType executable, Element element) {
        return TypeUtils.isPropertyGetter(executable, element) ? executable.getReturnType().accept(this, element) : null;
    }
}

