/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.processor.Context;
import org.hibernate.processor.annotation.EnabledFetchProfileMetaAttribute;
import org.hibernate.processor.annotation.ErrorHandler;
import org.hibernate.processor.annotation.NameMetaAttribute;
import org.hibernate.processor.annotation.NamedQueryMethod;
import org.hibernate.processor.annotation.TypedMetaAttribute;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.SqmTypeUtils;
import org.hibernate.processor.util.TypeUtils;
import org.hibernate.processor.validation.ProcessorSessionFactory;
import org.hibernate.processor.validation.Validation;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;

public abstract class AnnotationMeta
implements Metamodel {
    void addAuxiliaryMembers() {
        this.addAuxiliaryMembersForAnnotation("jakarta.persistence.NamedQuery", "QUERY_");
        this.addAuxiliaryMembersForRepeatableAnnotation("jakarta.persistence.NamedQueries", "QUERY_");
        this.addAuxiliaryMembersForAnnotation("jakarta.persistence.NamedNativeQuery", "QUERY_");
        this.addAuxiliaryMembersForRepeatableAnnotation("jakarta.persistence.NamedNativeQueries", "QUERY_");
        this.addAuxiliaryMembersForAnnotation("jakarta.persistence.SqlResultSetMapping", "MAPPING_");
        this.addAuxiliaryMembersForRepeatableAnnotation("jakarta.persistence.SqlResultSetMappings", "MAPPING_");
        this.addAuxiliaryMembersForAnnotation("jakarta.persistence.NamedEntityGraph", "GRAPH_");
        this.addAuxiliaryMembersForRepeatableAnnotation("jakarta.persistence.NamedEntityGraphs", "GRAPH_");
        this.addAuxiliaryMembersForAnnotation("org.hibernate.annotations.NamedQuery", "QUERY_");
        this.addAuxiliaryMembersForRepeatableAnnotation("org.hibernate.annotations.NamedQueries", "QUERY_");
        this.addAuxiliaryMembersForAnnotation("org.hibernate.annotations.NamedNativeQuery", "QUERY_");
        this.addAuxiliaryMembersForRepeatableAnnotation("org.hibernate.annotations.NamedNativeQueries", "QUERY_");
        this.addAuxiliaryMembersForAnnotation("org.hibernate.annotations.FetchProfile", "PROFILE_");
        this.addAuxiliaryMembersForRepeatableAnnotation("org.hibernate.annotations.FetchProfiles", "PROFILE_");
        this.addAuxiliaryMembersForAnnotation("org.hibernate.annotations.FilterDef", "FILTER_");
        this.addAuxiliaryMembersForRepeatableAnnotation("org.hibernate.annotations.FilterDefs", "FILTER_");
    }

    void checkNamedQueries() {
        boolean checkHql = TypeUtils.containsAnnotation(this.getElement(), "org.hibernate.annotations.processing.CheckHQL") || TypeUtils.containsAnnotation(this.getElement().getEnclosingElement(), "org.hibernate.annotations.processing.CheckHQL");
        this.handleNamedQueryAnnotation("jakarta.persistence.NamedQuery", checkHql);
        this.handleNamedQueryRepeatableAnnotation("jakarta.persistence.NamedQueries", checkHql);
        this.handleNamedQueryAnnotation("org.hibernate.annotations.NamedQuery", checkHql);
        this.handleNamedQueryRepeatableAnnotation("org.hibernate.annotations.NamedQueries", checkHql);
    }

    private void handleNamedQueryAnnotation(String annotationName, boolean checkHql) {
        AnnotationMirror mirror = TypeUtils.getAnnotationMirror(this.getElement(), annotationName);
        if (mirror != null) {
            this.handleNamedQuery(mirror, checkHql);
        }
    }

    private void handleNamedQueryRepeatableAnnotation(String annotationName, boolean checkHql) {
        AnnotationValue value;
        AnnotationMirror mirror = TypeUtils.getAnnotationMirror(this.getElement(), annotationName);
        if (mirror != null && (value = TypeUtils.getAnnotationValue(mirror)) != null) {
            List annotationValues = (List)value.getValue();
            for (AnnotationValue annotationValue : annotationValues) {
                this.handleNamedQuery((AnnotationMirror)annotationValue.getValue(), checkHql);
            }
        }
    }

    private void handleNamedQuery(AnnotationMirror mirror, boolean checkHql) {
        AnnotationValue nameValue = TypeUtils.getAnnotationValue(mirror, "name");
        if (nameValue != null) {
            Object object;
            String name = nameValue.getValue().toString();
            Context context = this.getContext();
            boolean reportErrors = context.checkNamedQuery(name);
            AnnotationValue value = TypeUtils.getAnnotationValue(mirror, "query");
            if (value != null && (object = value.getValue()) instanceof String) {
                String hql = (String)object;
                SqmStatement<?> statement = Validation.validate(hql, null, true, new WarningErrorHandler(context, this.getElement(), mirror, value, hql, reportErrors, checkHql), ProcessorSessionFactory.create(context.getProcessingEnvironment(), context.getEntityNameMappings(), context.getEnumTypesByValue(), context.isIndexing()));
                if (!this.isJakartaDataStyle() && statement instanceof SqmSelectStatement) {
                    String resultType;
                    SqmSelectStatement selectStatement = (SqmSelectStatement)statement;
                    if (AnnotationMeta.isQueryMethodName(name)) {
                        AnnotationValue annotationValue = TypeUtils.getAnnotationValue(mirror, "resultClass");
                        String resultType2 = annotationValue != null ? annotationValue.getValue().toString() : SqmTypeUtils.resultType(selectStatement);
                        this.putMember(name, new NamedQueryMethod(this, selectStatement, name.substring(1), this.isRepository(), this.getSessionType(), this.getSessionVariableName(), context.addNonnullAnnotation(), resultType2));
                    }
                    if (TypeUtils.getAnnotationValue(mirror, "resultClass") == null && (resultType = SqmTypeUtils.resultType(selectStatement)) != null) {
                        this.putMember("QUERY_" + name, new TypedMetaAttribute(this, name, "QUERY_", resultType, "jakarta.persistence.TypedQueryReference", hql));
                    }
                }
            }
        }
    }

    private static boolean isQueryMethodName(String name) {
        return name.length() >= 2 && name.charAt(0) == '#' && Character.isJavaIdentifierStart(name.charAt(1)) && name.substring(2).chars().allMatch(Character::isJavaIdentifierPart);
    }

    private void addAuxiliaryMembersForRepeatableAnnotation(String annotationName, String prefix) {
        AnnotationValue value;
        AnnotationMirror mirror = TypeUtils.getAnnotationMirror(this.getElement(), annotationName);
        if (mirror != null && (value = TypeUtils.getAnnotationValue(mirror)) != null) {
            List annotationValues = (List)value.getValue();
            for (AnnotationValue annotationValue : annotationValues) {
                this.addAuxiliaryMembersForMirror((AnnotationMirror)annotationValue.getValue(), prefix, annotationName);
            }
        }
    }

    private void addAuxiliaryMembersForAnnotation(String annotationName, String prefix) {
        AnnotationMirror mirror = TypeUtils.getAnnotationMirror(this.getElement(), annotationName);
        if (mirror != null) {
            this.addAuxiliaryMembersForMirror(mirror, prefix, annotationName);
        }
    }

    private void addAuxiliaryMembersForMirror(AnnotationMirror mirror, String prefix, String annotationName) {
        if (!this.isJakartaDataStyle()) {
            String name = this.defaultImplicitName(annotationName, AnnotationMeta.explicitName(mirror));
            this.putMember(prefix + name, this.auxiliaryMember(mirror, prefix, name));
        }
    }

    private static String explicitName(AnnotationMirror mirror) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : mirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals("name")) continue;
            return entry.getValue().getValue().toString();
        }
        return "";
    }

    private String defaultImplicitName(String annotationName, String explicitName) {
        return explicitName.isEmpty() && ("jakarta.persistence.NamedEntityGraph".equals(annotationName) || "jakarta.persistence.NamedEntityGraphs".equals(annotationName)) ? this.getSimpleName() : explicitName;
    }

    private NameMetaAttribute auxiliaryMember(AnnotationMirror mirror, String prefix, String name) {
        return switch (prefix) {
            case "QUERY_" -> {
                AnnotationValue resultClass = TypeUtils.getAnnotationValue(mirror, "resultClass");
                String resultTypeName = resultClass == null ? "java.lang.Object" : resultClass.getValue().toString();
                yield new TypedMetaAttribute(this, name, prefix, resultTypeName, "jakarta.persistence.TypedQueryReference", null);
            }
            case "GRAPH_" -> new TypedMetaAttribute(this, name, prefix, this.getQualifiedName(), "jakarta.persistence.EntityGraph", null);
            case "PROFILE_" -> new EnabledFetchProfileMetaAttribute(this, name, prefix, "org.hibernate.EnabledFetchProfile");
            default -> new NameMetaAttribute(this, name, prefix);
        };
    }

    protected String getSessionVariableName() {
        return "entityManager";
    }

    abstract boolean isRepository();

    abstract @Nullable String getSessionType();

    abstract void putMember(String var1, MetaAttribute var2);

    private static class WarningErrorHandler
    extends ErrorHandler {
        private final boolean reportErrors;
        private final boolean checkHql;

        private WarningErrorHandler(Context context, Element element, AnnotationMirror mirror, AnnotationValue value, String hql, boolean reportErrors, boolean checkHql) {
            super(context, element, mirror, value, hql);
            this.reportErrors = reportErrors;
            this.checkHql = checkHql;
        }

        @Override
        public void error(int start, int end, String message) {
            if (this.reportErrors) {
                if (this.checkHql) {
                    super.error(start, end, message);
                } else {
                    super.warn(start, end, message);
                }
            }
        }

        @Override
        public void warn(int start, int end, String message) {
            if (this.reportErrors) {
                super.warn(start, end, message);
            }
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
            if (this.reportErrors) {
                super.syntaxError(recognizer, offendingSymbol, line, charPositionInLine, message, e);
            }
        }
    }
}

