/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.hibernate.processor.model.ImportContext;

public class ImportContextImpl
implements ImportContext {
    private final Set<String> imports = new TreeSet<String>();
    private final Set<String> staticImports = new TreeSet<String>();
    private final Map<String, String> simpleNames = new HashMap<String, String>();
    private String basePackage = "";
    private static final Map<String, String> PRIMITIVES = new HashMap<String, String>();

    public ImportContextImpl(String basePackage) {
        this.basePackage = basePackage;
    }

    @Override
    public String importType(String typeExpression) {
        String result = typeExpression;
        String preamble = "";
        if (result.startsWith("@")) {
            index = result.lastIndexOf(32);
            if (index > 0) {
                preamble = result.substring(0, index + 1);
                result = result.substring(index + 1);
            }
        } else if (result.startsWith("?")) {
            for (index = 1; index < result.length() && Character.isWhitespace(result.charAt(index)); ++index) {
            }
            if (index < result.length()) {
                int nextIndex = -1;
                if (result.substring(index).startsWith("extends")) {
                    nextIndex = index + 7;
                } else if (result.substring(index).startsWith("super")) {
                    nextIndex = index + 5;
                }
                if (nextIndex > 0 && nextIndex < result.length() && Character.isWhitespace(result.charAt(nextIndex))) {
                    index = nextIndex;
                    while (Character.isWhitespace(result.charAt(index))) {
                        ++index;
                    }
                    preamble = result.substring(0, index);
                    result = this.importType(result.substring(index));
                }
            }
        }
        Object appendices = "";
        if (result.indexOf(60) >= 0) {
            int startIndex = result.indexOf(60);
            int endIndex = result.lastIndexOf(62);
            appendices = "<" + this.importTypes(result.substring(startIndex + 1, endIndex)) + ">" + result.substring(endIndex + 1);
            result = result.substring(0, startIndex);
        } else if (result.indexOf(91) >= 0) {
            index = result.indexOf(91);
            appendices = result.substring(index);
            result = result.substring(0, index);
        } else if (result.endsWith("...")) {
            appendices = "...";
            index = result.indexOf("...");
            result = result.substring(0, index);
        }
        return (preamble + this.unqualifyName(result) + (String)appendices).replace('$', '.');
    }

    private String unqualifyName(String qualifiedName) {
        boolean canBeSimple;
        String sourceQualifiedName = qualifiedName.replace('$', '.');
        String simpleName = ImportContextImpl.unqualify(qualifiedName);
        if (this.simpleNames.containsKey(simpleName)) {
            String existing = this.simpleNames.get(simpleName);
            canBeSimple = existing.equals(sourceQualifiedName);
        } else {
            canBeSimple = true;
            this.simpleNames.put(simpleName, sourceQualifiedName);
            this.imports.add(sourceQualifiedName);
        }
        if (this.inSamePackage(qualifiedName) || this.inJavaLang(qualifiedName) || canBeSimple && this.imports.contains(sourceQualifiedName)) {
            return ImportContextImpl.unqualify(qualifiedName);
        }
        return qualifiedName;
    }

    private String importTypes(String originalArgList) {
        StringBuilder argList = new StringBuilder();
        StringBuilder acc = new StringBuilder();
        StringTokenizer args = new StringTokenizer(originalArgList, ",");
        while (args.hasMoreTokens()) {
            if (!acc.isEmpty()) {
                acc.append(',');
            }
            acc.append(args.nextToken());
            int nesting = 0;
            block5: for (int i = 0; i < acc.length(); ++i) {
                switch (acc.charAt(i)) {
                    case '<': {
                        ++nesting;
                        continue block5;
                    }
                    case '>': {
                        --nesting;
                    }
                }
            }
            if (nesting != 0) continue;
            if (!argList.isEmpty()) {
                argList.append(',');
            }
            argList.append(this.importType(acc.toString()));
            acc.setLength(0);
        }
        return argList.toString();
    }

    @Override
    public String staticImport(String fqcn, String member) {
        String local = fqcn + "." + member;
        this.imports.add(local);
        this.staticImports.add(local);
        return "*".equals(member) ? "" : member;
    }

    private boolean inDefaultPackage(String className) {
        return className.indexOf(46) < 0;
    }

    private boolean isPrimitive(String className) {
        return PRIMITIVES.containsKey(className);
    }

    private boolean inSamePackage(String className) {
        return Objects.equals(ImportContextImpl.qualifier(className), this.basePackage);
    }

    private boolean inJavaLang(String className) {
        return "java.lang".equals(ImportContextImpl.qualifier(className));
    }

    @Override
    public String generateImports() {
        StringBuilder builder = new StringBuilder();
        for (String next : this.imports) {
            if (this.isAutoImported(next)) continue;
            if (this.staticImports.contains(next)) {
                builder.append("import static ").append(next).append(";").append(System.lineSeparator());
                continue;
            }
            builder.append("import ").append(next).append(";").append(System.lineSeparator());
        }
        return builder.toString();
    }

    private boolean isAutoImported(String next) {
        return this.isPrimitive(next) || this.inDefaultPackage(next) || this.inJavaLang(next) || this.inSamePackage(next);
    }

    public static String unqualify(String qualifiedName) {
        int loc = qualifiedName.lastIndexOf(46);
        return loc < 0 ? qualifiedName : qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
    }

    public static String qualifier(String qualifiedName) {
        int loc = qualifiedName.lastIndexOf(46);
        return loc < 0 ? "" : qualifiedName.substring(0, loc);
    }

    static {
        PRIMITIVES.put("char", "Character");
        PRIMITIVES.put("byte", "Byte");
        PRIMITIVES.put("short", "Short");
        PRIMITIVES.put("int", "Integer");
        PRIMITIVES.put("long", "Long");
        PRIMITIVES.put("boolean", "Boolean");
        PRIMITIVES.put("float", "Float");
        PRIMITIVES.put("double", "Double");
    }
}

