/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.tools.Diagnostic;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.processor.Context;
import org.hibernate.processor.ImportContextImpl;
import org.hibernate.processor.annotation.AnnotationMeta;
import org.hibernate.processor.model.ImportContext;
import org.hibernate.processor.model.MetaAttribute;

public class AnnotationMetaPackage
extends AnnotationMeta {
    private final ImportContext importContext;
    private final PackageElement element;
    private final Map<String, MetaAttribute> members;
    private final Context context;
    private boolean initialized;

    public AnnotationMetaPackage(PackageElement element, Context context) {
        this.element = element;
        this.context = context;
        this.members = new HashMap<String, MetaAttribute>();
        this.importContext = new ImportContextImpl(AnnotationMetaPackage.getPackageName(context, element));
    }

    public static AnnotationMetaPackage create(PackageElement element, Context context) {
        return new AnnotationMetaPackage(element, context);
    }

    @Override
    public final Context getContext() {
        return this.context;
    }

    @Override
    public boolean isImplementation() {
        return false;
    }

    @Override
    public final String getSimpleName() {
        return this.element.getSimpleName().toString();
    }

    @Override
    public final String getQualifiedName() {
        return this.element.getQualifiedName().toString();
    }

    @Override
    public @Nullable Element getSuperTypeElement() {
        return null;
    }

    @Override
    public final String getPackageName() {
        return AnnotationMetaPackage.getPackageName(this.context, this.element);
    }

    private static String getPackageName(Context context, PackageElement packageOf) {
        return context.getElementUtils().getName(packageOf.getQualifiedName()).toString();
    }

    @Override
    public List<MetaAttribute> getMembers() {
        if (!this.initialized) {
            this.init();
        }
        return new ArrayList<MetaAttribute>(this.members.values());
    }

    @Override
    public boolean isMetaComplete() {
        return false;
    }

    @Override
    public final String generateImports() {
        return this.importContext.generateImports();
    }

    @Override
    public final String importType(String fqcn) {
        return this.importContext.importType(fqcn);
    }

    @Override
    public final String staticImport(String fqcn, String member) {
        return this.importContext.staticImport(fqcn, member);
    }

    @Override
    public final PackageElement getElement() {
        return this.element;
    }

    public String toString() {
        return "AnnotationMetaPackage" + "{element=" + this.element + '}';
    }

    protected final void init() {
        this.getContext().logMessage(Diagnostic.Kind.OTHER, "Initializing type " + this.getQualifiedName() + ".");
        this.addAuxiliaryMembers();
        this.checkNamedQueries();
        this.initialized = true;
    }

    @Override
    void putMember(String name, MetaAttribute nameMetaAttribute) {
        this.members.put(name, nameMetaAttribute);
    }

    @Override
    boolean isRepository() {
        return false;
    }

    @Override
    @Nullable String getSessionType() {
        return null;
    }

    @Override
    public boolean isInjectable() {
        return false;
    }

    @Override
    public String scope() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public boolean isJakartaDataStyle() {
        return false;
    }

    @Override
    public List<AnnotationMirror> inheritedAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public String javadoc() {
        return "/**\n * Static metamodel package {@link " + String.valueOf(this.element.getQualifiedName()) + "}\n **/";
    }
}

