/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.validation;

import jakarta.persistence.metamodel.Bindable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EntityNameResolver;
import org.hibernate.MappingException;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.internal.DefaultCustomEntityDirtinessStrategy;
import org.hibernate.boot.internal.MetadataImpl;
import org.hibernate.boot.internal.StandardEntityNotFoundDelegate;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyJpaCompliantImpl;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategyStandardImpl;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.registry.internal.BootstrapServiceRegistryImpl;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.boot.registry.selector.internal.StrategySelectorImpl;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.EffectiveMappingDefaults;
import org.hibernate.boot.spi.MappingDefaults;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.internal.DisabledCaching;
import org.hibernate.cache.spi.CacheImplementor;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.query.internal.NativeQueryInterpreterStandardImpl;
import org.hibernate.engine.query.spi.NativeQueryInterpreter;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.jpa.internal.MutableJpaComplianceImpl;
import org.hibernate.jpa.spi.MutableJpaCompliance;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.AttributeClassification;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.internal.AbstractPluralAttribute;
import org.hibernate.metamodel.model.domain.internal.BagAttributeImpl;
import org.hibernate.metamodel.model.domain.internal.BasicSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.BasicTypeImpl;
import org.hibernate.metamodel.model.domain.internal.EmbeddableTypeImpl;
import org.hibernate.metamodel.model.domain.internal.EmbeddedSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.EntityTypeImpl;
import org.hibernate.metamodel.model.domain.internal.JpaMetamodelImpl;
import org.hibernate.metamodel.model.domain.internal.ListAttributeImpl;
import org.hibernate.metamodel.model.domain.internal.MapAttributeImpl;
import org.hibernate.metamodel.model.domain.internal.MappedSuperclassTypeImpl;
import org.hibernate.metamodel.model.domain.internal.MappingMetamodelImpl;
import org.hibernate.metamodel.model.domain.internal.PluralAttributeBuilder;
import org.hibernate.metamodel.model.domain.internal.SetAttributeImpl;
import org.hibernate.metamodel.model.domain.internal.SingularAttributeImpl;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.metamodel.spi.RuntimeMetamodelsImplementor;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.processor.validation.MockCollectionPersister;
import org.hibernate.processor.validation.MockEntityPersister;
import org.hibernate.processor.validation.MockJdbcServicesInitiator;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.query.criteria.ValueHandlingMode;
import org.hibernate.query.hql.HqlTranslator;
import org.hibernate.query.hql.internal.StandardHqlTranslator;
import org.hibernate.query.hql.spi.SqmCreationOptions;
import org.hibernate.query.internal.NamedObjectRepositoryImpl;
import org.hibernate.query.internal.QueryInterpretationCacheDisabledImpl;
import org.hibernate.query.named.NamedObjectRepository;
import org.hibernate.query.spi.ImmutableEntityUpdateQueryHandlingMode;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryEngineOptions;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.sql.internal.SqlTranslationEngineImpl;
import org.hibernate.query.sql.spi.SqlTranslationEngine;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.internal.SqmCriteriaNodeBuilder;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.sql.StandardSqmTranslatorFactory;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddableDomainType;
import org.hibernate.query.sqm.tree.domain.SqmPersistentAttribute;
import org.hibernate.query.sqm.tree.domain.SqmSingularPersistentAttribute;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.stat.internal.StatisticsImpl;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.BagType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BindingContext;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.ListType;
import org.hibernate.type.MapType;
import org.hibernate.type.SetType;
import org.hibernate.type.TimeZoneStorageStrategy;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.UnknownBasicJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.ObjectJdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class MockSessionFactory
implements SessionFactoryImplementor,
SessionFactoryOptions,
QueryEngine,
FunctionContributions,
MetadataBuildingOptions,
MetadataBuildingContext,
RuntimeModelCreationContext,
BootstrapContext,
JdbcTypeIndicators,
RuntimeMetamodelsImplementor {
    private static final BasicTypeImpl<Object> OBJECT_BASIC_TYPE = new BasicTypeImpl((JavaType)new UnknownBasicJavaType(Object.class), (JdbcType)ObjectJdbcType.INSTANCE);
    private final TypeConfiguration typeConfiguration;
    private final Map<String, MockEntityPersister> entityPersistersByName = new HashMap<String, MockEntityPersister>();
    private final Map<String, MockCollectionPersister> collectionPersistersByName = new HashMap<String, MockCollectionPersister>();
    private final StandardServiceRegistryImpl serviceRegistry;
    private final SqmFunctionRegistry functionRegistry;
    private final MappingMetamodelImpl metamodel;
    private final MetadataImplementor bootModel;
    private final NodeBuilder nodeBuilder;
    private final SqlTranslationEngine sqlTranslationEngine;
    private final ClassLoaderServiceImpl classLoaderService = new ClassLoaderServiceImpl(){

        public Class<?> classForName(String className) {
            try {
                return super.classForName(className);
            }
            catch (ClassLoadingException e) {
                if (MockSessionFactory.this.isClassDefined(className)) {
                    return Object[].class;
                }
                throw e;
            }
        }
    };
    private static final SessionFactoryObserver[] NO_OBSERVERS = new SessionFactoryObserver[0];
    private static final EntityNameResolver[] NO_RESOLVERS = new EntityNameResolver[0];
    static MutableJpaCompliance jpaCompliance = new MutableJpaComplianceImpl(Collections.emptyMap());

    public MockSessionFactory() {
        this.serviceRegistry = StandardServiceRegistryImpl.create((BootstrapServiceRegistry)new BootstrapServiceRegistryImpl(true, (ClassLoaderService)this.classLoaderService, (StrategySelector)new StrategySelectorImpl((ClassLoaderService)this.classLoaderService), Collections::emptyList), Collections.singletonList(MockJdbcServicesInitiator.INSTANCE), Collections.emptyList(), Collections.emptyMap());
        this.functionRegistry = new SqmFunctionRegistry();
        this.metamodel = new MockMappingMetamodelImpl();
        this.bootModel = new MetadataImpl(UUID.randomUUID(), (MetadataBuildingOptions)this, Collections.emptyMap(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), new Database((MetadataBuildingOptions)this, MockJdbcServicesInitiator.jdbcServices.getJdbcEnvironment()), (BootstrapContext)this);
        this.typeConfiguration = new TypeConfiguration();
        this.typeConfiguration.scope((MetadataBuildingContext)this);
        MockJdbcServicesInitiator.genericDialect.initializeFunctionRegistry((FunctionContributions)this);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory((FunctionContributions)this);
        functionFactory.listagg(null);
        functionFactory.inverseDistributionOrderedSetAggregates();
        functionFactory.hypotheticalOrderedSetAggregates();
        functionFactory.windowFunctions();
        this.typeConfiguration.scope((SessionFactoryImplementor)this);
        this.nodeBuilder = new SqmCriteriaNodeBuilder("", "", (QueryEngine)this, (QueryEngineOptions)this, (BindingContext)this);
        this.sqlTranslationEngine = new SqlTranslationEngineImpl((SessionFactoryImplementor)this, this.typeConfiguration, Collections.emptyMap());
    }

    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    public ClassLoaderService getClassLoaderService() {
        return this.classLoaderService;
    }

    public void addObserver(SessionFactoryObserver observer) {
    }

    public MetadataBuildingOptions getBuildingOptions() {
        return this;
    }

    public PhysicalNamingStrategy getPhysicalNamingStrategy() {
        return new PhysicalNamingStrategyStandardImpl();
    }

    public ImplicitNamingStrategy getImplicitNamingStrategy() {
        return new ImplicitNamingStrategyJpaCompliantImpl();
    }

    static CollectionType createCollectionType(String role, String name) {
        return switch (name) {
            case "Set", "SortedSet" -> new SetType(role, null);
            case "List", "SortedList" -> new ListType(role, null);
            case "Map", "SortedMap" -> new MapType(role, null);
            default -> new BagType(role, null);
        };
    }

    abstract MockEntityPersister createMockEntityPersister(String var1);

    abstract MockCollectionPersister createMockCollectionPersister(String var1);

    abstract boolean isEntityDefined(String var1);

    abstract String qualifyName(String var1);

    abstract boolean isAttributeDefined(String var1, String var2);

    abstract boolean isClassDefined(String var1);

    protected abstract boolean isEntity(String var1);

    abstract boolean isEnum(String var1);

    abstract boolean isEnumConstant(String var1, String var2);

    abstract Class<?> javaConstantType(String var1, String var2);

    abstract boolean isFieldDefined(String var1, String var2);

    abstract boolean isConstructorDefined(String var1, List<Type> var2);

    abstract Type propertyType(String var1, String var2);

    protected abstract boolean isSubtype(String var1, String var2);

    protected abstract String getSupertype(String var1);

    private EntityPersister createEntityPersister(String entityName) {
        MockEntityPersister result = this.entityPersistersByName.get(entityName);
        if (result != null) {
            return result;
        }
        result = this.createMockEntityPersister(entityName);
        this.entityPersistersByName.put(entityName, result);
        return result;
    }

    private CollectionPersister createCollectionPersister(String entityName) {
        MockCollectionPersister result = this.collectionPersistersByName.get(entityName);
        if (result != null) {
            return result;
        }
        result = this.createMockCollectionPersister(entityName);
        this.collectionPersistersByName.put(entityName, result);
        return result;
    }

    List<MockEntityPersister> getMockEntityPersisters() {
        return this.entityPersistersByName.values().stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Type getIdentifierType(String className) throws MappingException {
        return this.createEntityPersister(className).getIdentifierType();
    }

    public BasicType<?> getVersionType(String className) throws MappingException {
        return this.createEntityPersister(className).getVersionType();
    }

    public String getIdentifierPropertyName(String className) throws MappingException {
        return this.createEntityPersister(className).getIdentifierPropertyName();
    }

    public Type getReferencedPropertyType(String className, String propertyName) throws MappingException {
        return this.createEntityPersister(className).getPropertyType(propertyName);
    }

    public MappingMetamodelImplementor getMetamodel() {
        return this.metamodel;
    }

    public StandardServiceRegistryImpl getServiceRegistry() {
        return this.serviceRegistry;
    }

    public JdbcServices getJdbcServices() {
        return MockJdbcServicesInitiator.jdbcServices;
    }

    public String getName() {
        return "mock";
    }

    public SessionFactoryOptions getSessionFactoryOptions() {
        return this;
    }

    public Set<String> getDefinedFilterNames() {
        return Collections.emptySet();
    }

    public CacheImplementor getCache() {
        return new DisabledCaching((SessionFactoryImplementor)this);
    }

    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return new StandardEntityNotFoundDelegate();
    }

    public CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy() {
        return new DefaultCustomEntityDirtinessStrategy();
    }

    public CurrentTenantIdentifierResolver<Object> getCurrentTenantIdentifierResolver() {
        return null;
    }

    public JavaType<Object> getTenantIdentifierJavaType() {
        return null;
    }

    public boolean isPreferJavaTimeJdbcTypesEnabled() {
        return super.isPreferJavaTimeJdbcTypesEnabled();
    }

    public boolean isPreferNativeEnumTypesEnabled() {
        return super.isPreferNativeEnumTypesEnabled();
    }

    public boolean isXmlFormatMapperLegacyFormatEnabled() {
        return false;
    }

    public ValueHandlingMode getCriteriaValueHandlingMode() {
        return ValueHandlingMode.BIND;
    }

    public void close() {
    }

    public RootGraphImplementor<?> findEntityGraphByName(String s) {
        throw new UnsupportedOperationException("operation not supported");
    }

    static Class<?> toPrimitiveClass(Class<?> type) {
        return switch (type.getName()) {
            case "java.lang.Boolean" -> Boolean.TYPE;
            case "java.lang.Character" -> Character.TYPE;
            case "java.lang.Integer" -> Integer.TYPE;
            case "java.lang.Short" -> Short.TYPE;
            case "java.lang.Byte" -> Byte.TYPE;
            case "java.lang.Long" -> Long.TYPE;
            case "java.lang.Float" -> Float.TYPE;
            case "java.lang.Double" -> Double.TYPE;
            default -> Object.class;
        };
    }

    public NativeQueryInterpreter getNativeQueryInterpreter() {
        return new NativeQueryInterpreterStandardImpl(this.getNativeJdbcParametersIgnored());
    }

    public QueryInterpretationCache getInterpretationCache() {
        return new QueryInterpretationCacheDisabledImpl((ServiceRegistry)this.serviceRegistry);
    }

    public StatisticsImplementor getStatistics() {
        return new StatisticsImpl((SessionFactoryImplementor)this);
    }

    public SqmFunctionRegistry getSqmFunctionRegistry() {
        return this.functionRegistry;
    }

    public NodeBuilder getCriteriaBuilder() {
        return this.nodeBuilder;
    }

    public void validateNamedQueries() {
    }

    public NamedObjectRepository getNamedObjectRepository() {
        return new NamedObjectRepositoryImpl(new HashMap(), new HashMap(), new HashMap(), new HashMap());
    }

    public HqlTranslator getHqlTranslator() {
        return new StandardHqlTranslator((SqmCreationContext)this.nodeBuilder, new SqmCreationOptions(){});
    }

    public SqmTranslatorFactory getSqmTranslatorFactory() {
        return new StandardSqmTranslatorFactory();
    }

    public QueryEngine getQueryEngine() {
        return this;
    }

    public SqlTranslationEngine getSqlTranslationEngine() {
        return this.sqlTranslationEngine;
    }

    public JpaMetamodelImplementor getJpaMetamodel() {
        return this.metamodel.getJpaMetamodel();
    }

    public MappingMetamodelImplementor getMappingMetamodel() {
        return this.metamodel;
    }

    public RuntimeMetamodelsImplementor getRuntimeMetamodels() {
        return this;
    }

    public boolean isClosed() {
        return false;
    }

    public MutableJpaCompliance getJpaCompliance() {
        return jpaCompliance;
    }

    public String getSessionFactoryName() {
        return "mock";
    }

    public String getUuid() {
        return "mock";
    }

    public SessionFactoryObserver[] getSessionFactoryObservers() {
        return NO_OBSERVERS;
    }

    public EntityNameResolver[] getEntityNameResolvers() {
        return NO_RESOLVERS;
    }

    public boolean isDelayBatchFetchLoaderCreationsEnabled() {
        return false;
    }

    public Integer getMaximumFetchDepth() {
        return null;
    }

    public boolean allowImmutableEntityUpdate() {
        return true;
    }

    public ImmutableEntityUpdateQueryHandlingMode getImmutableEntityUpdateQueryHandlingMode() {
        return ImmutableEntityUpdateQueryHandlingMode.ALLOW;
    }

    public void setCheckNullability(boolean enabled) {
    }

    public Dialect getDialect() {
        return MockJdbcServicesInitiator.genericDialect;
    }

    public int getPreferredSqlTypeCodeForBoolean() {
        return 16;
    }

    public int getPreferredSqlTypeCodeForDuration() {
        return 2;
    }

    public int getPreferredSqlTypeCodeForUuid() {
        return 3000;
    }

    public int getPreferredSqlTypeCodeForInstant() {
        return 2014;
    }

    public int getPreferredSqlTypeCodeForArray() {
        return 2003;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this;
    }

    public BootstrapContext getBootstrapContext() {
        return this;
    }

    public MetadataImplementor getBootModel() {
        return this.bootModel;
    }

    public MappingMetamodelImplementor getDomainModel() {
        return this.metamodel;
    }

    public SqmFunctionRegistry getFunctionRegistry() {
        return this.functionRegistry;
    }

    public Map<String, Object> getSettings() {
        return Collections.emptyMap();
    }

    public SqlStringGenerationContext getSqlStringGenerationContext() {
        throw new UnsupportedOperationException("operation not supported");
    }

    public MappingDefaults getMappingDefaults() {
        return new MockMappingDefaults();
    }

    public EffectiveMappingDefaults getEffectiveDefaults() {
        throw new UnsupportedOperationException();
    }

    public TimeZoneStorageStrategy getDefaultTimeZoneStorageStrategy() {
        return TimeZoneStorageStrategy.NATIVE;
    }

    @Nullable Set<String> getEnumTypesForValue(String value) {
        return Collections.emptySet();
    }

    protected abstract String getJpaEntityName(String var1);

    private <T> SqmPersistentAttribute<T, ?> createAttribute(String name, String entityName, Type type, ManagedDomainType<T> owner) {
        JavaType javaType;
        if (type == null) {
            throw new UnsupportedOperationException(entityName + "." + name);
        }
        if (type.isCollectionType()) {
            CollectionType collectionType = (CollectionType)type;
            return this.createPluralAttribute(collectionType, entityName, name, owner);
        }
        if (type.isEntityType()) {
            return new SingularAttributeImpl(owner, name, AttributeClassification.MANY_TO_ONE, new MockEntityDomainType(new MockJavaType(type.getName())), null, null, false, false, true, false);
        }
        if (type.isComponentType()) {
            CompositeType compositeType = (CompositeType)type;
            return new SingularAttributeImpl(owner, name, AttributeClassification.EMBEDDED, this.createEmbeddableDomainType(entityName, compositeType, owner), null, null, false, false, true, false);
        }
        SqmDomainType sqmDomainType = (SqmDomainType)type;
        if (type instanceof JdbcMapping) {
            JdbcMapping jdbcMapping = (JdbcMapping)type;
            javaType = jdbcMapping.getJavaTypeDescriptor();
        } else {
            javaType = null;
        }
        return new SingularAttributeImpl(owner, name, AttributeClassification.BASIC, sqmDomainType, javaType, null, false, false, true, false);
    }

    private SqmDomainType<?> getElementDomainType(String entityName, CollectionType collectionType, ManagedDomainType<?> owner) {
        Type elementType = collectionType.getElementType((SessionFactoryImplementor)this);
        return this.getDomainType(entityName, collectionType, owner, elementType);
    }

    private DomainType<?> getMapKeyDomainType(String entityName, CollectionType collectionType, ManagedDomainType<?> owner) {
        Type keyType = this.getMappingMetamodel().getCollectionDescriptor(collectionType.getRole()).getIndexType();
        return this.getDomainType(entityName, collectionType, owner, keyType);
    }

    private SqmDomainType<?> getDomainType(String entityName, CollectionType collectionType, ManagedDomainType<?> owner, Type elementType) {
        if (elementType.isEntityType()) {
            String associatedEntityName = collectionType.getAssociatedEntityName((SessionFactoryImplementor)this);
            return new MockEntityDomainType(new MockJavaType(associatedEntityName));
        }
        if (elementType.isComponentType()) {
            CompositeType compositeType = (CompositeType)elementType;
            return this.createEmbeddableDomainType(entityName, compositeType, owner);
        }
        if (elementType instanceof SqmDomainType) {
            SqmDomainType domainType = (SqmDomainType)elementType;
            return domainType;
        }
        return OBJECT_BASIC_TYPE;
    }

    private <T> AbstractPluralAttribute<T, ?, ?> createPluralAttribute(CollectionType collectionType, String entityName, String name, ManagedDomainType<T> owner) {
        Property property = new Property();
        property.setName(name);
        JavaType collectionJavaType = this.typeConfiguration.getJavaTypeRegistry().resolveDescriptor(collectionType.getReturnedClass());
        SqmDomainType<?> elementDomainType = this.getElementDomainType(entityName, collectionType, owner);
        CollectionClassification classification = collectionType.getCollectionClassification();
        return switch (classification) {
            case CollectionClassification.LIST -> new ListAttributeImpl(new PluralAttributeBuilder(collectionJavaType, true, AttributeClassification.MANY_TO_MANY, classification, elementDomainType, (DomainType)this.typeConfiguration.getBasicTypeRegistry().getRegisteredType(Integer.class), owner, property, null));
            case CollectionClassification.BAG, CollectionClassification.ID_BAG -> new BagAttributeImpl(new PluralAttributeBuilder(collectionJavaType, true, AttributeClassification.MANY_TO_MANY, classification, elementDomainType, null, owner, property, null));
            case CollectionClassification.SET, CollectionClassification.SORTED_SET, CollectionClassification.ORDERED_SET -> new SetAttributeImpl(new PluralAttributeBuilder(collectionJavaType, true, AttributeClassification.MANY_TO_MANY, classification, elementDomainType, null, owner, property, null));
            case CollectionClassification.MAP, CollectionClassification.SORTED_MAP, CollectionClassification.ORDERED_MAP -> new MapAttributeImpl(new PluralAttributeBuilder(collectionJavaType, true, AttributeClassification.MANY_TO_MANY, classification, elementDomainType, this.getMapKeyDomainType(entityName, collectionType, owner), owner, property, null));
            default -> null;
        };
    }

    private <T> EmbeddableTypeImpl<T> createEmbeddableDomainType(final String entityName, final CompositeType compositeType, final ManagedDomainType<T> owner) {
        UnknownBasicJavaType javaType = new UnknownBasicJavaType(null, compositeType.getReturnedClassName());
        return new EmbeddableTypeImpl<T>(this, (JavaType)javaType, null, null, true, this.metamodel.getJpaMetamodel()){
            final /* synthetic */ MockSessionFactory this$0;
            {
                this.this$0 = this$0;
                super(javaType, superType, discriminatorType, isDynamic, domainMetamodel);
            }

            public SqmPersistentAttribute<T, ?> findAttribute(String name) {
                return this.this$0.createAttribute(name, entityName, compositeType.getSubtypes()[compositeType.getPropertyIndex(name)], owner);
            }
        };
    }

    private class MockMappingMetamodelImpl
    extends MappingMetamodelImpl {
        public MockMappingMetamodelImpl() {
            super(MockSessionFactory.this.typeConfiguration, (ServiceRegistry)MockSessionFactory.this.serviceRegistry);
        }

        public EntityPersister getEntityDescriptor(String entityName) {
            return MockSessionFactory.this.createEntityPersister(entityName);
        }

        public CollectionPersister getCollectionDescriptor(String role) {
            return MockSessionFactory.this.createCollectionPersister(role);
        }

        public CollectionPersister findCollectionDescriptor(String role) {
            return MockSessionFactory.this.createCollectionPersister(role);
        }

        public JpaMetamodelImplementor getJpaMetamodel() {
            return new MockJpaMetamodelImpl();
        }

        public EntityPersister findEntityDescriptor(String entityName) {
            return MockSessionFactory.this.createEntityPersister(entityName);
        }

        public Set<String> getEnumTypesForValue(String enumValue) {
            return MockSessionFactory.this.getEnumTypesForValue(enumValue);
        }
    }

    private static class MockMappingDefaults
    implements MappingDefaults {
        private MockMappingDefaults() {
        }

        public String getImplicitSchemaName() {
            return null;
        }

        public String getImplicitCatalogName() {
            return null;
        }

        public boolean shouldImplicitlyQuoteIdentifiers() {
            return false;
        }

        public String getImplicitIdColumnName() {
            return null;
        }

        public String getImplicitTenantIdColumnName() {
            return null;
        }

        public String getImplicitDiscriminatorColumnName() {
            return null;
        }

        public String getImplicitPackageName() {
            return null;
        }

        public boolean isAutoImportEnabled() {
            return false;
        }

        public String getImplicitCascadeStyleName() {
            return null;
        }

        public String getImplicitPropertyAccessorName() {
            return null;
        }

        public boolean areEntitiesImplicitlyLazy() {
            return false;
        }

        public boolean areCollectionsImplicitlyLazy() {
            return false;
        }

        public AccessType getImplicitCacheAccessType() {
            return null;
        }

        public CollectionClassification getImplicitListClassification() {
            return null;
        }
    }

    class MockEntityDomainType<X>
    extends EntityTypeImpl<X> {
        public MockEntityDomainType(JavaType<X> javaType) {
            this(javaType, this$0.getJpaEntityName(javaType.getTypeName()));
        }

        public MockEntityDomainType(JavaType<X> javaType, String jpaEntityName) {
            super(javaType.getTypeName(), jpaEntityName, false, true, false, javaType, null, MockSessionFactory.this.metamodel.getJpaMetamodel());
        }

        public SqmSingularPersistentAttribute<? super X, ?> findVersionAttribute() {
            BasicType<?> type = MockSessionFactory.this.getVersionType(this.getHibernateEntityName());
            if (type == null) {
                return null;
            }
            return new SingularAttributeImpl((ManagedDomainType)this, "{version}", AttributeClassification.BASIC, type, type.getRelationalJavaType(), null, false, true, false, false);
        }

        public boolean hasVersionAttribute() {
            return MockSessionFactory.this.getVersionType(this.getHibernateEntityName()) != null;
        }

        public SqmPathSource<?> getIdentifierDescriptor() {
            Type type = MockSessionFactory.this.getIdentifierType(this.getHibernateEntityName());
            if (type instanceof BasicDomainType) {
                BasicDomainType basicDomainType = (BasicDomainType)type;
                return new BasicSqmPathSource("{id}", null, basicDomainType, this.getExpressibleJavaType(), Bindable.BindableType.SINGULAR_ATTRIBUTE, false);
            }
            if (type instanceof SqmEmbeddableDomainType) {
                SqmEmbeddableDomainType embeddableDomainType = (SqmEmbeddableDomainType)type;
                return new EmbeddedSqmPathSource("{id}", null, embeddableDomainType, Bindable.BindableType.SINGULAR_ATTRIBUTE, false);
            }
            return null;
        }

        public SqmPathSource<?> findSubPathSource(String name, boolean includeSubtypes) {
            switch (name) {
                case "{id}": {
                    return this.getIdentifierDescriptor();
                }
                case "{version}": {
                    return this.findVersionAttribute();
                }
            }
            SqmPathSource source = super.findSubPathSource(name, includeSubtypes);
            if (source != null) {
                return source;
            }
            String supertype = MockSessionFactory.this.getSupertype(this.getHibernateEntityName());
            SqmPersistentAttribute superattribute = new MockMappedDomainType(supertype).findAttribute(name);
            if (superattribute != null) {
                return (SqmPathSource)superattribute;
            }
            for (Map.Entry<String, MockEntityPersister> entry : MockSessionFactory.this.entityPersistersByName.entrySet()) {
                MockEntityDomainType entityDomainType;
                SqmPersistentAttribute subattribute;
                MockEntityPersister entityPersister = entry.getValue();
                if (entityPersister.getEntityName().equals(this.getHibernateEntityName()) || !MockSessionFactory.this.isSubtype(entityPersister.getEntityName(), this.getHibernateEntityName()) || (subattribute = (entityDomainType = new MockEntityDomainType(new MockJavaType(entityPersister.getEntityName()), entityPersister.getJpaEntityName())).findAttribute(name)) == null) continue;
                return (SqmPathSource)subattribute;
            }
            return null;
        }

        public SqmPersistentAttribute<? super X, ?> findAttribute(String name) {
            SqmPersistentAttribute attribute = super.findAttribute(name);
            if (attribute != null) {
                return attribute;
            }
            String supertype = MockSessionFactory.this.getSupertype(this.getHibernateEntityName());
            return new MockMappedDomainType(supertype).findAttribute(name);
        }

        public SqmPersistentAttribute<X, ?> findDeclaredAttribute(String name) {
            String entityName = this.getHibernateEntityName();
            return MockSessionFactory.this.isAttributeDefined(entityName, name) ? MockSessionFactory.this.createAttribute(name, entityName, MockSessionFactory.this.getReferencedPropertyType(entityName, name), this) : null;
        }
    }

    private static class MockJavaType<X>
    implements BasicJavaType<X> {
        private final String typeName;

        public MockJavaType(String typeName) {
            this.typeName = typeName;
        }

        public <X1> X1 unwrap(X value, Class<X1> type, WrapperOptions options) {
            return null;
        }

        public <X1> X wrap(X1 value, WrapperOptions options) {
            return null;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Class<X> getJavaTypeClass() {
            try {
                return Class.forName(this.typeName);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    }

    class MockMappedDomainType<X>
    extends MappedSuperclassTypeImpl<X> {
        public MockMappedDomainType(String typeName) {
            super(typeName, false, true, false, null, null, MockSessionFactory.this.metamodel.getJpaMetamodel());
        }

        public SqmPersistentAttribute<X, ?> findDeclaredAttribute(String name) {
            String typeName = this.getTypeName();
            return MockSessionFactory.this.isFieldDefined(typeName, name) ? MockSessionFactory.this.createAttribute(name, typeName, MockSessionFactory.this.propertyType(typeName, name), this) : null;
        }
    }

    private class MockJpaMetamodelImpl
    extends JpaMetamodelImpl {
        public MockJpaMetamodelImpl() {
            super(MockSessionFactory.this.typeConfiguration, (MappingMetamodel)MockSessionFactory.this.metamodel, (ServiceRegistry)MockSessionFactory.this.serviceRegistry);
        }

        public @Nullable EntityDomainType<?> findEntityType(@Nullable String jpaEntityName) {
            String entityTypeName = MockSessionFactory.this.qualifyName(jpaEntityName);
            if (entityTypeName != null) {
                return new MockEntityDomainType(new MockJavaType(entityTypeName), jpaEntityName);
            }
            return null;
        }

        public String qualifyImportableName(String queryName) {
            if (MockSessionFactory.this.isClassDefined(queryName)) {
                return queryName;
            }
            if (MockSessionFactory.this.isEntityDefined(queryName)) {
                return MockSessionFactory.this.qualifyName(queryName);
            }
            return null;
        }

        public <X> @Nullable ManagedDomainType<X> findManagedType(@Nullable String typeName) {
            return typeName == null ? null : new MockEntityDomainType(new MockJavaType(typeName));
        }

        public <X> ManagedDomainType<X> findManagedType(Class<X> cls) {
            return this.findManagedType(cls.getName());
        }

        public <X> EntityDomainType<X> findEntityType(Class<X> cls) {
            return !cls.isArray() && !cls.isPrimitive() && MockSessionFactory.this.isEntity(cls.getName()) ? new MockEntityDomainType(new MockJavaType(cls.getName())) : null;
        }

        public EnumJavaType<?> getEnumType(final String className) {
            if (MockSessionFactory.this.isEnum(className)) {
                return new EnumJavaType(this, Enum.class){
                    final /* synthetic */ MockJpaMetamodelImpl this$1;
                    {
                        this.this$1 = this$1;
                        super(type);
                    }

                    public String getTypeName() {
                        return className;
                    }
                };
            }
            return null;
        }

        public JavaType<?> getJavaConstantType(String className, String fieldName) {
            return MockSessionFactory.this.getTypeConfiguration().getJavaTypeRegistry().resolveDescriptor(MockSessionFactory.this.javaConstantType(className, fieldName));
        }

        public <T> T getJavaConstant(String className, String fieldName) {
            return null;
        }

        public <E extends Enum<E>> E enumValue(EnumJavaType<E> enumType, String enumValueName) {
            if (!MockSessionFactory.this.isEnumConstant(enumType.getTypeName(), enumValueName)) {
                throw new IllegalArgumentException("No enum constant " + enumType.getTypeName() + "." + enumValueName);
            }
            return null;
        }

        public @Nullable Set<String> getEnumTypesForValue(String enumValue) {
            return MockSessionFactory.this.getEnumTypesForValue(enumValue);
        }
    }
}

