/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.xml;

import jakarta.persistence.AccessType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.MappingException;
import org.hibernate.boot.ResourceStreamLocator;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.jaxb.configuration.spi.JaxbPersistenceImpl;
import org.hibernate.boot.jaxb.internal.ConfigurationBinder;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbMappedSuperclassImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPersistenceUnitDefaultsImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPersistenceUnitMetadataImpl;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.processor.Context;
import org.hibernate.processor.util.AccessTypeInformation;
import org.hibernate.processor.util.FileTimeStampChecker;
import org.hibernate.processor.util.StringUtil;
import org.hibernate.processor.util.TypeUtils;
import org.hibernate.processor.util.xml.XmlParserHelper;
import org.hibernate.processor.xml.ResourceStreamLocatorImpl;
import org.hibernate.processor.xml.XmlMetaEntity;

public class JpaDescriptorParser {
    private static final String DEFAULT_ORM_XML_LOCATION = "/META-INF/orm.xml";
    private static final String SERIALIZATION_FILE_NAME = "Hibernate-Static-Metamodel-Generator.tmp";
    private final Context context;
    private final List<JaxbEntityMappingsImpl> entityMappings;
    private final XmlParserHelper xmlParserHelper;
    private final ConfigurationBinder configurationBinder;
    private final MappingBinder mappingBinder;

    public JpaDescriptorParser(Context context) {
        this.context = context;
        this.entityMappings = new ArrayList<JaxbEntityMappingsImpl>();
        this.xmlParserHelper = new XmlParserHelper(context);
        ResourceStreamLocatorImpl resourceStreamLocator = new ResourceStreamLocatorImpl(context);
        this.configurationBinder = new ConfigurationBinder((ResourceStreamLocator)resourceStreamLocator);
        this.mappingBinder = new MappingBinder((ResourceStreamLocator)resourceStreamLocator, (Function)null);
    }

    public void parseMappingXml() {
        Collection<String> mappingFileNames = this.determineMappingFileNames();
        if (this.context.doLazyXmlParsing() && this.mappingFilesUnchanged(mappingFileNames)) {
            return;
        }
        this.loadEntityMappings(mappingFileNames);
        this.determineDefaultAccessTypeAndMetaCompleteness();
        this.determineXmlAccessTypes();
        if (!this.context.isFullyXmlConfigured()) {
            this.determineAnnotationAccessTypes();
        }
        for (JaxbEntityMappingsImpl mappings : this.entityMappings) {
            String defaultPackageName = mappings.getPackage();
            this.parseEntities(mappings.getEntities(), defaultPackageName);
            this.parseEmbeddable(mappings.getEmbeddables(), defaultPackageName);
            this.parseMappedSuperClass(mappings.getMappedSuperclasses(), defaultPackageName);
        }
    }

    private Collection<String> determineMappingFileNames() {
        ArrayList<String> mappingFileNames = new ArrayList<String>();
        JaxbPersistenceImpl persistence = this.getPersistence();
        if (persistence != null) {
            List persistenceUnits = persistence.getPersistenceUnit();
            for (JaxbPersistenceImpl.JaxbPersistenceUnitImpl unit : persistenceUnits) {
                mappingFileNames.addAll(unit.getMappingFiles());
            }
        }
        mappingFileNames.add(DEFAULT_ORM_XML_LOCATION);
        mappingFileNames.addAll(this.context.getOrmXmlFiles());
        return mappingFileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable JaxbPersistenceImpl getPersistence() {
        JaxbPersistenceImpl persistence = null;
        String persistenceXmlLocation = this.context.getPersistenceXmlLocation();
        InputStream stream = this.xmlParserHelper.getInputStreamForResource(persistenceXmlLocation);
        if (stream == null) {
            return null;
        }
        try {
            Binding binding = this.configurationBinder.bind(stream, new Origin(SourceType.RESOURCE, persistenceXmlLocation));
            persistence = (JaxbPersistenceImpl)binding.getRoot();
        }
        catch (MappingException e) {
            throw e;
        }
        catch (Exception e) {
            this.context.logMessage(Diagnostic.Kind.WARNING, "Unable to parse persistence.xml: " + e.getMessage());
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return persistence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEntityMappings(Collection<String> mappingFileNames) {
        ResourceStreamLocatorImpl resourceStreamLocator = new ResourceStreamLocatorImpl(this.context);
        for (String mappingFile : mappingFileNames) {
            InputStream inputStream = resourceStreamLocator.locateResourceStream(mappingFile);
            if (inputStream == null) continue;
            try {
                Binding binding = this.mappingBinder.bind(inputStream, new Origin(SourceType.RESOURCE, mappingFile));
                if (binding == null) continue;
                this.entityMappings.add((JaxbEntityMappingsImpl)binding.getRoot());
            }
            catch (Exception e) {
                this.context.logMessage(Diagnostic.Kind.WARNING, "Unable to parse " + mappingFile + ": " + e.getMessage());
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean mappingFilesUnchanged(Collection<String> mappingFileNames) {
        boolean mappingFilesUnchanged = false;
        FileTimeStampChecker fileStampCheck = new FileTimeStampChecker();
        for (String mappingFile : mappingFileNames) {
            try {
                URL url = this.getClass().getResource(mappingFile);
                if (url == null) continue;
                File file = new File(url.toURI());
                this.context.logMessage(Diagnostic.Kind.OTHER, "Check file  " + mappingFile);
                if (!file.exists()) continue;
                fileStampCheck.add(mappingFile, file.lastModified());
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        FileTimeStampChecker serializedTimeStampCheck = this.loadTimeStampCache();
        if (serializedTimeStampCheck.equals(fileStampCheck)) {
            this.context.logMessage(Diagnostic.Kind.OTHER, "XML parsing will be skipped due to unchanged xml files");
            mappingFilesUnchanged = true;
        } else {
            this.saveTimeStampCache(fileStampCheck);
        }
        return mappingFilesUnchanged;
    }

    private void saveTimeStampCache(FileTimeStampChecker fileStampCheck) {
        File file = this.getSerializationTmpFile();
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));){
            out.writeObject(fileStampCheck);
            this.context.logMessage(Diagnostic.Kind.OTHER, "Serialized " + String.valueOf(fileStampCheck) + " into " + file.getAbsolutePath());
        }
        catch (IOException e) {
            this.context.logMessage(Diagnostic.Kind.OTHER, "Error serializing  " + String.valueOf(fileStampCheck));
        }
    }

    private File getSerializationTmpFile() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        return new File(tmpDir, SERIALIZATION_FILE_NAME);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private FileTimeStampChecker loadTimeStampCache() {
        File file = this.getSerializationTmpFile();
        if (file.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                FileTimeStampChecker fileTimeStampChecker;
                try (ObjectInputStream in = new ObjectInputStream(fileInputStream);){
                    fileTimeStampChecker = (FileTimeStampChecker)in.readObject();
                }
                return fileTimeStampChecker;
            }
            catch (IOException | ClassNotFoundException exception) {
                // empty catch block
            }
        }
        this.context.logMessage(Diagnostic.Kind.OTHER, "Error de-serializing  " + String.valueOf(file));
        return new FileTimeStampChecker();
    }

    private void parseEntities(List<JaxbEntityImpl> entities, String defaultPackageName) {
        for (JaxbEntityImpl entity : entities) {
            String fqcn = StringUtil.determineFullyQualifiedClassName(defaultPackageName, entity.getClazz());
            if (!this.xmlMappedTypeExists(fqcn)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fqcn + " is mapped in xml, but class does not exist. Skipping meta model generation.");
                continue;
            }
            XmlMetaEntity metaEntity = XmlMetaEntity.create(entity, defaultPackageName, this.getXmlMappedType(fqcn), this.context);
            if (this.context.containsMetaEntity(fqcn)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fqcn + " was already processed once. Skipping second occurrence.");
            }
            this.context.addMetaEntity(fqcn, metaEntity);
        }
    }

    private void parseEmbeddable(List<JaxbEmbeddableImpl> embeddables, String defaultPackageName) {
        for (JaxbEmbeddableImpl embeddable : embeddables) {
            String fqcn = StringUtil.determineFullyQualifiedClassName(defaultPackageName, embeddable.getClazz());
            String pkg = StringUtil.packageNameFromFullyQualifiedName(fqcn);
            if (!this.xmlMappedTypeExists(fqcn)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fqcn + " is mapped in xml, but class does not exist. Skipping meta model generation.");
                continue;
            }
            XmlMetaEntity metaEntity = new XmlMetaEntity(embeddable, pkg, this.getXmlMappedType(fqcn), this.context);
            if (this.context.containsMetaEmbeddable(fqcn)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fqcn + " was already processed once. Skipping second occurrence.");
            }
            this.context.addMetaEmbeddable(fqcn, metaEntity);
        }
    }

    private void parseMappedSuperClass(List<JaxbMappedSuperclassImpl> mappedSuperClasses, String defaultPackageName) {
        for (JaxbMappedSuperclassImpl mappedSuperClass : mappedSuperClasses) {
            String fqcn = StringUtil.determineFullyQualifiedClassName(defaultPackageName, mappedSuperClass.getClazz());
            String pkg = StringUtil.packageNameFromFullyQualifiedName(fqcn);
            if (!this.xmlMappedTypeExists(fqcn)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fqcn + " is mapped in xml, but class does not exist. Skipping meta model generation.");
                continue;
            }
            XmlMetaEntity metaEntity = new XmlMetaEntity(mappedSuperClass, pkg, this.getXmlMappedType(fqcn), this.context);
            if (this.context.containsMetaEntity(fqcn)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fqcn + " was already processed once. Skipping second occurrence.");
            }
            this.context.addMetaEntity(fqcn, metaEntity);
        }
    }

    private boolean xmlMappedTypeExists(String fullyQualifiedClassName) {
        Elements utils = this.context.getElementUtils();
        return utils.getTypeElement(fullyQualifiedClassName) != null;
    }

    private TypeElement getXmlMappedType(String fullyQualifiedClassName) {
        Elements utils = this.context.getElementUtils();
        return utils.getTypeElement(fullyQualifiedClassName);
    }

    private AccessType determineEntityAccessType(JaxbEntityMappingsImpl mappings) {
        AccessType contextAccessType = this.context.getPersistenceUnitDefaultAccessType();
        AccessType mappingsAccess = mappings.getAccess();
        if (mappingsAccess != null) {
            return mappingsAccess;
        }
        return contextAccessType;
    }

    private void determineXmlAccessTypes() {
        for (JaxbEntityMappingsImpl mappings : this.entityMappings) {
            AccessTypeInformation accessInfo;
            AccessType explicitAccessType;
            String fqcn;
            String name;
            String packageName = mappings.getPackage();
            AccessType defaultAccessType = this.determineEntityAccessType(mappings);
            for (JaxbEntityImpl entity : mappings.getEntities()) {
                name = entity.getClazz();
                fqcn = StringUtil.determineFullyQualifiedClassName(packageName, name);
                explicitAccessType = entity.getAccess();
                accessInfo = new AccessTypeInformation(fqcn, explicitAccessType, defaultAccessType);
                this.context.addAccessTypeInformation(fqcn, accessInfo);
            }
            for (JaxbMappedSuperclassImpl mappedSuperClass : mappings.getMappedSuperclasses()) {
                name = mappedSuperClass.getClazz();
                fqcn = StringUtil.determineFullyQualifiedClassName(packageName, name);
                explicitAccessType = mappedSuperClass.getAccess();
                accessInfo = new AccessTypeInformation(fqcn, explicitAccessType, defaultAccessType);
                this.context.addAccessTypeInformation(fqcn, accessInfo);
            }
            for (JaxbEmbeddableImpl embeddable : mappings.getEmbeddables()) {
                name = embeddable.getClazz();
                fqcn = StringUtil.determineFullyQualifiedClassName(packageName, name);
                explicitAccessType = embeddable.getAccess();
                accessInfo = new AccessTypeInformation(fqcn, explicitAccessType, defaultAccessType);
                this.context.addAccessTypeInformation(fqcn, accessInfo);
            }
        }
    }

    private void determineAnnotationAccessTypes() {
        for (JaxbEntityMappingsImpl mappings : this.entityMappings) {
            TypeElement element;
            String fqcn;
            String name;
            String packageName = mappings.getPackage();
            for (JaxbEntityImpl entity : mappings.getEntities()) {
                name = entity.getClazz();
                fqcn = StringUtil.determineFullyQualifiedClassName(packageName, name);
                element = this.context.getTypeElementForFullyQualifiedName(fqcn);
                if (element == null) continue;
                TypeUtils.determineAccessTypeForHierarchy(element, this.context);
            }
            for (JaxbMappedSuperclassImpl mappedSuperClass : mappings.getMappedSuperclasses()) {
                name = mappedSuperClass.getClazz();
                fqcn = StringUtil.determineFullyQualifiedClassName(packageName, name);
                element = this.context.getTypeElementForFullyQualifiedName(fqcn);
                if (element == null) continue;
                TypeUtils.determineAccessTypeForHierarchy(element, this.context);
            }
        }
    }

    private void determineDefaultAccessTypeAndMetaCompleteness() {
        for (JaxbEntityMappingsImpl mappings : this.entityMappings) {
            JaxbPersistenceUnitMetadataImpl meta = mappings.getPersistenceUnitMetadata();
            if (meta != null) {
                AccessType xmlJpaAccessType;
                this.context.mappingDocumentFullyXmlConfigured(meta.getXmlMappingMetadataComplete() != null);
                JaxbPersistenceUnitDefaultsImpl persistenceUnitDefaults = meta.getPersistenceUnitDefaults();
                if (persistenceUnitDefaults == null || (xmlJpaAccessType = persistenceUnitDefaults.getAccess()) == null) continue;
                this.context.setPersistenceUnitDefaultAccessType(xmlJpaAccessType);
                continue;
            }
            this.context.mappingDocumentFullyXmlConfigured(false);
        }
    }
}

