/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.validation;

import jakarta.persistence.AccessType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.internal.ShortNameImplicitDiscriminatorStrategy;
import org.hibernate.metamodel.mapping.DiscriminatorConverter;
import org.hibernate.metamodel.mapping.DiscriminatorType;
import org.hibernate.metamodel.mapping.internal.DiscriminatorTypeImpl;
import org.hibernate.metamodel.mapping.internal.UnifiedAnyDiscriminatorConverter;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.ImplicitDiscriminatorStrategy;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.processor.validation.MockSessionFactory;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;

public abstract class MockEntityPersister
implements EntityPersister,
Joinable {
    private static final String[] ID_COLUMN = new String[]{"id"};
    private final String entityName;
    private final MockSessionFactory factory;
    private final List<MockEntityPersister> subclassPersisters = new ArrayList<MockEntityPersister>();
    final AccessType defaultAccessType;
    private final Map<String, Type> propertyTypesByName = new HashMap<String, Type>();

    public MockEntityPersister(String entityName, AccessType defaultAccessType, MockSessionFactory factory) {
        this.entityName = entityName;
        this.factory = factory;
        this.defaultAccessType = defaultAccessType;
    }

    void initSubclassPersisters() {
        for (MockEntityPersister other : this.factory.getMockEntityPersisters()) {
            other.addPersister(this);
            this.addPersister(other);
        }
    }

    private void addPersister(MockEntityPersister entityPersister) {
        if (this.isSubclassPersister(entityPersister)) {
            this.subclassPersisters.add(entityPersister);
        }
    }

    private Type getSubclassPropertyType(String propertyPath) {
        return this.subclassPersisters.stream().map(sp -> sp.getPropertyType(propertyPath)).filter(Objects::nonNull).findAny().orElse(null);
    }

    abstract boolean isSamePersister(MockEntityPersister var1);

    abstract boolean isSubclassPersister(MockEntityPersister var1);

    public boolean isSubclassEntityName(String name) {
        return this.isSubclassPersister(this.subclassPersisters.stream().filter(persister -> persister.entityName.equals(name)).findFirst().orElseThrow());
    }

    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public EntityMetamodel getEntityMetamodel() {
        throw new UnsupportedOperationException("operation not supported");
    }

    public String getEntityName() {
        return this.entityName;
    }

    public final Type getPropertyType(String propertyPath) {
        Type cached = this.propertyTypesByName.get(propertyPath);
        if (cached == null) {
            Type type = this.propertyType(propertyPath);
            if (type != null) {
                this.propertyTypesByName.put(propertyPath, type);
            }
            return type;
        }
        return cached;
    }

    private Type propertyType(String propertyPath) {
        Type type = this.createPropertyType(propertyPath);
        if (type != null) {
            return type;
        }
        Type typeFromSubclass = this.getSubclassPropertyType(propertyPath);
        if (typeFromSubclass != null) {
            return typeFromSubclass;
        }
        if ("id".equals(propertyPath)) {
            return this.identifierType();
        }
        return null;
    }

    abstract Type createPropertyType(String var1);

    public String getIdentifierPropertyName() {
        return this.getRootEntityPersister().identifierPropertyName();
    }

    protected abstract String identifierPropertyName();

    public Type getIdentifierType() {
        return this.getRootEntityPersister().identifierType();
    }

    protected abstract Type identifierType();

    public BasicType<?> getVersionType() {
        return this.getRootEntityPersister().versionType();
    }

    protected abstract BasicType<?> versionType();

    public abstract String getRootEntityName();

    public MockEntityPersister getRootEntityPersister() {
        return this.factory.createMockEntityPersister(this.getRootEntityName());
    }

    public Set<String> getSubclassEntityNames() {
        HashSet<String> names = new HashSet<String>();
        names.add(this.entityName);
        for (MockEntityPersister persister : this.factory.getMockEntityPersisters()) {
            if (!persister.isSubclassPersister(this)) continue;
            names.add(persister.entityName);
        }
        return names;
    }

    public String[] toColumns(String propertyName) {
        return new String[]{""};
    }

    public String[] getPropertySpaces() {
        return new String[]{this.entityName};
    }

    public Serializable[] getQuerySpaces() {
        return new Serializable[]{this.entityName};
    }

    public EntityPersister getEntityPersister() {
        return this;
    }

    public String[] getIdentifierColumnNames() {
        return ID_COLUMN;
    }

    public DiscriminatorType<?> getDiscriminatorDomainType() {
        BasicType<String> type = this.getDiscriminatorType();
        return new DiscriminatorTypeImpl(type, (DiscriminatorConverter)new UnifiedAnyDiscriminatorConverter(new NavigableRole(this.entityName).append("{discriminator}"), type.getJavaTypeDescriptor(), type.getRelationalJavaType(), Collections.emptyMap(), (ImplicitDiscriminatorStrategy)ShortNameImplicitDiscriminatorStrategy.SHORT_NAME_STRATEGY, this.factory.getMetamodel()));
    }

    public String getTableName() {
        return this.entityName;
    }

    public String toString() {
        return "MockEntityPersister[" + this.entityName + "]";
    }

    public int getVersionPropertyIndex() {
        return 0;
    }

    public boolean isVersioned() {
        return true;
    }

    public String getMappedSuperclass() {
        return null;
    }

    public BasicType<String> getDiscriminatorType() {
        return this.factory.getTypeConfiguration().getBasicTypeForJavaType(String.class);
    }

    public boolean isMutable() {
        return true;
    }
}

