/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.util;

import jakarta.persistence.AccessType;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AccessTypeInformation {
    private final String fullyQualifiedName;
    private @Nullable AccessType explicitAccessType;
    private @Nullable AccessType defaultAccessType;
    static final AccessType DEFAULT_ACCESS_TYPE = AccessType.FIELD;

    public AccessTypeInformation(String fullyQualifiedName, @Nullable AccessType explicitAccessType, @Nullable AccessType defaultAccessType) {
        this.fullyQualifiedName = fullyQualifiedName;
        this.explicitAccessType = explicitAccessType;
        this.defaultAccessType = defaultAccessType;
    }

    public boolean isAccessTypeResolved() {
        return this.explicitAccessType != null || this.defaultAccessType != null;
    }

    public AccessType getAccessType() {
        if (this.explicitAccessType != null) {
            return this.explicitAccessType;
        }
        if (this.defaultAccessType != null) {
            return this.defaultAccessType;
        }
        return DEFAULT_ACCESS_TYPE;
    }

    public void setDefaultAccessType(AccessType defaultAccessType) {
        this.defaultAccessType = defaultAccessType;
    }

    public void setExplicitAccessType(AccessType explicitAccessType) {
        this.explicitAccessType = explicitAccessType;
    }

    public @Nullable AccessType getDefaultAccessType() {
        return this.defaultAccessType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AccessTypeInformation");
        sb.append("{fqcn='").append(this.fullyQualifiedName).append('\'');
        sb.append(", explicitAccessType=").append(this.explicitAccessType);
        sb.append(", defaultAccessType=").append(this.defaultAccessType);
        sb.append('}');
        return sb.toString();
    }
}

