/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import jakarta.persistence.AccessType;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.antlr.v4.runtime.Token;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.AssertionFailure;
import org.hibernate.grammars.hql.HqlLexer;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.ordering.OrderByFragmentTranslator;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.processor.Context;
import org.hibernate.processor.ImportContextImpl;
import org.hibernate.processor.ProcessLaterException;
import org.hibernate.processor.annotation.AbstractQueryMethod;
import org.hibernate.processor.annotation.AnnotationMeta;
import org.hibernate.processor.annotation.AnnotationMetaAttribute;
import org.hibernate.processor.annotation.AnnotationMetaType;
import org.hibernate.processor.annotation.CDIAccessorMetaAttribute;
import org.hibernate.processor.annotation.CDITypeMetaAttribute;
import org.hibernate.processor.annotation.CriteriaDeleteMethod;
import org.hibernate.processor.annotation.CriteriaFinderMethod;
import org.hibernate.processor.annotation.DataAnnotationMetaAttribute;
import org.hibernate.processor.annotation.DataMetaAttributeGenerationVisitor;
import org.hibernate.processor.annotation.DefaultConstructor;
import org.hibernate.processor.annotation.ErrorHandler;
import org.hibernate.processor.annotation.EventField;
import org.hibernate.processor.annotation.IdClassMetaAttribute;
import org.hibernate.processor.annotation.IdFinderMethod;
import org.hibernate.processor.annotation.InnerClassMetaAttribute;
import org.hibernate.processor.annotation.LifecycleMethod;
import org.hibernate.processor.annotation.MetaAttributeGenerationVisitor;
import org.hibernate.processor.annotation.NaturalIdFinderMethod;
import org.hibernate.processor.annotation.OrderBy;
import org.hibernate.processor.annotation.QueryMethod;
import org.hibernate.processor.annotation.RepositoryConstructor;
import org.hibernate.processor.model.ImportContext;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.AccessTypeInformation;
import org.hibernate.processor.util.NullnessUtil;
import org.hibernate.processor.util.StringUtil;
import org.hibernate.processor.util.TypeUtils;
import org.hibernate.processor.validation.ProcessorSessionFactory;
import org.hibernate.processor.validation.Validation;
import org.hibernate.query.SyntaxException;
import org.hibernate.query.criteria.JpaEntityJoin;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.hql.internal.HqlParseTreeBuilder;
import org.hibernate.query.sql.internal.ParameterParser;
import org.hibernate.query.sql.spi.ParameterRecognizer;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;

public class AnnotationMetaEntity
extends AnnotationMeta {
    private static final String ID_CLASS_MEMBER_NAME = "<ID_CLASS>";
    private final ImportContext importContext;
    private final TypeElement element;
    private final Map<String, MetaAttribute> members;
    private final Context context;
    private final boolean managed;
    private boolean jakartaDataRepository;
    private final boolean quarkusInjection;
    private final boolean springInjection;
    private String qualifiedName;
    private final boolean jakartaDataStaticModel;
    private AccessTypeInformation entityAccessTypeInfo;
    private boolean initialized;
    private Metamodel entityToMerge;
    private boolean repository = false;
    private String sessionType = "jakarta.persistence.EntityManager";
    private String sessionGetter = "entityManager";
    private final Map<String, String> memberTypes = new HashMap<String, String>();
    private @Nullable TypeElement primaryEntity;
    private static final Set<String> LEGAL_RAW_RESULT_TYPES = Set.of("java.util.List", "jakarta.persistence.Query", "org.hibernate.query.Query");
    private static final Set<String> LEGAL_GENERIC_RESULT_TYPES = Set.of("java.util.List", "java.util.stream.Stream", "java.util.Optional", "jakarta.persistence.TypedQuery", "org.hibernate.query.Query", "org.hibernate.query.SelectionQuery", "org.hibernate.query.KeyedResultList", "jakarta.data.page.Page", "jakarta.data.page.CursoredPage");

    public AnnotationMetaEntity(TypeElement element, Context context, boolean managed, boolean jakartaDataStaticMetamodel, @Nullable AnnotationMeta parent, @Nullable TypeElement primaryEntity) {
        this.element = element;
        this.context = context;
        this.managed = managed;
        this.members = new LinkedHashMap<String, MetaAttribute>();
        this.quarkusInjection = context.isQuarkusInjection();
        this.springInjection = context.isSpringInjection();
        this.importContext = parent != null ? parent : new ImportContextImpl(AnnotationMetaEntity.getPackageName(context, element));
        this.jakartaDataStaticModel = jakartaDataStaticMetamodel;
        this.primaryEntity = primaryEntity;
        this.importContext.importType(TypeUtils.getGeneratedClassFullyQualifiedName(element, AnnotationMetaEntity.getPackageName(context, element), this.jakartaDataStaticModel));
        if (!element.getQualifiedName().toString().endsWith("$")) {
            this.importContext.importType(element.getQualifiedName().toString());
        }
    }

    public static AnnotationMetaEntity create(TypeElement element, Context context, @Nullable AnnotationMetaEntity parent, @Nullable TypeElement primaryEntity) {
        return AnnotationMetaEntity.create(element, context, false, false, false, parent, primaryEntity);
    }

    public static AnnotationMetaEntity create(TypeElement element, Context context, @Nullable AnnotationMetaEntity parent) {
        return AnnotationMetaEntity.create(element, context, false, false, false, parent, null);
    }

    public static AnnotationMetaEntity create(TypeElement element, Context context, boolean lazilyInitialised, boolean managed, boolean jakartaData, @Nullable AnnotationMetaEntity parent, @Nullable TypeElement primaryEntity) {
        AnnotationMetaEntity annotationMetaEntity = new AnnotationMetaEntity(element, context, managed, jakartaData, parent, primaryEntity);
        if (parent != null) {
            parent.addInnerClass(annotationMetaEntity);
        }
        if (!lazilyInitialised) {
            annotationMetaEntity.init();
        }
        return annotationMetaEntity;
    }

    public @Nullable String getMemberType(String entityType, String memberName) {
        return this.memberTypes.get(StringHelper.qualify((String)entityType, (String)memberName));
    }

    public AccessTypeInformation getEntityAccessTypeInfo() {
        return this.entityAccessTypeInfo;
    }

    @Override
    public final Context getContext() {
        return this.context;
    }

    @Override
    public boolean isImplementation() {
        return this.repository;
    }

    @Override
    public boolean isJakartaDataStyle() {
        return this.jakartaDataStaticModel;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public final String getSimpleName() {
        return StringUtil.removeDollar(this.element.getSimpleName().toString());
    }

    private String getConstructorName() {
        return this.getSimpleName() + "_";
    }

    @Override
    public final String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.element.getQualifiedName().toString();
        }
        return this.qualifiedName;
    }

    @Override
    public @Nullable Element getSuperTypeElement() {
        return this.repository ? null : TypeUtils.findMappedSuperElement(this, this.context);
    }

    @Override
    public String getPackageName() {
        return AnnotationMetaEntity.getPackageName(this.context, this.element);
    }

    private static String getPackageName(Context context, TypeElement element) {
        return context.getElementUtils().getPackageOf(element).getQualifiedName().toString();
    }

    @Override
    public List<MetaAttribute> getMembers() {
        if (!this.initialized) {
            this.init();
            if (this.entityToMerge != null) {
                this.mergeInMembers(this.entityToMerge.getMembers());
            }
        }
        return new ArrayList<MetaAttribute>(this.members.values());
    }

    public void addInnerClass(AnnotationMetaEntity metaEntity) {
        this.putMember("INNER_" + metaEntity.getQualifiedName(), new InnerClassMetaAttribute(metaEntity));
    }

    @Override
    public boolean isMetaComplete() {
        return false;
    }

    private void mergeInMembers(Collection<MetaAttribute> attributes) {
        for (MetaAttribute attribute : attributes) {
            this.importType(attribute.getMetaType());
            this.importType(attribute.getTypeDeclaration());
            this.members.put(attribute.getPropertyName(), attribute);
        }
    }

    public void mergeInMembers(Metamodel other) {
        if (!this.initialized) {
            this.entityToMerge = other;
        } else {
            this.mergeInMembers(other.getMembers());
        }
    }

    @Override
    public final String generateImports() {
        return this.importContext.generateImports();
    }

    @Override
    public final String importType(String fqcn) {
        return this.importContext.importType(fqcn);
    }

    @Override
    public final String staticImport(String fqcn, String member) {
        return this.importContext.staticImport(fqcn, member);
    }

    @Override
    public final TypeElement getElement() {
        return this.element;
    }

    @Override
    void putMember(String name, MetaAttribute nameMetaAttribute) {
        this.members.put(name, nameMetaAttribute);
    }

    @Override
    boolean isRepository() {
        return this.repository;
    }

    boolean isJakartaDataRepository() {
        return this.jakartaDataRepository;
    }

    @Override
    String getSessionType() {
        return this.sessionType;
    }

    @Override
    public boolean isInjectable() {
        return this.repository;
    }

    @Override
    public String scope() {
        return "jakarta.enterprise.context.Dependent";
    }

    public String toString() {
        return "AnnotationMetaEntity" + "{element=" + this.element + ", members=" + this.members + '}';
    }

    protected void init() {
        this.getContext().logMessage(Diagnostic.Kind.OTHER, "Initializing type '" + this.getQualifiedName() + "'");
        this.setupSession();
        ArrayList<ExecutableElement> queryMethods = new ArrayList<ExecutableElement>();
        ArrayList<ExecutableElement> lifecycleMethods = new ArrayList<ExecutableElement>();
        if (this.repository) {
            List<ExecutableElement> methodsOfClass = ElementFilter.methodsIn(this.context.getAllMembers(this.element));
            for (ExecutableElement method : methodsOfClass) {
                if (TypeUtils.containsAnnotation(method, "org.hibernate.annotations.processing.HQL", "org.hibernate.annotations.processing.SQL", "jakarta.data.repository.Query", "org.hibernate.annotations.processing.Find", "jakarta.data.repository.Find")) {
                    queryMethods.add(method);
                    continue;
                }
                if (TypeUtils.containsAnnotation(method, "jakarta.data.repository.Insert", "jakarta.data.repository.Update", "jakarta.data.repository.Save")) {
                    lifecycleMethods.add(method);
                    continue;
                }
                if (TypeUtils.hasAnnotation((Element)method, "jakarta.data.repository.Delete")) {
                    if (this.isDeleteLifecycle(method)) {
                        lifecycleMethods.add(method);
                        continue;
                    }
                    queryMethods.add(method);
                    continue;
                }
                if (!method.getEnclosingElement().getKind().isInterface() || method.isDefault() || method.getModifiers().contains((Object)Modifier.PRIVATE) || AnnotationMetaEntity.isSessionGetter(method)) continue;
                String companionClassName = this.element.getQualifiedName().toString() + "$";
                if (this.context.getElementUtils().getTypeElement(companionClassName) == null) {
                    this.message(method, "repository method cannot be implemented (skipping whole repository)", Diagnostic.Kind.WARNING);
                }
                return;
            }
            boolean hibernateRepo = this.isExplicitlyHibernateRepository();
            if (this.primaryEntity == null) {
                this.primaryEntity = this.primaryEntity(lifecycleMethods);
            }
            if (!this.checkEntity(this.primaryEntity, hibernateRepo) || !this.checkEntities(lifecycleMethods, hibernateRepo)) {
                return;
            }
            if (!lifecycleMethods.isEmpty()) {
                this.validateStatelessSessionType();
            }
        } else {
            TypeUtils.determineAccessTypeForHierarchy(this.element, this.context);
            this.entityAccessTypeInfo = NullnessUtil.castNonNull(this.context.getAccessTypeInfo(this.getQualifiedName()));
            List<VariableElement> fieldsOfClass = ElementFilter.fieldsIn(this.element.getEnclosedElements());
            List<ExecutableElement> methodsOfClass = ElementFilter.methodsIn(this.element.getEnclosedElements());
            ArrayList<ExecutableElement> gettersAndSettersOfClass = new ArrayList<ExecutableElement>();
            for (ExecutableElement method : methodsOfClass) {
                if (this.isGetterOrSetter(method)) {
                    gettersAndSettersOfClass.add(method);
                    continue;
                }
                if (!this.element.getTypeParameters().isEmpty() || !TypeUtils.containsAnnotation(method, "org.hibernate.annotations.processing.HQL", "org.hibernate.annotations.processing.SQL", "org.hibernate.annotations.processing.Find")) continue;
                queryMethods.add(method);
            }
            if (this.managed && !this.jakartaDataStaticModel) {
                this.putMember("class", new AnnotationMetaType(this));
            }
            this.validatePersistentMembers(fieldsOfClass);
            this.validatePersistentMembers(gettersAndSettersOfClass);
            this.addPersistentMembers(fieldsOfClass, AccessType.FIELD);
            this.addPersistentMembers(gettersAndSettersOfClass, AccessType.PROPERTY);
            this.addIdClassIfNeeded(fieldsOfClass, gettersAndSettersOfClass);
            if (TypeUtils.hasAnnotation((Element)this.element, "jakarta.persistence.Entity") && this.isPanache2Type(this.element) && !this.jakartaDataStaticModel) {
                this.addRepositoryMembers(this.element);
            }
        }
        this.addAuxiliaryMembers();
        this.checkNamedQueries();
        this.addLifecycleMethods(lifecycleMethods);
        this.addQueryMethods(queryMethods);
        this.initialized = true;
    }

    private boolean checkEntity(@Nullable TypeElement entity, boolean hibernateRepo) {
        if (entity != null && !TypeUtils.hasAnnotation((Element)entity, "jakarta.persistence.Entity")) {
            if (hibernateRepo) {
                this.context.message(this.element, "unrecognized primary entity type: " + String.valueOf(entity.getQualifiedName()), Diagnostic.Kind.ERROR);
            }
            return false;
        }
        return true;
    }

    private boolean isExplicitlyHibernateRepository() {
        AnnotationMirror repository = TypeUtils.getAnnotationMirror(this.element, "jakarta.data.repository.Repository");
        if (repository != null) {
            AnnotationValue provider = TypeUtils.getAnnotationValue(repository, "provider");
            return provider != null && provider.getValue().toString().equalsIgnoreCase("hibernate");
        }
        return false;
    }

    private void addIdClassIfNeeded(List<VariableElement> fields, List<ExecutableElement> methods) {
        if (TypeUtils.hasAnnotation((Element)this.element, "jakarta.persistence.IdClass")) {
            this.checkIdMembers(fields, methods);
        } else {
            List<MetaAttribute> components = this.getIdMemberNames(fields, methods);
            if (components.size() >= 2) {
                this.putMember(ID_CLASS_MEMBER_NAME, new IdClassMetaAttribute(this, components));
            }
        }
    }

    private void addRepositoryMembers(TypeElement element) {
        Element managedBlockingRepository = null;
        Element statelessBlockingRepository = null;
        Element managedReactiveRepository = null;
        Element statelessReactiveRepository = null;
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getKind() != ElementKind.INTERFACE) continue;
            this.members.put(element2.getSimpleName().toString(), new CDIAccessorMetaAttribute(this, element2));
            if (TypeUtils.implementsInterface((TypeElement)element2, "io.quarkus.hibernate.panache.managed.blocking.PanacheManagedBlockingRepositoryBase")) {
                managedBlockingRepository = element2;
                continue;
            }
            if (TypeUtils.implementsInterface((TypeElement)element2, "io.quarkus.hibernate.panache.stateless.blocking.PanacheStatelessBlockingRepositoryBase")) {
                statelessBlockingRepository = element2;
                continue;
            }
            if (TypeUtils.implementsInterface((TypeElement)element2, "io.quarkus.hibernate.panache.managed.reactive.PanacheManagedReactiveRepositoryBase")) {
                managedReactiveRepository = element2;
                continue;
            }
            if (!TypeUtils.implementsInterface((TypeElement)element2, "io.quarkus.hibernate.panache.stateless.reactive.PanacheStatelessReactiveRepositoryBase")) continue;
            statelessReactiveRepository = element2;
        }
        if (this.quarkusInjection) {
            TypeMirror idType = this.findIdType();
            this.addAccessors(managedBlockingRepository, idType, "managedBlocking", "io.quarkus.hibernate.panache.managed.blocking.PanacheManagedBlockingRepositoryBase");
            this.addAccessors(statelessBlockingRepository, idType, "statelessBlocking", "io.quarkus.hibernate.panache.stateless.blocking.PanacheStatelessBlockingRepositoryBase");
            if (this.context.usesQuarkusReactiveCommon()) {
                this.addAccessors(managedReactiveRepository, idType, "managedReactive", "io.quarkus.hibernate.panache.managed.reactive.PanacheManagedReactiveRepositoryBase");
                this.addAccessors(statelessReactiveRepository, idType, "statelessReactive", "io.quarkus.hibernate.panache.stateless.reactive.PanacheStatelessReactiveRepositoryBase");
            }
        }
    }

    private List<MetaAttribute> getIdMemberNames(List<VariableElement> fields, List<ExecutableElement> methods) {
        String propertyName;
        ArrayList<MetaAttribute> components = new ArrayList<MetaAttribute>();
        for (VariableElement field : fields) {
            if (!this.isIdField(field) || !this.members.containsKey(propertyName = TypeUtils.propertyName(field))) continue;
            components.add(this.members.get(propertyName));
        }
        for (ExecutableElement method : methods) {
            if (!this.isIdProperty(method) || !this.members.containsKey(propertyName = TypeUtils.propertyName(method))) continue;
            components.add(this.members.get(propertyName));
        }
        return components;
    }

    private void checkIdMembers(List<VariableElement> fields, List<ExecutableElement> methods) {
        block6: {
            Object object;
            AnnotationValue annotationValue;
            AnnotationMirror annotationMirror = TypeUtils.getAnnotationMirror(this.element, "jakarta.persistence.IdClass");
            if (annotationMirror == null || (annotationValue = TypeUtils.getAnnotationValue(annotationMirror)) == null || !((object = annotationValue.getValue()) instanceof DeclaredType)) break block6;
            DeclaredType declaredType = (DeclaredType)object;
            TypeElement idClass = (TypeElement)declaredType.asElement();
            if (fields.stream().filter(this::isIdField).count() + methods.stream().filter(this::isIdProperty).count() == 1L) {
                for (VariableElement field : fields) {
                    if (!this.isIdField(field) || !TypeUtils.hasAnnotation((Element)field, "jakarta.persistence.OneToOne")) continue;
                    return;
                }
                for (ExecutableElement method : methods) {
                    if (!this.isIdProperty(method) || !TypeUtils.hasAnnotation((Element)method, "jakarta.persistence.OneToOne")) continue;
                    return;
                }
            } else {
                for (VariableElement field : fields) {
                    if (!this.isIdField(field)) continue;
                    AnnotationMetaEntity.memberStream(idClass).filter(element -> element.getKind() == ElementKind.FIELD && element.getSimpleName().contentEquals(field.getSimpleName())).findAny().ifPresentOrElse(match -> {
                        if (!this.isMatchingIdType(field, field.asType(), match.asType())) {
                            this.context.message((Element)match, "id field should be of type '" + String.valueOf(field.asType()) + "'", Diagnostic.Kind.ERROR);
                        }
                    }, () -> this.context.message(field, "no matching field in id class '" + String.valueOf(idClass.getSimpleName()) + "'", Diagnostic.Kind.ERROR));
                }
                for (ExecutableElement method : methods) {
                    if (!this.isIdProperty(method)) continue;
                    AnnotationMetaEntity.memberStream(idClass).filter(element -> element.getKind() == ElementKind.METHOD && element.getSimpleName().contentEquals(method.getSimpleName()) && this.isMatchingIdType(method, method.getReturnType(), ((ExecutableElement)element).getReturnType())).findAny().ifPresentOrElse(match -> {}, () -> this.context.message(method, "no matching property in id class '" + String.valueOf(idClass.getSimpleName()) + "'", Diagnostic.Kind.ERROR));
                }
            }
        }
    }

    private boolean isIdProperty(ExecutableElement method) {
        return TypeUtils.hasAnnotation((Element)method, "jakarta.persistence.Id") && this.isPersistent(method, AccessType.PROPERTY);
    }

    private boolean isIdField(VariableElement field) {
        return TypeUtils.hasAnnotation((Element)field, "jakarta.persistence.Id") && this.isPersistent(field, AccessType.FIELD);
    }

    private static Stream<? extends Element> memberStream(TypeElement idClass) {
        Stream result = idClass.getEnclosedElements().stream();
        TypeMirror superclass = idClass.getSuperclass();
        while (superclass.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)superclass;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            result = Stream.concat(result, typeElement.getEnclosedElements().stream());
            superclass = typeElement.getSuperclass();
        }
        return result;
    }

    private boolean isMatchingIdType(Element id, TypeMirror type, TypeMirror match) {
        return this.isSameType(type, match) || this.isEquivalentPrimitiveType(type, match) || this.isEquivalentPrimitiveType(match, type) || TypeUtils.hasAnnotation(id, "jakarta.persistence.ManyToOne", "jakarta.persistence.OneToOne");
    }

    private boolean isSameType(TypeMirror type, TypeMirror match) {
        return this.context.getTypeUtils().isSameType(type, match);
    }

    private boolean isEquivalentPrimitiveType(TypeMirror type, TypeMirror match) {
        return type.getKind().isPrimitive() && this.isSameType(this.context.getTypeUtils().boxedClass((PrimitiveType)type).asType(), match);
    }

    private void addAccessors(@Nullable Element repositoryType, @Nullable TypeMirror idType, String repositoryAccessor, String repositorySuperType) {
        TypeElement finalPrimaryEntity = this.primaryEntity;
        if (repositoryType != null) {
            this.members.put(repositoryAccessor, new CDIAccessorMetaAttribute(this, repositoryAccessor, repositoryType.getSimpleName().toString()));
        } else if (idType != null && finalPrimaryEntity != null) {
            String repositoryTypeName = "Panache" + repositoryAccessor.substring(0, 1).toUpperCase() + repositoryAccessor.substring(1) + "Repository";
            this.members.put(repositoryAccessor, new CDIAccessorMetaAttribute(this, repositoryAccessor, repositoryTypeName));
            this.members.put(repositoryAccessor + "Repository", new CDITypeMetaAttribute(this, repositoryTypeName, repositorySuperType + "<" + String.valueOf(finalPrimaryEntity.getSimpleName()) + ", " + idType.toString() + ">"));
        }
    }

    private @Nullable TypeMirror findIdType() {
        AnnotationValue value;
        TypeElement primaryEntityForTest = this.primaryEntity;
        if (primaryEntityForTest == null) {
            return null;
        }
        AnnotationMirror idClass = TypeUtils.getInheritedAnnotationMirror(this.context.getElementUtils(), primaryEntityForTest, "jakarta.persistence.IdClass");
        if (idClass != null && (value = TypeUtils.getAnnotationValue(idClass, "value")) != null) {
            return (TypeMirror)value.getValue();
        }
        Element idMember = this.findIdMember();
        if (idMember != null) {
            TypeMirror typedIdMember = this.context.getTypeUtils().asMemberOf((DeclaredType)primaryEntityForTest.asType(), idMember);
            return switch (typedIdMember.getKind()) {
                case TypeKind.ARRAY, TypeKind.DECLARED, TypeKind.BOOLEAN, TypeKind.BYTE, TypeKind.CHAR, TypeKind.SHORT, TypeKind.INT, TypeKind.LONG, TypeKind.FLOAT, TypeKind.DOUBLE -> typedIdMember;
                case TypeKind.EXECUTABLE -> ((ExecutableType)typedIdMember).getReturnType();
                default -> {
                    this.message(this.element, "Unhandled id member kind: " + String.valueOf(typedIdMember) + " for id " + String.valueOf(idMember), Diagnostic.Kind.ERROR);
                    yield null;
                }
            };
        }
        return null;
    }

    private @Nullable Element findIdMember() {
        if (this.primaryEntity == null) {
            this.message(this.element, "No primary entity defined to find id member", Diagnostic.Kind.ERROR);
            return null;
        }
        for (Element member : this.context.getAllMembers(this.primaryEntity)) {
            if (!TypeUtils.hasAnnotation(member, "jakarta.persistence.Id", "jakarta.persistence.EmbeddedId")) continue;
            return member;
        }
        this.message(this.element, "Could not find any member annotated with @Id or @EmbeddedId", Diagnostic.Kind.ERROR);
        return null;
    }

    private boolean checkEntities(List<ExecutableElement> lifecycleMethods, boolean hibernateRepo) {
        boolean foundPersistenceEntity = false;
        VariableElement nonPersistenceParameter = null;
        for (ExecutableElement lifecycleMethod : lifecycleMethods) {
            List<? extends VariableElement> parameters = lifecycleMethod.getParameters();
            if (parameters.isEmpty()) continue;
            VariableElement parameter = parameters.get(0);
            TypeMirror declaredType = parameter.asType();
            TypeMirror parameterType = this.parameterType(parameter);
            DeclaredType type = this.entityType(parameterType);
            if (type == null) continue;
            if (TypeUtils.hasAnnotation(type.asElement(), "jakarta.persistence.Entity")) {
                foundPersistenceEntity = true;
                continue;
            }
            if (declaredType != parameterType || nonPersistenceParameter != null) continue;
            nonPersistenceParameter = parameter;
        }
        if (foundPersistenceEntity && nonPersistenceParameter != null) {
            this.message(nonPersistenceParameter, "parameter type '" + String.valueOf(nonPersistenceParameter.asType()) + "' is not a Jakarta Persistence entity class (skipping entire repository)", hibernateRepo ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING);
        }
        return nonPersistenceParameter == null;
    }

    private void validateStatelessSessionType() {
        if (!this.isStatelessSession()) {
            this.message(this.element, "repository must be backed by a 'StatelessSession'", Diagnostic.Kind.ERROR);
        }
    }

    private static @Nullable TypeElement primaryEntity(TypeElement element) {
        for (TypeMirror typeMirror : element.getInterfaces()) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            Name name = typeElement.getQualifiedName();
            if (declaredType.getTypeArguments().size() == 2 && (name.contentEquals("jakarta.data.repository.BasicRepository") || name.contentEquals("jakarta.data.repository.CrudRepository") || name.contentEquals("jakarta.data.repository.DataRepository"))) {
                TypeMirror entityType = declaredType.getTypeArguments().get(0);
                if (entityType.getKind() != TypeKind.DECLARED) continue;
                DeclaredType entityDeclared = (DeclaredType)entityType;
                return (TypeElement)entityDeclared.asElement();
            }
            TypeElement primaryEntity = AnnotationMetaEntity.primaryEntity(typeElement);
            if (primaryEntity == null) continue;
            return primaryEntity;
        }
        return null;
    }

    private @Nullable TypeElement primaryEntity(List<ExecutableElement> lifecycleMethods) {
        TypeElement result = AnnotationMetaEntity.primaryEntity(this.element);
        if (result != null) {
            return result;
        }
        Types types = this.context.getTypeUtils();
        for (ExecutableElement element : lifecycleMethods) {
            VariableElement param;
            DeclaredType declaredType;
            if (element.getParameters().size() != 1 || (declaredType = this.entityType(this.parameterType(param = element.getParameters().get(0)))) == null) continue;
            if (result == null) {
                result = (TypeElement)declaredType.asElement();
                continue;
            }
            if (types.isSameType(result.asType(), declaredType)) continue;
            return null;
        }
        return result;
    }

    private void addDefaultConstructor() {
        String sessionVariableName = this.getSessionVariableName(this.sessionType);
        this.putMember("_", new DefaultConstructor(this, this.getConstructorName(), sessionVariableName, this.sessionType, sessionVariableName, this.dataStore(), this.context.addInjectAnnotation()));
    }

    private @Nullable String dataStore() {
        String dataStore;
        AnnotationValue dataStoreValue;
        AnnotationMirror repo = TypeUtils.getAnnotationMirror(this.element, "jakarta.data.repository.Repository");
        if (repo != null && (dataStoreValue = TypeUtils.getAnnotationValue(repo, "dataStore")) != null && !(dataStore = dataStoreValue.getValue().toString()).isEmpty()) {
            return dataStore;
        }
        return null;
    }

    private void setupSession() {
        if (this.element.getTypeParameters().isEmpty()) {
            this.jakartaDataRepository = TypeUtils.hasAnnotation((Element)this.element, "jakarta.data.repository.Repository");
            ExecutableElement getter = this.findSessionGetter(this.element);
            if (getter != null) {
                if (!this.isPanacheType(this.element) && !this.isPanache2Type(this.element)) {
                    this.repository = true;
                    this.sessionType = this.addDaoConstructor(getter);
                } else if (!this.isPanache2Repository(this.element) && !this.isPanache2Type(this.element)) {
                    this.sessionType = this.fullReturnType(getter);
                } else {
                    this.repository = true;
                    this.sessionType = this.setupQuarkusDaoConstructor(getter, this.element);
                }
            } else if (this.element.getKind() == ElementKind.INTERFACE && !this.jakartaDataRepository && (this.context.usesQuarkusOrm() || this.context.usesQuarkusReactive() || this.context.usesQuarkusPanache2())) {
                this.repository = true;
                this.sessionType = this.setupQuarkusDaoConstructor(null, this.element);
            }
            if (!this.repository && this.jakartaDataRepository) {
                this.repository = true;
                this.sessionType = "org.hibernate.StatelessSession";
                this.sessionType = this.addDaoConstructor(null);
            }
            if (this.needsDefaultConstructor()) {
                this.addDefaultConstructor();
            }
            if (this.needsEventBus()) {
                this.addEventBus();
            }
        }
    }

    private boolean needsEventBus() {
        return this.jakartaDataRepository && !this.isReactive() && this.context.isDataEventPackageAvailable() && this.context.addInjectAnnotation() && this.context.addDependentAnnotation();
    }

    void addEventBus() {
        this.putMember("_event", new EventField(this));
    }

    boolean needsDefaultConstructor() {
        return this.jakartaDataRepository && !this.quarkusInjection && !this.springInjection && this.context.addDependentAnnotation();
    }

    private @Nullable ExecutableElement findSessionGetter(TypeElement type) {
        if (!TypeUtils.hasAnnotation((Element)type, "jakarta.persistence.Entity", "jakarta.persistence.MappedSuperclass", "jakarta.persistence.Embeddable") || this.isPanacheType(type)) {
            DeclaredType declaredType;
            ExecutableElement executableElement;
            for (ExecutableElement method : ElementFilter.methodsIn(type.getEnclosedElements())) {
                if (!AnnotationMetaEntity.isSessionGetter(method)) continue;
                return method;
            }
            TypeMirror superclass = type.getSuperclass();
            if (superclass.getKind() == TypeKind.DECLARED && (executableElement = this.findSessionGetter((TypeElement)(declaredType = (DeclaredType)superclass).asElement())) != null) {
                return executableElement;
            }
            for (TypeMirror typeMirror : type.getInterfaces()) {
                DeclaredType declaredType2;
                ExecutableElement ret2;
                if (typeMirror.getKind() != TypeKind.DECLARED || (ret2 = this.findSessionGetter((TypeElement)(declaredType2 = (DeclaredType)typeMirror).asElement())) == null) continue;
                return ret2;
            }
        }
        return null;
    }

    public boolean isStatelessSession() {
        return AnnotationMetaEntity.usingStatelessSession(this.sessionType);
    }

    public boolean isReactive() {
        return AnnotationMetaEntity.usingReactiveSession(this.sessionType);
    }

    public boolean isReactiveSessionAccess() {
        return AnnotationMetaEntity.usingReactiveSessionAccess(this.sessionType);
    }

    public boolean isProvidedSessionAccess() {
        return this.sessionType.startsWith("org.springframework.beans.factory.ObjectProvider");
    }

    private boolean isPanacheType(TypeElement type) {
        return this.context.usesQuarkusOrm() && this.isOrmPanacheType(type) || this.context.usesQuarkusReactive() && this.isReactivePanacheType(type);
    }

    private boolean isOrmPanacheType(TypeElement type) {
        return TypeUtils.implementsInterface(type, "io.quarkus.hibernate.orm.panache.PanacheRepositoryBase") || TypeUtils.extendsClass(type, "io.quarkus.hibernate.orm.panache.PanacheEntityBase");
    }

    private boolean isReactivePanacheType(TypeElement type) {
        return TypeUtils.implementsInterface(type, "io.quarkus.hibernate.reactive.panache.PanacheRepositoryBase") || TypeUtils.extendsClass(type, "io.quarkus.hibernate.reactive.panache.PanacheEntityBase");
    }

    private boolean isPanache2Type(TypeElement type) {
        return TypeUtils.implementsInterface(type, "io.quarkus.hibernate.panache.PanacheEntityMarker") || this.isPanache2Repository(type);
    }

    private boolean isPanache2Repository(TypeElement type) {
        return TypeUtils.implementsInterface(type, "io.quarkus.hibernate.panache.managed.blocking.PanacheManagedBlockingRepositoryBase") || TypeUtils.implementsInterface(type, "io.quarkus.hibernate.panache.stateless.blocking.PanacheStatelessBlockingRepositoryBase") || TypeUtils.implementsInterface(type, "io.quarkus.hibernate.panache.managed.reactive.PanacheManagedReactiveRepositoryBase") || TypeUtils.implementsInterface(type, "io.quarkus.hibernate.panache.stateless.reactive.PanacheStatelessReactiveRepositoryBase");
    }

    private String addDaoConstructor(@Nullable ExecutableElement method) {
        String name;
        String returnType = method == null ? this.sessionType : this.fullReturnType(method);
        String sessionType = this.jakartaDataRepository && this.springInjection ? "org.springframework.beans.factory.ObjectProvider<" + returnType + ">" : returnType;
        String sessionVariableName = this.getSessionVariableName(sessionType);
        String string = name = method == null ? sessionVariableName : method.getSimpleName().toString();
        if (method == null || !method.isDefault()) {
            this.putMember(name, new RepositoryConstructor(this, this.getConstructorName(), name, sessionType, sessionVariableName, this.dataStore(), this.context.addInjectAnnotation(), this.context.addNonnullAnnotation(), method != null, this.jakartaDataRepository, this.quarkusInjection));
        } else {
            this.sessionGetter = String.valueOf(method.getSimpleName()) + "()";
        }
        return sessionType;
    }

    private String setupQuarkusDaoConstructor(@Nullable ExecutableElement getter, @Nullable TypeElement element) {
        boolean favorBlocking;
        boolean bl = favorBlocking = this.context.usesQuarkusOrm() || this.context.usesQuarkusPanache2() && element != null && (TypeUtils.implementsInterface(element, "io.quarkus.hibernate.panache.managed.blocking.PanacheManagedBlockingRepositoryBase") || TypeUtils.implementsInterface(element, "io.quarkus.hibernate.panache.stateless.blocking.PanacheStatelessBlockingRepositoryBase"));
        if (!(!this.context.usesQuarkusPanache2() || element == null || TypeUtils.implementsInterface(element, "io.quarkus.hibernate.panache.managed.blocking.PanacheManagedBlockingRepositoryBase") || TypeUtils.implementsInterface(element, "io.quarkus.hibernate.panache.stateless.blocking.PanacheStatelessBlockingRepositoryBase") || TypeUtils.implementsInterface(element, "io.quarkus.hibernate.panache.managed.reactive.PanacheManagedReactiveRepositoryBase") || TypeUtils.implementsInterface(element, "io.quarkus.hibernate.panache.stateless.reactive.PanacheStatelessReactiveRepositoryBase"))) {
            List<ExecutableElement> methodsOfClass = ElementFilter.methodsIn(this.context.getAllMembers(element));
            for (ExecutableElement method : methodsOfClass) {
                if (!TypeUtils.containsAnnotation(method, "org.hibernate.annotations.processing.HQL", "org.hibernate.annotations.processing.SQL", "jakarta.data.repository.Query", "org.hibernate.annotations.processing.Find", "jakarta.data.repository.Find")) continue;
                favorBlocking = !AnnotationMetaEntity.isUni(method.getReturnType());
                break;
            }
        }
        if (favorBlocking) {
            String sessionType;
            String name;
            if (getter != null) {
                name = getter.getSimpleName().toString();
                sessionType = this.fullReturnType(getter);
            } else if (element != null && TypeUtils.implementsInterface(element, "io.quarkus.hibernate.panache.stateless.blocking.PanacheStatelessBlockingRepositoryBase")) {
                name = "getStatelessSession";
                sessionType = "org.hibernate.StatelessSession";
            } else {
                name = "getSession";
                sessionType = "org.hibernate.Session";
            }
            this.putMember(name, new RepositoryConstructor(this, this.getConstructorName(), name, sessionType, this.getSessionVariableName(sessionType), this.dataStore(), this.context.addInjectAnnotation(), this.context.addNonnullAnnotation(), false, false, true));
            return sessionType;
        }
        this.importType("io.quarkus.hibernate.reactive.panache.common.runtime.SessionOperations");
        if (element != null && TypeUtils.implementsInterface(element, "io.quarkus.hibernate.panache.stateless.reactive.PanacheStatelessReactiveRepositoryBase")) {
            this.sessionGetter = "SessionOperations.getStatelessSession()";
            return "io.smallrye.mutiny.Uni<org.hibernate.reactive.mutiny.Mutiny.StatelessSession>";
        }
        this.sessionGetter = "SessionOperations.getSession()";
        return "io.smallrye.mutiny.Uni<org.hibernate.reactive.mutiny.Mutiny.Session>";
    }

    private static boolean isSessionGetter(ExecutableElement method) {
        return method.getParameters().isEmpty() && AnnotationMetaEntity.isSessionGetterType(method.getReturnType());
    }

    private static boolean isSessionGetterType(TypeMirror returnType) {
        if (returnType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)AnnotationMetaEntity.ununi(returnType);
            Element element = declaredType.asElement();
            if (element.getKind() == ElementKind.INTERFACE) {
                TypeElement typeElement = (TypeElement)element;
                Name name = typeElement.getQualifiedName();
                if (name.contentEquals("io.smallrye.mutiny.Uni") || name.contentEquals("org.springframework.beans.factory.ObjectProvider")) {
                    List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                    return typeArguments.size() == 1 && AnnotationMetaEntity.isSessionGetterType(typeArguments.get(0));
                }
                return name.contentEquals("org.hibernate.Session") || name.contentEquals("org.hibernate.StatelessSession") || name.contentEquals("org.hibernate.reactive.mutiny.Mutiny.Session") || name.contentEquals("org.hibernate.reactive.mutiny.Mutiny.StatelessSession") || name.contentEquals("jakarta.persistence.EntityManager");
            }
            return false;
        }
        return false;
    }

    private boolean isGetterOrSetter(Element methodOfClass) {
        TypeMirror returnType;
        List<? extends TypeMirror> methodParameterTypes;
        ExecutableType methodType = (ExecutableType)methodOfClass.asType();
        Name methodSimpleName = methodOfClass.getSimpleName();
        return AnnotationMetaEntity.isSetter(methodSimpleName, methodParameterTypes = methodType.getParameterTypes(), returnType = methodType.getReturnType()) || AnnotationMetaEntity.isGetter(methodSimpleName, methodParameterTypes, returnType);
    }

    private static boolean hasPrefix(Name methodSimpleName, String prefix) {
        int prefixLength = prefix.length();
        if (methodSimpleName.length() > prefixLength) {
            for (int i = 0; i < prefixLength; ++i) {
                if (methodSimpleName.charAt(i) == prefix.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isGetter(Name methodSimpleName, List<? extends TypeMirror> methodParameterTypes, TypeMirror returnType) {
        return (AnnotationMetaEntity.hasPrefix(methodSimpleName, "get") || AnnotationMetaEntity.hasPrefix(methodSimpleName, "is")) && methodParameterTypes.isEmpty() && returnType.getKind() != TypeKind.VOID;
    }

    private static boolean isSetter(Name methodSimpleName, List<? extends TypeMirror> methodParameterTypes, TypeMirror returnType) {
        return AnnotationMetaEntity.hasPrefix(methodSimpleName, "set") && methodParameterTypes.size() == 1 && returnType.getKind() != TypeKind.VOID;
    }

    private void validatePersistentMembers(List<? extends Element> membersOfClass) {
        for (Element element : membersOfClass) {
            if (TypeUtils.hasAnnotation(element, "jakarta.persistence.ManyToOne", "jakarta.persistence.OneToOne", "jakarta.persistence.OneToMany", "jakarta.persistence.ManyToMany")) {
                this.validateAssociation(element);
            }
            if (!TypeUtils.hasAnnotation(element, "jakarta.persistence.OrderBy")) continue;
            this.validateOrderBy(element);
        }
    }

    private void validateOrderBy(Element memberOfClass) {
        String fragment;
        AnnotationMirror annotation = NullnessUtil.castNonNull(TypeUtils.getAnnotationMirror(memberOfClass, "jakarta.persistence.OrderBy"));
        AnnotationValue annotationValue = TypeUtils.getAnnotationValue(annotation);
        if (annotationValue != null && !(fragment = annotationValue.getValue().toString()).isBlank()) {
            try {
                OrderByFragmentTranslator.check((String)fragment);
            }
            catch (SyntaxException e) {
                String message = "Error in ordering: " + e.getMessage();
                this.context.message(memberOfClass, annotation, annotationValue, message, Diagnostic.Kind.ERROR);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addPersistentMembers(List<? extends Element> membersOfClass, AccessType membersKind) {
        for (Element element : membersOfClass) {
            if (!this.isPersistent(element, membersKind)) continue;
            this.addPersistentMember(element);
        }
    }

    private void addPersistentMember(Element memberOfClass) {
        if (this.jakartaDataStaticModel) {
            DataAnnotationMetaAttribute dataMetaAttribute = memberOfClass.asType().accept(new DataMetaAttributeGenerationVisitor(this, this.context), memberOfClass);
            if (dataMetaAttribute != null) {
                String path = dataMetaAttribute.getPropertyName();
                this.members.put("_" + path, dataMetaAttribute);
                if (AnnotationMetaEntity.isEmbedded(memberOfClass)) {
                    TypeMirror type = AnnotationMetaEntity.attributeType(memberOfClass);
                    DeclaredType declaredType = (DeclaredType)type;
                    TypeElement typeElement = (TypeElement)declaredType.asElement();
                    for (Element element : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
                        this.addEmbeddablePersistentMember(element, path, AccessType.FIELD);
                    }
                    for (Element element : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                        if (!this.isGetterOrSetter(element)) continue;
                        this.addEmbeddablePersistentMember(element, path, AccessType.PROPERTY);
                    }
                }
            }
        } else {
            AnnotationMetaAttribute jpaMetaAttribute = memberOfClass.asType().accept(new MetaAttributeGenerationVisitor(this, this.context), memberOfClass);
            if (jpaMetaAttribute != null) {
                this.members.put(jpaMetaAttribute.getPropertyName(), jpaMetaAttribute);
            }
        }
    }

    private void addEmbeddablePersistentMember(Element memberOfEmbeddable, String path, AccessType membersKind) {
        DataAnnotationMetaAttribute metaAttribute;
        if (this.isPersistent(memberOfEmbeddable, membersKind) && (metaAttribute = memberOfEmbeddable.asType().accept(new DataMetaAttributeGenerationVisitor(this, path, this.context), memberOfEmbeddable)) != null) {
            this.members.put("_" + metaAttribute.getPropertyName(), metaAttribute);
        }
    }

    static boolean isEmbedded(Element memberOfClass) {
        if (TypeUtils.hasAnnotation(memberOfClass, "jakarta.persistence.Embedded")) {
            return true;
        }
        TypeMirror type = AnnotationMetaEntity.attributeType(memberOfClass);
        if (type.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)type;
            return TypeUtils.hasAnnotation(declaredType.asElement(), "jakarta.persistence.Embeddable");
        }
        return false;
    }

    private void validateAssociation(Element memberOfClass) {
        TypeMirror type = AnnotationMetaEntity.attributeType(memberOfClass);
        if (TypeUtils.hasAnnotation(memberOfClass, "jakarta.persistence.ManyToOne")) {
            AnnotationMirror annotation = NullnessUtil.castNonNull(TypeUtils.getAnnotationMirror(memberOfClass, "jakarta.persistence.ManyToOne"));
            this.validateToOneAssociation(memberOfClass, annotation, type);
        } else if (TypeUtils.hasAnnotation(memberOfClass, "jakarta.persistence.OneToOne")) {
            AnnotationMirror annotation = NullnessUtil.castNonNull(TypeUtils.getAnnotationMirror(memberOfClass, "jakarta.persistence.OneToOne"));
            this.validateToOneAssociation(memberOfClass, annotation, type);
        } else if (TypeUtils.hasAnnotation(memberOfClass, "jakarta.persistence.OneToMany")) {
            AnnotationMirror annotation = NullnessUtil.castNonNull(TypeUtils.getAnnotationMirror(memberOfClass, "jakarta.persistence.OneToMany"));
            this.validateToManyAssociation(memberOfClass, annotation, type);
        } else if (TypeUtils.hasAnnotation(memberOfClass, "jakarta.persistence.ManyToMany")) {
            AnnotationMirror annotation = NullnessUtil.castNonNull(TypeUtils.getAnnotationMirror(memberOfClass, "jakarta.persistence.ManyToMany"));
            this.validateToManyAssociation(memberOfClass, annotation, type);
        }
    }

    private static TypeMirror attributeType(Element memberOfClass) {
        switch (memberOfClass.getKind()) {
            case METHOD: {
                ExecutableElement method = (ExecutableElement)memberOfClass;
                return method.getReturnType();
            }
            case FIELD: {
                return memberOfClass.asType();
            }
        }
        throw new AssertionFailure("should be a field or getter");
    }

    private void validateToOneAssociation(Element memberOfClass, AnnotationMirror annotation, TypeMirror type) {
        AnnotationValue target = TypeUtils.getAnnotationValue(annotation, "targetEntity");
        this.validateAssociation(memberOfClass, annotation, target == null ? type : (TypeMirror)target.getValue());
    }

    private void validateToManyAssociation(Element memberOfClass, AnnotationMirror annotation, TypeMirror type) {
        AnnotationValue target = TypeUtils.getAnnotationValue(annotation, "targetEntity");
        this.validateAssociation(memberOfClass, annotation, target == null ? this.elementType(type) : (TypeMirror)target.getValue());
    }

    private void validateAssociation(Element memberOfClass, AnnotationMirror annotation, @Nullable TypeMirror typeMirror) {
        if (typeMirror != null) {
            switch (typeMirror.getKind()) {
                case TYPEVAR: {
                    if (!TypeUtils.hasAnnotation((Element)this.element, "jakarta.persistence.Entity")) break;
                    this.message(memberOfClass, "type '" + String.valueOf(typeMirror) + "' is a type variable", Diagnostic.Kind.WARNING);
                    break;
                }
                case DECLARED: {
                    DeclaredType assocDeclaredType = (DeclaredType)typeMirror;
                    TypeElement assocTypeElement = (TypeElement)assocDeclaredType.asElement();
                    if (TypeUtils.hasAnnotation((Element)assocTypeElement, "jakarta.persistence.Entity")) {
                        AnnotationValue mappedBy = TypeUtils.getAnnotationValue(annotation, "mappedBy");
                        if (mappedBy == null) break;
                        this.validateBidirectionalMapping(memberOfClass, annotation, mappedBy, assocTypeElement);
                        break;
                    }
                    this.message(memberOfClass, "type '" + String.valueOf(assocTypeElement.getSimpleName()) + "' is not annotated '@Entity'", Diagnostic.Kind.WARNING);
                    break;
                }
                default: {
                    this.message(memberOfClass, "type '" + String.valueOf(typeMirror) + "' is not an entity type", Diagnostic.Kind.WARNING);
                }
            }
        }
    }

    private void validateBidirectionalMapping(Element memberOfClass, AnnotationMirror annotation, AnnotationValue annotationVal, TypeElement assocTypeElement) {
        String mappedBy = annotationVal.getValue().toString();
        if (mappedBy != null && !mappedBy.isEmpty() && !mappedBy.equals("<error>")) {
            if (mappedBy.indexOf(46) > 0) {
                return;
            }
            for (Element member : this.context.getAllMembers(assocTypeElement)) {
                if (!TypeUtils.propertyName(member).contentEquals(mappedBy) || !this.compatibleAccess(assocTypeElement, member)) continue;
                this.validateBackRef(memberOfClass, annotation, assocTypeElement, member, annotationVal);
                return;
            }
            this.message(memberOfClass, annotation, annotationVal, "no matching member in '" + String.valueOf(assocTypeElement.getSimpleName()) + "'", Diagnostic.Kind.ERROR);
        }
    }

    private boolean compatibleAccess(TypeElement assocTypeElement, Element member) {
        AccessType memberAccessType = TypeUtils.determineAnnotationSpecifiedAccessType(member);
        AccessType accessType = memberAccessType == null ? this.getAccessType(assocTypeElement) : memberAccessType;
        return switch (member.getKind()) {
            case ElementKind.FIELD -> {
                if (accessType == AccessType.FIELD) {
                    yield true;
                }
                yield false;
            }
            case ElementKind.METHOD -> {
                if (accessType == AccessType.PROPERTY) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private void validateBackRef(Element memberOfClass, AnnotationMirror annotation, TypeElement assocTypeElement, Element referencedMember, AnnotationValue annotationVal) {
        TypeMirror backType;
        String expectedMappingAnnotation = switch (annotation.getAnnotationType().asElement().toString()) {
            case "jakarta.persistence.OneToOne" -> {
                backType = AnnotationMetaEntity.attributeType(referencedMember);
                yield "jakarta.persistence.OneToOne";
            }
            case "jakarta.persistence.OneToMany" -> {
                backType = AnnotationMetaEntity.attributeType(referencedMember);
                yield "jakarta.persistence.ManyToOne";
            }
            case "jakarta.persistence.ManyToMany" -> {
                backType = this.elementType(AnnotationMetaEntity.attributeType(referencedMember));
                yield "jakarta.persistence.ManyToMany";
            }
            default -> throw new AssertionFailure("should not have a mappedBy");
        };
        if (backType != null) {
            Element idMember = this.getIdMember();
            Types typeUtils = this.context.getTypeUtils();
            if (idMember == null || !typeUtils.isSameType(backType, idMember.asType())) {
                if (typeUtils.isSameType(backType, this.element.asType())) {
                    if (!TypeUtils.hasAnnotation(referencedMember, expectedMappingAnnotation)) {
                        this.message(memberOfClass, annotation, annotationVal, "member '" + String.valueOf(referencedMember.getSimpleName()) + "' of '" + String.valueOf(assocTypeElement.getSimpleName()) + "' is not annotated '@" + StringHelper.unqualify((String)expectedMappingAnnotation) + "'", Diagnostic.Kind.WARNING);
                    }
                } else {
                    this.message(memberOfClass, annotation, annotationVal, "member '" + String.valueOf(referencedMember.getSimpleName()) + "' of '" + String.valueOf(assocTypeElement.getSimpleName()) + "' is not of type '" + String.valueOf(this.element.getSimpleName()) + "'", Diagnostic.Kind.WARNING);
                }
            }
        }
    }

    private @Nullable Element getIdMember() {
        for (Element element : this.element.getEnclosedElements()) {
            if (!TypeUtils.hasAnnotation(element, "jakarta.persistence.Id", "jakarta.persistence.EmbeddedId")) continue;
            return element;
        }
        return null;
    }

    private boolean isPersistent(Element memberOfClass, AccessType membersKind) {
        return !(this.entityAccessTypeInfo.getAccessType() != membersKind && TypeUtils.determineAnnotationSpecifiedAccessType(memberOfClass) == null || TypeUtils.containsAnnotation(memberOfClass, "jakarta.persistence.Transient") || memberOfClass.getModifiers().contains((Object)Modifier.TRANSIENT) || memberOfClass.getModifiers().contains((Object)Modifier.STATIC) || memberOfClass.getKind() == ElementKind.METHOD && AnnotationMetaEntity.isSessionGetter((ExecutableElement)memberOfClass));
    }

    private void addLifecycleMethods(List<ExecutableElement> queryMethods) {
        for (ExecutableElement method : queryMethods) {
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            this.addLifecycleMethod(method);
        }
    }

    private boolean isDeleteLifecycle(ExecutableElement method) {
        if (method.getParameters().size() == 1) {
            VariableElement parameter = method.getParameters().get(0);
            DeclaredType declaredType = this.entityType(this.parameterType(parameter));
            return declaredType != null && TypeUtils.containsAnnotation(declaredType.asElement(), "jakarta.persistence.Entity");
        }
        return false;
    }

    private void addQueryMethods(List<ExecutableElement> queryMethods) {
        for (ExecutableElement method : queryMethods) {
            Set<Modifier> modifiers = method.getModifiers();
            if (!modifiers.contains((Object)Modifier.ABSTRACT) && !modifiers.contains((Object)Modifier.NATIVE)) continue;
            this.addQueryMethod(method);
        }
    }

    private void addQueryMethod(ExecutableElement method) {
        TypeMirror returnType = this.memberMethodType(method).getReturnType();
        TypeKind kind = returnType.getKind();
        if (kind == TypeKind.VOID || kind == TypeKind.ARRAY || kind.isPrimitive()) {
            this.addQueryMethod(method, returnType, null);
        } else if (kind == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)this.unUniIfPossible(method, returnType);
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            switch (typeArguments.size()) {
                case 0: {
                    if (TypeUtils.containsAnnotation(declaredType.asElement(), "jakarta.persistence.Entity")) {
                        this.addQueryMethod(method, declaredType, null);
                        break;
                    }
                    if (AnnotationMetaEntity.isLegalRawResultType(typeElement.getQualifiedName().toString())) {
                        this.addQueryMethod(method, null, typeElement);
                        break;
                    }
                    this.addQueryMethod(method, declaredType, null);
                    break;
                }
                case 1: {
                    if (!this.validatedQueryReturnType(method, typeElement)) break;
                    this.addQueryMethod(method, typeArguments.get(0), typeElement);
                    break;
                }
                default: {
                    this.message(method, "incorrect return type '" + String.valueOf(declaredType) + "'", Diagnostic.Kind.ERROR);
                }
            }
        }
    }

    private TypeMirror unUniIfPossible(ExecutableElement method, TypeMirror returnType) {
        TypeMirror result = AnnotationMetaEntity.ununi(returnType);
        if (this.repository) {
            if (this.isReactive()) {
                if (result == returnType) {
                    this.message(method, "backed by a reactive session, must return 'Uni'", Diagnostic.Kind.ERROR);
                }
            } else if (result != returnType) {
                this.message(method, "not backed by a reactive session, must not return 'Uni'", Diagnostic.Kind.ERROR);
            }
        }
        return result;
    }

    private boolean validatedQueryReturnType(ExecutableElement method, TypeElement typeElement) {
        String typeName;
        switch (typeName = typeElement.getQualifiedName().toString()) {
            case "jakarta.data.page.Page": {
                if (!AnnotationMetaEntity.hasPageRequest(method)) {
                    this.message(method, "method with return type '" + typeName + "' has no parameter of type 'PageRequest'", Diagnostic.Kind.ERROR);
                    return false;
                }
                return true;
            }
            case "jakarta.data.page.CursoredPage": {
                if (!AnnotationMetaEntity.hasPageRequest(method)) {
                    this.message(method, "method with return type '" + typeName + "' has no parameter of type 'PageRequest'", Diagnostic.Kind.ERROR);
                    return false;
                }
                if (!AnnotationMetaEntity.hasOrder(method)) {
                    this.message(method, "method with return type '" + typeName + "' has no parameter of type 'Order' or 'Sort' and no '@OrderBy' annotation", Diagnostic.Kind.ERROR);
                    return false;
                }
                return true;
            }
            case "org.hibernate.query.KeyedResultList": {
                if (!AnnotationMetaEntity.hashKeyedPage(method)) {
                    this.message(method, "method with return type '" + typeName + "' has no parameter of type 'KeyedPage'", Diagnostic.Kind.ERROR);
                    return false;
                }
                return true;
            }
        }
        if (AnnotationMetaEntity.isLegalGenericResultType(typeName)) {
            return true;
        }
        this.message(method, "incorrect return type '" + typeName + "'", Diagnostic.Kind.ERROR);
        return false;
    }

    private static boolean hashKeyedPage(ExecutableElement method) {
        return method.getParameters().stream().anyMatch(param -> AnnotationMetaEntity.typeNameEquals(param.asType(), "org.hibernate.query.KeyedPage"));
    }

    private static boolean hasPageRequest(ExecutableElement method) {
        return method.getParameters().stream().anyMatch(param -> AnnotationMetaEntity.typeNameEquals(param.asType(), "jakarta.data.page.PageRequest"));
    }

    private static boolean hasOrder(ExecutableElement method) {
        return TypeUtils.hasAnnotation((Element)method, "jakarta.data.repository.OrderBy", "jakarta.data.repository.OrderBy.List") || method.getParameters().stream().anyMatch(param -> AnnotationMetaEntity.typeNameEquals(param.asType(), "jakarta.data.Order") || AnnotationMetaEntity.typeNameEquals(param.asType(), "jakarta.data.Sort") || AnnotationMetaEntity.typeNameEqualsArray(param.asType(), "jakarta.data.Sort"));
    }

    private static TypeMirror ununi(TypeMirror returnType) {
        DeclaredType declaredType;
        TypeElement typeElement;
        if (returnType.getKind() == TypeKind.DECLARED && (typeElement = (TypeElement)(declaredType = (DeclaredType)returnType).asElement()).getQualifiedName().contentEquals("io.smallrye.mutiny.Uni")) {
            return declaredType.getTypeArguments().get(0);
        }
        return returnType;
    }

    private static boolean isUni(TypeMirror returnType) {
        if (returnType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)returnType;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            return typeElement.getQualifiedName().contentEquals("io.smallrye.mutiny.Uni");
        }
        return false;
    }

    private static boolean isLegalRawResultType(String containerTypeName) {
        return LEGAL_RAW_RESULT_TYPES.contains(containerTypeName);
    }

    private static boolean isLegalGenericResultType(String containerTypeName) {
        return LEGAL_GENERIC_RESULT_TYPES.contains(containerTypeName);
    }

    private void addQueryMethod(ExecutableElement method, @Nullable TypeMirror returnType, @Nullable TypeElement containerType) {
        AnnotationMirror jdql;
        AnnotationMirror sql;
        AnnotationMirror hql = TypeUtils.getAnnotationMirror(method, "org.hibernate.annotations.processing.HQL");
        if (hql != null) {
            this.addQueryMethod(method, returnType, containerType, hql, false);
        }
        if ((sql = TypeUtils.getAnnotationMirror(method, "org.hibernate.annotations.processing.SQL")) != null) {
            this.addQueryMethod(method, returnType, containerType, sql, true);
        }
        if ((jdql = TypeUtils.getAnnotationMirror(method, "jakarta.data.repository.Query")) != null) {
            this.addQueryMethod(method, returnType, containerType, jdql, false);
        }
        if (TypeUtils.hasAnnotation((Element)method, "org.hibernate.annotations.processing.Find", "jakarta.data.repository.Find")) {
            this.addFinderMethod(method, returnType, containerType);
        } else if (TypeUtils.hasAnnotation((Element)method, "jakarta.data.repository.Delete")) {
            this.addDeleteMethod(method, returnType);
        }
    }

    private void addDeleteMethod(ExecutableElement method, @Nullable TypeMirror returnType) {
        if (returnType != null) {
            if (this.isReactive() ? AnnotationMetaEntity.isLegalReactiveDeleteReturnType(returnType) : AnnotationMetaEntity.isLegalDeleteReturnType(returnType)) {
                this.createCriteriaDelete(method);
            } else {
                this.message(method, this.isReactive() ? "must be 'Uni<Void>' or 'Uni<Integer>'" : "must be 'void' or return 'int' or 'long'", Diagnostic.Kind.ERROR);
            }
        }
    }

    private static boolean isLegalDeleteReturnType(TypeMirror returnType) {
        TypeKind kind = returnType.getKind();
        return kind == TypeKind.VOID || kind == TypeKind.INT || kind == TypeKind.LONG;
    }

    private static boolean isLegalReactiveDeleteReturnType(TypeMirror returnType) {
        TypeKind kind = returnType.getKind();
        if (kind == TypeKind.DECLARED) {
            DeclaredType type = (DeclaredType)returnType;
            TypeElement typeElement = (TypeElement)type.asElement();
            Name name = typeElement.getQualifiedName();
            return name.contentEquals(Void.class.getName()) || name.contentEquals(Integer.class.getName());
        }
        return false;
    }

    private void addLifecycleMethod(ExecutableElement method) {
        TypeMirror returnType = this.unUniIfPossible(method, method.getReturnType());
        if (method.getParameters().size() != 1) {
            this.message(method, "must have exactly one parameter", Diagnostic.Kind.ERROR);
        } else if (returnType == null) {
            this.message(method, "must be declared 'void'", Diagnostic.Kind.ERROR);
        } else {
            boolean returnArgument = !AnnotationMetaEntity.isVoid(returnType);
            String operation = AnnotationMetaEntity.lifecycleOperation(method);
            VariableElement parameter = method.getParameters().get(0);
            TypeMirror declaredParameterType = parameter.asType();
            TypeMirror parameterType = this.parameterType(parameter);
            DeclaredType declaredType = this.entityType(parameterType);
            if (declaredType == null) {
                this.message(parameter, "incorrect parameter type '" + String.valueOf(parameterType) + "' is not an entity type", Diagnostic.Kind.ERROR);
            } else if (!TypeUtils.hasAnnotation(declaredType.asElement(), "jakarta.persistence.Entity") && declaredParameterType == parameterType) {
                this.message(parameter, "incorrect parameter type '" + String.valueOf(parameterType) + "' is not annotated '@Entity'", Diagnostic.Kind.ERROR);
            } else if (returnArgument && !this.isSameType(returnType, declaredParameterType)) {
                this.message(parameter, "return type '" + String.valueOf(returnType) + "' disagrees with parameter type '" + String.valueOf(parameterType) + "'", Diagnostic.Kind.ERROR);
            } else {
                String entity = this.typeAsString(parameterType);
                String methodName = method.getSimpleName().toString();
                this.putMember(methodName + "." + entity, new LifecycleMethod(this, method, entity, this.typeAsString(this.lifecycleParameterArgument(parameterType)), methodName, parameter.getSimpleName().toString(), this.getSessionVariableName(), this.sessionType, operation, this.context.addNonnullAnnotation(), AnnotationMetaEntity.lifecycleParameterKind(parameterType), returnArgument, this.hasGeneratedId(declaredType), this.element));
            }
        }
    }

    private boolean hasGeneratedId(DeclaredType entityType) {
        TypeElement typeElement = (TypeElement)entityType.asElement();
        for (Element member : this.context.getAllMembers(typeElement)) {
            if (!TypeUtils.hasAnnotation(member, "jakarta.persistence.GeneratedValue") || !TypeUtils.hasAnnotation(member, "jakarta.persistence.Id")) continue;
            return true;
        }
        return false;
    }

    private static LifecycleMethod.ParameterKind lifecycleParameterKind(TypeMirror parameterType) {
        switch (parameterType.getKind()) {
            case ARRAY: {
                return LifecycleMethod.ParameterKind.ARRAY;
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)parameterType;
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                return typeElement.getQualifiedName().contentEquals("java.util.List") ? LifecycleMethod.ParameterKind.LIST : LifecycleMethod.ParameterKind.NORMAL;
            }
        }
        return LifecycleMethod.ParameterKind.NORMAL;
    }

    private TypeMirror lifecycleParameterArgument(TypeMirror parameterType) {
        switch (parameterType.getKind()) {
            case ARRAY: {
                ArrayType arrayType = (ArrayType)parameterType;
                return arrayType.getComponentType();
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)parameterType;
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                return typeElement.getQualifiedName().contentEquals("java.util.List") && !declaredType.getTypeArguments().isEmpty() ? declaredType.getTypeArguments().get(0) : this.context.getElementUtils().getTypeElement("java.lang.Object").asType();
            }
        }
        return parameterType;
    }

    private static boolean isVoid(TypeMirror returnType) {
        switch (returnType.getKind()) {
            case VOID: {
                return true;
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)returnType;
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                return typeElement.getQualifiedName().contentEquals("java.lang.Void");
            }
        }
        return false;
    }

    private @Nullable DeclaredType entityType(TypeMirror parameterType) {
        Types types = this.context.getTypeUtils();
        switch (parameterType.getKind()) {
            case TYPEVAR: {
                TypeVariable typeVariable = (TypeVariable)parameterType;
                parameterType = typeVariable.getUpperBound();
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)parameterType;
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                if (typeElement.getQualifiedName().contentEquals("java.util.List") && !declaredType.getTypeArguments().isEmpty()) {
                    TypeMirror elementType = types.erasure(declaredType.getTypeArguments().get(0));
                    return elementType.getKind() == TypeKind.DECLARED ? (DeclaredType)elementType : null;
                }
                return declaredType;
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)parameterType;
                TypeMirror componentType = types.erasure(arrayType.getComponentType());
                return componentType.getKind() == TypeKind.DECLARED ? (DeclaredType)componentType : null;
            }
        }
        return null;
    }

    private @Nullable TypeMirror elementType(TypeMirror parameterType) {
        switch (parameterType.getKind()) {
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)parameterType;
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                return switch (typeArguments.size()) {
                    case 1 -> typeArguments.get(0);
                    case 2 -> typeArguments.get(1);
                    default -> null;
                };
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)parameterType;
                return arrayType.getComponentType();
            }
        }
        return null;
    }

    private static String lifecycleOperation(ExecutableElement method) {
        if (TypeUtils.hasAnnotation((Element)method, "jakarta.data.repository.Insert")) {
            return "insert";
        }
        if (TypeUtils.hasAnnotation((Element)method, "jakarta.data.repository.Update")) {
            return "update";
        }
        if (TypeUtils.hasAnnotation((Element)method, "jakarta.data.repository.Delete")) {
            return "delete";
        }
        if (TypeUtils.hasAnnotation((Element)method, "jakarta.data.repository.Save")) {
            return "upsert";
        }
        throw new AssertionFailure("Unrecognized lifecycle operation");
    }

    private void addFinderMethod(ExecutableElement method, @Nullable TypeMirror returnType, @Nullable TypeElement containerType) {
        if (returnType == null) {
            this.message(method, "missing return type", Diagnostic.Kind.ERROR);
        } else if (returnType.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)returnType;
            TypeMirror componentType = arrayType.getComponentType();
            if (componentType.getKind() != TypeKind.DECLARED) {
                this.message(method, "incorrect return type '" + String.valueOf(returnType) + "' is not an array with entity elements", Diagnostic.Kind.ERROR);
            } else {
                DeclaredType declaredType = (DeclaredType)componentType;
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                if (!TypeUtils.containsAnnotation(typeElement, "jakarta.persistence.Entity")) {
                    this.message(method, "incorrect return type '" + String.valueOf(returnType) + "' is not annotated '@Entity'", Diagnostic.Kind.ERROR);
                } else {
                    this.createCriteriaFinder(method, arrayType.getComponentType(), "[]", typeElement);
                }
            }
        } else if (returnType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)returnType;
            TypeElement entity = (TypeElement)declaredType.asElement();
            if (!TypeUtils.containsAnnotation(entity, "jakarta.persistence.Entity")) {
                this.message(method, "incorrect return type '" + String.valueOf(declaredType) + "' is not annotated '@Entity'", Diagnostic.Kind.ERROR);
            } else if (containerType != null && !containerType.getQualifiedName().contentEquals("java.util.Optional")) {
                this.createCriteriaFinder(method, declaredType, containerType.toString(), entity);
            } else {
                for (VariableElement variableElement : method.getParameters()) {
                    String type = variableElement.asType().toString();
                    if (QueryMethod.isPageParam(type)) {
                        this.message(variableElement, "pagination would have no effect", Diagnostic.Kind.ERROR);
                        continue;
                    }
                    if (!QueryMethod.isOrderParam(type)) continue;
                    this.message(variableElement, "ordering would have no effect", Diagnostic.Kind.ERROR);
                }
                String containerTypeName = containerType == null ? null : "java.util.Optional";
                long l = method.getParameters().stream().filter(AnnotationMetaEntity::isFinderParameterMappingToAttribute).count();
                switch ((int)l) {
                    case 0: {
                        this.message(method, "missing parameter", Diagnostic.Kind.ERROR);
                        break;
                    }
                    case 1: {
                        this.createSingleParameterFinder(method, declaredType, entity, containerTypeName);
                        break;
                    }
                    default: {
                        this.createMultipleParameterFinder(method, declaredType, entity, containerTypeName);
                    }
                }
            }
        } else {
            this.message(method, "incorrect return type '" + String.valueOf(returnType) + "' is not an entity type", Diagnostic.Kind.ERROR);
        }
    }

    private void createCriteriaFinder(ExecutableElement method, TypeMirror returnType, @Nullable String containerType, TypeElement entity) {
        String methodName = method.getSimpleName().toString();
        List<String> paramNames = this.parameterNames(method, entity);
        List<String> paramTypes = this.parameterTypes(method);
        List<Boolean> paramPatterns = AnnotationMetaEntity.parameterPatterns(method);
        String[] sessionType = this.sessionTypeFromParameters(paramNames, paramTypes);
        String methodKey = methodName + String.valueOf(paramTypes);
        ArrayList<Boolean> multivalued = new ArrayList<Boolean>();
        for (VariableElement variableElement : method.getParameters()) {
            if (AnnotationMetaEntity.isFinderParameterMappingToAttribute(variableElement)) {
                multivalued.add(this.validateFinderParameter(entity, variableElement) == FieldType.MULTIVALUED);
                continue;
            }
            multivalued.add(false);
            this.checkFinderParameter(entity, variableElement);
        }
        this.warnAboutMissingOrder(method);
        this.putMember(methodKey, new CriteriaFinderMethod(this, method, methodName, this.typeAsString(returnType, false), containerType, paramNames, paramTypes, this.parameterNullability(method, entity), multivalued, paramPatterns, this.repository, sessionType[0], sessionType[1], AnnotationMetaEntity.enabledFetchProfiles(method), this.orderByList(method, entity), this.context.addNonnullAnnotation(), this.jakartaDataRepository, this.fullReturnType(method), TypeUtils.hasAnnotation((Element)method, "jakarta.annotation.Nullable")));
    }

    private void checkFinderParameter(@Nullable TypeElement entityType, VariableElement parameter) {
        Types types = this.context.getTypeUtils();
        TypeMirror parameterType = this.parameterType(parameter);
        String typeName = parameterType.toString();
        if (QueryMethod.isOrderParam(typeName) || AbstractQueryMethod.isRestrictionParam(typeName)) {
            TypeMirror typeArgument = AnnotationMetaEntity.getTypeArgument(parameterType);
            if (entityType != null) {
                if (typeArgument == null) {
                    this.missingTypeArgError(entityType, parameter, typeName);
                } else if (!types.isSameType(typeArgument, entityType.asType())) {
                    this.wrongTypeArgError(entityType, parameter, typeName);
                }
            } else {
                this.message(parameter, "repository method does not return entity type", Diagnostic.Kind.ERROR);
            }
        }
    }

    private void createCriteriaDelete(ExecutableElement method) {
        TypeElement entity = this.primaryEntity;
        if (entity == null) {
            this.message(method, "repository does not have a well-defined primary entity type", Diagnostic.Kind.ERROR);
        } else {
            String methodName = method.getSimpleName().toString();
            List<String> paramNames = this.parameterNames(method, entity);
            List<String> paramTypes = this.parameterTypes(method);
            List<Boolean> paramPatterns = AnnotationMetaEntity.parameterPatterns(method);
            String[] sessionType = this.sessionTypeFromParameters(paramNames, paramTypes);
            String methodKey = methodName + String.valueOf(paramTypes);
            ArrayList<Boolean> multivalued = new ArrayList<Boolean>();
            for (VariableElement variableElement : method.getParameters()) {
                if (AnnotationMetaEntity.isFinderParameterMappingToAttribute(variableElement)) {
                    multivalued.add(this.validateFinderParameter(entity, variableElement) == FieldType.MULTIVALUED);
                    continue;
                }
                multivalued.add(false);
            }
            this.putMember(methodKey, new CriteriaDeleteMethod(this, method, methodName, entity.getQualifiedName().toString(), paramNames, paramTypes, this.parameterNullability(method, entity), multivalued, paramPatterns, this.repository, sessionType[0], sessionType[1], this.context.addNonnullAnnotation(), this.jakartaDataRepository, this.fullReturnType(method)));
        }
    }

    private void wrongTypeArgError(TypeElement entityType, VariableElement parameter, String parameterType) {
        this.message(parameter, "mismatched type of " + this.message(parameterType, entityType), Diagnostic.Kind.ERROR);
    }

    private void missingTypeArgError(TypeElement entityType, VariableElement parameter, String parameterType) {
        this.message(parameter, "missing type of " + this.message(parameterType, entityType), Diagnostic.Kind.ERROR);
    }

    private String message(String parameterType, TypeElement entityType) {
        String entityTypeName = entityType.getSimpleName().toString();
        if (parameterType.startsWith("org.hibernate.query.Order") || parameterType.startsWith("jakarta.data.Order")) {
            return "order (should be 'Order<? super " + entityTypeName + ">')";
        }
        if (parameterType.startsWith("java.util.List<org.hibernate.query.Order")) {
            return "order (should be 'List<Order<? super " + entityTypeName + ">>')";
        }
        if (parameterType.startsWith("org.hibernate.query.restriction.Restriction")) {
            return "restriction (should be 'Restriction<? super " + entityTypeName + ">')";
        }
        if (parameterType.startsWith("java.util.List<org.hibernate.query.restriction.Restriction")) {
            return "restriction (should be 'List<Restriction<? super " + entityTypeName + ">>')";
        }
        if (parameterType.startsWith("jakarta.data.Sort")) {
            return "sort (should be 'Sort<? super " + entityTypeName + ">')";
        }
        return "parameter";
    }

    private List<OrderBy> orderByList(ExecutableElement method, TypeElement returnType) {
        TypeElement entityType = this.implicitEntityType(returnType);
        if (entityType != null) {
            AnnotationMirror orderByList = TypeUtils.getAnnotationMirror(method, "jakarta.data.repository.OrderBy.List");
            if (orderByList != null) {
                ArrayList<OrderBy> result = new ArrayList<OrderBy>();
                List list = (List)NullnessUtil.castNonNull(TypeUtils.getAnnotationValue(orderByList)).getValue();
                for (AnnotationValue element : list) {
                    result.add(this.orderByExpression(NullnessUtil.castNonNull((AnnotationMirror)element.getValue()), entityType, method));
                }
                return result;
            }
            AnnotationMirror orderBy = TypeUtils.getAnnotationMirror(method, "jakarta.data.repository.OrderBy");
            if (orderBy != null) {
                return List.of(this.orderByExpression(orderBy, entityType, method));
            }
        }
        return Collections.emptyList();
    }

    private OrderBy orderByExpression(AnnotationMirror orderBy, TypeElement entityType, ExecutableElement method) {
        String fieldName = NullnessUtil.castNonNull(TypeUtils.getAnnotationValue(orderBy)).getValue().toString();
        if (fieldName.equals("<error>")) {
            throw new ProcessLaterException();
        }
        AnnotationValue descendingOrNull = TypeUtils.getAnnotationValue(orderBy, "descending");
        AnnotationValue ignoreCaseOrNull = TypeUtils.getAnnotationValue(orderBy, "ignoreCase");
        boolean descending = descendingOrNull != null && (Boolean)descendingOrNull.getValue() != false;
        boolean ignoreCase = ignoreCaseOrNull != null && (Boolean)ignoreCaseOrNull.getValue() != false;
        String path = fieldName.replace('$', '.').replace('_', '.');
        if (this.memberMatchingPath(entityType, path) == null) {
            this.message(method, orderBy, "no matching field named '" + fieldName + "' in entity class '" + String.valueOf(entityType.getQualifiedName()) + "'", Diagnostic.Kind.ERROR);
        }
        return new OrderBy(path, descending, ignoreCase);
    }

    private static @Nullable TypeMirror getTypeArgument(TypeMirror parameterType) {
        switch (parameterType.getKind()) {
            case ARRAY: {
                ArrayType arrayType = (ArrayType)parameterType;
                return AnnotationMetaEntity.getTypeArgument(arrayType.getComponentType());
            }
            case DECLARED: {
                DeclaredType type = (DeclaredType)parameterType;
                switch (AnnotationMetaEntity.typeName(parameterType)) {
                    case "java.util.List": {
                        Iterator<? extends TypeMirror> iterator = type.getTypeArguments().iterator();
                        if (iterator.hasNext()) {
                            TypeMirror arg = iterator.next();
                            return AnnotationMetaEntity.getTypeArgument(arg);
                        }
                        return null;
                    }
                    case "org.hibernate.query.Order": 
                    case "org.hibernate.query.restriction.Restriction": 
                    case "jakarta.data.Sort": 
                    case "jakarta.data.Order": {
                        Iterator<? extends TypeMirror> iterator = type.getTypeArguments().iterator();
                        if (iterator.hasNext()) {
                            TypeMirror arg = iterator.next();
                            switch (arg.getKind()) {
                                case WILDCARD: {
                                    return ((WildcardType)arg).getSuperBound();
                                }
                                case ARRAY: 
                                case DECLARED: 
                                case TYPEVAR: {
                                    return arg;
                                }
                            }
                            return null;
                        }
                        return null;
                    }
                }
                return null;
            }
        }
        return null;
    }

    private static boolean isFinderParameterMappingToAttribute(VariableElement parameter) {
        String typeName = parameter.asType().toString();
        return !AbstractQueryMethod.isSpecialParam(typeName) || AbstractQueryMethod.isRangeParam(typeName);
    }

    private String[] sessionTypeFromParameters(List<String> paramNames, List<String> paramTypes) {
        for (int i = 0; i < paramNames.size(); ++i) {
            String type = paramTypes.get(i);
            if (!AbstractQueryMethod.isSessionParameter(type)) continue;
            String name = paramNames.get(i);
            return new String[]{type, name};
        }
        return new String[]{this.getSessionType(), this.getSessionVariableName()};
    }

    @Override
    protected String getSessionVariableName() {
        return this.getSessionVariableName(this.sessionType);
    }

    private String getSessionVariableName(String sessionType) {
        return switch (sessionType) {
            case "org.hibernate.Session", "org.hibernate.StatelessSession", "org.hibernate.reactive.mutiny.Mutiny.Session", "org.hibernate.reactive.mutiny.Mutiny.StatelessSession", "org.springframework.beans.factory.ObjectProvider<org.hibernate.StatelessSession>" -> "session";
            default -> this.sessionGetter;
        };
    }

    private static List<String> enabledFetchProfiles(ExecutableElement method) {
        AnnotationMirror findAnnotation = TypeUtils.getAnnotationMirror(method, "org.hibernate.annotations.processing.Find");
        if (findAnnotation == null) {
            return Collections.emptyList();
        }
        AnnotationValue enabledFetchProfiles = TypeUtils.getAnnotationValue(findAnnotation, "enabledFetchProfiles");
        if (enabledFetchProfiles == null) {
            return Collections.emptyList();
        }
        List annotationValues = (List)enabledFetchProfiles.getValue();
        List<String> result = annotationValues.stream().map(AnnotationValue::toString).collect(Collectors.toList());
        if (result.stream().anyMatch("<error>"::equals)) {
            throw new ProcessLaterException();
        }
        return result;
    }

    private void createMultipleParameterFinder(ExecutableElement method, TypeMirror returnType, TypeElement entity, @Nullable String containerType) {
        String methodName = method.getSimpleName().toString();
        List<String> paramNames = this.parameterNames(method, entity);
        List<String> paramTypes = this.parameterTypes(method);
        String[] sessionType = this.sessionTypeFromParameters(paramNames, paramTypes);
        String methodKey = methodName + String.valueOf(paramTypes);
        ArrayList<Boolean> multivalued = new ArrayList<Boolean>();
        ArrayList<@Nullable FieldType> fieldTypes = new ArrayList<FieldType>();
        for (VariableElement variableElement : method.getParameters()) {
            if (AnnotationMetaEntity.isFinderParameterMappingToAttribute(variableElement)) {
                FieldType fieldType = this.validateFinderParameter(entity, variableElement);
                fieldTypes.add(fieldType);
                multivalued.add(fieldType == FieldType.MULTIVALUED);
                continue;
            }
            multivalued.add(false);
        }
        this.warnAboutMissingOrder(method);
        if (!AnnotationMetaEntity.usingStatelessSession(sessionType[0]) && this.matchesNaturalKey(entity, fieldTypes)) {
            this.putMember(methodKey, new NaturalIdFinderMethod(this, method, methodName, returnType.toString(), containerType, paramNames, paramTypes, this.parameterNullability(method, entity), this.repository, sessionType[0], sessionType[1], AnnotationMetaEntity.enabledFetchProfiles(method), this.context.addNonnullAnnotation(), this.jakartaDataRepository, this.fullReturnType(method)));
        } else {
            List<Boolean> paramPatterns = AnnotationMetaEntity.parameterPatterns(method);
            this.putMember(methodKey, new CriteriaFinderMethod(this, method, methodName, this.typeAsString(returnType, false), containerType, paramNames, paramTypes, this.parameterNullability(method, entity), multivalued, paramPatterns, this.repository, sessionType[0], sessionType[1], AnnotationMetaEntity.enabledFetchProfiles(method), this.orderByList(method, entity), this.context.addNonnullAnnotation(), this.jakartaDataRepository, this.fullReturnType(method), TypeUtils.hasAnnotation((Element)method, "jakarta.annotation.Nullable")));
        }
    }

    private void warnAboutMissingOrder(ExecutableElement method) {
        if (!TypeUtils.hasAnnotation((Element)method, "jakarta.data.repository.OrderBy", "jakarta.data.repository.OrderBy.List")) {
            boolean hasPageRequest = false;
            boolean hasSortOrOrder = false;
            for (VariableElement variableElement : method.getParameters()) {
                String parameterType = variableElement.asType().toString();
                if (QueryMethod.isOrderParam(parameterType)) {
                    hasSortOrOrder = true;
                }
                if (!QueryMethod.isPageParam(parameterType)) continue;
                hasPageRequest = true;
            }
            if (hasPageRequest && !hasSortOrOrder) {
                this.context.message(method, "'PageRequest' with no 'Sort' or 'Order' and no '@OrderBy'", Diagnostic.Kind.MANDATORY_WARNING);
            }
        }
    }

    private void createSingleParameterFinder(ExecutableElement method, TypeMirror returnType, TypeElement entity, @Nullable String containerType) {
        String methodName = method.getSimpleName().toString();
        VariableElement parameter = method.getParameters().stream().filter(AnnotationMetaEntity::isFinderParameterMappingToAttribute).findFirst().orElseThrow();
        List<String> paramNames = this.parameterNames(method, entity);
        List<String> paramTypes = this.parameterTypes(method);
        String[] sessionType = this.sessionTypeFromParameters(paramNames, paramTypes);
        FieldType fieldType = this.validateFinderParameter(entity, parameter);
        if (fieldType != null) {
            String methodKey = methodName + "!";
            List<String> profiles = AnnotationMetaEntity.enabledFetchProfiles(method);
            switch (AnnotationMetaEntity.pickStrategy(fieldType, sessionType[0], profiles).ordinal()) {
                case 0: {
                    this.putMember(methodKey, new IdFinderMethod(this, method, methodName, returnType.toString(), containerType, paramNames, paramTypes, this.repository, sessionType[0], sessionType[1], profiles, this.context.addNonnullAnnotation(), this.jakartaDataRepository, this.fullReturnType(method), TypeUtils.hasAnnotation((Element)method, "jakarta.annotation.Nullable")));
                    break;
                }
                case 1: {
                    if (!AnnotationMetaEntity.usingStatelessSession(sessionType[0])) {
                        this.putMember(methodKey, new NaturalIdFinderMethod(this, method, methodName, returnType.toString(), containerType, paramNames, paramTypes, this.parameterNullability(method, entity), this.repository, sessionType[0], sessionType[1], profiles, this.context.addNonnullAnnotation(), this.jakartaDataRepository, this.fullReturnType(method)));
                        break;
                    }
                }
                case 2: 
                case 3: {
                    this.putMember(methodKey, new CriteriaFinderMethod(this, method, methodName, this.typeAsString(returnType, false), containerType, paramNames, paramTypes, this.parameterNullability(method, entity), AnnotationMetaEntity.parameterMultivalued(method, fieldType), AnnotationMetaEntity.parameterPatterns(method), this.repository, sessionType[0], sessionType[1], profiles, this.orderByList(method, entity), this.context.addNonnullAnnotation(), this.jakartaDataRepository, this.fullReturnType(method), TypeUtils.hasAnnotation((Element)method, "jakarta.annotation.Nullable")));
                }
            }
        }
    }

    private static List<Boolean> parameterMultivalued(ExecutableElement method, FieldType fieldType) {
        return method.getParameters().stream().map(param -> AnnotationMetaEntity.isFinderParameterMappingToAttribute(param) && fieldType == FieldType.MULTIVALUED).collect(Collectors.toList());
    }

    private static FieldType pickStrategy(FieldType fieldType, String sessionType, List<String> profiles) {
        if ((AnnotationMetaEntity.usingStatelessSession(sessionType) || AnnotationMetaEntity.usingReactiveSession(sessionType)) && !profiles.isEmpty()) {
            return FieldType.BASIC;
        }
        return switch (fieldType.ordinal()) {
            case 0 -> FieldType.ID;
            case 1 -> FieldType.NATURAL_ID;
            default -> FieldType.BASIC;
        };
    }

    private boolean matchesNaturalKey(TypeElement entity, List<@Nullable FieldType> fieldTypes) {
        return fieldTypes.stream().allMatch(type -> type == FieldType.NATURAL_ID) && entity.getEnclosedElements().stream().filter(member -> TypeUtils.hasAnnotation(member, "org.hibernate.annotations.NaturalId")).count() == (long)fieldTypes.size();
    }

    private @Nullable FieldType validateFinderParameter(TypeElement entityType, VariableElement param) {
        Element member;
        String path = AnnotationMetaEntity.parameterName(param);
        boolean idClassRef = AnnotationMetaEntity.isIdRef(path) && TypeUtils.hasAnnotation((Element)entityType, "jakarta.persistence.IdClass");
        Element element = member = idClassRef ? null : this.memberMatchingPath(entityType, path);
        if (member != null) {
            if (TypeUtils.isPluralAttribute(member)) {
                this.message(param, "matching field is a collection", Diagnostic.Kind.ERROR);
                return null;
            }
            TypeMirror memberType = AnnotationMetaEntity.memberType(member);
            TypeMirror attributeType = Objects.requireNonNullElse(TypeUtils.resolveTypeMirror(entityType, member.getEnclosingElement(), memberType.toString()), memberType);
            if (this.checkParameterType(entityType, param, attributeType)) {
                return FieldType.MULTIVALUED;
            }
            if (TypeUtils.containsAnnotation(param, "org.hibernate.annotations.processing.Pattern")) {
                AnnotationMirror mirror = TypeUtils.getAnnotationMirror(param, "org.hibernate.annotations.processing.Pattern");
                if (mirror != null && !AnnotationMetaEntity.typeNameEquals(param.asType(), "java.lang.String")) {
                    this.message(param, mirror, "parameter annotated '@Pattern' is not of type 'String'", Diagnostic.Kind.ERROR);
                }
                return FieldType.BASIC;
            }
            if (TypeUtils.containsAnnotation(member, "jakarta.persistence.Id", "jakarta.persistence.EmbeddedId")) {
                return FieldType.ID;
            }
            if (TypeUtils.containsAnnotation(member, "org.hibernate.annotations.NaturalId")) {
                return FieldType.NATURAL_ID;
            }
            return FieldType.BASIC;
        }
        if (idClassRef) {
            AnnotationMirror idClass = TypeUtils.getAnnotationMirror(entityType, "jakarta.persistence.IdClass");
            if (idClass == null) {
                return null;
            }
            AnnotationValue value = TypeUtils.getAnnotationValue(idClass);
            if (value != null && this.isSameType(this.actualParameterType(param), (TypeMirror)value.getValue())) {
                return FieldType.ID;
            }
            this.message(param, "does not match id class of entity class '" + String.valueOf(entityType) + "'", Diagnostic.Kind.ERROR);
            return null;
        }
        this.message(param, "no matching field named '" + path + "' in entity class '" + String.valueOf(entityType) + "'", Diagnostic.Kind.ERROR);
        return null;
    }

    private TypeMirror actualParameterType(VariableElement param) {
        ExecutableElement method = (ExecutableElement)param.getEnclosingElement();
        ExecutableType methodType = (ExecutableType)this.context.getTypeUtils().asMemberOf((DeclaredType)this.element.asType(), method);
        return methodType.getParameterTypes().get(method.getParameters().indexOf(param));
    }

    private boolean checkParameterType(TypeElement entityType, VariableElement param, TypeMirror attributeType) {
        TypeMirror parameterType;
        Types types = this.context.getTypeUtils();
        if (types.isSameType(parameterType = this.parameterType(param), attributeType)) {
            return false;
        }
        if (attributeType.getKind().isPrimitive()) {
            PrimitiveType primitiveType = (PrimitiveType)attributeType;
            attributeType = types.boxedClass(primitiveType).asType();
        }
        TypeKind kind = parameterType.getKind();
        switch (kind) {
            case TYPEVAR: {
                TypeVariable typeVariable = (TypeVariable)parameterType;
                parameterType = typeVariable.getUpperBound();
            }
            case DECLARED: {
                if (types.isSameType(parameterType, attributeType)) {
                    return false;
                }
                TypeElement list = this.context.getTypeElementForFullyQualifiedName("java.util.List");
                TypeElement range = this.context.getTypeElementForFullyQualifiedName("org.hibernate.query.range.Range");
                if (types.isSameType(parameterType, types.getDeclaredType(list, attributeType))) {
                    return true;
                }
                if (types.isSameType(parameterType, types.getDeclaredType(range, attributeType))) {
                    return false;
                }
                this.parameterTypeError(entityType, param, attributeType);
                return false;
            }
            case ARRAY: {
                if (!types.isSameType(parameterType, types.getArrayType(attributeType))) {
                    this.parameterTypeError(entityType, param, attributeType);
                }
                return true;
            }
        }
        if (kind.isPrimitive()) {
            PrimitiveType primitiveType = (PrimitiveType)parameterType;
            if (!types.isSameType(types.boxedClass(primitiveType).asType(), attributeType)) {
                this.parameterTypeError(entityType, param, attributeType);
            }
            return false;
        }
        return false;
    }

    private void parameterTypeError(TypeElement entityType, VariableElement param, TypeMirror attributeType) {
        this.message(param, "matching field has type '" + this.stripAnnotations(this.typeAsString(attributeType)) + "' in entity class '" + String.valueOf(entityType) + "'", Diagnostic.Kind.ERROR);
    }

    private String stripAnnotations(String type) {
        if (type.startsWith("@")) {
            int index = type.lastIndexOf(32);
            return index > 0 ? type.substring(index + 1) : type;
        }
        return type;
    }

    private boolean finderParameterNullable(TypeElement entity, VariableElement param) {
        Element member = this.memberMatchingPath(entity, AnnotationMetaEntity.parameterName(param));
        return AnnotationMetaEntity.isNullable(param) && (member == null || AnnotationMetaEntity.isNullable(member));
    }

    private AccessType getAccessType(TypeElement entity) {
        String entityClassName = entity.getQualifiedName().toString();
        TypeUtils.determineAccessTypeForHierarchy(entity, this.context);
        return NullnessUtil.castNonNull(this.context.getAccessTypeInfo(entityClassName)).getAccessType();
    }

    private static TypeMirror memberType(Element member) {
        if (member.getKind() == ElementKind.METHOD) {
            ExecutableElement method = (ExecutableElement)member;
            return method.getReturnType();
        }
        return member.asType();
    }

    private @Nullable Element memberMatchingPath(TypeElement entityType, String path) {
        return this.memberMatchingPath(entityType, new StringTokenizer(path, "."));
    }

    private @Nullable Element memberMatchingPath(TypeElement entityType, StringTokenizer tokens) {
        AccessType accessType = this.getAccessType(entityType);
        String nextToken = tokens.nextToken();
        for (Element member : this.context.getAllMembers(entityType)) {
            if (AnnotationMetaEntity.isIdRef(nextToken) && TypeUtils.hasAnnotation(member, "jakarta.persistence.Id", "jakarta.persistence.EmbeddedId")) {
                return member;
            }
            Element match = this.memberMatchingPath(entityType, member, accessType, tokens, nextToken);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private static boolean isIdRef(String token) {
        return "id(this)".equalsIgnoreCase(token);
    }

    private @Nullable Element memberMatchingPath(TypeElement entityType, Element candidate, AccessType accessType, StringTokenizer tokens, String token) {
        Name memberName = candidate.getSimpleName();
        TypeMirror type = AnnotationMetaEntity.memberType(candidate, accessType, token, memberName);
        if (type == null) {
            return null;
        }
        if (tokens.hasMoreTokens()) {
            return type.getKind() == TypeKind.DECLARED ? this.memberForPath(entityType, tokens, (DeclaredType)type, memberName) : null;
        }
        return candidate;
    }

    private @Nullable Element memberForPath(TypeElement entityType, StringTokenizer tokens, DeclaredType type, Name memberName) {
        TypeElement memberType = (TypeElement)type.asElement();
        this.memberTypes.put(StringHelper.qualify((String)entityType.getQualifiedName().toString(), (String)memberName.toString()), memberType.getQualifiedName().toString());
        return this.memberMatchingPath(memberType, tokens);
    }

    private static @Nullable TypeMirror memberType(Element candidate, AccessType accessType, String token, Name memberName) {
        ElementKind kind = candidate.getKind();
        if (accessType == AccessType.FIELD && kind == ElementKind.FIELD) {
            return AnnotationMetaEntity.fieldMatches(token, memberName) ? candidate.asType() : null;
        }
        if (accessType == AccessType.PROPERTY && kind == ElementKind.METHOD) {
            ExecutableElement executable = (ExecutableElement)candidate;
            return AnnotationMetaEntity.getterMatches(token, memberName) ? executable.getReturnType() : null;
        }
        return null;
    }

    private static boolean fieldMatches(String token, Name fieldName) {
        return fieldName.contentEquals(token);
    }

    private static boolean getterMatches(String token, Name methodName) {
        if (AnnotationMetaEntity.hasPrefix(methodName, "get")) {
            return token.equals(Introspector.decapitalize(methodName.subSequence(3, methodName.length()).toString()));
        }
        if (AnnotationMetaEntity.hasPrefix(methodName, "is")) {
            return token.equals(Introspector.decapitalize(methodName.subSequence(2, methodName.length()).toString()));
        }
        return false;
    }

    private void addQueryMethod(ExecutableElement method, @Nullable TypeMirror returnType, @Nullable TypeElement containerType, AnnotationMirror mirror, boolean isNative) {
        Object object;
        String containerTypeName;
        if (containerType == null) {
            if (returnType != null && returnType.getKind() == TypeKind.ARRAY) {
                ArrayType arrayType = (ArrayType)returnType;
                TypeMirror componentType = arrayType.getComponentType();
                TypeElement object2 = this.context.getElementUtils().getTypeElement("java.lang.Object");
                if (!this.isSameType(object2.asType(), componentType)) {
                    returnType = componentType;
                    containerTypeName = "[]";
                } else {
                    containerTypeName = null;
                }
            } else {
                containerTypeName = null;
            }
        } else {
            containerTypeName = containerType.getQualifiedName().toString();
        }
        AnnotationValue value = TypeUtils.getAnnotationValue(mirror);
        if (value != null && (object = value.getValue()) instanceof String) {
            String queryString = (String)object;
            this.addQueryMethod(method, returnType, containerTypeName, mirror, isNative, value, queryString);
        }
    }

    private void addQueryMethod(ExecutableElement method, @Nullable TypeMirror returnType, @Nullable String containerTypeName, AnnotationMirror mirror, boolean isNative, AnnotationValue value, String queryString) {
        String processedQuery;
        List<OrderBy> orderBys;
        List<String> paramNames = AnnotationMetaEntity.parameterNames(method);
        List<String> paramTypes = this.parameterTypes(method);
        this.checkParameters(method, returnType, paramNames, paramTypes, mirror, value, queryString);
        String[] sessionType = this.sessionTypeFromParameters(paramNames, paramTypes);
        DeclaredType resultType = this.resultType(method, returnType, mirror, value);
        List<OrderBy> list = orderBys = resultType == null ? Collections.emptyList() : this.orderByList(method, (TypeElement)resultType.asElement());
        if (isNative) {
            processedQuery = queryString;
            this.validateSql(method, mirror, processedQuery, paramNames, value);
        } else {
            processedQuery = AnnotationMetaEntity.addFromClauseIfNecessary(queryString, this.implicitEntityName(resultType));
            this.validateHql(method, returnType, mirror, value, processedQuery, paramNames, paramTypes);
        }
        QueryMethod attribute = new QueryMethod(this, method, method.getSimpleName().toString(), processedQuery, returnType == null ? null : returnType.toString(), returnType == null ? null : AnnotationMetaEntity.returnTypeClass(returnType), containerTypeName, paramNames, paramTypes, AnnotationMetaEntity.isInsertUpdateDelete(queryString), isNative, this.repository, sessionType[0], sessionType[1], orderBys, this.context.addNonnullAnnotation(), this.jakartaDataRepository, this.fullReturnType(method), TypeUtils.hasAnnotation((Element)method, "jakarta.annotation.Nullable"));
        this.putMember(attribute.getPropertyName() + String.valueOf(paramTypes), attribute);
    }

    private String fullReturnType(ExecutableElement method) {
        return this.typeAsString(this.memberMethodType(method).getReturnType());
    }

    private static String returnTypeClass(TypeMirror returnType) {
        switch (returnType.getKind()) {
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)returnType;
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                return typeElement.getQualifiedName().toString();
            }
            case INT: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case SHORT: {
                return "short";
            }
            case BYTE: {
                return "byte";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case CHAR: {
                return "char";
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)returnType;
                return AnnotationMetaEntity.returnTypeClass(arrayType.getComponentType()) + "[]";
            }
        }
        return returnType.toString();
    }

    private @Nullable String implicitEntityName(@Nullable DeclaredType resultType) {
        if (resultType != null && TypeUtils.hasAnnotation(resultType.asElement(), "jakarta.persistence.Entity")) {
            AnnotationMirror annotation = TypeUtils.getAnnotationMirror(resultType.asElement(), "jakarta.persistence.Entity");
            if (annotation == null) {
                throw new AssertionFailure("@Entity annotation should not be missing");
            }
            return AnnotationMetaEntity.entityName(resultType, annotation);
        }
        if (this.primaryEntity != null) {
            return this.primaryEntity.getSimpleName().toString();
        }
        return null;
    }

    private @Nullable TypeElement implicitEntityType(@Nullable TypeElement resultType) {
        if (resultType != null && TypeUtils.hasAnnotation((Element)resultType, "jakarta.persistence.Entity")) {
            return resultType;
        }
        if (this.primaryEntity != null) {
            return this.primaryEntity;
        }
        return null;
    }

    private static String entityName(DeclaredType resultType, AnnotationMirror annotation) {
        String explicitName;
        AnnotationValue name = TypeUtils.getAnnotationValue(annotation, "name");
        if (name != null && !(explicitName = name.getValue().toString()).isEmpty()) {
            return explicitName;
        }
        return resultType.asElement().getSimpleName().toString();
    }

    private static String addFromClauseIfNecessary(String hql, @Nullable String entityType) {
        if (entityType == null) {
            return hql;
        }
        if (AnnotationMetaEntity.isInsertUpdateDelete(hql)) {
            return hql;
        }
        HqlLexer hqlLexer = HqlParseTreeBuilder.INSTANCE.buildHqlLexer(hql);
        List allTokens = hqlLexer.getAllTokens();
        for (Token token : allTokens) {
            switch (token.getType()) {
                case 106: {
                    return hql;
                }
                case 109: 
                case 111: 
                case 179: 
                case 234: {
                    return new StringBuilder(hql).insert(token.getStartIndex(), "from " + entityType + " ").toString();
                }
            }
        }
        return hql + " from " + entityType;
    }

    private @Nullable DeclaredType resultType(ExecutableElement method, @Nullable TypeMirror returnType, AnnotationMirror mirror, AnnotationValue value) {
        if (returnType != null && returnType.getKind() == TypeKind.DECLARED) {
            DeclaredType resultType = (DeclaredType)returnType;
            if (!resultType.getTypeArguments().isEmpty()) {
                this.message(method, mirror, value, "query result type may not be a generic type (change '" + String.valueOf(returnType) + "' to '" + String.valueOf(this.context.getTypeUtils().erasure(returnType)) + "')", Diagnostic.Kind.ERROR);
            }
            return resultType;
        }
        return null;
    }

    private static boolean isInsertUpdateDelete(String hql) {
        String trimmed = hql.trim();
        String keyword = trimmed.length() > 6 ? trimmed.substring(0, 6) : "";
        return keyword.equalsIgnoreCase("update") || keyword.equalsIgnoreCase("delete") || keyword.equalsIgnoreCase("insert");
    }

    private void validateHql(ExecutableElement method, @Nullable TypeMirror returnType, AnnotationMirror mirror, AnnotationValue value, String hql, List<String> paramNames, List<String> paramTypes) {
        SqmStatement<?> statement = Validation.validate(hql, returnType, true, new ErrorHandler(this.context, this.isLocal(method) ? method : this.element, mirror, value, hql), ProcessorSessionFactory.create(this.context.getProcessingEnvironment(), this.context.getEntityNameMappings(), this.context.getEnumTypesByValue(), this.context.isIndexing()));
        if (statement != null) {
            if (statement instanceof SqmSelectStatement) {
                SqmSelectStatement selectStatement = (SqmSelectStatement)statement;
                this.validateSelectHql(method, returnType, mirror, value, selectStatement);
            } else {
                this.validateUpdateHql(method, returnType, mirror, value);
            }
            for (SqmParameter param : statement.getSqmParameters()) {
                this.checkParameter(param, paramNames, paramTypes, method, mirror, value);
            }
        }
    }

    private void validateUpdateHql(ExecutableElement method, @Nullable TypeMirror returnType, AnnotationMirror mirror, AnnotationValue value) {
        boolean reactive = this.isReactive();
        if (!this.isValidUpdateReturnType(returnType, method, reactive)) {
            this.message(method, mirror, value, "return type of mutation query method must be " + (!reactive ? "'int', 'long', 'boolean' or 'void'" : "'Uni<Integer>', 'Uni<Boolean>' or 'Uni<Void>'"), Diagnostic.Kind.ERROR);
        }
    }

    private boolean isValidUpdateReturnType(@Nullable TypeMirror returnType, ExecutableElement method, boolean reactive) {
        if (returnType == null) {
            return false;
        }
        if (reactive) {
            String returnTypeName = this.fullReturnType(method);
            return returnTypeName.equals("io.smallrye.mutiny.Uni<java.lang.Void>") || returnTypeName.equals("io.smallrye.mutiny.Uni<java.lang.Boolean>") || returnTypeName.equals("io.smallrye.mutiny.Uni<java.lang.Integer>");
        }
        return returnType.getKind() == TypeKind.VOID || returnType.getKind() == TypeKind.BOOLEAN || returnType.getKind() == TypeKind.INT || returnType.getKind() == TypeKind.LONG;
    }

    private void validateSelectHql(ExecutableElement method, @Nullable TypeMirror returnType, AnnotationMirror mirror, AnnotationValue value, SqmSelectStatement<?> statement) {
        if (returnType != null) {
            boolean returnTypeCorrect;
            JpaSelection selection = statement.getSelection();
            if (selection.isCompoundSelection()) {
                switch (returnType.getKind()) {
                    case ARRAY: {
                        returnTypeCorrect = AnnotationMetaEntity.checkReturnedArrayType((ArrayType)returnType);
                        break;
                    }
                    case DECLARED: {
                        if (!AnnotationMetaEntity.checkConstructorReturn((DeclaredType)returnType, selection)) {
                            this.message(method, mirror, value, "return type '" + String.valueOf(returnType) + "' of method has no constructor matching query selection list", Diagnostic.Kind.ERROR);
                        }
                        returnTypeCorrect = true;
                        break;
                    }
                    default: {
                        returnTypeCorrect = false;
                        break;
                    }
                }
            } else if (selection instanceof JpaEntityJoin) {
                JpaEntityJoin from = (JpaEntityJoin)selection;
                returnTypeCorrect = this.checkReturnedEntity(from.getModel(), returnType);
            } else if (selection instanceof JpaRoot) {
                JpaRoot from = (JpaRoot)selection;
                returnTypeCorrect = this.checkReturnedEntity(from.getModel(), returnType);
            } else {
                try {
                    Class javaResultType = selection.getJavaType();
                    if (javaResultType == null) {
                        returnTypeCorrect = true;
                    } else {
                        TypeElement typeElement = this.context.getTypeElementForFullyQualifiedName(javaResultType.getName());
                        Types types = this.context.getTypeUtils();
                        returnTypeCorrect = types.isAssignable(returnType, types.erasure(typeElement.asType()));
                    }
                }
                catch (Exception e) {
                    returnTypeCorrect = true;
                }
            }
            if (!returnTypeCorrect) {
                this.message(method, mirror, value, "return type of query did not match return type '" + String.valueOf(returnType) + "' of method", Diagnostic.Kind.ERROR);
            }
        }
    }

    private void validateSql(final ExecutableElement method, final AnnotationMirror mirror, String sql, final List<String> paramNames, final AnnotationValue value) {
        ParameterParser.parse((String)sql, (ParameterRecognizer)new ParameterRecognizer(){
            int ordinalCount = 0;

            public void ordinalParameter(int sourcePosition) {
                ++this.ordinalCount;
                if (this.ordinalCount > paramNames.size()) {
                    AnnotationMetaEntity.this.message(method, mirror, value, "missing method parameter for query parameter " + this.ordinalCount + " (add a parameter to '" + String.valueOf(method.getSimpleName()) + "')", Diagnostic.Kind.ERROR);
                }
            }

            public void namedParameter(String name, int sourcePosition) {
                if (!paramNames.contains(name)) {
                    AnnotationMetaEntity.this.message(method, mirror, value, "missing method parameter for query parameter :" + name + " (add a parameter '" + name + "' to '" + String.valueOf(method.getSimpleName()) + "')", Diagnostic.Kind.ERROR);
                }
            }

            public void jpaPositionalParameter(int label, int sourcePosition) {
                if (label > paramNames.size()) {
                    AnnotationMetaEntity.this.message(method, mirror, value, "missing method parameter for query parameter ?" + label + " (add a parameter to '" + String.valueOf(method.getSimpleName()) + "')", Diagnostic.Kind.ERROR);
                }
            }

            public void other(char character) {
            }
        });
    }

    private static boolean checkConstructorReturn(DeclaredType returnType, JpaSelection<?> selection) {
        List selectionItems = selection.getSelectionItems();
        if (selectionItems == null) {
            return true;
        }
        TypeElement typeElement = (TypeElement)returnType.asElement();
        Name qualifiedName = typeElement.getQualifiedName();
        if (qualifiedName.contentEquals("jakarta.persistence.Tuple") || qualifiedName.contentEquals("java.util.List") || qualifiedName.contentEquals("java.util.Map")) {
            return true;
        }
        for (Element element : typeElement.getEnclosedElements()) {
            ExecutableElement constructor;
            if (element.getKind() != ElementKind.CONSTRUCTOR || !AnnotationMetaEntity.constructorMatches(selectionItems, (constructor = (ExecutableElement)element).getParameters())) continue;
            return true;
        }
        return false;
    }

    private static boolean constructorMatches(List<? extends JpaSelection<?>> selectionItems, List<? extends VariableElement> parameters) {
        int itemCount = selectionItems.size();
        if (parameters.size() == itemCount) {
            for (int i = 0; i < itemCount; ++i) {
                JpaSelection<?> item = selectionItems.get(i);
                if (item == null || item.getJavaType() == null || AnnotationMetaEntity.parameterMatches(parameters.get(i), item)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean parameterMatches(VariableElement parameter, JpaSelection<?> item) {
        Class javaType = item.getJavaType();
        return javaType != null && AnnotationMetaEntity.parameterMatches(parameter.asType(), javaType, item.getJavaTypeName());
    }

    private static boolean parameterMatches(TypeMirror parameterType, Class<?> itemType, String itemTypeName) {
        TypeKind kind = parameterType.getKind();
        if (kind == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)parameterType;
            TypeElement paramTypeElement = (TypeElement)declaredType.asElement();
            return paramTypeElement.getQualifiedName().contentEquals(itemTypeName);
        }
        if (kind.isPrimitive()) {
            return TypeUtils.primitiveClassMatchesKind(itemType, kind);
        }
        if (kind == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)parameterType;
            return itemType.isArray() && AnnotationMetaEntity.parameterMatches(arrayType.getComponentType(), itemType.getComponentType(), itemType.getComponentType().getTypeName());
        }
        return false;
    }

    private static boolean checkReturnedArrayType(ArrayType returnType) {
        TypeMirror componentType = returnType.getComponentType();
        if (componentType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)componentType;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            return typeElement.getQualifiedName().contentEquals("java.lang.Object");
        }
        return false;
    }

    private boolean checkReturnedEntity(EntityDomainType<?> model, TypeMirror returnType) {
        if (returnType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)returnType;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            return typeElement.getQualifiedName().contentEquals(model.getHibernateEntityName());
        }
        return false;
    }

    private void checkParameter(SqmParameter<?> param, List<String> paramNames, List<String> paramTypes, ExecutableElement method, AnnotationMirror mirror, AnnotationValue value) {
        String queryParamType;
        SqmBindableType expressible = param.getExpressible();
        String string = queryParamType = expressible == null ? null : expressible.getTypeName();
        if (queryParamType != null && !"unknown".equals(queryParamType)) {
            if (param.getName() != null) {
                this.checkNamedParameter(param, paramNames, paramTypes, method, mirror, value, queryParamType);
            } else if (param.getPosition() != null) {
                this.checkOrdinalParameter(param, paramNames, paramTypes, method, mirror, value, queryParamType);
            }
        }
    }

    private void checkOrdinalParameter(SqmParameter<?> param, List<String> paramNames, List<String> paramTypes, ExecutableElement method, AnnotationMirror mirror, AnnotationValue value, String queryParamType) {
        int position = param.getPosition();
        if (position > paramNames.size()) {
            this.message(method, mirror, value, "missing method parameter for query parameter ?" + position + " (add a parameter of type '" + queryParamType + "' to '" + String.valueOf(method.getSimpleName()) + "')", Diagnostic.Kind.ERROR);
        } else {
            String argType = paramTypes.get(position - 1);
            if (!AnnotationMetaEntity.isLegalAssignment(param, argType, queryParamType)) {
                this.message(method, mirror, value, "parameter matching query parameter ?" + position + " has the wrong type (change the method parameter type to '" + queryParamType + "')", Diagnostic.Kind.ERROR);
            }
        }
    }

    private static String stripTypeAnnotations(String argType) {
        while (argType.startsWith("@")) {
            int index = argType.indexOf(32);
            if (index <= 0) continue;
            argType = argType.substring(index + 1);
        }
        return argType;
    }

    private void checkNamedParameter(SqmParameter<?> param, List<String> paramNames, List<String> paramTypes, ExecutableElement method, AnnotationMirror mirror, AnnotationValue value, String queryParamType) {
        String name = param.getName();
        int index = paramNames.indexOf(name);
        if (index < 0) {
            this.message(method, mirror, value, "missing method parameter for query parameter :" + name + " (add a parameter '" + queryParamType + " " + name + "' to '" + String.valueOf(method.getSimpleName()) + "')", Diagnostic.Kind.ERROR);
        } else {
            String argType = paramTypes.get(index);
            if (!AnnotationMetaEntity.isLegalAssignment(param, argType, queryParamType)) {
                this.message(method, mirror, value, "parameter matching query parameter :" + name + " has the wrong type (change the method parameter type to '" + queryParamType + "')", Diagnostic.Kind.ERROR);
            }
        }
    }

    private static boolean isLegalAssignment(SqmParameter<?> param, String argumentType, String queryParamType) {
        String argType = AnnotationMetaEntity.stripTypeAnnotations(argumentType);
        return param.allowMultiValuedBinding() ? AnnotationMetaEntity.isLegalAssignment(argType, "java.util.List<" + queryParamType + ">") || AnnotationMetaEntity.isLegalAssignment(argType, "java.util.Set<" + queryParamType + ">") || AnnotationMetaEntity.isLegalAssignment(argType, "java.util.Collection<" + queryParamType + ">") : AnnotationMetaEntity.isLegalAssignment(argType, queryParamType);
    }

    private static boolean isLegalAssignment(String argType, String paramType) {
        return paramType.equals(argType) || paramType.equals(AnnotationMetaEntity.fromPrimitive(argType));
    }

    private static @Nullable String fromPrimitive(String argType) {
        return switch (argType) {
            case "boolean" -> Boolean.class.getName();
            case "char" -> Character.class.getName();
            case "int" -> Integer.class.getName();
            case "long" -> Long.class.getName();
            case "short" -> Short.class.getName();
            case "byte" -> Byte.class.getName();
            case "float" -> Float.class.getName();
            case "double" -> Double.class.getName();
            default -> null;
        };
    }

    private List<Boolean> parameterNullability(ExecutableElement method, TypeElement entity) {
        return method.getParameters().stream().map(param -> this.finderParameterNullable(entity, (VariableElement)param)).collect(Collectors.toList());
    }

    private List<String> parameterTypes(ExecutableElement method) {
        return method.getParameters().stream().map(param -> this.typeAsString(this.parameterType((VariableElement)param))).collect(Collectors.toList());
    }

    private String typeAsString(TypeMirror type) {
        return this.typeAsString(type, true);
    }

    private String typeAsString(TypeMirror type, boolean includeAnnotations) {
        DeclaredType dt;
        Element element;
        if (type instanceof DeclaredType && (element = (dt = (DeclaredType)type).asElement()) instanceof TypeElement) {
            TypeElement te = (TypeElement)element;
            StringBuilder result = new StringBuilder();
            if (includeAnnotations) {
                for (AnnotationMirror annotationMirror : type.getAnnotationMirrors()) {
                    result.append(annotationMirror.toString()).append(' ');
                }
            }
            result.append(te.getQualifiedName().toString());
            if (!dt.getTypeArguments().isEmpty()) {
                int index;
                result.append("<");
                for (index = 0; index < dt.getTypeArguments().size() - 1; ++index) {
                    result.append(this.typeAsString(dt.getTypeArguments().get(index), true)).append(", ");
                }
                result.append(this.typeAsString(dt.getTypeArguments().get(index), true));
                result.append(">");
            }
            return result.toString();
        }
        return type.toString();
    }

    private TypeMirror parameterType(VariableElement parameter) {
        ExecutableElement method = (ExecutableElement)parameter.getEnclosingElement();
        TypeMirror type = this.memberMethodType(method).getParameterTypes().get(method.getParameters().indexOf(parameter));
        switch (type.getKind()) {
            case TYPEVAR: {
                TypeVariable typeVariable = (TypeVariable)type;
                return this.context.getTypeUtils().erasure(typeVariable);
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)type;
                return declaredType.getTypeArguments().stream().anyMatch(arg -> arg.getKind() == TypeKind.TYPEVAR) ? this.context.getTypeUtils().erasure(type) : type;
            }
        }
        return type;
    }

    private ExecutableType memberMethodType(ExecutableElement method) {
        return (ExecutableType)this.context.getTypeUtils().asMemberOf((DeclaredType)this.element.asType(), method);
    }

    private static List<Boolean> parameterPatterns(ExecutableElement method) {
        return method.getParameters().stream().map(param -> TypeUtils.hasAnnotation((Element)param, "org.hibernate.annotations.processing.Pattern")).toList();
    }

    private List<String> parameterNames(ExecutableElement method, TypeElement entity) {
        String idName = TypeUtils.hasAnnotation((Element)entity, "jakarta.persistence.IdClass") ? "{id}" : entity.getEnclosedElements().stream().filter(member -> TypeUtils.hasAnnotation(member, "jakarta.persistence.Id")).map(TypeUtils::propertyName).findFirst().orElse("{id}");
        return method.getParameters().stream().map(AnnotationMetaEntity::parameterName).map(name -> AnnotationMetaEntity.isIdRef(name) ? idName : name).toList();
    }

    private static List<String> parameterNames(ExecutableElement method) {
        return method.getParameters().stream().map(AnnotationMetaEntity::parameterName).toList();
    }

    private static String parameterName(VariableElement parameter) {
        AnnotationMirror by = TypeUtils.getAnnotationMirror(parameter, "jakarta.data.repository.By");
        AnnotationMirror param = TypeUtils.getAnnotationMirror(parameter, "jakarta.data.repository.Param");
        if (by != null) {
            String name = NullnessUtil.castNonNull(TypeUtils.getAnnotationValue(by)).getValue().toString();
            if (name.contains("<error>")) {
                throw new ProcessLaterException();
            }
            return name.replace('$', '.').replace('_', '.');
        }
        if (param != null) {
            String name = NullnessUtil.castNonNull(TypeUtils.getAnnotationValue(param)).getValue().toString();
            if (name.contains("<error>")) {
                throw new ProcessLaterException();
            }
            return name;
        }
        return parameter.getSimpleName().toString().replace('$', '.').replace('_', '.');
    }

    private static boolean isNullable(Element member) {
        switch (member.getKind()) {
            case METHOD: {
                ExecutableElement method = (ExecutableElement)member;
                if (method.getReturnType().getKind().isPrimitive()) {
                    return false;
                }
            }
            case FIELD: 
            case PARAMETER: {
                if (!member.asType().getKind().isPrimitive()) break;
                return false;
            }
        }
        for (AnnotationMirror annotationMirror : member.getAnnotationMirrors()) {
            AnnotationValue optional;
            TypeElement annotationType = (TypeElement)annotationMirror.getAnnotationType().asElement();
            Name name = annotationType.getQualifiedName();
            if (name.contentEquals("jakarta.persistence.Id") || name.contentEquals("jakarta.validation.constraints.NotNull") || name.contentEquals("jakarta.annotation.Nonnull")) {
                return false;
            }
            if (!name.contentEquals("jakarta.persistence.Basic") && !name.contentEquals("jakarta.persistence.ManyToOne") && !name.contentEquals("jakarta.persistence.OneToOne") || (optional = TypeUtils.getAnnotationValue(annotationMirror, "optional")) == null || !optional.getValue().equals(Boolean.FALSE)) continue;
            return false;
        }
        return true;
    }

    private void checkParameters(ExecutableElement method, @Nullable TypeMirror returnType, List<String> paramNames, List<String> paramTypes, AnnotationMirror mirror, AnnotationValue value, String hql) {
        for (int i = 1; i <= paramNames.size(); ++i) {
            String type;
            String string = paramNames.get(i - 1);
            if (!AnnotationMetaEntity.parameterIsMissing(hql, i, string, type = paramTypes.get(i - 1))) continue;
            this.message(method, mirror, value, "missing query parameter for '" + string + "' (no parameter named :" + string + " or ?" + i + ")", Diagnostic.Kind.ERROR);
        }
        if (returnType != null) {
            for (VariableElement variableElement : method.getParameters()) {
                this.checkFinderParameter(this.explicitEntityType(returnType), variableElement);
            }
        }
    }

    private @Nullable TypeElement explicitEntityType(@Nullable TypeMirror resultType) {
        DeclaredType declaredType;
        Element typeElement;
        if (resultType != null && resultType.getKind() == TypeKind.DECLARED && TypeUtils.hasAnnotation(typeElement = (declaredType = (DeclaredType)resultType).asElement(), "jakarta.persistence.Entity")) {
            return (TypeElement)typeElement;
        }
        return null;
    }

    private static boolean typeNameEquals(TypeMirror parameterType, String typeName) {
        if (parameterType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)parameterType;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            return typeElement.getQualifiedName().contentEquals(typeName);
        }
        return false;
    }

    private static boolean typeNameEqualsArray(TypeMirror parameterType, String typeName) {
        if (parameterType.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)parameterType;
            return AnnotationMetaEntity.typeNameEquals(arrayType.getComponentType(), typeName);
        }
        return false;
    }

    private static String typeName(TypeMirror parameterType) {
        if (parameterType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)parameterType;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            return typeElement.getQualifiedName().toString();
        }
        return parameterType.toString();
    }

    private static boolean parameterIsMissing(String hql, int i, String param, String type) {
        return !AnnotationMetaEntity.hasParameter(hql, i, param) && !AbstractQueryMethod.isSpecialParam(type);
    }

    private static boolean hasParameter(String hql, int i, String param) {
        return Pattern.compile(".*(:" + param + "|\\?" + i + ")\\b.*", 32).matcher(hql).matches();
    }

    private static boolean usingReactiveSession(String sessionType) {
        return "org.hibernate.reactive.mutiny.Mutiny.Session".equals(sessionType) || "org.hibernate.reactive.mutiny.Mutiny.StatelessSession".equals(sessionType) || "io.smallrye.mutiny.Uni<org.hibernate.reactive.mutiny.Mutiny.Session>".equals(sessionType) || "io.smallrye.mutiny.Uni<org.hibernate.reactive.mutiny.Mutiny.StatelessSession>".equals(sessionType);
    }

    private static boolean usingStatelessSession(String sessionType) {
        return "org.hibernate.StatelessSession".equals(sessionType) || "org.hibernate.reactive.mutiny.Mutiny.StatelessSession".equals(sessionType) || "io.smallrye.mutiny.Uni<org.hibernate.reactive.mutiny.Mutiny.StatelessSession>".equals(sessionType) || "org.springframework.beans.factory.ObjectProvider<org.hibernate.StatelessSession>".equals(sessionType);
    }

    private static boolean usingReactiveSessionAccess(String sessionType) {
        return "io.smallrye.mutiny.Uni<org.hibernate.reactive.mutiny.Mutiny.Session>".equals(sessionType) || "io.smallrye.mutiny.Uni<org.hibernate.reactive.mutiny.Mutiny.StatelessSession>".equals(sessionType);
    }

    private boolean isLocal(Element methodOrParam) {
        return switch (methodOrParam.getKind()) {
            case ElementKind.PARAMETER -> this.element.getEnclosedElements().contains(methodOrParam.getEnclosingElement());
            case ElementKind.METHOD, ElementKind.FIELD -> this.element.getEnclosedElements().contains(methodOrParam);
            default -> true;
        };
    }

    public void message(Element method, String message, Diagnostic.Kind severity) {
        if (this.isLocal(method)) {
            this.context.message(method, message, severity);
        } else {
            this.context.message(this.element, AnnotationMetaEntity.messageWithLocation(method, message), severity);
        }
    }

    public void message(Element method, AnnotationMirror mirror, String message, Diagnostic.Kind severity) {
        if (this.isLocal(method)) {
            this.context.message(method, mirror, message, severity);
        } else {
            this.context.message(this.element, AnnotationMetaEntity.messageWithLocation(method, message), severity);
        }
    }

    public void message(Element method, AnnotationMirror mirror, AnnotationValue value, String message, Diagnostic.Kind severity) {
        if (this.isLocal(method)) {
            this.context.message(method, mirror, value, message, severity);
        } else {
            this.context.message(this.element, AnnotationMetaEntity.messageWithLocation(method, message), severity);
        }
    }

    private static String messageWithLocation(Element element, String message) {
        return element.getKind() == ElementKind.PARAMETER ? message + " for parameter '" + String.valueOf(element.getSimpleName()) + "' of inherited member '" + String.valueOf(element.getEnclosingElement().getSimpleName()) + "'" : message + " for inherited member '" + String.valueOf(element.getSimpleName()) + "'";
    }

    @Override
    public List<AnnotationMirror> inheritedAnnotations() {
        if (this.jakartaDataRepository) {
            return this.element.getAnnotationMirrors().stream().filter(annotationMirror -> TypeUtils.hasAnnotation(annotationMirror.getAnnotationType().asElement(), "jakarta.interceptor.InterceptorBinding")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public String javadoc() {
        if (this.jakartaDataRepository) {
            return "/**\n * Implements Jakarta Data repository {@link " + this.qualifiedName + "}\n **/";
        }
        if (this.repository) {
            return "/**\n * Implements repository {@link " + this.qualifiedName + "}\n **/";
        }
        if (this.jakartaDataStaticModel) {
            return "/**\n * Jakarta Data static metamodel for {@link " + this.qualifiedName + "}\n **/";
        }
        return "/**\n * Static metamodel for {@link " + this.qualifiedName + "}\n **/";
    }

    static enum FieldType {
        ID,
        NATURAL_ID,
        BASIC,
        MULTIVALUED;

    }
}

