/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.List;
import java.util.StringTokenizer;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.processor.annotation.AbstractFinderMethod;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.annotation.OrderBy;
import org.hibernate.processor.util.TypeUtils;

public abstract class AbstractCriteriaMethod
extends AbstractFinderMethod {
    private final List<Boolean> multivalued;
    private final List<Boolean> paramPatterns;

    public AbstractCriteriaMethod(AnnotationMetaEntity annotationMetaEntity, ExecutableElement method, String methodName, String entity, @Nullable String containerType, boolean belongsToDao, String sessionType, String sessionName, List<String> fetchProfiles, List<String> paramNames, List<String> paramTypes, List<OrderBy> orderBys, boolean addNonnullAnnotation, boolean convertToDataExceptions, List<Boolean> multivalued, List<Boolean> paramPatterns, String fullReturnType, boolean nullable) {
        super(annotationMetaEntity, method, methodName, entity, containerType, belongsToDao, sessionType, sessionName, fetchProfiles, paramNames, paramTypes, orderBys, addNonnullAnnotation, convertToDataExceptions, fullReturnType, nullable);
        this.multivalued = multivalued;
        this.paramPatterns = paramPatterns;
    }

    @Override
    public String getAttributeDeclarationString() {
        List<String> paramTypes = this.parameterTypes();
        StringBuilder declaration = new StringBuilder();
        this.comment(declaration);
        this.modifiers(declaration);
        this.preamble(declaration, paramTypes);
        this.chainSession(declaration);
        this.nullChecks(declaration, paramTypes);
        this.createBuilder(declaration);
        this.createCriteriaQuery(declaration);
        this.where(declaration, paramTypes);
        this.executeQuery(declaration, paramTypes);
        this.convertExceptions(declaration);
        this.chainSessionEnd(false, declaration);
        AbstractCriteriaMethod.closingBrace(declaration);
        return declaration.toString();
    }

    abstract void executeQuery(StringBuilder var1, List<String> var2);

    abstract String createCriteriaMethod();

    abstract String createQueryMethod();

    String specificationType() {
        return "org.hibernate.query.specification.SelectionSpecification";
    }

    @Override
    void createQuery(StringBuilder declaration, boolean declareVariable) {
        boolean specification;
        if (declareVariable) {
            if (this.dataRepository && !this.isReactive()) {
                declaration.append('\t');
            }
            declaration.append('\t');
            declaration.append("var _select = ");
        }
        if ((specification = this.isUsingSpecification()) && !this.isReactive()) {
            declaration.append("_spec.createQuery(").append(this.localSessionName()).append(this.getObjectCall()).append(")");
        } else {
            declaration.append(this.localSessionName()).append(this.getObjectCall()).append(".").append(this.createQueryMethod()).append('(');
            if (specification) {
                declaration.append("_spec.buildCriteria(_builder)");
            } else {
                declaration.append("_query");
            }
            declaration.append(")");
        }
    }

    @Override
    void createSpecification(StringBuilder declaration) {
        if (this.isUsingSpecification()) {
            declaration.append("\tvar _spec = ").append(this.annotationMetaEntity.importType(this.specificationType())).append(".create(_query);\n");
        }
    }

    @Override
    boolean isUsingSpecification() {
        return this.hasRestriction() || this.hasOrder() && !AbstractCriteriaMethod.isJakartaCursoredPage(this.containerType);
    }

    void createCriteriaQuery(StringBuilder declaration) {
        String entityClass = this.annotationMetaEntity.importType(this.entity);
        declaration.append("\tvar _query = _builder.").append(this.createCriteriaMethod()).append('(').append(entityClass).append(".class);\n").append("\tvar _entity = _query.from(").append(entityClass).append(".class);\n");
    }

    private void createBuilder(StringBuilder declaration) {
        declaration.append("\tvar _builder = ").append(this.localSessionName()).append(this.getObjectCall()).append(".getCriteriaBuilder();\n");
    }

    void nullChecks(StringBuilder declaration, List<String> paramTypes) {
        for (int i = 0; i < this.paramNames.size(); ++i) {
            if (!this.isNonNull(i, paramTypes)) continue;
            this.nullCheck(declaration, (String)this.paramNames.get(i));
        }
    }

    void where(StringBuilder declaration, List<String> paramTypes) {
        declaration.append("\t_query.where(");
        boolean first = true;
        for (int i = 0; i < this.paramNames.size(); ++i) {
            String paramName = (String)this.paramNames.get(i);
            String paramType = paramTypes.get(i);
            if (AbstractCriteriaMethod.isSpecialParam(paramType)) continue;
            if (first) {
                first = false;
            } else {
                declaration.append(", ");
            }
            this.condition(declaration, i, paramName, paramType);
        }
        declaration.append("\n\t);");
    }

    private void condition(StringBuilder declaration, int i, String paramName, String paramType) {
        declaration.append("\n\t\t\t");
        String parameterName = AbstractCriteriaMethod.parameterName(paramName);
        if (this.isNullable(i) && !TypeUtils.isPrimitive(paramType)) {
            declaration.append(parameterName).append("==null").append("\n\t\t\t\t? ").append("_entity");
            this.path(declaration, paramName);
            declaration.append(".isNull()").append("\n\t\t\t\t: ");
        }
        if (this.multivalued.get(i).booleanValue()) {
            declaration.append("_entity");
            this.path(declaration, paramName);
            declaration.append(".in(");
            if (paramType.endsWith("[]")) {
                declaration.append("(Object[]) ");
            }
            declaration.append(parameterName).append(")");
        } else {
            declaration.append("_builder.").append(this.paramPatterns.get(i) != false ? "like" : "equal").append("(_entity");
            this.path(declaration, paramName);
            declaration.append(", ").append(parameterName).append(')');
        }
    }

    private void path(StringBuilder declaration, String paramName) {
        StringTokenizer tokens = new StringTokenizer(paramName, ".");
        String typeName = this.entity;
        while (typeName != null && tokens.hasMoreTokens()) {
            TypeElement typeElement = this.annotationMetaEntity.getContext().getElementUtils().getTypeElement(typeName);
            String memberName = tokens.nextToken();
            declaration.append(".get(");
            if ("{id}".equals(memberName)) {
                declaration.append('\"').append(memberName).append('\"');
            } else {
                declaration.append(this.annotationMetaEntity.importType(TypeUtils.getGeneratedClassFullyQualifiedName(typeElement, false))).append('.').append(memberName);
            }
            declaration.append(')');
            typeName = this.annotationMetaEntity.getMemberType(typeName, memberName);
        }
    }
}

