/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.util;

import java.io.Serializable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.processor.Context;
import org.hibernate.processor.util.Constants;
import org.hibernate.processor.util.TypeUtils;

class BasicAttributeVisitor
extends SimpleTypeVisitor8<Boolean, Element> {
    private final Context context;

    public BasicAttributeVisitor(Context context) {
        super(false);
        this.context = context;
    }

    @Override
    public Boolean visitPrimitive(PrimitiveType primitiveType, Element element) {
        return true;
    }

    @Override
    public Boolean visitArray(ArrayType arrayType, Element element) {
        TypeElement componentElement = (TypeElement)this.context.getTypeUtils().asElement(arrayType.getComponentType());
        return Constants.BASIC_ARRAY_TYPES.contains(((TypeElement)NullnessUtil.castNonNull((Object)componentElement)).getQualifiedName().toString());
    }

    @Override
    public Boolean visitDeclared(DeclaredType declaredType, Element element) {
        ElementKind kind = element.getKind();
        if (kind == ElementKind.ENUM) {
            return true;
        }
        if (TypeUtils.isClassOrRecordType(element) || kind == ElementKind.INTERFACE) {
            TypeElement typeElement = (TypeElement)element;
            return Constants.BASIC_TYPES.contains(typeElement.getQualifiedName().toString()) || TypeUtils.hasAnnotation(element, "jakarta.persistence.Embeddable") || this.isSerializable(typeElement);
        }
        return false;
    }

    private boolean isSerializable(TypeElement typeElement) {
        TypeMirror serializableType = this.context.getElementUtils().getTypeElement(Serializable.class.getName()).asType();
        return this.context.getTypeUtils().isSubtype(typeElement.asType(), serializableType);
    }
}

