/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.List;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;

public class IdClassMetaAttribute
implements MetaAttribute {
    private final Metamodel parent;
    private final List<MetaAttribute> components;

    public IdClassMetaAttribute(Metamodel parent, List<MetaAttribute> components) {
        this.parent = parent;
        this.components = components;
    }

    @Override
    public boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public boolean hasStringAttribute() {
        return false;
    }

    @Override
    public String getAttributeDeclarationString() {
        StringBuilder decl = new StringBuilder().append("\n/**\n * Static ID class for {@link ").append(this.parent.getQualifiedName()).append("}\n **/\n").append("public record Id");
        String delimiter = "(";
        for (MetaAttribute component : this.components) {
            decl.append(delimiter).append(this.parent.importType(component.getTypeDeclaration())).append(' ').append(component.getPropertyName());
            delimiter = ", ";
        }
        return decl.append(") {}").toString();
    }

    @Override
    public String getAttributeNameDeclarationString() {
        return "";
    }

    @Override
    public String getMetaType() {
        return "";
    }

    @Override
    public String getPropertyName() {
        return "";
    }

    @Override
    public String getTypeDeclaration() {
        return "";
    }

    @Override
    public Metamodel getHostingEntity() {
        return this.parent;
    }
}

