/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.validation;

import java.util.Map;
import org.hibernate.annotations.processing.GenericDialect;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.internal.QualifiedObjectNameFormatterStandardImpl;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.jdbc.env.spi.QualifiedObjectNameFormatter;
import org.hibernate.engine.jdbc.internal.JdbcServicesInitiator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.processor.validation.Mocker;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;

class MockJdbcServicesInitiator
extends JdbcServicesInitiator {
    static final JdbcServicesInitiator INSTANCE = new MockJdbcServicesInitiator();
    static final JdbcServices jdbcServices = Mocker.nullary(MockJdbcServices.class).get();
    static final GenericDialect genericDialect = new GenericDialect();

    MockJdbcServicesInitiator() {
    }

    public JdbcServices initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        return jdbcServices;
    }

    public static abstract class MockJdbcServices
    implements JdbcServices,
    JdbcEnvironment {
        public Dialect getDialect() {
            return genericDialect;
        }

        public JdbcEnvironment getJdbcEnvironment() {
            return this;
        }

        public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
            return new StandardSqlAstTranslatorFactory();
        }

        public Identifier getCurrentCatalog() {
            return null;
        }

        public Identifier getCurrentSchema() {
            return null;
        }

        public QualifiedObjectNameFormatter getQualifiedObjectNameFormatter() {
            return new QualifiedObjectNameFormatterStandardImpl(this.getNameQualifierSupport(), ".");
        }

        public NameQualifierSupport getNameQualifierSupport() {
            return genericDialect.getNameQualifierSupport();
        }
    }
}

