/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.xml;

import jakarta.persistence.AccessType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAttributesContainerImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbBasicImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbElementCollectionImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddableAttributesContainerImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddedIdImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddedImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbIdImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbManyToManyImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbManyToOneImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbMapKeyClassImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbMappedSuperclassImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbOneToManyImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbOneToOneImpl;
import org.hibernate.processor.Context;
import org.hibernate.processor.ImportContextImpl;
import org.hibernate.processor.MetaModelGenerationException;
import org.hibernate.processor.model.ImportContext;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.AccessTypeInformation;
import org.hibernate.processor.util.Constants;
import org.hibernate.processor.util.NullnessUtil;
import org.hibernate.processor.util.StringUtil;
import org.hibernate.processor.util.TypeUtils;
import org.hibernate.processor.xml.XmlMetaCollection;
import org.hibernate.processor.xml.XmlMetaMap;
import org.hibernate.processor.xml.XmlMetaSingleAttribute;

public class XmlMetaEntity
implements Metamodel {
    private final String clazzName;
    private final String packageName;
    private final String defaultPackageName;
    private final ImportContext importContext;
    private final List<MetaAttribute> members = new ArrayList<MetaAttribute>();
    private final TypeElement element;
    private final Context context;
    private final boolean isMetaComplete;
    private @Nullable JaxbAttributesContainerImpl attributes;
    private @Nullable JaxbEmbeddableAttributesContainerImpl embeddableAttributes;
    private AccessTypeInformation accessTypeInfo;
    private boolean initialized;

    XmlMetaEntity(JaxbEntityImpl ormEntity, String defaultPackageName, TypeElement element, Context context) {
        this(ormEntity.getClazz(), defaultPackageName, element, context, ormEntity.isMetadataComplete());
        this.attributes = ormEntity.getAttributes();
        this.embeddableAttributes = null;
    }

    static XmlMetaEntity create(JaxbEntityImpl ormEntity, String defaultPackageName, TypeElement element, Context context) {
        XmlMetaEntity entity = new XmlMetaEntity(ormEntity, defaultPackageName, element, context);
        entity.init();
        return entity;
    }

    XmlMetaEntity(JaxbMappedSuperclassImpl mappedSuperclass, String defaultPackageName, TypeElement element, Context context) {
        this(mappedSuperclass.getClazz(), defaultPackageName, element, context, mappedSuperclass.isMetadataComplete());
        this.attributes = mappedSuperclass.getAttributes();
        this.embeddableAttributes = null;
    }

    XmlMetaEntity(JaxbEmbeddableImpl embeddable, String defaultPackageName, TypeElement element, Context context) {
        this(embeddable.getClazz(), defaultPackageName, element, context, embeddable.isMetadataComplete());
        this.attributes = null;
        this.embeddableAttributes = embeddable.getAttributes();
    }

    private XmlMetaEntity(String clazz, String defaultPackageName, TypeElement element, Context context, Boolean metaComplete) {
        this.defaultPackageName = defaultPackageName;
        String className = clazz;
        String pkg = defaultPackageName;
        if (StringUtil.isFullyQualified(className)) {
            pkg = StringUtil.packageNameFromFullyQualifiedName(className);
            className = StringUtil.classNameFromFullyQualifiedName(clazz);
        }
        this.clazzName = className;
        this.packageName = pkg;
        this.context = context;
        this.importContext = new ImportContextImpl(pkg);
        this.element = element;
        this.isMetaComplete = XmlMetaEntity.initIsMetaComplete(context, metaComplete);
    }

    private void init() {
        this.context.logMessage(Diagnostic.Kind.OTHER, "Initializing type " + this.getQualifiedName() + ".");
        this.accessTypeInfo = NullnessUtil.castNonNull(this.context.getAccessTypeInfo(this.getQualifiedName()));
        if (this.attributes != null) {
            this.parseAttributes(this.attributes);
        } else {
            this.parseEmbeddableAttributes(this.embeddableAttributes);
        }
        this.initialized = true;
    }

    @Override
    public String getSimpleName() {
        return this.clazzName;
    }

    @Override
    public String getQualifiedName() {
        return this.packageName + "." + this.getSimpleName();
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public @Nullable Element getSuperTypeElement() {
        return TypeUtils.findMappedSuperElement(this, this.context);
    }

    @Override
    public List<MetaAttribute> getMembers() {
        if (!this.initialized) {
            this.init();
        }
        return this.members;
    }

    @Override
    public String generateImports() {
        return this.importContext.generateImports();
    }

    @Override
    public String importType(String fqcn) {
        return this.importContext.importType(fqcn);
    }

    @Override
    public String staticImport(String fqcn, String member) {
        return this.importContext.staticImport(fqcn, member);
    }

    @Override
    public TypeElement getElement() {
        return this.element;
    }

    @Override
    public boolean isMetaComplete() {
        return this.isMetaComplete;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XmlMetaEntity");
        sb.append("{accessTypeInfo=").append(this.accessTypeInfo);
        sb.append(", clazzName='").append(this.clazzName).append('\'');
        sb.append(", members=").append(this.members);
        sb.append(", isMetaComplete=").append(this.isMetaComplete);
        sb.append('}');
        return sb.toString();
    }

    private static boolean initIsMetaComplete(Context context, Boolean metadataComplete) {
        return context.isFullyXmlConfigured() || Boolean.TRUE.equals(metadataComplete);
    }

    private @Nullable String @Nullable [] getCollectionTypes(String propertyName, String explicitTargetEntity, @Nullable String explicitMapKeyClass, ElementKind expectedElementKind) {
        for (Element element : this.element.getEnclosedElements()) {
            DeclaredType type;
            if (!expectedElementKind.equals((Object)element.getKind())) continue;
            String elementPropertyName = element.getSimpleName().toString();
            if (element.getKind().equals((Object)ElementKind.METHOD)) {
                elementPropertyName = StringUtil.getPropertyName(elementPropertyName);
            }
            if (!propertyName.equals(elementPropertyName) || (type = this.determineDeclaredType(element)) == null) continue;
            return this.determineTypes(propertyName, explicitTargetEntity, explicitMapKeyClass, type);
        }
        return null;
    }

    private @Nullable DeclaredType determineDeclaredType(Element elem) {
        ExecutableType executableType;
        DeclaredType type = null;
        if (elem.asType() instanceof DeclaredType) {
            type = (DeclaredType)elem.asType();
        } else if (elem.asType() instanceof ExecutableType && (executableType = (ExecutableType)elem.asType()).getReturnType() instanceof DeclaredType) {
            type = (DeclaredType)executableType.getReturnType();
        }
        return type;
    }

    private @Nullable String[] determineTypes(String propertyName, String explicitTargetEntity, @Nullable String explicitMapKeyClass, DeclaredType type) {
        @Nullable String[] types = new String[3];
        this.determineTargetType(type, propertyName, explicitTargetEntity, types);
        if (this.determineCollectionType(type, types).equals("jakarta.persistence.metamodel.MapAttribute")) {
            this.determineMapType(type, explicitMapKeyClass, types);
        }
        return types;
    }

    private void determineMapType(DeclaredType type, @Nullable String explicitMapKeyClass, @Nullable String[] types) {
        types[2] = explicitMapKeyClass != null ? explicitMapKeyClass : TypeUtils.getKeyType(type, this.context);
    }

    private String determineCollectionType(DeclaredType type, @Nullable String[] types) {
        types[1] = Constants.COLLECTIONS.get(type.asElement().toString());
        return NullnessUtil.castNonNull(types[1]);
    }

    private void determineTargetType(DeclaredType type, String propertyName, String explicitTargetEntity, @Nullable String[] types) {
        List<? extends TypeMirror> typeArguments = type.getTypeArguments();
        if (typeArguments.isEmpty() && explicitTargetEntity == null) {
            throw new MetaModelGenerationException("Unable to determine target entity type for " + this.clazzName + "." + propertyName + ".");
        }
        types[0] = explicitTargetEntity == null ? TypeUtils.extractClosestRealTypeAsString(typeArguments.get(0), this.context) : explicitTargetEntity;
    }

    private @Nullable String getType(String propertyName, @Nullable String explicitTargetEntity, ElementKind expectedElementKind) {
        for (Element element : this.element.getEnclosedElements()) {
            TypeMirror mirror;
            if (!expectedElementKind.equals((Object)element.getKind())) continue;
            String name = element.getSimpleName().toString();
            if (ElementKind.METHOD.equals((Object)element.getKind())) {
                name = StringUtil.getPropertyName(name);
                mirror = ((ExecutableElement)element).getReturnType();
            } else {
                mirror = element.asType();
            }
            if (name == null || !name.equals(propertyName)) continue;
            if (explicitTargetEntity != null) {
                return explicitTargetEntity;
            }
            switch (mirror.getKind()) {
                case INT: {
                    return "java.lang.Integer";
                }
                case LONG: {
                    return "java.lang.Long";
                }
                case BOOLEAN: {
                    return "java.lang.Boolean";
                }
                case BYTE: {
                    return "java.lang.Byte";
                }
                case SHORT: {
                    return "java.lang.Short";
                }
                case CHAR: {
                    return "java.lang.Char";
                }
                case FLOAT: {
                    return "java.lang.Float";
                }
                case DOUBLE: {
                    return "java.lang.Double";
                }
                case DECLARED: {
                    return ((DeclaredType)mirror).asElement().asType().toString();
                }
                case TYPEVAR: {
                    return mirror.toString();
                }
            }
        }
        this.context.logMessage(Diagnostic.Kind.WARNING, "Unable to determine type for property " + propertyName + " of class " + this.getQualifiedName() + " using access type " + String.valueOf(this.accessTypeInfo.getDefaultAccessType()));
        return null;
    }

    private void parseAttributes(JaxbAttributesContainerImpl attributes) {
        JaxbElementCollectionImpl collection;
        JaxbOneToManyImpl oneToMany;
        JaxbManyToManyImpl manyToMany;
        XmlMetaSingleAttribute attribute;
        for (JaxbIdImpl id : attributes.getIdAttributes()) {
            ElementKind elementKind = this.getElementKind(id.getAccess());
            String type = this.getType(id.getName(), null, elementKind);
            if (type == null) continue;
            attribute = new XmlMetaSingleAttribute(this, id.getName(), type);
            this.members.add(attribute);
        }
        if (attributes.getEmbeddedIdAttribute() != null) {
            JaxbEmbeddedIdImpl embeddedId = attributes.getEmbeddedIdAttribute();
            ElementKind elementKind = this.getElementKind(embeddedId.getAccess());
            String type = this.getType(embeddedId.getName(), null, elementKind);
            if (type != null) {
                attribute = new XmlMetaSingleAttribute(this, embeddedId.getName(), type);
                this.members.add(attribute);
            }
        }
        for (JaxbBasicImpl basic : attributes.getBasicAttributes()) {
            this.parseBasic(basic);
        }
        for (JaxbManyToOneImpl manyToOne : attributes.getManyToOneAttributes()) {
            this.parseManyToOne(manyToOne);
        }
        for (JaxbOneToOneImpl oneToOne : attributes.getOneToOneAttributes()) {
            this.parseOneToOne(oneToOne);
        }
        Iterator iterator = attributes.getManyToManyAttributes().iterator();
        while (iterator.hasNext() && !this.parseManyToMany(manyToMany = (JaxbManyToManyImpl)iterator.next())) {
        }
        iterator = attributes.getOneToManyAttributes().iterator();
        while (iterator.hasNext() && !this.parseOneToMany(oneToMany = (JaxbOneToManyImpl)iterator.next())) {
        }
        iterator = attributes.getElementCollectionAttributes().iterator();
        while (iterator.hasNext() && !this.parseElementCollection(collection = (JaxbElementCollectionImpl)iterator.next())) {
        }
        for (JaxbEmbeddedImpl embedded : attributes.getEmbeddedAttributes()) {
            this.parseEmbedded(embedded);
        }
    }

    private void parseEmbeddableAttributes(@Nullable JaxbEmbeddableAttributesContainerImpl attributes) {
        JaxbElementCollectionImpl collection;
        JaxbOneToManyImpl oneToMany;
        JaxbManyToManyImpl manyToMany;
        if (attributes == null) {
            return;
        }
        for (JaxbBasicImpl basic : attributes.getBasicAttributes()) {
            this.parseBasic(basic);
        }
        for (JaxbManyToOneImpl manyToOne : attributes.getManyToOneAttributes()) {
            this.parseManyToOne(manyToOne);
        }
        for (JaxbOneToOneImpl oneToOne : attributes.getOneToOneAttributes()) {
            this.parseOneToOne(oneToOne);
        }
        Iterator iterator = attributes.getManyToManyAttributes().iterator();
        while (iterator.hasNext() && !this.parseManyToMany(manyToMany = (JaxbManyToManyImpl)iterator.next())) {
        }
        iterator = attributes.getOneToManyAttributes().iterator();
        while (iterator.hasNext() && !this.parseOneToMany(oneToMany = (JaxbOneToManyImpl)iterator.next())) {
        }
        iterator = attributes.getElementCollectionAttributes().iterator();
        while (iterator.hasNext() && !this.parseElementCollection(collection = (JaxbElementCollectionImpl)iterator.next())) {
        }
    }

    private boolean parseElementCollection(JaxbElementCollectionImpl collection) {
        String[] types;
        ElementKind elementKind = this.getElementKind(collection.getAccess());
        String explicitTargetClass = this.determineExplicitTargetEntity(collection.getTargetClass());
        String explicitMapKey = this.determineExplicitMapKeyClass(collection.getMapKeyClass());
        try {
            types = this.getCollectionTypes(collection.getName(), explicitTargetClass, explicitMapKey, elementKind);
        }
        catch (MetaModelGenerationException e) {
            this.logMetaModelException(collection.getName(), e);
            return true;
        }
        if (types != null) {
            String type = NullnessUtil.castNonNull(types[0]);
            String collectionType = NullnessUtil.castNonNull(types[1]);
            String keyType = types[2];
            XmlMetaCollection metaCollection = keyType == null ? new XmlMetaCollection(this, collection.getName(), type, collectionType) : new XmlMetaMap(this, collection.getName(), type, collectionType, keyType);
            this.members.add(metaCollection);
        }
        return false;
    }

    private void parseEmbedded(JaxbEmbeddedImpl embedded) {
        ElementKind elementKind = this.getElementKind(embedded.getAccess());
        String type = this.getType(embedded.getName(), null, elementKind);
        if (type != null) {
            XmlMetaSingleAttribute attribute = new XmlMetaSingleAttribute(this, embedded.getName(), type);
            this.members.add(attribute);
        }
    }

    private String determineExplicitTargetEntity(String targetClass) {
        String explicitTargetClass = targetClass;
        if (explicitTargetClass != null) {
            explicitTargetClass = StringUtil.determineFullyQualifiedClassName(this.defaultPackageName, targetClass);
        }
        return explicitTargetClass;
    }

    private @Nullable String determineExplicitMapKeyClass(JaxbMapKeyClassImpl mapKeyClass) {
        String explicitMapKey = null;
        if (mapKeyClass != null) {
            explicitMapKey = StringUtil.determineFullyQualifiedClassName(this.defaultPackageName, mapKeyClass.getClazz());
        }
        return explicitMapKey;
    }

    private boolean parseOneToMany(JaxbOneToManyImpl oneToMany) {
        String[] types;
        ElementKind elementKind = this.getElementKind(oneToMany.getAccess());
        String explicitTargetClass = this.determineExplicitTargetEntity(oneToMany.getTargetEntity());
        String explicitMapKey = this.determineExplicitMapKeyClass(oneToMany.getMapKeyClass());
        try {
            types = this.getCollectionTypes(oneToMany.getName(), explicitTargetClass, explicitMapKey, elementKind);
        }
        catch (MetaModelGenerationException e) {
            this.logMetaModelException(oneToMany.getName(), e);
            return true;
        }
        if (types != null) {
            String type = NullnessUtil.castNonNull(types[0]);
            String collectionType = NullnessUtil.castNonNull(types[1]);
            String keyType = types[2];
            XmlMetaCollection metaCollection = keyType == null ? new XmlMetaCollection(this, oneToMany.getName(), type, collectionType) : new XmlMetaMap(this, oneToMany.getName(), type, collectionType, keyType);
            this.members.add(metaCollection);
        }
        return false;
    }

    private boolean parseManyToMany(JaxbManyToManyImpl manyToMany) {
        String[] types;
        ElementKind elementKind = this.getElementKind(manyToMany.getAccess());
        String explicitTargetClass = this.determineExplicitTargetEntity(manyToMany.getTargetEntity());
        String explicitMapKey = this.determineExplicitMapKeyClass(manyToMany.getMapKeyClass());
        try {
            types = this.getCollectionTypes(manyToMany.getName(), explicitTargetClass, explicitMapKey, elementKind);
        }
        catch (MetaModelGenerationException e) {
            this.logMetaModelException(manyToMany.getName(), e);
            return true;
        }
        if (types != null) {
            String type = NullnessUtil.castNonNull(types[0]);
            String collectionType = NullnessUtil.castNonNull(types[1]);
            String keyType = types[2];
            XmlMetaCollection metaCollection = keyType == null ? new XmlMetaCollection(this, manyToMany.getName(), type, collectionType) : new XmlMetaMap(this, manyToMany.getName(), type, collectionType, keyType);
            this.members.add(metaCollection);
        }
        return false;
    }

    private void parseOneToOne(JaxbOneToOneImpl oneToOne) {
        ElementKind elementKind = this.getElementKind(oneToOne.getAccess());
        String type = this.getType(oneToOne.getName(), oneToOne.getTargetEntity(), elementKind);
        if (type != null) {
            XmlMetaSingleAttribute attribute = new XmlMetaSingleAttribute(this, oneToOne.getName(), type);
            this.members.add(attribute);
        }
    }

    private void parseManyToOne(JaxbManyToOneImpl manyToOne) {
        ElementKind elementKind = this.getElementKind(manyToOne.getAccess());
        String type = this.getType(manyToOne.getName(), manyToOne.getTargetEntity(), elementKind);
        if (type != null) {
            XmlMetaSingleAttribute attribute = new XmlMetaSingleAttribute(this, manyToOne.getName(), type);
            this.members.add(attribute);
        }
    }

    private void parseBasic(JaxbBasicImpl basic) {
        ElementKind elementKind = this.getElementKind(basic.getAccess());
        String type = this.getType(basic.getName(), null, elementKind);
        if (type != null) {
            XmlMetaSingleAttribute attribute = new XmlMetaSingleAttribute(this, basic.getName(), type);
            this.members.add(attribute);
        }
    }

    private void logMetaModelException(String name, MetaModelGenerationException e) {
        StringBuilder builder = new StringBuilder();
        builder.append("Error processing xml for ");
        builder.append(this.clazzName);
        builder.append(".");
        builder.append(name);
        builder.append(". Error message: ");
        builder.append(e.getMessage());
        this.context.logMessage(Diagnostic.Kind.WARNING, builder.toString());
    }

    private ElementKind getElementKind(AccessType accessType) {
        if (accessType == null) {
            return TypeUtils.getElementKindForAccessType(this.accessTypeInfo.getAccessType());
        }
        return AccessType.FIELD.equals((Object)accessType) ? ElementKind.FIELD : ElementKind.METHOD;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public boolean isImplementation() {
        return false;
    }

    @Override
    public boolean isInjectable() {
        return false;
    }

    @Override
    public String scope() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public boolean isJakartaDataStyle() {
        return false;
    }

    @Override
    public List<AnnotationMirror> inheritedAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public String javadoc() {
        return "/**\n * Static metamodel for {@link " + this.clazzName + "}\n **/";
    }
}

