/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;

public class DefaultConstructor
implements MetaAttribute {
    private final AnnotationMetaEntity annotationMetaEntity;
    private final String constructorName;
    private final String methodName;
    private final String sessionTypeName;
    private final String sessionVariableName;
    private final @Nullable String dataStore;
    private final boolean addInjectAnnotation;

    public DefaultConstructor(AnnotationMetaEntity annotationMetaEntity, String constructorName, String methodName, String sessionTypeName, String sessionVariableName, @Nullable String dataStore, boolean addInjectAnnotation) {
        this.annotationMetaEntity = annotationMetaEntity;
        this.constructorName = constructorName;
        this.methodName = methodName;
        this.sessionTypeName = sessionTypeName;
        this.sessionVariableName = sessionVariableName;
        this.dataStore = dataStore;
        this.addInjectAnnotation = addInjectAnnotation;
    }

    private boolean isReactive() {
        return this.annotationMetaEntity.isReactive();
    }

    @Override
    public boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public boolean hasStringAttribute() {
        return false;
    }

    @Override
    public String getAttributeDeclarationString() {
        StringBuilder declaration = new StringBuilder();
        declaration.append('\n');
        if (this.annotationMetaEntity.getSuperTypeElement() == null) {
            declaration.append("@").append(this.annotationMetaEntity.importType("jakarta.persistence.PersistenceUnit"));
            if (this.dataStore != null) {
                declaration.append("(unitName=\"").append(this.dataStore).append("\")");
            }
            declaration.append("\nprivate ").append(this.annotationMetaEntity.importType("jakarta.persistence.EntityManagerFactory")).append(" ").append(this.sessionVariableName).append("Factory;\n\n");
            String sessionFactoryType = this.isReactive() ? "org.hibernate.reactive.mutiny.Mutiny.SessionFactory" : "org.hibernate.SessionFactory";
            declaration.append('@').append(this.annotationMetaEntity.importType("jakarta.annotation.PostConstruct")).append("\nprivate void openSession() {").append("\n\t").append(this.sessionVariableName).append(" = ").append(this.sessionVariableName).append("Factory.unwrap(").append(this.annotationMetaEntity.importType(sessionFactoryType)).append(".class).openStatelessSession()");
            if ("org.hibernate.reactive.mutiny.Mutiny.Session".equals(this.sessionTypeName) || "org.hibernate.reactive.mutiny.Mutiny.StatelessSession".equals(this.sessionTypeName)) {
                declaration.append(".await().indefinitely()");
            }
            declaration.append(";\n}\n\n");
            if (!this.isReactive()) {
                declaration.append('@').append(this.annotationMetaEntity.importType("jakarta.annotation.PreDestroy")).append("\nprivate void closeSession() {").append("\n\t").append(this.sessionVariableName).append(".close();").append("\n}\n\n");
            }
        }
        this.inject(declaration);
        declaration.append(this.constructorName).append("(").append(") {").append("\n}");
        return declaration.toString();
    }

    private void inject(StringBuilder declaration) {
        if (this.addInjectAnnotation) {
            declaration.append('@').append(this.annotationMetaEntity.importType("jakarta.inject.Inject")).append('\n');
        }
    }

    @Override
    public String getAttributeNameDeclarationString() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public String getMetaType() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public String getPropertyName() {
        return this.methodName;
    }

    @Override
    public String getTypeDeclaration() {
        return "jakarta.persistence.EntityManager";
    }

    @Override
    public Metamodel getHostingEntity() {
        return this.annotationMetaEntity;
    }
}

