/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import javax.lang.model.element.Element;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.StringUtil;
import org.hibernate.processor.util.TypeUtils;

public abstract class AnnotationMetaAttribute
implements MetaAttribute {
    final Element element;
    final AnnotationMetaEntity parent;
    private final String type;

    public AnnotationMetaAttribute(AnnotationMetaEntity parent, Element element, String type) {
        this.element = element;
        this.parent = parent;
        this.type = type;
    }

    @Override
    public boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public boolean hasStringAttribute() {
        return true;
    }

    @Override
    public String getAttributeDeclarationString() {
        return "\n/**\n * Static metamodel for attribute {@link " + this.parent.getQualifiedName() + '#' + this.element.getSimpleName() + "}\n **/\n" + "public static volatile " + this.parent.importType(this.getMetaType()) + '<' + this.parent.importType(this.parent.getQualifiedName()) + ", " + this.parent.importType(this.getTypeDeclaration()) + '>' + ' ' + this.getPropertyName() + ';';
    }

    @Override
    public String getAttributeNameDeclarationString() {
        return "\n/**\n * @see " + "#" + this.getPropertyName() + "\n **/\n" + "public static final " + this.parent.importType("java.lang.String") + ' ' + StringUtil.getUpperUnderscoreCaseFromLowerCamelCase(this.getPropertyName()) + " = " + '\"' + this.getPropertyName() + '\"' + ';';
    }

    @Override
    public String getPropertyName() {
        return TypeUtils.propertyName(this.element);
    }

    @Override
    public Metamodel getHostingEntity() {
        return this.parent;
    }

    @Override
    public abstract String getMetaType();

    @Override
    public String getTypeDeclaration() {
        return this.type;
    }

    public String toString() {
        return "AnnotationMetaAttribute" + "{element=" + this.element + ", type='" + this.type + '\'' + '}';
    }
}

