/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.validation;

import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.QueryException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.grammars.hql.HqlLexer;
import org.hibernate.grammars.hql.HqlParser;
import org.hibernate.processor.validation.ProcessorSessionFactory;
import org.hibernate.query.hql.internal.HqlParseTreeBuilder;
import org.hibernate.query.hql.internal.SemanticQueryBuilder;
import org.hibernate.query.hql.spi.SqmCreationOptions;
import org.hibernate.query.sqm.EntityTypeException;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.PathElementException;
import org.hibernate.query.sqm.TerminalPathException;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.type.descriptor.java.spi.JdbcTypeRecommendationException;

public class Validation {
    private static final SqmCreationOptions CREATION_OPTIONS = new SqmCreationOptions(){};

    public static @Nullable SqmStatement<?> validate(String hql, @Nullable TypeMirror returnType, boolean checkTyping, Handler handler, SessionFactoryImplementor factory) {
        return Validation.validate(hql, returnType, checkTyping, handler, factory, 0);
    }

    public static @Nullable SqmStatement<?> validate(String hql, @Nullable TypeMirror returnType, boolean checkTyping, Handler handler, SessionFactoryImplementor factory, int errorOffset) {
        try {
            HqlParser.StatementContext statementContext = Validation.parseAndCheckSyntax(hql, handler);
            if (checkTyping && handler.getErrorCount() == 0) {
                return Validation.checkTyping(hql, returnType, handler, factory, errorOffset, statementContext);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static @Nullable SqmStatement<?> checkTyping(String hql, @Nullable TypeMirror returnType, Handler handler, SessionFactoryImplementor factory, int errorOffset, HqlParser.StatementContext statementContext) {
        block3: {
            try {
                return Validation.createSemanticQueryBuilder(returnType, hql, factory).visitStatement(statementContext);
            }
            catch (JdbcTypeRecommendationException jdbcTypeRecommendationException) {
            }
            catch (PropertyNotFoundException | QueryException | EntityTypeException | PathElementException | TerminalPathException se) {
                String message = se.getMessage();
                if (message == null) break block3;
                handler.error(-errorOffset + 1, -errorOffset + hql.length(), message);
            }
        }
        return null;
    }

    private static SemanticQueryBuilder<?> createSemanticQueryBuilder(@Nullable TypeMirror returnType, String hql, SessionFactoryImplementor factory) {
        NodeBuilder context = factory.getQueryEngine().getCriteriaBuilder();
        if (returnType != null && returnType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)returnType;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            String typeName = typeElement.getQualifiedName().toString();
            String shortName = typeElement.getSimpleName().toString();
            return ProcessorSessionFactory.isEntity(typeElement) ? new SemanticQueryBuilder(typeName, shortName, ProcessorSessionFactory.getHibernateEntityName(typeElement), CREATION_OPTIONS, (SqmCreationContext)context, hql) : new SemanticQueryBuilder(typeName, shortName, Object[].class, CREATION_OPTIONS, (SqmCreationContext)context, hql);
        }
        return new SemanticQueryBuilder(Object[].class, CREATION_OPTIONS, (SqmCreationContext)context, hql);
    }

    private static HqlParser.StatementContext parseAndCheckSyntax(String hql, Handler handler) {
        HqlLexer hqlLexer = HqlParseTreeBuilder.INSTANCE.buildHqlLexer(hql);
        HqlParser hqlParser = HqlParseTreeBuilder.INSTANCE.buildHqlParser(hql, hqlLexer);
        ((ParserATNSimulator)hqlParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        hqlParser.removeErrorListeners();
        hqlParser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        try {
            return hqlParser.statement();
        }
        catch (ParseCancellationException e) {
            hqlLexer.reset();
            hqlParser.reset();
            ((ParserATNSimulator)hqlParser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            hqlParser.setErrorHandler((ANTLRErrorStrategy)new DefaultErrorStrategy());
            hqlParser.addErrorListener((ANTLRErrorListener)handler);
            return hqlParser.statement();
        }
    }

    public static interface Handler
    extends ANTLRErrorListener {
        public void error(int var1, int var2, String var3);

        public void warn(int var1, int var2, String var3);

        public int getErrorCount();
    }
}

