/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.validation;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

@FunctionalInterface
public interface Mocker<T> {
    public static final Map<Class<?>, Class<?>> mocks = new HashMap();

    public T make(Object ... var1);

    public static <T> Supplier<T> nullary(Class<T> clazz) {
        try {
            Class mock = Mocker.load(clazz);
            return () -> {
                try {
                    return mock.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Mocker<T> variadic(Class<T> clazz) {
        Constructor<?>[] constructors = Mocker.load(clazz).getDeclaredConstructors();
        if (constructors.length > 1) {
            throw new RuntimeException("more than one constructor for " + String.valueOf(clazz));
        }
        Constructor<?> constructor = constructors[0];
        return args -> {
            try {
                return constructor.newInstance(args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T> Class<? extends T> load(Class<T> clazz) {
        if (mocks.containsKey(clazz)) {
            return mocks.get(clazz);
        }
        Class mock = new ByteBuddy().subclass(clazz).method((ElementMatcher)ElementMatchers.returns(String.class).and((ElementMatcher)ElementMatchers.isAbstract())).intercept((Implementation)FixedValue.value((Object)"")).method((ElementMatcher)ElementMatchers.returns(Boolean.TYPE).and((ElementMatcher)ElementMatchers.isAbstract())).intercept((Implementation)FixedValue.value((Object)false)).method((ElementMatcher)ElementMatchers.returns(Integer.TYPE).and((ElementMatcher)ElementMatchers.isAbstract())).intercept((Implementation)FixedValue.value((Object)0)).method((ElementMatcher)ElementMatchers.returns(Long.TYPE).and((ElementMatcher)ElementMatchers.isAbstract())).intercept((Implementation)FixedValue.value((Object)0L)).method((ElementMatcher)ElementMatchers.returns(int[].class).and((ElementMatcher)ElementMatchers.isAbstract())).intercept((Implementation)FixedValue.value((Object)new int[0])).method((ElementMatcher)ElementMatchers.returns(String[].class).and((ElementMatcher)ElementMatchers.isAbstract())).intercept((Implementation)FixedValue.value((Object)new String[0])).make().load(clazz.getClassLoader()).getLoaded();
        mocks.put(clazz, mock);
        return mock;
    }
}

