/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.processor.annotation.AbstractCriteriaMethod;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.annotation.OrderBy;

public class CriteriaFinderMethod
extends AbstractCriteriaMethod {
    private final List<Boolean> paramNullability;

    CriteriaFinderMethod(AnnotationMetaEntity annotationMetaEntity, ExecutableElement method, String methodName, String entity, @Nullable String containerType, List<String> paramNames, List<String> paramTypes, List<Boolean> paramNullability, List<Boolean> multivalued, List<Boolean> paramPatterns, boolean belongsToDao, String sessionType, String sessionName, List<String> fetchProfiles, List<OrderBy> orderBys, boolean addNonnullAnnotation, boolean dataRepository, String fullReturnType, boolean nullable) {
        super(annotationMetaEntity, method, methodName, entity, containerType, belongsToDao, sessionType, sessionName, fetchProfiles, paramNames, paramTypes, orderBys, addNonnullAnnotation, dataRepository, multivalued, paramPatterns, fullReturnType, nullable);
        this.paramNullability = paramNullability;
    }

    @Override
    public boolean isNullable(int index) {
        return this.paramNullability.get(index);
    }

    @Override
    boolean singleResult() {
        return this.containerType == null;
    }

    @Override
    void executeQuery(StringBuilder declaration, List<String> paramTypes) {
        declaration.append('\n');
        this.createSpecification(declaration);
        this.handleRestrictionParameters(declaration, paramTypes);
        this.collectOrdering(declaration, paramTypes, this.containerType);
        this.tryReturn(declaration, paramTypes, this.containerType);
        this.castResult(declaration);
        this.createQuery(declaration);
        this.handlePageParameters(declaration, paramTypes, this.containerType);
        boolean unwrapped = this.initiallyUnwrapped();
        unwrapped = this.enableFetchProfile(declaration, unwrapped);
        this.execute(declaration, paramTypes, unwrapped);
    }

    private void castResult(StringBuilder declaration) {
        if (this.containerType == null && !this.fetchProfiles.isEmpty() && this.isUsingEntityManager()) {
            declaration.append("(").append(this.annotationMetaEntity.importType(this.entity)).append(") ");
        }
    }

    private void execute(StringBuilder declaration, List<String> paramTypes, boolean unwrapped) {
        this.executeSelect(declaration, paramTypes, this.containerType, unwrapped, CriteriaFinderMethod.isHibernateQueryType(this.containerType));
    }

    @Override
    String createQueryMethod() {
        return this.isUsingEntityManager() || this.isReactive() || CriteriaFinderMethod.isUnspecializedQueryType(this.containerType) ? "createQuery" : "createSelectionQuery";
    }

    @Override
    String createCriteriaMethod() {
        return "createQuery";
    }
}

