/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.boot.ResourceStreamLocator;
import org.hibernate.processor.Context;

public class ResourceStreamLocatorImpl
implements ResourceStreamLocator {
    private static final String RESOURCE_PATH_SEPARATOR = "/";
    private final Context context;

    public ResourceStreamLocatorImpl(Context context) {
        this.context = context;
    }

    public @Nullable InputStream locateResourceStream(String resourceName) {
        InputStream ormStream;
        if (!((String)resourceName).startsWith(RESOURCE_PATH_SEPARATOR)) {
            resourceName = RESOURCE_PATH_SEPARATOR + (String)resourceName;
        }
        String pkg = this.getPackage((String)resourceName);
        String name = this.getRelativeName((String)resourceName);
        try {
            FileObject fileObject = this.context.getProcessingEnvironment().getFiler().getResource(StandardLocation.CLASS_OUTPUT, pkg, name);
            ormStream = fileObject.openInputStream();
        }
        catch (IOException e1) {
            ormStream = this.getClass().getResourceAsStream((String)resourceName);
        }
        return ormStream;
    }

    private String getPackage(String resourceName) {
        if (!resourceName.contains(RESOURCE_PATH_SEPARATOR)) {
            return "";
        }
        return resourceName.substring(0, resourceName.lastIndexOf(RESOURCE_PATH_SEPARATOR));
    }

    private String getRelativeName(String resourceName) {
        if (!resourceName.contains(RESOURCE_PATH_SEPARATOR)) {
            return resourceName;
        }
        return resourceName.substring(resourceName.lastIndexOf(RESOURCE_PATH_SEPARATOR) + 1);
    }
}

