/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.TypeUtils;

public abstract class AbstractAnnotatedMethod
implements MetaAttribute {
    final AnnotationMetaEntity annotationMetaEntity;
    private final ExecutableElement method;
    final String sessionType;
    final String sessionName;

    public AbstractAnnotatedMethod(AnnotationMetaEntity annotationMetaEntity, ExecutableElement method, String sessionName, String sessionType) {
        this.annotationMetaEntity = annotationMetaEntity;
        this.method = method;
        this.sessionName = sessionName;
        this.sessionType = sessionType;
    }

    @Override
    public Metamodel getHostingEntity() {
        return this.annotationMetaEntity;
    }

    boolean isUsingEntityManager() {
        return "jakarta.persistence.EntityManager".equals(this.sessionType);
    }

    boolean isUsingStatelessSession() {
        return this.annotationMetaEntity.isStatelessSession();
    }

    boolean isReactive() {
        return this.annotationMetaEntity.isReactive();
    }

    boolean isReactiveSessionAccess() {
        return this.annotationMetaEntity.isReactiveSessionAccess();
    }

    String localSessionName() {
        return this.isReactiveSessionAccess() ? "_session" : this.sessionName;
    }

    String getObjectCall() {
        return this.annotationMetaEntity.isProvidedSessionAccess() ? ".getObject()" : "";
    }

    @Override
    public List<AnnotationMirror> inheritedAnnotations() {
        if (this.annotationMetaEntity.isJakartaDataRepository()) {
            return this.method.getAnnotationMirrors().stream().filter(annotationMirror -> TypeUtils.hasAnnotation(annotationMirror.getAnnotationType().asElement(), "jakarta.interceptor.InterceptorBinding")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    void nullCheck(StringBuilder declaration, String paramName) {
        declaration.append('\t').append(this.annotationMetaEntity.staticImport("java.util.Objects", "requireNonNull")).append('(').append(AbstractAnnotatedMethod.parameterName(paramName)).append(", \"Null ").append("{id}".equals(paramName) ? "id" : paramName).append("\");\n");
    }

    static String parameterName(String name) {
        return name.equals("{id}") ? "id" : name.replace('.', '$');
    }

    protected void handle(StringBuilder declaration, String handled, String rethrown) {
        if (this.isReactive()) {
            declaration.append("\n\t\t\t.onFailure(").append(this.annotationMetaEntity.importType(handled)).append(".class)\n").append("\t\t\t\t\t.transform(_ex -> new ").append(this.annotationMetaEntity.importType(rethrown)).append("(_ex.getMessage(), _ex))");
        } else {
            declaration.append("\tcatch (").append(this.annotationMetaEntity.importType(handled)).append(" _ex) {\n").append("\t\tthrow new ").append(this.annotationMetaEntity.importType(rethrown)).append("(_ex.getMessage(), _ex);\n").append("\t}\n");
        }
    }
}

