/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.util;

import java.util.Locale;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class StringUtil {
    private static final @UnknownKeyFor @NonNull @Initialized String GET = "get";
    private static final @UnknownKeyFor @NonNull @Initialized String IS = "is";
    private static final @UnknownKeyFor @NonNull @Initialized String HAS = "has";

    private StringUtil() {
    }

    public static @UnknownKeyFor @NonNull @Initialized String determineFullyQualifiedClassName(@UnknownKeyFor @NonNull @Initialized String defaultPackage, @UnknownKeyFor @NonNull @Initialized String name) {
        return StringUtil.isFullyQualified(name) ? name : defaultPackage + "." + name;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isFullyQualified(@UnknownKeyFor @NonNull @Initialized String name) {
        return name.contains(".");
    }

    public static @UnknownKeyFor @NonNull @Initialized String packageNameFromFullyQualifiedName(@UnknownKeyFor @NonNull @Initialized String fullyQualifiedName) {
        return fullyQualifiedName.substring(0, fullyQualifiedName.lastIndexOf("."));
    }

    public static @UnknownKeyFor @NonNull @Initialized String classNameFromFullyQualifiedName(@UnknownKeyFor @NonNull @Initialized String fullyQualifiedName) {
        return fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(".") + 1);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isProperty(@UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String returnType) {
        if (methodName == null) {
            return false;
        }
        return !StringUtil.isVoid(returnType) && StringUtil.isValidPropertyName(methodName, GET) || StringUtil.isBoolean(returnType) && (StringUtil.isValidPropertyName(methodName, IS) || StringUtil.isValidPropertyName(methodName, HAS));
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isVoid(@UnknownKeyFor @NonNull @Initialized String returnType) {
        return "void".equals(returnType);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isBoolean(@UnknownKeyFor @NonNull @Initialized String type) {
        return "Boolean".equals(type) || "java.lang.Boolean".equals(type) || "boolean".equals(type);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isValidPropertyName(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String prefix) {
        return name.startsWith(prefix) && name.length() > prefix.length();
    }

    public static @UnknownKeyFor @NonNull @Initialized String getPropertyName(@UnknownKeyFor @NonNull @Initialized String name) {
        return StringUtil.decapitalize(StringUtil.trimPropertyPrefix(name));
    }

    private static @UnknownKeyFor @NonNull @Initialized String trimPropertyPrefix(@UnknownKeyFor @NonNull @Initialized String name) {
        if (name.startsWith(GET)) {
            return name.replaceFirst(GET, "");
        }
        if (name.startsWith(IS)) {
            return name.replaceFirst(IS, "");
        }
        if (name.startsWith(HAS)) {
            return name.replaceFirst(HAS, "");
        }
        return name;
    }

    public static @UnknownKeyFor @NonNull @Initialized String decapitalize(@UnknownKeyFor @NonNull @Initialized String string) {
        return string == null || string.isEmpty() || StringUtil.startsWithSeveralUpperCaseLetters(string) ? string : string.substring(0, 1).toLowerCase(Locale.ROOT) + string.substring(1);
    }

    public static @UnknownKeyFor @NonNull @Initialized String nameToFieldName(@UnknownKeyFor @NonNull @Initialized String name) {
        return StringUtil.getUpperUnderscoreCaseFromLowerCamelCase(StringUtil.nameToMethodName(name));
    }

    public static @UnknownKeyFor @NonNull @Initialized String nameToMethodName(@UnknownKeyFor @NonNull @Initialized String name) {
        return name.replaceAll("[\\s.\\-!@#%=+/*^&|(){}\\[\\],]", "_");
    }

    public static @UnknownKeyFor @NonNull @Initialized String getUpperUnderscoreCaseFromLowerCamelCase(@UnknownKeyFor @NonNull @Initialized String lowerCamelCaseString) {
        int codePoint;
        StringBuilder result = new StringBuilder();
        boolean wasLowerCase = false;
        for (int position = 0; position < lowerCamelCaseString.length(); position += Character.charCount(codePoint)) {
            codePoint = lowerCamelCaseString.codePointAt(position);
            boolean isUpperCase = Character.isUpperCase(codePoint);
            if (wasLowerCase && isUpperCase) {
                result.append('_');
            }
            result.appendCodePoint(Character.toUpperCase(codePoint));
            wasLowerCase = !isUpperCase;
        }
        if (result.toString().equals(lowerCamelCaseString)) {
            result.insert(0, '_');
        }
        return result.toString();
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean startsWithSeveralUpperCaseLetters(@UnknownKeyFor @NonNull @Initialized String string) {
        return string.length() > 1 && Character.isUpperCase(string.charAt(0)) && Character.isUpperCase(string.charAt(1));
    }

    public static @UnknownKeyFor @NonNull @Initialized String removeDollar(@UnknownKeyFor @NonNull @Initialized String simpleName) {
        return simpleName.endsWith("$") ? simpleName.substring(0, simpleName.length() - 1) : simpleName;
    }
}

