/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.util;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.query.criteria.JpaEntityJoin;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;

public final class SqmTypeUtils {
    private SqmTypeUtils() {
    }

    public static @UnknownKeyFor @NonNull @Initialized String resultType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SqmSelectStatement<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> selectStatement) {
        JpaSelection selection = selectStatement.getSelection();
        if (selection instanceof SqmSelectClause) {
            SqmSelectClause from = (SqmSelectClause)selection;
            return from.getSelectionItems().size() > 1 ? "Object[]" : ((SqmSelectableNode)from.getSelectionItems().get(0)).getJavaTypeName();
        }
        if (selection instanceof JpaRoot) {
            JpaRoot root = (JpaRoot)selection;
            return root.getJavaTypeName();
        }
        if (selection instanceof JpaEntityJoin) {
            JpaEntityJoin join = (JpaEntityJoin)selection;
            return join.getJavaTypeName();
        }
        return selection.getJavaTypeName();
    }
}

