/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.List;
import java.util.StringTokenizer;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.annotation.AbstractFinderMethod;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.annotation.OrderBy;
import org.hibernate.processor.util.TypeUtils;

public abstract class AbstractCriteriaMethod
extends AbstractFinderMethod {
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> multivalued;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> paramPatterns;

    public AbstractCriteriaMethod(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String entity, @Nullable @UnknownKeyFor @Initialized String containerType, @UnknownKeyFor @NonNull @Initialized boolean belongsToDao, @UnknownKeyFor @NonNull @Initialized String sessionType, @UnknownKeyFor @NonNull @Initialized String sessionName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fetchProfiles, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized OrderBy> orderBys, @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation, @UnknownKeyFor @NonNull @Initialized boolean convertToDataExceptions, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> multivalued, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> paramPatterns, @UnknownKeyFor @NonNull @Initialized String fullReturnType, @UnknownKeyFor @NonNull @Initialized boolean nullable) {
        super(annotationMetaEntity, method, methodName, entity, containerType, belongsToDao, sessionType, sessionName, fetchProfiles, paramNames, paramTypes, orderBys, addNonnullAnnotation, convertToDataExceptions, fullReturnType, nullable);
        this.multivalued = multivalued;
        this.paramPatterns = paramPatterns;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        List<String> paramTypes = this.parameterTypes();
        StringBuilder declaration = new StringBuilder();
        this.comment(declaration);
        this.modifiers(declaration);
        this.preamble(declaration, paramTypes);
        this.chainSession(declaration);
        this.nullChecks(paramTypes, declaration);
        this.createBuilder(declaration);
        this.createCriteriaQuery(declaration);
        this.where(declaration, paramTypes);
        this.executeQuery(declaration, paramTypes);
        this.convertExceptions(declaration);
        this.chainSessionEnd(false, declaration);
        AbstractCriteriaMethod.closingBrace(declaration);
        return declaration.toString();
    }

    abstract void executeQuery(@UnknownKeyFor @NonNull @Initialized StringBuilder var1, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var2);

    abstract @UnknownKeyFor @NonNull @Initialized String createCriteriaMethod();

    abstract @UnknownKeyFor @NonNull @Initialized String createQueryMethod();

    @UnknownKeyFor @NonNull @Initialized String specificationType() {
        return "org.hibernate.query.specification.SelectionSpecification";
    }

    @Override
    void createQuery(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        boolean specification = this.isUsingSpecification();
        if (specification && !this.isReactive()) {
            declaration.append("_spec.createQuery(").append(this.localSessionName()).append(")\n");
        } else {
            declaration.append(this.localSessionName()).append(".").append(this.createQueryMethod()).append('(');
            if (specification) {
                declaration.append("_spec.buildCriteria(_builder)");
            } else {
                declaration.append("_query");
            }
            declaration.append(")\n");
        }
    }

    @Override
    void createSpecification(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.isUsingSpecification()) {
            declaration.append("\tvar _spec = ").append(this.annotationMetaEntity.importType(this.specificationType())).append(".create(_query);\n");
        }
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized boolean isUsingSpecification() {
        return this.hasRestriction() || this.hasOrder() && !AbstractCriteriaMethod.isJakartaCursoredPage(this.containerType);
    }

    void createCriteriaQuery(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        String entityClass = this.annotationMetaEntity.importType(this.entity);
        declaration.append("\tvar _query = _builder.").append(this.createCriteriaMethod()).append('(').append(entityClass).append(".class);\n").append("\tvar _entity = _query.from(").append(entityClass).append(".class);\n");
    }

    private void createBuilder(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append("\tvar _builder = ").append(this.localSessionName());
        if (this.isReactive()) {
            declaration.append(".getFactory()");
        }
        declaration.append(".getCriteriaBuilder();\n");
    }

    void nullChecks(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        for (int i = 0; i < this.paramNames.size(); ++i) {
            String paramName = (String)this.paramNames.get(i);
            String paramType = paramTypes.get(i);
            if (this.isNullable(i) || TypeUtils.isPrimitive(paramType)) continue;
            this.nullCheck(declaration, paramName);
        }
    }

    void where(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes) {
        declaration.append("\t_query.where(");
        boolean first = true;
        for (int i = 0; i < this.paramNames.size(); ++i) {
            String paramName = (String)this.paramNames.get(i);
            String paramType = paramTypes.get(i);
            if (AbstractCriteriaMethod.isSpecialParam(paramType)) continue;
            if (first) {
                first = false;
            } else {
                declaration.append(", ");
            }
            this.condition(declaration, i, paramName, paramType);
        }
        declaration.append("\n\t);");
    }

    private void condition(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized int i, @UnknownKeyFor @NonNull @Initialized String paramName, @UnknownKeyFor @NonNull @Initialized String paramType) {
        declaration.append("\n\t\t\t");
        String parameterName = AbstractCriteriaMethod.parameterName(paramName);
        if (this.isNullable(i) && !TypeUtils.isPrimitive(paramType)) {
            declaration.append(parameterName).append("==null").append("\n\t\t\t\t? ").append("_entity");
            this.path(declaration, paramName);
            declaration.append(".isNull()").append("\n\t\t\t\t: ");
        }
        if (this.multivalued.get(i).booleanValue()) {
            declaration.append("_entity");
            this.path(declaration, paramName);
            declaration.append(".in(");
            if (paramType.endsWith("[]")) {
                declaration.append("(Object[]) ");
            }
            declaration.append(parameterName).append(")");
        } else {
            declaration.append("_builder.").append(this.paramPatterns.get(i) != false ? "like" : "equal").append("(_entity");
            this.path(declaration, paramName);
            declaration.append(", ").append(parameterName).append(')');
        }
    }

    private void path(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized String paramName) {
        StringTokenizer tokens = new StringTokenizer(paramName, ".");
        String typeName = this.entity;
        while (typeName != null && tokens.hasMoreTokens()) {
            TypeElement typeElement = this.annotationMetaEntity.getContext().getElementUtils().getTypeElement(typeName);
            String memberName = tokens.nextToken();
            declaration.append(".get(");
            if ("{id}".equals(memberName)) {
                declaration.append('\"').append(memberName).append('\"');
            } else {
                declaration.append(this.annotationMetaEntity.importType(TypeUtils.getGeneratedClassFullyQualifiedName(typeElement, false))).append('.').append(memberName);
            }
            declaration.append(')');
            typeName = this.annotationMetaEntity.getMemberType(typeName, memberName);
        }
    }
}

