/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.TypeUtils;

public abstract class AbstractAnnotatedMethod
implements MetaAttribute {
    final @UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity;
    private final @UnknownKeyFor @NonNull @Initialized ExecutableElement method;
    final @UnknownKeyFor @NonNull @Initialized String sessionType;
    final @UnknownKeyFor @NonNull @Initialized String sessionName;

    public AbstractAnnotatedMethod(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized String sessionName, @UnknownKeyFor @NonNull @Initialized String sessionType) {
        this.annotationMetaEntity = annotationMetaEntity;
        this.method = method;
        this.sessionName = sessionName;
        this.sessionType = sessionType;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Metamodel getHostingEntity() {
        return this.annotationMetaEntity;
    }

    @UnknownKeyFor @NonNull @Initialized boolean isUsingEntityManager() {
        return "jakarta.persistence.EntityManager".equals(this.sessionType);
    }

    @UnknownKeyFor @NonNull @Initialized boolean isUsingStatelessSession() {
        return this.annotationMetaEntity.isStatelessSession();
    }

    @UnknownKeyFor @NonNull @Initialized boolean isReactive() {
        return this.annotationMetaEntity.isReactive();
    }

    @UnknownKeyFor @NonNull @Initialized boolean isReactiveSessionAccess() {
        return this.annotationMetaEntity.isReactiveSessionAccess();
    }

    @UnknownKeyFor @NonNull @Initialized String localSessionName() {
        return this.isReactiveSessionAccess() ? "_session" : this.sessionName;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AnnotationMirror> inheritedAnnotations() {
        if (this.annotationMetaEntity.isJakartaDataRepository()) {
            return this.method.getAnnotationMirrors().stream().filter(annotationMirror -> TypeUtils.hasAnnotation(annotationMirror.getAnnotationType().asElement(), "jakarta.interceptor.InterceptorBinding")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    void nullCheck(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized String paramName) {
        declaration.append('\t').append(this.annotationMetaEntity.staticImport("java.util.Objects", "requireNonNull")).append('(').append(AbstractAnnotatedMethod.parameterName(paramName)).append(", \"Null ").append("{id}".equals(paramName) ? "id" : paramName).append("\");\n");
    }

    static @UnknownKeyFor @NonNull @Initialized String parameterName(@UnknownKeyFor @NonNull @Initialized String name) {
        return name.equals("{id}") ? "id" : name.replace('.', '$');
    }

    protected void handle(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized String handled, @UnknownKeyFor @NonNull @Initialized String rethrown) {
        if (this.isReactive()) {
            declaration.append("\n\t\t\t.onFailure(").append(this.annotationMetaEntity.importType(handled)).append(".class)\n").append("\t\t\t\t\t.transform(_ex -> new ").append(this.annotationMetaEntity.importType(rethrown)).append("(_ex.getMessage(), _ex))");
        } else {
            declaration.append("\tcatch (").append(this.annotationMetaEntity.importType(handled)).append(" _ex) {\n").append("\t\tthrow new ").append(this.annotationMetaEntity.importType(rethrown)).append("(_ex.getMessage(), _ex);\n").append("\t}\n");
        }
    }
}

