/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.Context;
import org.hibernate.processor.annotation.EnabledFetchProfileMetaAttribute;
import org.hibernate.processor.annotation.ErrorHandler;
import org.hibernate.processor.annotation.NameMetaAttribute;
import org.hibernate.processor.annotation.NamedQueryMethod;
import org.hibernate.processor.annotation.TypedMetaAttribute;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.SqmTypeUtils;
import org.hibernate.processor.util.TypeUtils;
import org.hibernate.processor.validation.ProcessorSessionFactory;
import org.hibernate.processor.validation.Validation;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;

public abstract class AnnotationMeta
implements Metamodel {
    void addAuxiliaryMembers() {
        this.addAuxiliaryMembersForAnnotation("jakarta.persistence.NamedQuery", "QUERY_");
        this.addAuxiliaryMembersForRepeatableAnnotation("jakarta.persistence.NamedQueries", "QUERY_");
        this.addAuxiliaryMembersForAnnotation("jakarta.persistence.NamedNativeQuery", "QUERY_");
        this.addAuxiliaryMembersForRepeatableAnnotation("jakarta.persistence.NamedNativeQueries", "QUERY_");
        this.addAuxiliaryMembersForAnnotation("jakarta.persistence.SqlResultSetMapping", "MAPPING_");
        this.addAuxiliaryMembersForRepeatableAnnotation("jakarta.persistence.SqlResultSetMappings", "MAPPING_");
        this.addAuxiliaryMembersForAnnotation("jakarta.persistence.NamedEntityGraph", "GRAPH_");
        this.addAuxiliaryMembersForRepeatableAnnotation("jakarta.persistence.NamedEntityGraphs", "GRAPH_");
        this.addAuxiliaryMembersForAnnotation("org.hibernate.annotations.NamedQuery", "QUERY_");
        this.addAuxiliaryMembersForRepeatableAnnotation("org.hibernate.annotations.NamedQueries", "QUERY_");
        this.addAuxiliaryMembersForAnnotation("org.hibernate.annotations.NamedNativeQuery", "QUERY_");
        this.addAuxiliaryMembersForRepeatableAnnotation("org.hibernate.annotations.NamedNativeQueries", "QUERY_");
        this.addAuxiliaryMembersForAnnotation("org.hibernate.annotations.FetchProfile", "PROFILE_");
        this.addAuxiliaryMembersForRepeatableAnnotation("org.hibernate.annotations.FetchProfiles", "PROFILE_");
        this.addAuxiliaryMembersForAnnotation("org.hibernate.annotations.FilterDef", "FILTER_");
        this.addAuxiliaryMembersForRepeatableAnnotation("org.hibernate.annotations.FilterDefs", "FILTER_");
    }

    void checkNamedQueries() {
        boolean checkHql = TypeUtils.containsAnnotation(this.getElement(), "org.hibernate.annotations.processing.CheckHQL") || TypeUtils.containsAnnotation(this.getElement().getEnclosingElement(), "org.hibernate.annotations.processing.CheckHQL");
        this.handleNamedQueryAnnotation("jakarta.persistence.NamedQuery", checkHql);
        this.handleNamedQueryRepeatableAnnotation("jakarta.persistence.NamedQueries", checkHql);
        this.handleNamedQueryAnnotation("org.hibernate.annotations.NamedQuery", checkHql);
        this.handleNamedQueryRepeatableAnnotation("org.hibernate.annotations.NamedQueries", checkHql);
    }

    private void handleNamedQueryAnnotation(@UnknownKeyFor @NonNull @Initialized String annotationName, @UnknownKeyFor @NonNull @Initialized boolean checkHql) {
        AnnotationMirror mirror = TypeUtils.getAnnotationMirror(this.getElement(), annotationName);
        if (mirror != null) {
            this.handleNamedQuery(mirror, checkHql);
        }
    }

    private void handleNamedQueryRepeatableAnnotation(@UnknownKeyFor @NonNull @Initialized String annotationName, @UnknownKeyFor @NonNull @Initialized boolean checkHql) {
        AnnotationValue value;
        AnnotationMirror mirror = TypeUtils.getAnnotationMirror(this.getElement(), annotationName);
        if (mirror != null && (value = TypeUtils.getAnnotationValue(mirror)) != null) {
            List annotationValues = (List)value.getValue();
            for (AnnotationValue annotationValue : annotationValues) {
                this.handleNamedQuery((AnnotationMirror)annotationValue.getValue(), checkHql);
            }
        }
    }

    private void handleNamedQuery(@UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized boolean checkHql) {
        AnnotationValue nameValue = TypeUtils.getAnnotationValue(mirror, "name");
        if (nameValue != null) {
            Object object;
            String name = nameValue.getValue().toString();
            Context context = this.getContext();
            boolean reportErrors = context.checkNamedQuery(name);
            AnnotationValue value = TypeUtils.getAnnotationValue(mirror, "query");
            if (value != null && (object = value.getValue()) instanceof String) {
                String hql = (String)object;
                SqmStatement<?> statement = Validation.validate(hql, null, true, new WarningErrorHandler(context, this.getElement(), mirror, value, hql, reportErrors, checkHql), ProcessorSessionFactory.create(context.getProcessingEnvironment(), context.getEntityNameMappings(), context.getEnumTypesByValue(), context.isIndexing()));
                if (!this.isJakartaDataStyle() && statement instanceof SqmSelectStatement) {
                    String resultType;
                    SqmSelectStatement selectStatement = (SqmSelectStatement)statement;
                    if (AnnotationMeta.isQueryMethodName(name)) {
                        AnnotationValue annotationValue = TypeUtils.getAnnotationValue(mirror, "resultClass");
                        String resultType2 = annotationValue != null ? annotationValue.getValue().toString() : SqmTypeUtils.resultType(selectStatement);
                        this.putMember(name, new NamedQueryMethod(this, selectStatement, name.substring(1), this.isRepository(), this.getSessionType(), this.getSessionVariableName(), context.addNonnullAnnotation(), resultType2));
                    }
                    if (TypeUtils.getAnnotationValue(mirror, "resultClass") == null && (resultType = SqmTypeUtils.resultType(selectStatement)) != null) {
                        this.putMember("QUERY_" + name, new TypedMetaAttribute(this, name, "QUERY_", resultType, "jakarta.persistence.TypedQueryReference", hql));
                    }
                }
            }
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isQueryMethodName(@UnknownKeyFor @NonNull @Initialized String name) {
        return name.length() >= 2 && name.charAt(0) == '#' && Character.isJavaIdentifierStart(name.charAt(1)) && name.substring(2).chars().allMatch(Character::isJavaIdentifierPart);
    }

    private void addAuxiliaryMembersForRepeatableAnnotation(@UnknownKeyFor @NonNull @Initialized String annotationName, @UnknownKeyFor @NonNull @Initialized String prefix) {
        AnnotationValue value;
        AnnotationMirror mirror = TypeUtils.getAnnotationMirror(this.getElement(), annotationName);
        if (mirror != null && (value = TypeUtils.getAnnotationValue(mirror)) != null) {
            List annotationValues = (List)value.getValue();
            for (AnnotationValue annotationValue : annotationValues) {
                this.addAuxiliaryMembersForMirror((AnnotationMirror)annotationValue.getValue(), prefix);
            }
        }
    }

    private void addAuxiliaryMembersForAnnotation(@UnknownKeyFor @NonNull @Initialized String annotationName, @UnknownKeyFor @NonNull @Initialized String prefix) {
        AnnotationMirror mirror = TypeUtils.getAnnotationMirror(this.getElement(), annotationName);
        if (mirror != null) {
            this.addAuxiliaryMembersForMirror(mirror, prefix);
        }
    }

    private void addAuxiliaryMembersForMirror(@UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized String prefix) {
        if (!this.isJakartaDataStyle()) {
            mirror.getElementValues().forEach((key, value) -> {
                String name;
                if (key.getSimpleName().contentEquals("name") && !(name = value.getValue().toString()).isEmpty()) {
                    this.putMember(prefix + name, this.auxiliaryMember(mirror, prefix, name));
                }
            });
        }
    }

    private @UnknownKeyFor @NonNull @Initialized NameMetaAttribute auxiliaryMember(@UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized String prefix, @UnknownKeyFor @NonNull @Initialized String name) {
        return switch (prefix) {
            case "QUERY_" -> {
                AnnotationValue resultClass = TypeUtils.getAnnotationValue(mirror, "resultClass");
                String resultTypeName = resultClass == null ? "java.lang.Object" : resultClass.getValue().toString();
                yield new TypedMetaAttribute(this, name, prefix, resultTypeName, "jakarta.persistence.TypedQueryReference", null);
            }
            case "GRAPH_" -> new TypedMetaAttribute(this, name, prefix, this.getQualifiedName(), "jakarta.persistence.EntityGraph", null);
            case "PROFILE_" -> new EnabledFetchProfileMetaAttribute(this, name, prefix, "org.hibernate.EnabledFetchProfile");
            default -> new NameMetaAttribute(this, name, prefix);
        };
    }

    protected @UnknownKeyFor @NonNull @Initialized String getSessionVariableName() {
        return "entityManager";
    }

    abstract @UnknownKeyFor @NonNull @Initialized boolean isRepository();

    abstract @Nullable @UnknownKeyFor @Initialized String getSessionType();

    abstract void putMember(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized MetaAttribute var2);

    private static class WarningErrorHandler
    extends ErrorHandler {
        private final @UnknownKeyFor @NonNull @Initialized boolean reportErrors;
        private final @UnknownKeyFor @NonNull @Initialized boolean checkHql;

        private WarningErrorHandler(@UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized Element element, @UnknownKeyFor @NonNull @Initialized AnnotationMirror mirror, @UnknownKeyFor @NonNull @Initialized AnnotationValue value, @UnknownKeyFor @NonNull @Initialized String hql, @UnknownKeyFor @NonNull @Initialized boolean reportErrors, @UnknownKeyFor @NonNull @Initialized boolean checkHql) {
            super(context, element, mirror, value, hql);
            this.reportErrors = reportErrors;
            this.checkHql = checkHql;
        }

        @Override
        public void error(@UnknownKeyFor @NonNull @Initialized int start, @UnknownKeyFor @NonNull @Initialized int end, @UnknownKeyFor @NonNull @Initialized String message) {
            if (this.reportErrors) {
                if (this.checkHql) {
                    super.error(start, end, message);
                } else {
                    super.warn(start, end, message);
                }
            }
        }

        @Override
        public void warn(@UnknownKeyFor @NonNull @Initialized int start, @UnknownKeyFor @NonNull @Initialized int end, @UnknownKeyFor @NonNull @Initialized String message) {
            if (this.reportErrors) {
                super.warn(start, end, message);
            }
        }

        @Override
        public void syntaxError(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Recognizer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> recognizer, @UnknownKeyFor @NonNull @Initialized Object offendingSymbol, @UnknownKeyFor @NonNull @Initialized int line, @UnknownKeyFor @NonNull @Initialized int charPositionInLine, @UnknownKeyFor @NonNull @Initialized String message, @UnknownKeyFor @NonNull @Initialized RecognitionException e) {
            if (this.reportErrors) {
                super.syntaxError(recognizer, offendingSymbol, line, charPositionInLine, message, e);
            }
        }
    }
}

