/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.validation;

import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.QueryException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.grammars.hql.HqlLexer;
import org.hibernate.grammars.hql.HqlParser;
import org.hibernate.processor.validation.ProcessorSessionFactory;
import org.hibernate.query.hql.internal.HqlParseTreeBuilder;
import org.hibernate.query.hql.internal.SemanticQueryBuilder;
import org.hibernate.query.hql.spi.SqmCreationOptions;
import org.hibernate.query.sqm.EntityTypeException;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.PathElementException;
import org.hibernate.query.sqm.TerminalPathException;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.type.descriptor.java.spi.JdbcTypeRecommendationException;

public class Validation {
    private static final @UnknownKeyFor @NonNull @Initialized SqmCreationOptions CREATION_OPTIONS = new SqmCreationOptions(){};

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized SqmStatement<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> validate(@UnknownKeyFor @NonNull @Initialized String hql, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized boolean checkTyping, @UnknownKeyFor @NonNull @Initialized Handler handler, @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory) {
        return Validation.validate(hql, returnType, checkTyping, handler, factory, 0);
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized SqmStatement<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> validate(@UnknownKeyFor @NonNull @Initialized String hql, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized boolean checkTyping, @UnknownKeyFor @NonNull @Initialized Handler handler, @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory, @UnknownKeyFor @NonNull @Initialized int errorOffset) {
        try {
            HqlParser.StatementContext statementContext = Validation.parseAndCheckSyntax(hql, handler);
            if (checkTyping && handler.getErrorCount() == 0) {
                return Validation.checkTyping(hql, returnType, handler, factory, errorOffset, statementContext);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized SqmStatement<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> checkTyping(@UnknownKeyFor @NonNull @Initialized String hql, @Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized Handler handler, @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory, @UnknownKeyFor @NonNull @Initialized int errorOffset, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized HqlParser.StatementContext statementContext) {
        block3: {
            try {
                return Validation.createSemanticQueryBuilder(returnType, hql, factory).visitStatement(statementContext);
            }
            catch (JdbcTypeRecommendationException jdbcTypeRecommendationException) {
            }
            catch (PropertyNotFoundException | QueryException | EntityTypeException | PathElementException | TerminalPathException se) {
                String message = se.getMessage();
                if (message == null) break block3;
                handler.error(-errorOffset + 1, -errorOffset + hql.length(), message);
            }
        }
        return null;
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SemanticQueryBuilder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> createSemanticQueryBuilder(@Nullable @UnknownKeyFor @Initialized TypeMirror returnType, @UnknownKeyFor @NonNull @Initialized String hql, @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor factory) {
        NodeBuilder context = factory.getQueryEngine().getCriteriaBuilder();
        if (returnType != null && returnType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)returnType;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            String typeName = typeElement.getQualifiedName().toString();
            String shortName = typeElement.getSimpleName().toString();
            return ProcessorSessionFactory.isEntity(typeElement) ? new SemanticQueryBuilder(typeName, shortName, ProcessorSessionFactory.getHibernateEntityName(typeElement), CREATION_OPTIONS, (SqmCreationContext)context, hql) : new SemanticQueryBuilder(typeName, shortName, Object[].class, CREATION_OPTIONS, (SqmCreationContext)context, hql);
        }
        return new SemanticQueryBuilder(Object[].class, CREATION_OPTIONS, (SqmCreationContext)context, hql);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized HqlParser.StatementContext parseAndCheckSyntax(@UnknownKeyFor @NonNull @Initialized String hql, @UnknownKeyFor @NonNull @Initialized Handler handler) {
        HqlLexer hqlLexer = HqlParseTreeBuilder.INSTANCE.buildHqlLexer(hql);
        HqlParser hqlParser = HqlParseTreeBuilder.INSTANCE.buildHqlParser(hql, hqlLexer);
        ((ParserATNSimulator)hqlParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        hqlParser.removeErrorListeners();
        hqlParser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        try {
            return hqlParser.statement();
        }
        catch (ParseCancellationException e) {
            hqlLexer.reset();
            hqlParser.reset();
            ((ParserATNSimulator)hqlParser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            hqlParser.setErrorHandler((ANTLRErrorStrategy)new DefaultErrorStrategy());
            hqlParser.addErrorListener((ANTLRErrorListener)handler);
            return hqlParser.statement();
        }
    }

    public static interface Handler
    extends ANTLRErrorListener {
        public void error(@UnknownKeyFor @NonNull @Initialized int var1, @UnknownKeyFor @NonNull @Initialized int var2, @UnknownKeyFor @NonNull @Initialized String var3);

        public void warn(@UnknownKeyFor @NonNull @Initialized int var1, @UnknownKeyFor @NonNull @Initialized int var2, @UnknownKeyFor @NonNull @Initialized String var3);

        public @UnknownKeyFor @NonNull @Initialized int getErrorCount();
    }
}

