/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.xml;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.StringUtil;
import org.hibernate.processor.xml.XmlMetaEntity;

public abstract class XmlMetaAttribute
implements MetaAttribute {
    private final @UnknownKeyFor @NonNull @Initialized XmlMetaEntity hostingEntity;
    private final @UnknownKeyFor @NonNull @Initialized String propertyName;
    private final @UnknownKeyFor @NonNull @Initialized String type;

    XmlMetaAttribute(@UnknownKeyFor @NonNull @Initialized XmlMetaEntity parent, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized String type) {
        this.hostingEntity = parent;
        this.propertyName = propertyName;
        this.type = type;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasStringAttribute() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        return "public static volatile " + this.hostingEntity.importType(this.getMetaType()) + "<" + this.hostingEntity.importType(this.hostingEntity.getQualifiedName()) + ", " + this.hostingEntity.importType(this.getTypeDeclaration()) + "> " + this.getPropertyName() + ";";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeNameDeclarationString() {
        return "public static final " + this.hostingEntity.importType(String.class.getName()) + " " + StringUtil.getUpperUnderscoreCaseFromLowerCamelCase(this.getPropertyName()) + " = " + "\"" + this.getPropertyName() + "\"" + ";";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTypeDeclaration() {
        return this.type;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Metamodel getHostingEntity() {
        return this.hostingEntity;
    }

    @Override
    public abstract @UnknownKeyFor @NonNull @Initialized String getMetaType();

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XmlMetaAttribute");
        sb.append("{propertyName='").append(this.propertyName).append('\'');
        sb.append(", type='").append(this.type).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

