/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.annotation.AbstractQueryMethod;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.annotation.OrderBy;

public abstract class AbstractFinderMethod
extends AbstractQueryMethod {
    final @Nullable @UnknownKeyFor @Initialized String containerType;
    final @UnknownKeyFor @NonNull @Initialized String entity;
    final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fetchProfiles;

    AbstractFinderMethod(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String entity, @Nullable @UnknownKeyFor @Initialized String containerType, @UnknownKeyFor @NonNull @Initialized boolean belongsToDao, @UnknownKeyFor @NonNull @Initialized String sessionType, @UnknownKeyFor @NonNull @Initialized String sessionName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fetchProfiles, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized OrderBy> orderBys, @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation, @UnknownKeyFor @NonNull @Initialized boolean convertToDataExceptions, @UnknownKeyFor @NonNull @Initialized String fullReturnType, @UnknownKeyFor @NonNull @Initialized boolean nullable) {
        super(annotationMetaEntity, method, methodName, paramNames, paramTypes, entity, sessionType, sessionName, belongsToDao, orderBys, addNonnullAnnotation, convertToDataExceptions, fullReturnType, nullable);
        this.entity = entity;
        this.containerType = containerType;
        this.fetchProfiles = fetchProfiles;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasStringAttribute() {
        return false;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTypeDeclaration() {
        return this.entity;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeNameDeclarationString() {
        throw new UnsupportedOperationException("operation not supported");
    }

    void comment(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append("\n/**").append("\n * Find ").append("{@link ").append(this.annotationMetaEntity.importType(this.entity)).append("}");
        long paramCount = this.paramTypes.stream().filter(type -> !AbstractFinderMethod.isSpecialParam(type)).count();
        if (paramCount > 0L) {
            declaration.append(" by ");
            int count = 0;
            for (int i = 0; i < this.paramTypes.size(); ++i) {
                String type2 = (String)this.paramTypes.get(i);
                if (AbstractFinderMethod.isSpecialParam(type2)) continue;
                if (count > 0) {
                    if ((long)(count + 1) == paramCount) {
                        declaration.append(paramCount > 2L ? ", and " : " and ");
                    } else {
                        declaration.append(", ");
                    }
                }
                ++count;
                String path = (String)this.paramNames.get(i);
                declaration.append("{@link ").append(this.annotationMetaEntity.importType(this.entity)).append('#').append(this.qualifier(path)).append(' ').append(path).append("}");
            }
        }
        declaration.append('.').append("\n *");
        this.see(declaration);
        declaration.append("\n **/\n");
    }

    @UnknownKeyFor @NonNull @Initialized String qualifier(@UnknownKeyFor @NonNull @Initialized String name) {
        int index = name.indexOf(46);
        return index > 0 ? name.substring(0, index) : name;
    }

    void unwrapSession(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.isUsingEntityManager()) {
            declaration.append(".unwrap(").append(this.annotationMetaEntity.importType("org.hibernate.Session")).append(".class)\n\t\t\t");
        }
    }

    @UnknownKeyFor @NonNull @Initialized boolean enableFetchProfile(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized boolean unwrapped) {
        if (!this.fetchProfiles.isEmpty()) {
            this.unwrapQuery(declaration, unwrapped);
            unwrapped = true;
        }
        for (String profile : this.fetchProfiles) {
            declaration.append("\t\t\t.enableFetchProfile(").append(profile).append(")\n");
        }
        return unwrapped;
    }

    void tryReturn(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.dataRepository) {
            declaration.append("\ttry {\n\t");
        }
        declaration.append("\treturn ").append(this.sessionName);
    }

    void modifiers(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append(this.belongsToDao ? "@Override\npublic " : "public static ");
    }
}

