/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.privilegedactions;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.validation.ConstraintValidator;

public class GetConstraintValidatorList
implements PrivilegedAction<List<ConstraintValidator<?, ?>>> {
    public static List<ConstraintValidator<?, ?>> getConstraintValidatorList() {
        GetConstraintValidatorList action = new GetConstraintValidatorList();
        if (System.getSecurityManager() != null) {
            return (List)AccessController.doPrivileged(action);
        }
        return action.run();
    }

    @Override
    public List<ConstraintValidator<?, ?>> run() {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        List<ConstraintValidator<?, ?>> constraintValidatorList = this.loadConstraintValidators(classloader);
        if (constraintValidatorList.isEmpty()) {
            classloader = GetConstraintValidatorList.class.getClassLoader();
            constraintValidatorList = this.loadConstraintValidators(classloader);
        }
        return constraintValidatorList;
    }

    private List<ConstraintValidator<?, ?>> loadConstraintValidators(ClassLoader classloader) {
        ServiceLoader<ConstraintValidator> loader = ServiceLoader.load(ConstraintValidator.class, classloader);
        Iterator<ConstraintValidator> constraintValidatorIterator = loader.iterator();
        ArrayList constraintValidators = new ArrayList();
        while (constraintValidatorIterator.hasNext()) {
            try {
                constraintValidators.add(constraintValidatorIterator.next());
            }
            catch (ServiceConfigurationError e) {}
        }
        return constraintValidators;
    }
}

