/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.hv;

import java.net.IDN;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.constraints.Email;

public class EmailValidator
implements ConstraintValidator<Email, CharSequence> {
    private static String ATOM = "[a-z0-9!#$%&'*+/=?^_`{|}~-]";
    private static String DOMAIN = ATOM + "+(\\." + ATOM + "+)*";
    private static String IP_DOMAIN = "\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\]";
    private final Pattern localPattern = Pattern.compile(ATOM + "+(\\." + ATOM + "+)*", 2);
    private final Pattern domainPattern = Pattern.compile(DOMAIN + "|" + IP_DOMAIN, 2);

    public void initialize(Email annotation) {
    }

    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (value == null || value.length() == 0) {
            return true;
        }
        String[] emailParts = value.toString().split("@", 3);
        if (emailParts.length != 2) {
            return false;
        }
        if (emailParts[0].endsWith(".") || emailParts[1].endsWith(".")) {
            return false;
        }
        if (!this.matchPart(emailParts[0], this.localPattern)) {
            return false;
        }
        return this.matchPart(emailParts[1], this.domainPattern);
    }

    private boolean matchPart(String part, Pattern pattern) {
        try {
            part = IDN.toASCII(part);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        Matcher matcher = pattern.matcher(part);
        return matcher.matches();
    }
}

