/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.descriptor;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.descriptor.ElementDescriptorImpl;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.logging.Messages;

public class BeanDescriptorImpl
extends ElementDescriptorImpl
implements BeanDescriptor {
    private final Map<String, PropertyDescriptor> constrainedProperties;
    private final Map<String, MethodDescriptor> constrainedMethods;
    private final Map<String, ConstructorDescriptor> constrainedConstructors;

    public BeanDescriptorImpl(Type beanClass, Set<ConstraintDescriptorImpl<?>> classLevelConstraints, Map<String, PropertyDescriptor> constrainedProperties, Map<String, MethodDescriptor> constrainedMethods, Map<String, ConstructorDescriptor> constrainedConstructors, boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        super(beanClass, classLevelConstraints, defaultGroupSequenceRedefined, defaultGroupSequence);
        this.constrainedProperties = Collections.unmodifiableMap(constrainedProperties);
        this.constrainedMethods = Collections.unmodifiableMap(constrainedMethods);
        this.constrainedConstructors = Collections.unmodifiableMap(constrainedConstructors);
    }

    public final boolean isBeanConstrained() {
        return this.hasConstraints() || !this.constrainedProperties.isEmpty() || !this.constrainedMethods.isEmpty() || !this.constrainedConstructors.isEmpty();
    }

    public final PropertyDescriptor getConstraintsForProperty(String propertyName) {
        Contracts.assertNotNull(propertyName, "The property name cannot be null");
        return this.constrainedProperties.get(propertyName);
    }

    public final Set<PropertyDescriptor> getConstrainedProperties() {
        return new HashSet<PropertyDescriptor>(this.constrainedProperties.values());
    }

    public ConstructorDescriptor getConstraintsForConstructor(Class<?> ... parameterTypes) {
        return this.constrainedConstructors.get(this.getElementClass().getSimpleName() + Arrays.toString(parameterTypes));
    }

    public Set<ConstructorDescriptor> getConstrainedConstructors() {
        return new HashSet<ConstructorDescriptor>(this.constrainedConstructors.values());
    }

    public Set<MethodDescriptor> getConstrainedMethods() {
        return new HashSet<MethodDescriptor>(this.constrainedMethods.values());
    }

    public MethodDescriptor getConstraintsForMethod(String methodName, Class<?> ... parameterTypes) {
        Contracts.assertNotNull(methodName, Messages.MESSAGES.methodNameMustNotBeNull());
        return this.constrainedMethods.get(methodName + Arrays.toString(parameterTypes));
    }

    @Override
    public ElementDescriptor.Kind getKind() {
        return ElementDescriptor.Kind.BEAN;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BeanDescriptorImpl");
        sb.append("{class='");
        sb.append(this.getElementClass().getSimpleName());
        sb.append("'}");
        return sb.toString();
    }
}

