/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.constraintvalidation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.TypeHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ConstraintValidatorManager {
    private static final Log log = LoggerFactory.make();
    private final ConstraintValidatorFactory defaultConstraintValidatorFactory;
    private ConstraintValidatorFactory leastRecentlyUsedNonDefaultConstraintValidatorFactory;
    private final ConcurrentHashMap<CacheKey, ConstraintValidator<?, ?>> constraintValidatorCache;

    public ConstraintValidatorManager(ConstraintValidatorFactory constraintValidatorFactory) {
        this.defaultConstraintValidatorFactory = constraintValidatorFactory;
        this.constraintValidatorCache = new ConcurrentHashMap();
    }

    public <V, A extends Annotation> ConstraintValidator<A, V> getInitializedValidator(Type validatedValueType, ConstraintDescriptor<A> descriptor, ConstraintValidatorFactory constraintFactory) {
        Contracts.assertNotNull(validatedValueType);
        Contracts.assertNotNull(descriptor);
        Contracts.assertNotNull(constraintFactory);
        CacheKey key = new CacheKey(descriptor.getAnnotation(), validatedValueType, constraintFactory);
        Object constraintValidator = this.constraintValidatorCache.get(key);
        if (constraintValidator == null) {
            Class<ConstraintValidator<?, ?>> validatorClass = this.findMatchingValidatorClass(descriptor, validatedValueType);
            constraintValidator = this.createAndInitializeValidator(constraintFactory, validatorClass, descriptor);
            this.putInitializedValidator(validatedValueType, descriptor.getAnnotation(), constraintFactory, (ConstraintValidator<?, ?>)constraintValidator);
        } else {
            log.tracef("Constraint validator %s found in cache.", constraintValidator);
        }
        return constraintValidator;
    }

    private void putInitializedValidator(Type validatedValueType, Annotation annotation, ConstraintValidatorFactory constraintFactory, ConstraintValidator<?, ?> constraintValidator) {
        if (constraintFactory != this.defaultConstraintValidatorFactory && constraintFactory != this.leastRecentlyUsedNonDefaultConstraintValidatorFactory) {
            this.clearEntriesForFactory(this.leastRecentlyUsedNonDefaultConstraintValidatorFactory);
            this.leastRecentlyUsedNonDefaultConstraintValidatorFactory = constraintFactory;
        }
        CacheKey key = new CacheKey(annotation, validatedValueType, constraintFactory);
        this.constraintValidatorCache.putIfAbsent(key, constraintValidator);
    }

    private <V, A extends Annotation> ConstraintValidator<A, V> createAndInitializeValidator(ConstraintValidatorFactory constraintFactory, Class<? extends ConstraintValidator<?, ?>> validatorClass, ConstraintDescriptor<A> descriptor) {
        ConstraintValidator constraintValidator = constraintFactory.getInstance(validatorClass);
        if (constraintValidator == null) {
            throw log.getConstraintFactoryMustNotReturnNullException(validatorClass.getName());
        }
        this.initializeConstraint(descriptor, constraintValidator);
        return constraintValidator;
    }

    private void clearEntriesForFactory(ConstraintValidatorFactory constraintFactory) {
        ArrayList<CacheKey> entriesToRemove = new ArrayList<CacheKey>();
        for (Map.Entry<CacheKey, ConstraintValidator<?, ?>> entry : this.constraintValidatorCache.entrySet()) {
            if (entry.getKey().getConstraintFactory() != constraintFactory) continue;
            entriesToRemove.add(entry.getKey());
        }
        for (CacheKey key : entriesToRemove) {
            this.constraintValidatorCache.remove(key);
        }
    }

    public void clear() {
        for (Map.Entry<CacheKey, ConstraintValidator<?, ?>> entry : this.constraintValidatorCache.entrySet()) {
            entry.getKey().getConstraintFactory().releaseInstance(entry.getValue());
        }
        this.constraintValidatorCache.clear();
    }

    public ConstraintValidatorFactory getDefaultConstraintValidatorFactory() {
        return this.defaultConstraintValidatorFactory;
    }

    public int numberOfCachedConstraintValidatorInstances() {
        return this.constraintValidatorCache.size();
    }

    private <A extends Annotation> Class<? extends ConstraintValidator<?, ?>> findMatchingValidatorClass(ConstraintDescriptor<A> descriptor, Type validatedValueType) {
        Map<Type, Class<ConstraintValidator<?, ?>>> availableValidatorTypes = TypeHelper.getValidatorsTypes(descriptor.getConstraintValidatorClasses());
        List<Type> discoveredSuitableTypes = this.findSuitableValidatorTypes(validatedValueType, availableValidatorTypes);
        this.resolveAssignableTypes(discoveredSuitableTypes);
        this.verifyResolveWasUnique(validatedValueType, discoveredSuitableTypes);
        Type suitableType = discoveredSuitableTypes.get(0);
        return availableValidatorTypes.get(suitableType);
    }

    private void verifyResolveWasUnique(Type valueClass, List<Type> assignableClasses) {
        if (assignableClasses.size() == 0) {
            String className = valueClass.toString();
            if (valueClass instanceof Class) {
                Class clazz = (Class)valueClass;
                className = clazz.isArray() ? clazz.getComponentType().toString() + "[]" : clazz.getName();
            }
            throw log.getNoValidatorFoundForTypeException(className);
        }
        if (assignableClasses.size() > 1) {
            StringBuilder builder = new StringBuilder();
            for (Type clazz : assignableClasses) {
                builder.append(clazz);
                builder.append(", ");
            }
            builder.delete(builder.length() - 2, builder.length());
            throw log.getMoreThanOneValidatorFoundForTypeException(valueClass, builder.toString());
        }
    }

    private List<Type> findSuitableValidatorTypes(Type type, Map<Type, Class<? extends ConstraintValidator<?, ?>>> availableValidatorTypes) {
        ArrayList<Type> determinedSuitableTypes = new ArrayList<Type>();
        for (Type validatorType : availableValidatorTypes.keySet()) {
            if (!TypeHelper.isAssignable(validatorType, type) || determinedSuitableTypes.contains(validatorType)) continue;
            determinedSuitableTypes.add(validatorType);
        }
        return determinedSuitableTypes;
    }

    private <A extends Annotation> void initializeConstraint(ConstraintDescriptor<A> descriptor, ConstraintValidator<A, ?> constraintValidator) {
        try {
            constraintValidator.initialize(descriptor.getAnnotation());
        }
        catch (RuntimeException e) {
            throw log.getUnableToInitializeConstraintValidatorException(constraintValidator.getClass().getName(), e);
        }
    }

    private void resolveAssignableTypes(List<Type> assignableTypes) {
        if (assignableTypes.size() == 0 || assignableTypes.size() == 1) {
            return;
        }
        ArrayList<Type> typesToRemove = new ArrayList<Type>();
        do {
            typesToRemove.clear();
            Type type = assignableTypes.get(0);
            for (int i = 1; i < assignableTypes.size(); ++i) {
                if (TypeHelper.isAssignable(type, assignableTypes.get(i))) {
                    typesToRemove.add(type);
                    continue;
                }
                if (!TypeHelper.isAssignable(assignableTypes.get(i), type)) continue;
                typesToRemove.add(assignableTypes.get(i));
            }
            assignableTypes.removeAll(typesToRemove);
        } while (typesToRemove.size() > 0);
    }

    private static final class CacheKey {
        private final Annotation annotation;
        private final Type validatedType;
        private final ConstraintValidatorFactory constraintFactory;

        private CacheKey(Annotation annotation, Type validatorType, ConstraintValidatorFactory constraintFactory) {
            this.annotation = annotation;
            this.validatedType = validatorType;
            this.constraintFactory = constraintFactory;
        }

        public ConstraintValidatorFactory getConstraintFactory() {
            return this.constraintFactory;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.annotation != null ? !this.annotation.equals(cacheKey.annotation) : cacheKey.annotation != null) {
                return false;
            }
            if (this.constraintFactory != null ? !this.constraintFactory.equals(cacheKey.constraintFactory) : cacheKey.constraintFactory != null) {
                return false;
            }
            return !(this.validatedType != null ? !this.validatedType.equals(cacheKey.validatedType) : cacheKey.validatedType != null);
        }

        public int hashCode() {
            int result = this.annotation != null ? this.annotation.hashCode() : 0;
            result = 31 * result + (this.validatedType != null ? this.validatedType.hashCode() : 0);
            result = 31 * result + (this.constraintFactory != null ? this.constraintFactory.hashCode() : 0);
            return result;
        }
    }
}

