
package org.hibernate.validator.internal.util.logging;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Generated;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;


/**
 * Warning this class consists of generated code.
 * 
 */
@Generated(value = "org.jboss.logging.processor.model.MessageLoggerImplementor", date = "2014-07-25T13:32:28+0200")
public class Log_$logger
    implements Serializable, Log, BasicLogger
{

    private final static long serialVersionUID = 1L;
    private final static String projectCode = "HV";
    private final static String FQCN = Log_$logger.class.getName();
    protected final Logger log;
    private final static String usingTraversableResolver = "Using %s as traversable resolver.";
    private final static String getInvalidRegularExpressionException = "Invalid regular expression.";
    private final static String getIsNotAConstraintValidatorClassException = "%s is not a constraint validator class.";
    private final static String getUnableToExpandDefaultGroupListException = "Unable to expand default group list %1$s into sequence %2$s.";
    private final static String getAttemptToSpecifyAnArrayWhereSingleValueIsExpectedException = "Attempt to specify an array where single value is expected.";
    private final static String unableToCloseInputStream = "Unable to close input stream.";
    private final static String getMissingActualTypeArgumentForTypeParameterException = "Missing actual type argument for type parameter: %s.";
    private final static String getIsNotAnAnnotationException = "%s is not an annotation.";
    private final static String getGroupHasToBeAnInterfaceException = "A group has to be an interface. %s is not.";
    private final static String getMoreThanOneValidatorFoundForTypeException = "There are multiple validator classes which could validate the type %1$s. The validator classes are: %2$s.";
    private final static String getUnableToCreateAnnotationForConfiguredConstraintException = "Unable to create annotation for configured constraint: %s.";
    private final static String unableToCreateSchema = "Unable to create schema for %1$s: %2$s";
    private final static String getWrongDefaultValueForPayloadParameterException = "%s contains Constraint annotation, but the payload parameter default value is not the empty array.";
    private final static String getPropertyNameCannotBeNullOrEmptyException = "Property name cannot be null or empty.";
    private final static String getErrorDuringCallOfTraversableResolverIsReachableException = "Call to TraversableResolver.isReachable() threw an exception.";
    private final static String getInvalidPropertyPathException2 = "Invalid property path. There is no property %1$s in entity %2$s.";
    private final static String usingConstraintFactory = "Using %s as constraint factory.";
    private final static String getCharacterIsNotADigitException = "'%c' is not a digit.";
    private final static String parsingXMLFile = "%s found. Parsing XML based configuration.";
    private final static String getUnableToFindAnnotationParameterException = "The specified annotation defines no parameter '%s'.";
    private final static String getBeanDoesNotContainThePropertyException = "%1$s does not contain the property %2$s.";
    private final static String getMinCannotBeNegativeException = "The min parameter cannot be negative.";
    private final static String getUnableToInstantiateException1 = "Unable to instantiate %s.";
    private final static String getHasToBeAPrimitiveTypeException = "%s has to be a primitive type.";
    private final static String getUnableToFindProviderException = "Unable to find provider: %s.";
    private final static String getPropertyPathMustProvideIndexOrMapKeyException = "Property path must provide index or map key.";
    private final static String getUnableToExpandGroupSequenceException = "Unable to expand group sequence.";
    private final static String getInvalidDefaultGroupSequenceDefinitionException = "Default group sequence and default group sequence provider cannot be defined at the same time.";
    private final static String getUnableToInstantiateBeanValidationProviderException = "Unable to instantiate Bean Validation provider %s.";
    private final static String getWrongParameterTypeException = "Wrong parameter type. Expected: %1$s Actual: %2$s.";
    private final static String getMaxCannotBeNegativeException = "The max parameter cannot be negative.";
    private final static String getMultipleDefinitionOfDefaultGroupSequenceProviderException = "Multiple definitions of default group sequence provider.";
    private final static String getElementTypeHasToBeFieldOrMethodException = "Element type has to be FIELD or METHOD.";
    private final static String getIllegalArgumentException = "%s";
    private final static String getInvalidCharValueException = "Invalid char value: %s.";
    private final static String getIsDefinedTwiceInMappingXmlForBeanException = "%1$s is defined twice in mapping xml for bean %2$s.";
    private final static String ignoringXmlConfiguration = "Ignoring XML configuration.";
    private final static String unableToCloseXMLFileInputStream = "Unable to close input stream for %s.";
    private final static String getUnableToGetAnnotationParameterException = "Unable to get '%1$s' from %2$s.";
    private final static String getNoDefaultGroupInGroupSequenceException = "'Default.class' cannot appear in default group sequence list.";
    private final static String getInvalidLengthForFractionPartException = "The length of the fraction part cannot be negative.";
    private final static String getUnableToOpenInputStreamForMappingFileException = "Unable to open input stream for mapping file %s.";
    private final static String getScriptMustReturnTrueOrFalseException3 = "Script \"%1$s\" returned %2$s (of type %3$s), but must return either true or false.";
    private final static String getInvalidCheckDigitException = "A explicitly specified check digit must lie outside the interval: [%1$d, %2$d].";
    private final static String getUnableToInstantiateTraversableResolverClassException = "Unable to instantiate traversable resolver class %s.";
    private final static String getWrongDefaultGroupSequenceProviderTypeException = "The default group sequence provider defined for %s has the wrong type";
    private final static String getErrorDuringScriptExecutionException = "Error during execution of script \"%s\" occurred.";
    private final static String getInvalidRangeException = "Invalid Range: %1$d > %2$d.";
    private final static String getWrongDefaultValueForGroupsParameterException = "%s contains Constraint annotation, but the groups parameter default value is not the empty array.";
    private final static String getUnableToAccessMemberException = "Unable to access %s.";
    private final static String getAnnotationDoesNotContainAParameterException = "Annotation of type %1$s does not contain a parameter %2$s.";
    private final static String usingMessageInterpolator = "Using %s as message interpolator.";
    private final static String version = "Hibernate Validator %s";
    private final static String getUnableToRetrieveAnnotationParameterValueException = "Unable to retrieve annotation parameter value.";
    private final static String usingValidationProvider = "Using %s as validation provider.";
    private final static String getScriptMustReturnTrueOrFalseException1 = "Script \"%s\" returned null, but must return either true or false.";
    private final static String getConstraintWithoutMandatoryParameterException = "%2$s contains Constraint annotation, but does not contain a %1$s parameter.";
    private final static String getUnableToInstantiateConstraintFactoryClassException = "Unable to instantiate constraint factory class %s.";
    private final static String getTypeNotSupportedException = "Type %s not supported.";
    private final static String getBeanClassHasAlreadyBeConfiguredInXmlException = "%s has already be configured in xml.";
    private final static String getNoValidatorFoundForTypeException = "No validator could be found for type: %s.";
    private final static String getUnableToReadAnnotationAttributesException = "Unable to read annotation attributes: %s.";
    private final static String getMultipleDefinitionOfDefaultGroupSequenceException = "Multiple definitions of default group sequence.";
    private final static String getWrongTypeForGroupsParameterException = "%s contains Constraint annotation, but the groups parameter is of wrong type.";
    private final static String getUnableToInitializeConstraintValidatorException = "Unable to initialize %s.";
    private final static String getReservedParameterNamesException = "%s, %s, %s are reserved parameter names.";
    private final static String getConstraintParametersCannotStartWithValidException = "Parameters starting with 'valid' are not allowed in a constraint.";
    private final static String getInvalidLengthOfParameterMetaDataListException = "Method %1$s has %2$s parameters, but the passed list of parameter meta data has a size of %3$s.";
    private final static String getUnableToInstantiateMessageInterpolatorClassException = "Unable to instantiate message interpolator class %s.";
    private final static String getEndIndexCannotBeNegativeException = "End index cannot be negative: %d.";
    private final static String throwInvalidFormat = "Invalid format: %s.";
    private final static String getWrongAttributeTypeForOverriddenConstraintException = "The overriding type of a composite constraint must be identical to the overridden one. Expected %1$s found %2$s.";
    private final static String getBeanDoesNotContainTheFieldException = "%1$s does not contain the fieldType %2$s.";
    private final static String getUnableToLoadClassException = "Unable to load class: %s.";
    private final static String getAtLeastOneCustomMessageMustBeCreatedException = "At least one custom message must be created if the default error message gets disabled.";
    private final static String getMemberIsNeitherAFieldNorAMethodException = "Member %s is neither a field nor a method.";
    private final static String getSequenceDefinitionsNotAllowedException = "Sequence definitions are not allowed as composing parts of a sequence.";
    private final static String getUnexpectedParameterValueException = "Unexpected parameter value.";
    private final static String getInvalidBigDecimalFormatException = "%s does not represent a valid BigDecimal format.";
    private final static String getUnableToFindMethodException = "Type %1$s doesn't have a method %2$s(%3$s).";
    private final static String getUnableToParsePropertyPathException = "Unable to parse property path %s.";
    private final static String getInvalidMethodParameterIndexException1 = "A valid parameter index has to be specified for method '%s'";
    private final static String unableToLoadProviderClass = "Unable to load provider class %s.";
    private final static String getInvalidIndexException = "The given index must be between %1$s and %2$s.";
    private final static String getUnableToFindPropertyWithAccessException = "The class %1$s does not have a property '%2$s' with access %3$s.";
    private final static String getNullIsAnInvalidTypeForAConstraintValidatorException = "null is an invalid type for a constraint validator.";
    private final static String getNoValueProvidedForAnnotationParameterException = "No value provided for %s.";
    private final static String getExceptionDuringIsValidCall = "Unexpected exception during isValid call.";
    private final static String getErrorParsingMappingFileException = "Error parsing mapping file.";
    private final static String getInvalidJavaIdentifierException = "%s is not a valid Java Identifier.";
    private final static String getLengthCannotBeNegativeException = "The length cannot be negative.";
    private final static String getUnableToReadServicesFileException = "Unable to read %s.";
    private final static String getStartIndexCannotBeNegativeException = "Start index cannot be negative: %d.";
    private final static String getInvalidReturnTypeException = "Invalid return type: %s. Should be a enumeration type.";
    private final static String getErrorDuringCallOfTraversableResolverIsCascadableException = "Call to TraversableResolver.isCascadable() threw an exception.";
    private final static String getAtLeastOneGroupHasToBeSpecifiedException = "At least one group has to be specified.";
    private final static String getInconsistentFailFastConfigurationException = "Inconsistent fail fast configuration. Fail fast enabled via programmatic API, but explicitly disabled via properties.";
    private final static String getInconsistentConfigurationException = "Assertion error: inconsistent ConfigurationImpl construction.";
    private final static String getInvalidMethodParameterIndexException2 = "Method %1$s doesn't have a parameter with index %2$d.";
    private final static String getOverriddenConstraintAttributeNotFoundException = "Overridden constraint does not define an attribute with name %s.";
    private final static String getBeanClassMustBePartOfRedefinedDefaultGroupSequenceException = "%s must be part of the redefined default group sequence.";
    private final static String getWrongTypeForPayloadParameterException = "%s contains Constraint annotation, but the payload parameter is of wrong type.";
    private final static String getInvalidPropertyValue = "Invalid value for property %s: %s";
    private final static String getUnableToFindAnnotationConstraintsException = "Unable to find constraints for  %s.";
    private final static String getTryingToInstantiateAnnotationWithUnknownParametersException = "Trying to instantiate %1$s with unknown parameter(s): %2$s.";
    private final static String getConstraintFactoryMustNotReturnNullException = "Constraint factory returned null when trying to create instance of %s.";
    private final static String getInvalidPropertyPathException0 = "Invalid property path.";
    private final static String getUnableToInstantiateException2 = "Unable to instantiate %1$s: %2$s.";
    private final static String getWrongTypeForMessageParameterException = "%s contains Constraint annotation, but the message parameter is not of type java.lang.String.";
    private final static String getUnableToParseValidationXmlFileException = "Unable to parse %s.";
    private final static String getCyclicDependencyInGroupsDefinitionException = "Cyclic dependency in groups definition";
    private final static String getMissingFormatStringInTemplateException = "Missing format string in template: %s.";
    private final static String getInvalidNumberFormatException = "Invalid %s format.";
    private final static String getInvalidLengthForIntegerPartException = "The length of the integer part cannot be negative.";
    private final static String getWrongPayloadClassException = "Specified payload class %s does not implement javax.validation.Payload";
    private final static String getUnableToInstantiateValidationProviderClassException = "Unable to instantiate validation provider class %s.";

    public Log_$logger(final Logger log) {
        this.log = log;
    }

    @Override
    public final boolean isTraceEnabled() {
        return log.isTraceEnabled();
    }

    @Override
    public final void trace(Object message) {
        log.trace(FQCN, message, null);
    }

    @Override
    public final void trace(Object message, Throwable t) {
        log.trace(FQCN, message, t);
    }

    @Override
    public final void trace(String loggerFqcn, Object message, Throwable t) {
        log.trace(loggerFqcn, message, t);
    }

    @Override
    public final void trace(String loggerFqcn, Object message, Object[] params, Throwable t) {
        log.trace(loggerFqcn, message, params, t);
    }

    @Override
    public final void tracev(String format, Object... params) {
        log.logv(FQCN, Logger.Level.TRACE, null, format, params);
    }

    @Override
    public final void tracev(String format, Object param1) {
        log.logv(FQCN, Logger.Level.TRACE, null, format, param1);
    }

    @Override
    public final void tracev(String format, Object param1, Object param2) {
        log.logv(FQCN, Logger.Level.TRACE, null, format, param1, param2);
    }

    @Override
    public final void tracev(String format, Object param1, Object param2, Object param3) {
        log.logv(FQCN, Logger.Level.TRACE, null, format, param1, param2, param3);
    }

    @Override
    public final void tracev(Throwable t, String format, Object... params) {
        log.logv(FQCN, Logger.Level.TRACE, t, format, params);
    }

    @Override
    public final void tracev(Throwable t, String format, Object param1) {
        log.logv(FQCN, Logger.Level.TRACE, t, format, param1);
    }

    @Override
    public final void tracev(Throwable t, String format, Object param1, Object param2) {
        log.logv(FQCN, Logger.Level.TRACE, t, format, param1, param2);
    }

    @Override
    public final void tracev(Throwable t, String format, Object param1, Object param2, Object param3) {
        log.logv(FQCN, Logger.Level.TRACE, t, format, param1, param2, param3);
    }

    @Override
    public final void tracef(String format, Object... params) {
        log.logf(FQCN, Logger.Level.TRACE, null, format, params);
    }

    @Override
    public final void tracef(String format, Object param1) {
        log.logf(FQCN, Logger.Level.TRACE, null, format, param1);
    }

    @Override
    public final void tracef(String format, Object param1, Object param2) {
        log.logf(FQCN, Logger.Level.TRACE, null, format, param1, param2);
    }

    @Override
    public final void tracef(String format, Object param1, Object param2, Object param3) {
        log.logf(FQCN, Logger.Level.TRACE, null, format, param1, param2, param3);
    }

    @Override
    public final void tracef(Throwable t, String format, Object... params) {
        log.logf(FQCN, Logger.Level.TRACE, t, format, params);
    }

    @Override
    public final void tracef(Throwable t, String format, Object param1) {
        log.logf(FQCN, Logger.Level.TRACE, t, format, param1);
    }

    @Override
    public final void tracef(Throwable t, String format, Object param1, Object param2) {
        log.logf(FQCN, Logger.Level.TRACE, t, format, param1, param2);
    }

    @Override
    public final void tracef(Throwable t, String format, Object param1, Object param2, Object param3) {
        log.logf(FQCN, Logger.Level.TRACE, t, format, param1, param2, param3);
    }

    @Override
    public final boolean isDebugEnabled() {
        return log.isDebugEnabled();
    }

    @Override
    public final void debug(Object message) {
        log.debug(FQCN, message, null);
    }

    @Override
    public final void debug(Object message, Throwable t) {
        log.debug(FQCN, message, t);
    }

    @Override
    public final void debug(String loggerFqcn, Object message, Throwable t) {
        log.debug(loggerFqcn, message, t);
    }

    @Override
    public final void debug(String loggerFqcn, Object message, Object[] params, Throwable t) {
        log.debug(loggerFqcn, message, params, t);
    }

    @Override
    public final void debugv(String format, Object... params) {
        log.logv(FQCN, Logger.Level.DEBUG, null, format, params);
    }

    @Override
    public final void debugv(String format, Object param1) {
        log.logv(FQCN, Logger.Level.DEBUG, null, format, param1);
    }

    @Override
    public final void debugv(String format, Object param1, Object param2) {
        log.logv(FQCN, Logger.Level.DEBUG, null, format, param1, param2);
    }

    @Override
    public final void debugv(String format, Object param1, Object param2, Object param3) {
        log.logv(FQCN, Logger.Level.DEBUG, null, format, param1, param2, param3);
    }

    @Override
    public final void debugv(Throwable t, String format, Object... params) {
        log.logv(FQCN, Logger.Level.DEBUG, t, format, params);
    }

    @Override
    public final void debugv(Throwable t, String format, Object param1) {
        log.logv(FQCN, Logger.Level.DEBUG, t, format, param1);
    }

    @Override
    public final void debugv(Throwable t, String format, Object param1, Object param2) {
        log.logv(FQCN, Logger.Level.DEBUG, t, format, param1, param2);
    }

    @Override
    public final void debugv(Throwable t, String format, Object param1, Object param2, Object param3) {
        log.logv(FQCN, Logger.Level.DEBUG, t, format, param1, param2, param3);
    }

    @Override
    public final void debugf(String format, Object... params) {
        log.logf(FQCN, Logger.Level.DEBUG, null, format, params);
    }

    @Override
    public final void debugf(String format, Object param1) {
        log.logf(FQCN, Logger.Level.DEBUG, null, format, param1);
    }

    @Override
    public final void debugf(String format, Object param1, Object param2) {
        log.logf(FQCN, Logger.Level.DEBUG, null, format, param1, param2);
    }

    @Override
    public final void debugf(String format, Object param1, Object param2, Object param3) {
        log.logf(FQCN, Logger.Level.DEBUG, null, format, param1, param2, param3);
    }

    @Override
    public final void debugf(Throwable t, String format, Object... params) {
        log.logf(FQCN, Logger.Level.DEBUG, t, format, params);
    }

    @Override
    public final void debugf(Throwable t, String format, Object param1) {
        log.logf(FQCN, Logger.Level.DEBUG, t, format, param1);
    }

    @Override
    public final void debugf(Throwable t, String format, Object param1, Object param2) {
        log.logf(FQCN, Logger.Level.DEBUG, t, format, param1, param2);
    }

    @Override
    public final void debugf(Throwable t, String format, Object param1, Object param2, Object param3) {
        log.logf(FQCN, Logger.Level.DEBUG, t, format, param1, param2, param3);
    }

    @Override
    public final boolean isInfoEnabled() {
        return log.isInfoEnabled();
    }

    @Override
    public final void info(Object message) {
        log.info(FQCN, message, null);
    }

    @Override
    public final void info(Object message, Throwable t) {
        log.info(FQCN, message, t);
    }

    @Override
    public final void info(String loggerFqcn, Object message, Throwable t) {
        log.info(loggerFqcn, message, t);
    }

    @Override
    public final void info(String loggerFqcn, Object message, Object[] params, Throwable t) {
        log.info(loggerFqcn, message, params, t);
    }

    @Override
    public final void infov(String format, Object... params) {
        log.logv(FQCN, Logger.Level.INFO, null, format, params);
    }

    @Override
    public final void infov(String format, Object param1) {
        log.logv(FQCN, Logger.Level.INFO, null, format, param1);
    }

    @Override
    public final void infov(String format, Object param1, Object param2) {
        log.logv(FQCN, Logger.Level.INFO, null, format, param1, param2);
    }

    @Override
    public final void infov(String format, Object param1, Object param2, Object param3) {
        log.logv(FQCN, Logger.Level.INFO, null, format, param1, param2, param3);
    }

    @Override
    public final void infov(Throwable t, String format, Object... params) {
        log.logv(FQCN, Logger.Level.INFO, t, format, params);
    }

    @Override
    public final void infov(Throwable t, String format, Object param1) {
        log.logv(FQCN, Logger.Level.INFO, t, format, param1);
    }

    @Override
    public final void infov(Throwable t, String format, Object param1, Object param2) {
        log.logv(FQCN, Logger.Level.INFO, t, format, param1, param2);
    }

    @Override
    public final void infov(Throwable t, String format, Object param1, Object param2, Object param3) {
        log.logv(FQCN, Logger.Level.INFO, t, format, param1, param2, param3);
    }

    @Override
    public final void infof(String format, Object... params) {
        log.logf(FQCN, Logger.Level.INFO, null, format, params);
    }

    @Override
    public final void infof(String format, Object param1) {
        log.logf(FQCN, Logger.Level.INFO, null, format, param1);
    }

    @Override
    public final void infof(String format, Object param1, Object param2) {
        log.logf(FQCN, Logger.Level.INFO, null, format, param1, param2);
    }

    @Override
    public final void infof(String format, Object param1, Object param2, Object param3) {
        log.logf(FQCN, Logger.Level.INFO, null, format, param1, param2, param3);
    }

    @Override
    public final void infof(Throwable t, String format, Object... params) {
        log.logf(FQCN, Logger.Level.INFO, t, format, params);
    }

    @Override
    public final void infof(Throwable t, String format, Object param1) {
        log.logf(FQCN, Logger.Level.INFO, t, format, param1);
    }

    @Override
    public final void infof(Throwable t, String format, Object param1, Object param2) {
        log.logf(FQCN, Logger.Level.INFO, t, format, param1, param2);
    }

    @Override
    public final void infof(Throwable t, String format, Object param1, Object param2, Object param3) {
        log.logf(FQCN, Logger.Level.INFO, t, format, param1, param2, param3);
    }

    @Override
    public final void warn(Object message) {
        log.warn(FQCN, message, null);
    }

    @Override
    public final void warn(Object message, Throwable t) {
        log.warn(FQCN, message, t);
    }

    @Override
    public final void warn(String loggerFqcn, Object message, Throwable t) {
        log.warn(loggerFqcn, message, t);
    }

    @Override
    public final void warn(String loggerFqcn, Object message, Object[] params, Throwable t) {
        log.warn(loggerFqcn, message, params, t);
    }

    @Override
    public final void warnv(String format, Object... params) {
        log.logv(FQCN, Logger.Level.WARN, null, format, params);
    }

    @Override
    public final void warnv(String format, Object param1) {
        log.logv(FQCN, Logger.Level.WARN, null, format, param1);
    }

    @Override
    public final void warnv(String format, Object param1, Object param2) {
        log.logv(FQCN, Logger.Level.WARN, null, format, param1, param2);
    }

    @Override
    public final void warnv(String format, Object param1, Object param2, Object param3) {
        log.logv(FQCN, Logger.Level.WARN, null, format, param1, param2, param3);
    }

    @Override
    public final void warnv(Throwable t, String format, Object... params) {
        log.logv(FQCN, Logger.Level.WARN, t, format, params);
    }

    @Override
    public final void warnv(Throwable t, String format, Object param1) {
        log.logv(FQCN, Logger.Level.WARN, t, format, param1);
    }

    @Override
    public final void warnv(Throwable t, String format, Object param1, Object param2) {
        log.logv(FQCN, Logger.Level.WARN, t, format, param1, param2);
    }

    @Override
    public final void warnv(Throwable t, String format, Object param1, Object param2, Object param3) {
        log.logv(FQCN, Logger.Level.WARN, t, format, param1, param2, param3);
    }

    @Override
    public final void warnf(String format, Object... params) {
        log.logf(FQCN, Logger.Level.WARN, null, format, params);
    }

    @Override
    public final void warnf(String format, Object param1) {
        log.logf(FQCN, Logger.Level.WARN, null, format, param1);
    }

    @Override
    public final void warnf(String format, Object param1, Object param2) {
        log.logf(FQCN, Logger.Level.WARN, null, format, param1, param2);
    }

    @Override
    public final void warnf(String format, Object param1, Object param2, Object param3) {
        log.logf(FQCN, Logger.Level.WARN, null, format, param1, param2, param3);
    }

    @Override
    public final void warnf(Throwable t, String format, Object... params) {
        log.logf(FQCN, Logger.Level.WARN, t, format, params);
    }

    @Override
    public final void warnf(Throwable t, String format, Object param1) {
        log.logf(FQCN, Logger.Level.WARN, t, format, param1);
    }

    @Override
    public final void warnf(Throwable t, String format, Object param1, Object param2) {
        log.logf(FQCN, Logger.Level.WARN, t, format, param1, param2);
    }

    @Override
    public final void warnf(Throwable t, String format, Object param1, Object param2, Object param3) {
        log.logf(FQCN, Logger.Level.WARN, t, format, param1, param2, param3);
    }

    @Override
    public final void error(Object message) {
        log.error(FQCN, message, null);
    }

    @Override
    public final void error(Object message, Throwable t) {
        log.error(FQCN, message, t);
    }

    @Override
    public final void error(String loggerFqcn, Object message, Throwable t) {
        log.error(loggerFqcn, message, t);
    }

    @Override
    public final void error(String loggerFqcn, Object message, Object[] params, Throwable t) {
        log.error(loggerFqcn, message, params, t);
    }

    @Override
    public final void errorv(String format, Object... params) {
        log.logv(FQCN, Logger.Level.ERROR, null, format, params);
    }

    @Override
    public final void errorv(String format, Object param1) {
        log.logv(FQCN, Logger.Level.ERROR, null, format, param1);
    }

    @Override
    public final void errorv(String format, Object param1, Object param2) {
        log.logv(FQCN, Logger.Level.ERROR, null, format, param1, param2);
    }

    @Override
    public final void errorv(String format, Object param1, Object param2, Object param3) {
        log.logv(FQCN, Logger.Level.ERROR, null, format, param1, param2, param3);
    }

    @Override
    public final void errorv(Throwable t, String format, Object... params) {
        log.logv(FQCN, Logger.Level.ERROR, t, format, params);
    }

    @Override
    public final void errorv(Throwable t, String format, Object param1) {
        log.logv(FQCN, Logger.Level.ERROR, t, format, param1);
    }

    @Override
    public final void errorv(Throwable t, String format, Object param1, Object param2) {
        log.logv(FQCN, Logger.Level.ERROR, t, format, param1, param2);
    }

    @Override
    public final void errorv(Throwable t, String format, Object param1, Object param2, Object param3) {
        log.logv(FQCN, Logger.Level.ERROR, t, format, param1, param2, param3);
    }

    @Override
    public final void errorf(String format, Object... params) {
        log.logf(FQCN, Logger.Level.ERROR, null, format, params);
    }

    @Override
    public final void errorf(String format, Object param1) {
        log.logf(FQCN, Logger.Level.ERROR, null, format, param1);
    }

    @Override
    public final void errorf(String format, Object param1, Object param2) {
        log.logf(FQCN, Logger.Level.ERROR, null, format, param1, param2);
    }

    @Override
    public final void errorf(String format, Object param1, Object param2, Object param3) {
        log.logf(FQCN, Logger.Level.ERROR, null, format, param1, param2, param3);
    }

    @Override
    public final void errorf(Throwable t, String format, Object... params) {
        log.logf(FQCN, Logger.Level.ERROR, t, format, params);
    }

    @Override
    public final void errorf(Throwable t, String format, Object param1) {
        log.logf(FQCN, Logger.Level.ERROR, t, format, param1);
    }

    @Override
    public final void errorf(Throwable t, String format, Object param1, Object param2) {
        log.logf(FQCN, Logger.Level.ERROR, t, format, param1, param2);
    }

    @Override
    public final void errorf(Throwable t, String format, Object param1, Object param2, Object param3) {
        log.logf(FQCN, Logger.Level.ERROR, t, format, param1, param2, param3);
    }

    @Override
    public final void fatal(Object message) {
        log.fatal(FQCN, message, null);
    }

    @Override
    public final void fatal(Object message, Throwable t) {
        log.fatal(FQCN, message, t);
    }

    @Override
    public final void fatal(String loggerFqcn, Object message, Throwable t) {
        log.fatal(loggerFqcn, message, t);
    }

    @Override
    public final void fatal(String loggerFqcn, Object message, Object[] params, Throwable t) {
        log.fatal(loggerFqcn, message, params, t);
    }

    @Override
    public final void fatalv(String format, Object... params) {
        log.logv(FQCN, Logger.Level.FATAL, null, format, params);
    }

    @Override
    public final void fatalv(String format, Object param1) {
        log.logv(FQCN, Logger.Level.FATAL, null, format, param1);
    }

    @Override
    public final void fatalv(String format, Object param1, Object param2) {
        log.logv(FQCN, Logger.Level.FATAL, null, format, param1, param2);
    }

    @Override
    public final void fatalv(String format, Object param1, Object param2, Object param3) {
        log.logv(FQCN, Logger.Level.FATAL, null, format, param1, param2, param3);
    }

    @Override
    public final void fatalv(Throwable t, String format, Object... params) {
        log.logv(FQCN, Logger.Level.FATAL, t, format, params);
    }

    @Override
    public final void fatalv(Throwable t, String format, Object param1) {
        log.logv(FQCN, Logger.Level.FATAL, t, format, param1);
    }

    @Override
    public final void fatalv(Throwable t, String format, Object param1, Object param2) {
        log.logv(FQCN, Logger.Level.FATAL, t, format, param1, param2);
    }

    @Override
    public final void fatalv(Throwable t, String format, Object param1, Object param2, Object param3) {
        log.logv(FQCN, Logger.Level.FATAL, t, format, param1, param2, param3);
    }

    @Override
    public final void fatalf(String format, Object... params) {
        log.logf(FQCN, Logger.Level.FATAL, null, format, params);
    }

    @Override
    public final void fatalf(String format, Object param1) {
        log.logf(FQCN, Logger.Level.FATAL, null, format, param1);
    }

    @Override
    public final void fatalf(String format, Object param1, Object param2) {
        log.logf(FQCN, Logger.Level.FATAL, null, format, param1, param2);
    }

    @Override
    public final void fatalf(String format, Object param1, Object param2, Object param3) {
        log.logf(FQCN, Logger.Level.FATAL, null, format, param1, param2, param3);
    }

    @Override
    public final void fatalf(Throwable t, String format, Object... params) {
        log.logf(FQCN, Logger.Level.FATAL, t, format, params);
    }

    @Override
    public final void fatalf(Throwable t, String format, Object param1) {
        log.logf(FQCN, Logger.Level.FATAL, t, format, param1);
    }

    @Override
    public final void fatalf(Throwable t, String format, Object param1, Object param2) {
        log.logf(FQCN, Logger.Level.FATAL, t, format, param1, param2);
    }

    @Override
    public final void fatalf(Throwable t, String format, Object param1, Object param2, Object param3) {
        log.logf(FQCN, Logger.Level.FATAL, t, format, param1, param2, param3);
    }

    public final boolean isEnabled(Logger.Level level) {
        return log.isEnabled(level);
    }

    @Override
    public final void log(Logger.Level level, Object message) {
        log.log(FQCN, level, message, null, null);
    }

    @Override
    public final void log(Logger.Level level, Object message, Throwable t) {
        log.log(FQCN, level, message, null, t);
    }

    @Override
    public final void log(Logger.Level level, String loggerFqcn, Object message, Throwable t) {
        log.log(level, loggerFqcn, message, t);
    }

    @Override
    public final void log(String loggerFqcn, Logger.Level level, Object message, Object[] params, Throwable t) {
        log.log(loggerFqcn, level, message, params, t);
    }

    @Override
    public final void logv(Logger.Level level, String format, Object... params) {
        log.logv(FQCN, level, null, format, params);
    }

    @Override
    public final void logv(Logger.Level level, String format, Object param1) {
        log.logv(FQCN, level, null, format, param1);
    }

    @Override
    public final void logv(Logger.Level level, String format, Object param1, Object param2) {
        log.logv(FQCN, level, null, format, param1, param2);
    }

    @Override
    public final void logv(Logger.Level level, String format, Object param1, Object param2, Object param3) {
        log.logv(FQCN, level, null, format, param1, param2, param3);
    }

    @Override
    public final void logv(Logger.Level level, Throwable t, String format, Object... params) {
        log.logv(FQCN, level, t, format, params);
    }

    @Override
    public final void logv(Logger.Level level, Throwable t, String format, Object param1) {
        log.logv(FQCN, level, t, format, param1);
    }

    @Override
    public final void logv(Logger.Level level, Throwable t, String format, Object param1, Object param2) {
        log.logv(FQCN, level, t, format, param1, param2);
    }

    @Override
    public final void logv(Logger.Level level, Throwable t, String format, Object param1, Object param2, Object param3) {
        log.logv(FQCN, level, t, format, param1, param2, param3);
    }

    @Override
    public final void logv(String loggerFqcn, Logger.Level level, Throwable t, String format, Object... params) {
        log.logv(loggerFqcn, level, t, format, params);
    }

    @Override
    public final void logv(String loggerFqcn, Logger.Level level, Throwable t, String format, Object param1) {
        log.logv(loggerFqcn, level, t, format, param1);
    }

    @Override
    public final void logv(String loggerFqcn, Logger.Level level, Throwable t, String format, Object param1, Object param2) {
        log.logv(loggerFqcn, level, t, format, param1, param2);
    }

    @Override
    public final void logv(String loggerFqcn, Logger.Level level, Throwable t, String format, Object param1, Object param2, Object param3) {
        log.logv(loggerFqcn, level, t, format, param1, param2, param3);
    }

    @Override
    public final void logf(Logger.Level level, String format, Object... params) {
        log.logf(FQCN, level, null, format, params);
    }

    @Override
    public final void logf(Logger.Level level, String format, Object param1) {
        log.logf(FQCN, level, null, format, param1);
    }

    @Override
    public final void logf(Logger.Level level, String format, Object param1, Object param2) {
        log.logf(FQCN, level, null, format, param1, param2);
    }

    @Override
    public final void logf(Logger.Level level, String format, Object param1, Object param2, Object param3) {
        log.logf(FQCN, level, null, format, param1, param2, param3);
    }

    @Override
    public final void logf(Logger.Level level, Throwable t, String format, Object... params) {
        log.logf(FQCN, level, t, format, params);
    }

    @Override
    public final void logf(Logger.Level level, Throwable t, String format, Object param1) {
        log.logf(FQCN, level, t, format, param1);
    }

    @Override
    public final void logf(Logger.Level level, Throwable t, String format, Object param1, Object param2) {
        log.logf(FQCN, level, t, format, param1, param2);
    }

    @Override
    public final void logf(Logger.Level level, Throwable t, String format, Object param1, Object param2, Object param3) {
        log.logf(FQCN, level, t, format, param1, param2, param3);
    }

    @Override
    public final void logf(String loggerFqcn, Logger.Level level, Throwable t, String format, Object... params) {
        log.logf(loggerFqcn, level, t, format, params);
    }

    @Override
    public final void logf(String loggerFqcn, Logger.Level level, Throwable t, String format, Object param1) {
        log.logf(loggerFqcn, level, t, format, param1);
    }

    @Override
    public final void logf(String loggerFqcn, Logger.Level level, Throwable t, String format, Object param1, Object param2) {
        log.logf(loggerFqcn, level, t, format, param1, param2);
    }

    @Override
    public final void logf(String loggerFqcn, Logger.Level level, Throwable t, String format, Object param1, Object param2, Object param3) {
        log.logf(loggerFqcn, level, t, format, param1, param2, param3);
    }

    @Override
    public final void usingTraversableResolver(final String traversableResolverClassName) {
        log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000005: ")+ usingTraversableResolver$str()), traversableResolverClassName);
    }

    protected String usingTraversableResolver$str() {
        return usingTraversableResolver;
    }

    @Override
    public final IllegalArgumentException getInvalidRegularExpressionException(final PatternSyntaxException e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000022: ")+ getInvalidRegularExpressionException$str())), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidRegularExpressionException$str() {
        return getInvalidRegularExpressionException;
    }

    @Override
    public final javax.validation.ValidationException getIsNotAConstraintValidatorClassException(final Class validatorClass) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000102: ")+ getIsNotAConstraintValidatorClassException$str()), validatorClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getIsNotAConstraintValidatorClassException$str() {
        return getIsNotAConstraintValidatorClassException;
    }

    @Override
    public final javax.validation.GroupDefinitionException getUnableToExpandDefaultGroupListException(final List defaultGroupList, final List groupList) {
        javax.validation.GroupDefinitionException result = new javax.validation.GroupDefinitionException(String.format(((projectCode +"000043: ")+ getUnableToExpandDefaultGroupListException$str()), defaultGroupList, groupList));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToExpandDefaultGroupListException$str() {
        return getUnableToExpandDefaultGroupListException;
    }

    @Override
    public final javax.validation.ValidationException getAttemptToSpecifyAnArrayWhereSingleValueIsExpectedException() {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000108: ")+ getAttemptToSpecifyAnArrayWhereSingleValueIsExpectedException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getAttemptToSpecifyAnArrayWhereSingleValueIsExpectedException$str() {
        return getAttemptToSpecifyAnArrayWhereSingleValueIsExpectedException;
    }

    @Override
    public final void unableToCloseInputStream() {
        log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000008: ")+ unableToCloseInputStream$str()));
    }

    protected String unableToCloseInputStream$str() {
        return unableToCloseInputStream;
    }

    @Override
    public final IllegalArgumentException getMissingActualTypeArgumentForTypeParameterException(final TypeVariable typeParameter) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000094: ")+ getMissingActualTypeArgumentForTypeParameterException$str()), typeParameter));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMissingActualTypeArgumentForTypeParameterException$str() {
        return getMissingActualTypeArgumentForTypeParameterException;
    }

    @Override
    public final javax.validation.ValidationException getIsNotAnAnnotationException(final String annotationClassName) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000101: ")+ getIsNotAnAnnotationException$str()), annotationClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getIsNotAnAnnotationException$str() {
        return getIsNotAnAnnotationException;
    }

    @Override
    public final javax.validation.ValidationException getGroupHasToBeAnInterfaceException(final String className) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000045: ")+ getGroupHasToBeAnInterfaceException$str()), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getGroupHasToBeAnInterfaceException$str() {
        return getGroupHasToBeAnInterfaceException;
    }

    @Override
    public final javax.validation.UnexpectedTypeException getMoreThanOneValidatorFoundForTypeException(final Type type, final String validatorClasses) {
        javax.validation.UnexpectedTypeException result = new javax.validation.UnexpectedTypeException(String.format(((projectCode +"000031: ")+ getMoreThanOneValidatorFoundForTypeException$str()), type, validatorClasses));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMoreThanOneValidatorFoundForTypeException$str() {
        return getMoreThanOneValidatorFoundForTypeException;
    }

    @Override
    public final javax.validation.ValidationException getUnableToCreateAnnotationForConfiguredConstraintException(final String message, final RuntimeException e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000012: ")+ getUnableToCreateAnnotationForConfiguredConstraintException$str()), message), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToCreateAnnotationForConfiguredConstraintException$str() {
        return getUnableToCreateAnnotationForConfiguredConstraintException;
    }

    @Override
    public final void unableToCreateSchema(final String fileName, final String message) {
        log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000011: ")+ unableToCreateSchema$str()), fileName, message);
    }

    protected String unableToCreateSchema$str() {
        return unableToCreateSchema;
    }

    @Override
    public final javax.validation.ConstraintDefinitionException getWrongDefaultValueForPayloadParameterException(final String constraintName) {
        javax.validation.ConstraintDefinitionException result = new javax.validation.ConstraintDefinitionException(String.format(((projectCode +"000075: ")+ getWrongDefaultValueForPayloadParameterException$str()), constraintName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getWrongDefaultValueForPayloadParameterException$str() {
        return getWrongDefaultValueForPayloadParameterException;
    }

    @Override
    public final IllegalArgumentException getPropertyNameCannotBeNullOrEmptyException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000087: ")+ getPropertyNameCannotBeNullOrEmptyException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getPropertyNameCannotBeNullOrEmptyException$str() {
        return getPropertyNameCannotBeNullOrEmptyException;
    }

    @Override
    public final javax.validation.ValidationException getErrorDuringCallOfTraversableResolverIsReachableException(final RuntimeException e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000041: ")+ getErrorDuringCallOfTraversableResolverIsReachableException$str())), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getErrorDuringCallOfTraversableResolverIsReachableException$str() {
        return getErrorDuringCallOfTraversableResolverIsReachableException;
    }

    @Override
    public final IllegalArgumentException getInvalidPropertyPathException(final String propertyName, final String beanClassName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000039: ")+ getInvalidPropertyPathException2$str()), propertyName, beanClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidPropertyPathException2$str() {
        return getInvalidPropertyPathException2;
    }

    @Override
    public final void usingConstraintFactory(final String constraintFactoryClassName) {
        log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000003: ")+ usingConstraintFactory$str()), constraintFactoryClassName);
    }

    protected String usingConstraintFactory$str() {
        return usingConstraintFactory;
    }

    @Override
    public final NumberFormatException getCharacterIsNotADigitException(final char c) {
        NumberFormatException result = new NumberFormatException(String.format(((projectCode +"000072: ")+ getCharacterIsNotADigitException$str()), c));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getCharacterIsNotADigitException$str() {
        return getCharacterIsNotADigitException;
    }

    @Override
    public final void parsingXMLFile(final String fileName) {
        log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000007: ")+ parsingXMLFile$str()), fileName);
    }

    protected String parsingXMLFile$str() {
        return parsingXMLFile;
    }

    @Override
    public final javax.validation.ValidationException getUnableToFindAnnotationParameterException(final String parameterName, final NoSuchMethodException e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000083: ")+ getUnableToFindAnnotationParameterException$str()), parameterName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToFindAnnotationParameterException$str() {
        return getUnableToFindAnnotationParameterException;
    }

    @Override
    public final javax.validation.ValidationException getBeanDoesNotContainThePropertyException(final String beanClassName, final String getterName) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000106: ")+ getBeanDoesNotContainThePropertyException$str()), beanClassName, getterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getBeanDoesNotContainThePropertyException$str() {
        return getBeanDoesNotContainThePropertyException;
    }

    @Override
    public final IllegalArgumentException getMinCannotBeNegativeException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000019: ")+ getMinCannotBeNegativeException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMinCannotBeNegativeException$str() {
        return getMinCannotBeNegativeException;
    }

    @Override
    public final javax.validation.ValidationException getUnableToInstantiateException(final Class clazz, final Exception e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000063: ")+ getUnableToInstantiateException1$str()), clazz), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToInstantiateException1$str() {
        return getUnableToInstantiateException1;
    }

    @Override
    public final IllegalArgumentException getHasToBeAPrimitiveTypeException(final Class clazz) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000091: ")+ getHasToBeAPrimitiveTypeException$str()), clazz));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getHasToBeAPrimitiveTypeException$str() {
        return getHasToBeAPrimitiveTypeException;
    }

    @Override
    public final javax.validation.ValidationException getUnableToFindProviderException(final Class providerClass) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000027: ")+ getUnableToFindProviderException$str()), providerClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToFindProviderException$str() {
        return getUnableToFindProviderException;
    }

    @Override
    public final IllegalArgumentException getPropertyPathMustProvideIndexOrMapKeyException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000040: ")+ getPropertyPathMustProvideIndexOrMapKeyException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getPropertyPathMustProvideIndexOrMapKeyException$str() {
        return getPropertyPathMustProvideIndexOrMapKeyException;
    }

    @Override
    public final javax.validation.GroupDefinitionException getUnableToExpandGroupSequenceException() {
        javax.validation.GroupDefinitionException result = new javax.validation.GroupDefinitionException(String.format(((projectCode +"000048: ")+ getUnableToExpandGroupSequenceException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToExpandGroupSequenceException$str() {
        return getUnableToExpandGroupSequenceException;
    }

    @Override
    public final javax.validation.GroupDefinitionException getInvalidDefaultGroupSequenceDefinitionException() {
        javax.validation.GroupDefinitionException result = new javax.validation.GroupDefinitionException(String.format(((projectCode +"000052: ")+ getInvalidDefaultGroupSequenceDefinitionException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidDefaultGroupSequenceDefinitionException$str() {
        return getInvalidDefaultGroupSequenceDefinitionException;
    }

    @Override
    public final javax.validation.ValidationException getUnableToInstantiateBeanValidationProviderException(final List providerName, final Exception e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000066: ")+ getUnableToInstantiateBeanValidationProviderException$str()), providerName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToInstantiateBeanValidationProviderException$str() {
        return getUnableToInstantiateBeanValidationProviderException;
    }

    @Override
    public final javax.validation.ValidationException getWrongParameterTypeException(final String expectedType, final String currentType) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000082: ")+ getWrongParameterTypeException$str()), expectedType, currentType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getWrongParameterTypeException$str() {
        return getWrongParameterTypeException;
    }

    @Override
    public final IllegalArgumentException getMaxCannotBeNegativeException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000020: ")+ getMaxCannotBeNegativeException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMaxCannotBeNegativeException$str() {
        return getMaxCannotBeNegativeException;
    }

    @Override
    public final javax.validation.GroupDefinitionException getMultipleDefinitionOfDefaultGroupSequenceProviderException() {
        javax.validation.GroupDefinitionException result = new javax.validation.GroupDefinitionException(String.format(((projectCode +"000060: ")+ getMultipleDefinitionOfDefaultGroupSequenceProviderException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMultipleDefinitionOfDefaultGroupSequenceProviderException$str() {
        return getMultipleDefinitionOfDefaultGroupSequenceProviderException;
    }

    @Override
    public final IllegalArgumentException getElementTypeHasToBeFieldOrMethodException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000088: ")+ getElementTypeHasToBeFieldOrMethodException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getElementTypeHasToBeFieldOrMethodException$str() {
        return getElementTypeHasToBeFieldOrMethodException;
    }

    @Override
    public final IllegalArgumentException getIllegalArgumentException(final String message) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000116: ")+ getIllegalArgumentException$str()), message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getIllegalArgumentException$str() {
        return getIllegalArgumentException;
    }

    @Override
    public final javax.validation.ValidationException getInvalidCharValueException(final String value) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000111: ")+ getInvalidCharValueException$str()), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidCharValueException$str() {
        return getInvalidCharValueException;
    }

    @Override
    public final javax.validation.ValidationException getIsDefinedTwiceInMappingXmlForBeanException(final String name, final String beanClassName) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000104: ")+ getIsDefinedTwiceInMappingXmlForBeanException$str()), name, beanClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getIsDefinedTwiceInMappingXmlForBeanException$str() {
        return getIsDefinedTwiceInMappingXmlForBeanException;
    }

    @Override
    public final void ignoringXmlConfiguration() {
        log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000002: ")+ ignoringXmlConfiguration$str()));
    }

    protected String ignoringXmlConfiguration$str() {
        return ignoringXmlConfiguration;
    }

    @Override
    public final void unableToCloseXMLFileInputStream(final String fileName) {
        log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000010: ")+ unableToCloseXMLFileInputStream$str()), fileName);
    }

    protected String unableToCloseXMLFileInputStream$str() {
        return unableToCloseXMLFileInputStream;
    }

    @Override
    public final javax.validation.ValidationException getUnableToGetAnnotationParameterException(final String parameterName, final String annotationName, final Exception e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000084: ")+ getUnableToGetAnnotationParameterException$str()), parameterName, annotationName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToGetAnnotationParameterException$str() {
        return getUnableToGetAnnotationParameterException;
    }

    @Override
    public final javax.validation.GroupDefinitionException getNoDefaultGroupInGroupSequenceException() {
        javax.validation.GroupDefinitionException result = new javax.validation.GroupDefinitionException(String.format(((projectCode +"000053: ")+ getNoDefaultGroupInGroupSequenceException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getNoDefaultGroupInGroupSequenceException$str() {
        return getNoDefaultGroupInGroupSequenceException;
    }

    @Override
    public final IllegalArgumentException getInvalidLengthForFractionPartException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000018: ")+ getInvalidLengthForFractionPartException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidLengthForFractionPartException$str() {
        return getInvalidLengthForFractionPartException;
    }

    @Override
    public final javax.validation.ValidationException getUnableToOpenInputStreamForMappingFileException(final String mappingFileName) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000096: ")+ getUnableToOpenInputStreamForMappingFileException$str()), mappingFileName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToOpenInputStreamForMappingFileException$str() {
        return getUnableToOpenInputStreamForMappingFileException;
    }

    @Override
    public final javax.validation.ConstraintDeclarationException getScriptMustReturnTrueOrFalseException(final String script, final Object executionResult, final String type) {
        javax.validation.ConstraintDeclarationException result = new javax.validation.ConstraintDeclarationException(String.format(((projectCode +"000025: ")+ getScriptMustReturnTrueOrFalseException3$str()), script, executionResult, type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getScriptMustReturnTrueOrFalseException3$str() {
        return getScriptMustReturnTrueOrFalseException3;
    }

    @Override
    public final IllegalArgumentException getInvalidCheckDigitException(final int startIndex, final int endIndex) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000071: ")+ getInvalidCheckDigitException$str()), startIndex, endIndex));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidCheckDigitException$str() {
        return getInvalidCheckDigitException;
    }

    @Override
    public final javax.validation.ValidationException getUnableToInstantiateTraversableResolverClassException(final String traversableResolverClassName, final Exception e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000098: ")+ getUnableToInstantiateTraversableResolverClassException$str()), traversableResolverClassName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToInstantiateTraversableResolverClassException$str() {
        return getUnableToInstantiateTraversableResolverClassException;
    }

    @Override
    public final javax.validation.GroupDefinitionException getWrongDefaultGroupSequenceProviderTypeException(final String beanClassName) {
        javax.validation.GroupDefinitionException result = new javax.validation.GroupDefinitionException(String.format(((projectCode +"000055: ")+ getWrongDefaultGroupSequenceProviderTypeException$str()), beanClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getWrongDefaultGroupSequenceProviderTypeException$str() {
        return getWrongDefaultGroupSequenceProviderTypeException;
    }

    @Override
    public final javax.validation.ConstraintDeclarationException getErrorDuringScriptExecutionException(final String script, final Exception e) {
        javax.validation.ConstraintDeclarationException result = new javax.validation.ConstraintDeclarationException(String.format(((projectCode +"000023: ")+ getErrorDuringScriptExecutionException$str()), script), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getErrorDuringScriptExecutionException$str() {
        return getErrorDuringScriptExecutionException;
    }

    @Override
    public final IllegalArgumentException getInvalidRangeException(final int startIndex, final int endIndex) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000070: ")+ getInvalidRangeException$str()), startIndex, endIndex));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidRangeException$str() {
        return getInvalidRangeException;
    }

    @Override
    public final javax.validation.ConstraintDefinitionException getWrongDefaultValueForGroupsParameterException(final String constraintName) {
        javax.validation.ConstraintDefinitionException result = new javax.validation.ConstraintDefinitionException(String.format(((projectCode +"000077: ")+ getWrongDefaultValueForGroupsParameterException$str()), constraintName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getWrongDefaultValueForGroupsParameterException$str() {
        return getWrongDefaultValueForGroupsParameterException;
    }

    @Override
    public final javax.validation.ValidationException getUnableToAccessMemberException(final String memberName, final Exception e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000090: ")+ getUnableToAccessMemberException$str()), memberName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToAccessMemberException$str() {
        return getUnableToAccessMemberException;
    }

    @Override
    public final javax.validation.ValidationException getAnnotationDoesNotContainAParameterException(final String annotationClassName, final String parameterName) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000107: ")+ getAnnotationDoesNotContainAParameterException$str()), annotationClassName, parameterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getAnnotationDoesNotContainAParameterException$str() {
        return getAnnotationDoesNotContainAParameterException;
    }

    @Override
    public final void usingMessageInterpolator(final String messageInterpolatorClassName) {
        log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000004: ")+ usingMessageInterpolator$str()), messageInterpolatorClassName);
    }

    protected String usingMessageInterpolator$str() {
        return usingMessageInterpolator;
    }

    @Override
    public final void version(final String version) {
        log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000001: ")+ version$str()), version);
    }

    protected String version$str() {
        return version;
    }

    @Override
    public final javax.validation.ValidationException getUnableToRetrieveAnnotationParameterValueException(final Exception e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000059: ")+ getUnableToRetrieveAnnotationParameterValueException$str())), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToRetrieveAnnotationParameterValueException$str() {
        return getUnableToRetrieveAnnotationParameterValueException;
    }

    @Override
    public final void usingValidationProvider(final String validationProviderClassName) {
        log.logf(FQCN, (Logger.Level.INFO), null, ((projectCode +"000006: ")+ usingValidationProvider$str()), validationProviderClassName);
    }

    protected String usingValidationProvider$str() {
        return usingValidationProvider;
    }

    @Override
    public final javax.validation.ConstraintDeclarationException getScriptMustReturnTrueOrFalseException(final String script) {
        javax.validation.ConstraintDeclarationException result = new javax.validation.ConstraintDeclarationException(String.format(((projectCode +"000024: ")+ getScriptMustReturnTrueOrFalseException1$str()), script));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getScriptMustReturnTrueOrFalseException1$str() {
        return getScriptMustReturnTrueOrFalseException1;
    }

    @Override
    public final javax.validation.ConstraintDefinitionException getConstraintWithoutMandatoryParameterException(final String parameterName, final String constraintName) {
        javax.validation.ConstraintDefinitionException result = new javax.validation.ConstraintDefinitionException(String.format(((projectCode +"000074: ")+ getConstraintWithoutMandatoryParameterException$str()), parameterName, constraintName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getConstraintWithoutMandatoryParameterException$str() {
        return getConstraintWithoutMandatoryParameterException;
    }

    @Override
    public final javax.validation.ValidationException getUnableToInstantiateConstraintFactoryClassException(final String constraintFactoryClassName, final javax.validation.ValidationException e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000095: ")+ getUnableToInstantiateConstraintFactoryClassException$str()), constraintFactoryClassName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToInstantiateConstraintFactoryClassException$str() {
        return getUnableToInstantiateConstraintFactoryClassException;
    }

    @Override
    public final javax.validation.ValidationException getTypeNotSupportedException(final Class type) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000036: ")+ getTypeNotSupportedException$str()), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getTypeNotSupportedException$str() {
        return getTypeNotSupportedException;
    }

    @Override
    public final javax.validation.ValidationException getBeanClassHasAlreadyBeConfiguredInXmlException(final String beanClassName) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000103: ")+ getBeanClassHasAlreadyBeConfiguredInXmlException$str()), beanClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getBeanClassHasAlreadyBeConfiguredInXmlException$str() {
        return getBeanClassHasAlreadyBeConfiguredInXmlException;
    }

    @Override
    public final javax.validation.UnexpectedTypeException getNoValidatorFoundForTypeException(final String className) {
        javax.validation.UnexpectedTypeException result = new javax.validation.UnexpectedTypeException(String.format(((projectCode +"000030: ")+ getNoValidatorFoundForTypeException$str()), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getNoValidatorFoundForTypeException$str() {
        return getNoValidatorFoundForTypeException;
    }

    @Override
    public final javax.validation.ValidationException getUnableToReadAnnotationAttributesException(final Class annotationClass, final Exception e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000058: ")+ getUnableToReadAnnotationAttributesException$str()), annotationClass), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToReadAnnotationAttributesException$str() {
        return getUnableToReadAnnotationAttributesException;
    }

    @Override
    public final javax.validation.GroupDefinitionException getMultipleDefinitionOfDefaultGroupSequenceException() {
        javax.validation.GroupDefinitionException result = new javax.validation.GroupDefinitionException(String.format(((projectCode +"000061: ")+ getMultipleDefinitionOfDefaultGroupSequenceException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMultipleDefinitionOfDefaultGroupSequenceException$str() {
        return getMultipleDefinitionOfDefaultGroupSequenceException;
    }

    @Override
    public final javax.validation.ConstraintDefinitionException getWrongTypeForGroupsParameterException(final String constraintName, final ClassCastException e) {
        javax.validation.ConstraintDefinitionException result = new javax.validation.ConstraintDefinitionException(String.format(((projectCode +"000078: ")+ getWrongTypeForGroupsParameterException$str()), constraintName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getWrongTypeForGroupsParameterException$str() {
        return getWrongTypeForGroupsParameterException;
    }

    @Override
    public final javax.validation.ValidationException getUnableToInitializeConstraintValidatorException(final String validatorClassName, final RuntimeException e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000032: ")+ getUnableToInitializeConstraintValidatorException$str()), validatorClassName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToInitializeConstraintValidatorException$str() {
        return getUnableToInitializeConstraintValidatorException;
    }

    @Override
    public final javax.validation.ValidationException getReservedParameterNamesException(final String messageParameterName, final String groupsParameterName, final String payloadParameterName) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000113: ")+ getReservedParameterNamesException$str()), messageParameterName, groupsParameterName, payloadParameterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getReservedParameterNamesException$str() {
        return getReservedParameterNamesException;
    }

    @Override
    public final javax.validation.ConstraintDefinitionException getConstraintParametersCannotStartWithValidException() {
        javax.validation.ConstraintDefinitionException result = new javax.validation.ConstraintDefinitionException(String.format(((projectCode +"000073: ")+ getConstraintParametersCannotStartWithValidException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getConstraintParametersCannotStartWithValidException$str() {
        return getConstraintParametersCannotStartWithValidException;
    }

    @Override
    public final IllegalArgumentException getInvalidLengthOfParameterMetaDataListException(final Method method, final int nbParameters, final int listSize) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000062: ")+ getInvalidLengthOfParameterMetaDataListException$str()), method, nbParameters, listSize));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidLengthOfParameterMetaDataListException$str() {
        return getInvalidLengthOfParameterMetaDataListException;
    }

    @Override
    public final javax.validation.ValidationException getUnableToInstantiateMessageInterpolatorClassException(final String messageInterpolatorClassName, final Exception e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000097: ")+ getUnableToInstantiateMessageInterpolatorClassException$str()), messageInterpolatorClassName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToInstantiateMessageInterpolatorClassException$str() {
        return getUnableToInstantiateMessageInterpolatorClassException;
    }

    @Override
    public final IllegalArgumentException getEndIndexCannotBeNegativeException(final int endIndex) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000069: ")+ getEndIndexCannotBeNegativeException$str()), endIndex));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getEndIndexCannotBeNegativeException$str() {
        return getEndIndexCannotBeNegativeException;
    }

    @Override
    public final javax.validation.ValidationException throwInvalidFormat(final String message, final IllegalFormatException e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000051: ")+ throwInvalidFormat$str()), message), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String throwInvalidFormat$str() {
        return throwInvalidFormat;
    }

    @Override
    public final javax.validation.ConstraintDefinitionException getWrongAttributeTypeForOverriddenConstraintException(final String expectedReturnType, final Class currentReturnType) {
        javax.validation.ConstraintDefinitionException result = new javax.validation.ConstraintDefinitionException(String.format(((projectCode +"000081: ")+ getWrongAttributeTypeForOverriddenConstraintException$str()), expectedReturnType, currentReturnType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getWrongAttributeTypeForOverriddenConstraintException$str() {
        return getWrongAttributeTypeForOverriddenConstraintException;
    }

    @Override
    public final javax.validation.ValidationException getBeanDoesNotContainTheFieldException(final String beanClassName, final String fieldName) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000105: ")+ getBeanDoesNotContainTheFieldException$str()), beanClassName, fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getBeanDoesNotContainTheFieldException$str() {
        return getBeanDoesNotContainTheFieldException;
    }

    @Override
    public final javax.validation.ValidationException getUnableToLoadClassException(final String className, final Exception e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000065: ")+ getUnableToLoadClassException$str()), className), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToLoadClassException$str() {
        return getUnableToLoadClassException;
    }

    @Override
    public final javax.validation.ValidationException getAtLeastOneCustomMessageMustBeCreatedException() {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000033: ")+ getAtLeastOneCustomMessageMustBeCreatedException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getAtLeastOneCustomMessageMustBeCreatedException$str() {
        return getAtLeastOneCustomMessageMustBeCreatedException;
    }

    @Override
    public final IllegalArgumentException getMemberIsNeitherAFieldNorAMethodException(final Member member) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000089: ")+ getMemberIsNeitherAFieldNorAMethodException$str()), member));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMemberIsNeitherAFieldNorAMethodException$str() {
        return getMemberIsNeitherAFieldNorAMethodException;
    }

    @Override
    public final javax.validation.GroupDefinitionException getSequenceDefinitionsNotAllowedException() {
        javax.validation.GroupDefinitionException result = new javax.validation.GroupDefinitionException(String.format(((projectCode +"000046: ")+ getSequenceDefinitionsNotAllowedException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getSequenceDefinitionsNotAllowedException$str() {
        return getSequenceDefinitionsNotAllowedException;
    }

    @Override
    public final javax.validation.ValidationException getUnexpectedParameterValueException(final ClassCastException e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000109: ")+ getUnexpectedParameterValueException$str())), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnexpectedParameterValueException$str() {
        return getUnexpectedParameterValueException;
    }

    @Override
    public final IllegalArgumentException getInvalidBigDecimalFormatException(final String value, final NumberFormatException e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000016: ")+ getInvalidBigDecimalFormatException$str()), value), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidBigDecimalFormatException$str() {
        return getInvalidBigDecimalFormatException;
    }

    @Override
    public final IllegalArgumentException getUnableToFindMethodException(final Class beanClass, final String name, final String parametersType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000014: ")+ getUnableToFindMethodException$str()), beanClass, name, parametersType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToFindMethodException$str() {
        return getUnableToFindMethodException;
    }

    @Override
    public final IllegalArgumentException getUnableToParsePropertyPathException(final String propertyPath) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000035: ")+ getUnableToParsePropertyPathException$str()), propertyPath));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToParsePropertyPathException$str() {
        return getUnableToParsePropertyPathException;
    }

    @Override
    public final IllegalArgumentException getInvalidMethodParameterIndexException(final String methodName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000015: ")+ getInvalidMethodParameterIndexException1$str()), methodName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidMethodParameterIndexException1$str() {
        return getInvalidMethodParameterIndexException1;
    }

    @Override
    public final javax.validation.ValidationException getUnexpectedParameterValueException() {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000109: ")+ getUnexpectedParameterValueException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void unableToLoadProviderClass(final String providerName) {
        log.logf(FQCN, (Logger.Level.WARN), null, ((projectCode +"000009: ")+ unableToLoadProviderClass$str()), providerName);
    }

    protected String unableToLoadProviderClass$str() {
        return unableToLoadProviderClass;
    }

    @Override
    public final IndexOutOfBoundsException getInvalidIndexException(final String lowerBound, final String upperBound) {
        IndexOutOfBoundsException result = new IndexOutOfBoundsException(String.format(((projectCode +"000049: ")+ getInvalidIndexException$str()), lowerBound, upperBound));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidIndexException$str() {
        return getInvalidIndexException;
    }

    @Override
    public final javax.validation.ValidationException getUnableToFindPropertyWithAccessException(final Class beanClass, final String property, final ElementType elementType) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000013: ")+ getUnableToFindPropertyWithAccessException$str()), beanClass, property, elementType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToFindPropertyWithAccessException$str() {
        return getUnableToFindPropertyWithAccessException;
    }

    @Override
    public final javax.validation.ValidationException getNullIsAnInvalidTypeForAConstraintValidatorException() {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000093: ")+ getNullIsAnInvalidTypeForAConstraintValidatorException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getNullIsAnInvalidTypeForAConstraintValidatorException$str() {
        return getNullIsAnInvalidTypeForAConstraintValidatorException;
    }

    @Override
    public final IllegalArgumentException getNoValueProvidedForAnnotationParameterException(final String parameterName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000085: ")+ getNoValueProvidedForAnnotationParameterException$str()), parameterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getNoValueProvidedForAnnotationParameterException$str() {
        return getNoValueProvidedForAnnotationParameterException;
    }

    @Override
    public final javax.validation.ValidationException getUnableToLoadClassException(final String className) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000065: ")+ getUnableToLoadClassException$str()), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final javax.validation.ValidationException getUnableToInstantiateException(final String className, final Exception e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000063: ")+ getUnableToInstantiateException1$str()), className), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final javax.validation.ValidationException getExceptionDuringIsValidCall(final RuntimeException e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000028: ")+ getExceptionDuringIsValidCall$str())), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getExceptionDuringIsValidCall$str() {
        return getExceptionDuringIsValidCall;
    }

    @Override
    public final javax.validation.ValidationException getErrorParsingMappingFileException(final Exception e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000115: ")+ getErrorParsingMappingFileException$str())), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getErrorParsingMappingFileException$str() {
        return getErrorParsingMappingFileException;
    }

    @Override
    public final IllegalArgumentException getInvalidJavaIdentifierException(final String identifier) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000034: ")+ getInvalidJavaIdentifierException$str()), identifier));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidJavaIdentifierException$str() {
        return getInvalidJavaIdentifierException;
    }

    @Override
    public final IllegalArgumentException getLengthCannotBeNegativeException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000021: ")+ getLengthCannotBeNegativeException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getLengthCannotBeNegativeException$str() {
        return getLengthCannotBeNegativeException;
    }

    @Override
    public final javax.validation.ValidationException getUnableToReadServicesFileException(final String servicesFileName, final Exception e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000067: ")+ getUnableToReadServicesFileException$str()), servicesFileName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToReadServicesFileException$str() {
        return getUnableToReadServicesFileException;
    }

    @Override
    public final IllegalArgumentException getStartIndexCannotBeNegativeException(final int startIndex) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000068: ")+ getStartIndexCannotBeNegativeException$str()), startIndex));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getStartIndexCannotBeNegativeException$str() {
        return getStartIndexCannotBeNegativeException;
    }

    @Override
    public final javax.validation.ValidationException getInvalidReturnTypeException(final Class returnType, final ClassCastException e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000112: ")+ getInvalidReturnTypeException$str()), returnType), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidReturnTypeException$str() {
        return getInvalidReturnTypeException;
    }

    @Override
    public final javax.validation.ValidationException getErrorDuringCallOfTraversableResolverIsCascadableException(final RuntimeException e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000042: ")+ getErrorDuringCallOfTraversableResolverIsCascadableException$str())), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getErrorDuringCallOfTraversableResolverIsCascadableException$str() {
        return getErrorDuringCallOfTraversableResolverIsCascadableException;
    }

    @Override
    public final IllegalArgumentException getAtLeastOneGroupHasToBeSpecifiedException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000044: ")+ getAtLeastOneGroupHasToBeSpecifiedException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getAtLeastOneGroupHasToBeSpecifiedException$str() {
        return getAtLeastOneGroupHasToBeSpecifiedException;
    }

    @Override
    public final javax.validation.ValidationException getInconsistentFailFastConfigurationException() {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000037: ")+ getInconsistentFailFastConfigurationException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInconsistentFailFastConfigurationException$str() {
        return getInconsistentFailFastConfigurationException;
    }

    @Override
    public final javax.validation.ValidationException getInconsistentConfigurationException() {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000026: ")+ getInconsistentConfigurationException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInconsistentConfigurationException$str() {
        return getInconsistentConfigurationException;
    }

    @Override
    public final IllegalArgumentException getInvalidMethodParameterIndexException(final String method, final int index) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000056: ")+ getInvalidMethodParameterIndexException2$str()), method, index));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidMethodParameterIndexException2$str() {
        return getInvalidMethodParameterIndexException2;
    }

    @Override
    public final javax.validation.ConstraintDefinitionException getOverriddenConstraintAttributeNotFoundException(final String attributeName) {
        javax.validation.ConstraintDefinitionException result = new javax.validation.ConstraintDefinitionException(String.format(((projectCode +"000080: ")+ getOverriddenConstraintAttributeNotFoundException$str()), attributeName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getOverriddenConstraintAttributeNotFoundException$str() {
        return getOverriddenConstraintAttributeNotFoundException;
    }

    @Override
    public final javax.validation.GroupDefinitionException getBeanClassMustBePartOfRedefinedDefaultGroupSequenceException(final String beanClassName) {
        javax.validation.GroupDefinitionException result = new javax.validation.GroupDefinitionException(String.format(((projectCode +"000054: ")+ getBeanClassMustBePartOfRedefinedDefaultGroupSequenceException$str()), beanClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getBeanClassMustBePartOfRedefinedDefaultGroupSequenceException$str() {
        return getBeanClassMustBePartOfRedefinedDefaultGroupSequenceException;
    }

    @Override
    public final javax.validation.ConstraintDefinitionException getWrongTypeForPayloadParameterException(final String constraintName, final ClassCastException e) {
        javax.validation.ConstraintDefinitionException result = new javax.validation.ConstraintDefinitionException(String.format(((projectCode +"000076: ")+ getWrongTypeForPayloadParameterException$str()), constraintName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getWrongTypeForPayloadParameterException$str() {
        return getWrongTypeForPayloadParameterException;
    }

    @Override
    public final javax.validation.ValidationException getInvalidPropertyValue(final String propertyName, final String propertyValue, final Exception e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000117: ")+ getInvalidPropertyValue$str()), propertyName, propertyValue), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidPropertyValue$str() {
        return getInvalidPropertyValue;
    }

    @Override
    public final javax.validation.ValidationException getUnableToFindAnnotationConstraintsException(final Class annotationClass) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000057: ")+ getUnableToFindAnnotationConstraintsException$str()), annotationClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToFindAnnotationConstraintsException$str() {
        return getUnableToFindAnnotationConstraintsException;
    }

    @Override
    public final RuntimeException getTryingToInstantiateAnnotationWithUnknownParametersException(final Class annotationType, final Set unknownParameters) {
        RuntimeException result = new RuntimeException(String.format(((projectCode +"000086: ")+ getTryingToInstantiateAnnotationWithUnknownParametersException$str()), annotationType, unknownParameters));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getTryingToInstantiateAnnotationWithUnknownParametersException$str() {
        return getTryingToInstantiateAnnotationWithUnknownParametersException;
    }

    @Override
    public final javax.validation.ValidationException getConstraintFactoryMustNotReturnNullException(final String validatorClassName) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000029: ")+ getConstraintFactoryMustNotReturnNullException$str()), validatorClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getConstraintFactoryMustNotReturnNullException$str() {
        return getConstraintFactoryMustNotReturnNullException;
    }

    @Override
    public final IllegalArgumentException getInvalidPropertyPathException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000038: ")+ getInvalidPropertyPathException0$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidPropertyPathException0$str() {
        return getInvalidPropertyPathException0;
    }

    @Override
    public final javax.validation.ValidationException getUnableToInstantiateException(final String message, final Class clazz, final Exception e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000064: ")+ getUnableToInstantiateException2$str()), message, clazz), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToInstantiateException2$str() {
        return getUnableToInstantiateException2;
    }

    @Override
    public final javax.validation.ConstraintDefinitionException getWrongTypeForMessageParameterException(final String constraintName) {
        javax.validation.ConstraintDefinitionException result = new javax.validation.ConstraintDefinitionException(String.format(((projectCode +"000079: ")+ getWrongTypeForMessageParameterException$str()), constraintName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getWrongTypeForMessageParameterException$str() {
        return getWrongTypeForMessageParameterException;
    }

    @Override
    public final javax.validation.ValidationException getUnableToParseValidationXmlFileException(final String file, final Exception e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000100: ")+ getUnableToParseValidationXmlFileException$str()), file), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToParseValidationXmlFileException$str() {
        return getUnableToParseValidationXmlFileException;
    }

    @Override
    public final javax.validation.GroupDefinitionException getCyclicDependencyInGroupsDefinitionException() {
        javax.validation.GroupDefinitionException result = new javax.validation.GroupDefinitionException(String.format(((projectCode +"000047: ")+ getCyclicDependencyInGroupsDefinitionException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getCyclicDependencyInGroupsDefinitionException$str() {
        return getCyclicDependencyInGroupsDefinitionException;
    }

    @Override
    public final javax.validation.ValidationException getMissingFormatStringInTemplateException(final String expression) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000050: ")+ getMissingFormatStringInTemplateException$str()), expression));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMissingFormatStringInTemplateException$str() {
        return getMissingFormatStringInTemplateException;
    }

    @Override
    public final javax.validation.ValidationException getInvalidNumberFormatException(final String formatName, final NumberFormatException e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000110: ")+ getInvalidNumberFormatException$str()), formatName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidNumberFormatException$str() {
        return getInvalidNumberFormatException;
    }

    @Override
    public final IllegalArgumentException getInvalidLengthForIntegerPartException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(((projectCode +"000017: ")+ getInvalidLengthForIntegerPartException$str())));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidLengthForIntegerPartException$str() {
        return getInvalidLengthForIntegerPartException;
    }

    @Override
    public final javax.validation.ValidationException getWrongPayloadClassException(final String payloadClassName) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000114: ")+ getWrongPayloadClassException$str()), payloadClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getWrongPayloadClassException$str() {
        return getWrongPayloadClassException;
    }

    @Override
    public final javax.validation.ValidationException getUnableToInstantiateValidationProviderClassException(final String providerClassName, final Exception e) {
        javax.validation.ValidationException result = new javax.validation.ValidationException(String.format(((projectCode +"000099: ")+ getUnableToInstantiateValidationProviderClassException$str()), providerClassName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToInstantiateValidationProviderClassException$str() {
        return getUnableToInstantiateValidationProviderClassException;
    }

}
