/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.messageinterpolation;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.MessageInterpolator;
import org.hibernate.validator.resourceloading.PlatformResourceBundleLocator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBundleMessageInterpolator
implements MessageInterpolator {
    public static final String DEFAULT_VALIDATION_MESSAGES = "org.hibernate.validator.ValidationMessages";
    public static final String USER_VALIDATION_MESSAGES = "ValidationMessages";
    private static final Pattern MESSAGE_PARAMETER_PATTERN = Pattern.compile("(\\{[^\\}]+?\\})");
    private final Locale defaultLocale;
    private final ResourceBundleLocator userResourceBundleLocator;
    private final ResourceBundleLocator defaultResourceBundleLocator;
    private final ConcurrentMap<LocalisedMessage, String> resolvedMessages = new ConcurrentHashMap<LocalisedMessage, String>();
    private final boolean cacheMessages;

    public ResourceBundleMessageInterpolator() {
        this((ResourceBundleLocator)null);
    }

    @Deprecated
    public ResourceBundleMessageInterpolator(org.hibernate.validator.resourceloading.ResourceBundleLocator userResourceBundleLocator) {
        this(new Adapter(userResourceBundleLocator));
    }

    public ResourceBundleMessageInterpolator(ResourceBundleLocator userResourceBundleLocator) {
        this(userResourceBundleLocator, true);
    }

    @Deprecated
    public ResourceBundleMessageInterpolator(org.hibernate.validator.resourceloading.ResourceBundleLocator userResourceBundleLocator, boolean cacheMessages) {
        this(new Adapter(userResourceBundleLocator), cacheMessages);
    }

    public ResourceBundleMessageInterpolator(ResourceBundleLocator userResourceBundleLocator, boolean cacheMessages) {
        this.defaultLocale = Locale.getDefault();
        this.userResourceBundleLocator = userResourceBundleLocator == null ? new PlatformResourceBundleLocator(USER_VALIDATION_MESSAGES) : userResourceBundleLocator;
        this.defaultResourceBundleLocator = new PlatformResourceBundleLocator(DEFAULT_VALIDATION_MESSAGES);
        this.cacheMessages = cacheMessages;
    }

    public String interpolate(String message, MessageInterpolator.Context context) {
        return this.interpolateMessage(message, context.getConstraintDescriptor().getAttributes(), this.defaultLocale);
    }

    public String interpolate(String message, MessageInterpolator.Context context, Locale locale) {
        return this.interpolateMessage(message, context.getConstraintDescriptor().getAttributes(), locale);
    }

    private String interpolateMessage(String message, Map<String, Object> annotationParameters, Locale locale) {
        String cachedResolvedMessage;
        LocalisedMessage localisedMessage = new LocalisedMessage(message, locale);
        String resolvedMessage = null;
        if (this.cacheMessages) {
            resolvedMessage = (String)this.resolvedMessages.get(localisedMessage);
        }
        if (resolvedMessage == null) {
            ResourceBundle userResourceBundle = this.userResourceBundleLocator.getResourceBundle(locale);
            ResourceBundle defaultResourceBundle = this.defaultResourceBundleLocator.getResourceBundle(locale);
            resolvedMessage = message;
            boolean evaluatedDefaultBundleOnce = false;
            while (true) {
                String userBundleResolvedMessage = this.replaceVariables(resolvedMessage, userResourceBundle, locale, true);
                if (evaluatedDefaultBundleOnce && !this.hasReplacementTakenPlace(userBundleResolvedMessage, resolvedMessage)) break;
                resolvedMessage = this.replaceVariables(userBundleResolvedMessage, defaultResourceBundle, locale, false);
                evaluatedDefaultBundleOnce = true;
            }
        }
        if (this.cacheMessages && (cachedResolvedMessage = this.resolvedMessages.putIfAbsent(localisedMessage, resolvedMessage)) != null) {
            resolvedMessage = cachedResolvedMessage;
        }
        resolvedMessage = this.replaceAnnotationAttributes(resolvedMessage, annotationParameters);
        resolvedMessage = resolvedMessage.replace("\\{", "{");
        resolvedMessage = resolvedMessage.replace("\\}", "}");
        resolvedMessage = resolvedMessage.replace("\\\\", "\\");
        return resolvedMessage;
    }

    private boolean hasReplacementTakenPlace(String origMessage, String newMessage) {
        return !origMessage.equals(newMessage);
    }

    private String replaceVariables(String message, ResourceBundle bundle2, Locale locale, boolean recurse) {
        Matcher matcher = MESSAGE_PARAMETER_PATTERN.matcher(message);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String parameter = matcher.group(1);
            String resolvedParameterValue = this.resolveParameter(parameter, bundle2, locale, recurse);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(resolvedParameterValue));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String replaceAnnotationAttributes(String message, Map<String, Object> annotationParameters) {
        Matcher matcher = MESSAGE_PARAMETER_PATTERN.matcher(message);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String parameter = matcher.group(1);
            Object variable = annotationParameters.get(this.removeCurlyBrace(parameter));
            String resolvedParameterValue = variable != null ? (variable.getClass().isArray() ? Arrays.toString((Object[])variable) : variable.toString()) : parameter;
            resolvedParameterValue = Matcher.quoteReplacement(resolvedParameterValue);
            matcher.appendReplacement(sb, resolvedParameterValue);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String resolveParameter(String parameterName, ResourceBundle bundle2, Locale locale, boolean recurse) {
        String parameterValue;
        try {
            if (bundle2 != null) {
                parameterValue = bundle2.getString(this.removeCurlyBrace(parameterName));
                if (recurse) {
                    parameterValue = this.replaceVariables(parameterValue, bundle2, locale, recurse);
                }
            } else {
                parameterValue = parameterName;
            }
        }
        catch (MissingResourceException e) {
            parameterValue = parameterName;
        }
        return parameterValue;
    }

    private String removeCurlyBrace(String parameter) {
        return parameter.substring(1, parameter.length() - 1);
    }

    private static class Adapter
    implements ResourceBundleLocator {
        private final org.hibernate.validator.resourceloading.ResourceBundleLocator adaptee;

        public Adapter(org.hibernate.validator.resourceloading.ResourceBundleLocator adaptee) {
            this.adaptee = adaptee;
        }

        public ResourceBundle getResourceBundle(Locale locale) {
            return this.adaptee.getResourceBundle(locale);
        }
    }

    private static class LocalisedMessage {
        private final String message;
        private final Locale locale;

        LocalisedMessage(String message, Locale locale) {
            this.message = message;
            this.locale = locale;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalisedMessage that = (LocalisedMessage)o;
            if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) {
                return false;
            }
            return !(this.message != null ? !this.message.equals(that.message) : that.message != null);
        }

        public int hashCode() {
            int result = this.message != null ? this.message.hashCode() : 0;
            result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
            return result;
        }
    }
}

